/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRightAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRoleAdmin;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRights;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoResult;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import java.util.HashMap;
import java.util.HashSet;

class SecurityHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SecurityHelper");
    private int m_objectID;
    private int m_loggedOnUserID;
    private ISecuritySession m_session;
    private IPluginMgr m_pluginMgr;
    private boolean m_isGlobalInfoLoaded;
    private boolean m_isMRRGranted;
    private boolean m_isSMRRGrantedForObj;
    private boolean m_isCIFGrantedForObj;
    private HashMap m_assignedRights;
    private HashSet m_assignedRoles;
    private HashMap m_assignRoleRightMap;
    private HashMap m_principalsSecInfoMap;

    public SecurityHelper(int objectID, int loggedOnUserID, ISecuritySession session) {
        block2: {
            this.m_objectID = objectID;
            this.m_loggedOnUserID = loggedOnUserID;
            this.m_session = session;
            try {
                this.m_pluginMgr = (IPluginMgr)PluginMgrFactory.getFactory().makeOCCA("", this.m_session);
            }
            catch (SDKException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"SecurithHelper.SecurityHelper(): Failed to get plugin manager", (Throwable)((Object)e));
            }
        }
        this.m_principalsSecInfoMap = new HashMap();
        this.m_assignRoleRightMap = new HashMap();
    }

    public boolean isCanSetAll(int princID) throws SDKException {
        if (!this.m_isGlobalInfoLoaded) {
            this.ensureSecInfo(princID);
        }
        return this.m_isMRRGranted;
    }

    public boolean isCanSetRight(int princID, RightDescriptor right) throws SDKException {
        Principal princ;
        RightDescriptor normalized = this.normalizeRight(right);
        if (this.m_isGlobalInfoLoaded) {
            if (this.isCanSetAll(princID)) {
                return true;
            }
            if (!this.isGlobalCanSetRightWithoutMRR(normalized)) {
                return false;
            }
        }
        if ((princ = this.ensureSecInfo(princID)) == null) {
            return false;
        }
        return this.isCanSetAll(princID) || this.isGlobalCanSetRightWithoutMRR(normalized) && princ.isSMRRGrantedForPrincipal();
    }

    public boolean isCanSetRole(int princID, int roleID) throws SDKException {
        Principal princ;
        if (this.m_isGlobalInfoLoaded) {
            if (this.isCanSetAll(princID)) {
                return this.isAssignRoleRightGranted(roleID);
            }
            if (!this.isGlobalCanSetRoleWithoutMRR(roleID)) {
                return false;
            }
        }
        if ((princ = this.ensureSecInfo(princID)) == null) {
            return false;
        }
        if (this.isCanSetAll(princID)) {
            return this.isAssignRoleRightGranted(roleID);
        }
        return this.isGlobalCanSetRoleWithoutMRR(roleID) && princ.isSMRRGrantedForPrincipal();
    }

    public boolean isCanSetInheritance(int princID) throws SDKException {
        Principal princ;
        if (this.m_isGlobalInfoLoaded) {
            if (this.isCanSetAll(princID)) {
                return true;
            }
            if (!this.m_isCIFGrantedForObj) {
                return false;
            }
        }
        if ((princ = this.ensureSecInfo(princID)) == null) {
            return false;
        }
        return this.isCanSetAll(princID) || this.m_isCIFGrantedForObj && princ.isCIFGrantedForPrincipal();
    }

    private RightDescriptor normalizeRight(RightDescriptor right) throws SDKException {
        if (this.m_pluginMgr != null) {
            Object applicableKind;
            boolean isOwner;
            Object rightKind;
            int baseID;
            block10: {
                block9: {
                    baseID = SecurityIDs.getBaseRightID(right.id);
                    rightKind = right.kind;
                    try {
                        if (RightID.isSpecificType(right.kind)) {
                            rightKind = SecurityValidator.getRealKind(this.m_pluginMgr, right.kind);
                        } else if (SecurityIDs.isPluginSpecificRight(right.id)) {
                            SecurityIDs.getRightKind(right.id, this.m_pluginMgr);
                        }
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) break block9;
                        LOG.debug((Object)("SecurityHelper.normalizeRight(): failed to get plugin info for " + right.kind));
                    }
                }
                isOwner = right.isOwner || SecurityIDs.isOwnerRight(right.id);
                applicableKind = right.applicableObjectType;
                try {
                    if (RightID.isSpecificType(right.applicableObjectType)) {
                        applicableKind = SecurityValidator.getRealProgID(this.m_pluginMgr, right.applicableObjectType);
                    }
                }
                catch (SDKException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug((Object)("SecurityHelper.normalizeRight(): failed to get plugin info for " + right.applicableObjectType));
                }
            }
            String scope = SecurityValidator.validateScope(right.scope);
            return new RightDescriptor(baseID, rightKind, isOwner, scope, applicableKind);
        }
        return right;
    }

    private boolean isGlobalCanSetRightWithoutMRR(RightDescriptor right) throws SDKException {
        RightDescriptor rightNonOwner;
        this.ensureGlobalSecInfo();
        if (!this.m_isSMRRGrantedForObj) {
            return false;
        }
        Boolean granted = null;
        if (this.m_assignedRights != null && (granted = (Boolean)this.m_assignedRights.get(right)) != null && granted.booleanValue()) {
            return true;
        }
        if (right.isOwner && this.isGlobalCanSetRightWithoutMRR(rightNonOwner = new RightDescriptor(right.id, right.kind, false, right.scope, "Any"))) {
            return true;
        }
        if (granted == null && RightID.isSpecificType(right.applicableObjectType)) {
            RightDescriptor rightAnyType = new RightDescriptor(right.id, right.kind, right.isOwner, right.scope, "Any");
            return this.isGlobalCanSetRightWithoutMRR(rightAnyType);
        }
        return false;
    }

    private boolean isGlobalCanSetRoleWithoutMRR(int roleID) throws SDKException {
        this.ensureGlobalSecInfo();
        return this.m_isSMRRGrantedForObj && this.m_assignedRoles != null && this.m_assignedRoles.contains(new Integer(roleID)) && this.isAssignRoleRightGranted(roleID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAssignRoleRightGranted(int roleID) throws SDKException {
        HashMap hashMap = this.m_assignRoleRightMap;
        synchronized (hashMap) {
            Boolean isGranted = (Boolean)this.m_assignRoleRightMap.get(new Integer(roleID));
            if (isGranted != null) {
                return isGranted;
            }
        }
        ISecCacheController secCache = this.m_session.getSecurityInfoMgr().getSecCache();
        secCache.batch();
        try {
            secCache.cacheRight(83, "", roleID);
            secCache.commit();
        }
        catch (Throwable e) {
            secCache.rollback();
            if (e instanceof SDKException) {
                throw (SDKException)((Object)e);
            }
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        ISecRights secRights = this.m_session.getSecurityInfoMgr().getRights();
        boolean isGranted = secRights.checkRight(83, "", roleID) == 2;
        HashMap hashMap2 = this.m_assignRoleRightMap;
        synchronized (hashMap2) {
            this.m_assignRoleRightMap.put(new Integer(roleID), new Boolean(isGranted));
        }
        return isGranted;
    }

    private void ensureGlobalSecInfo() throws SDKException {
        if (!this.m_isGlobalInfoLoaded) {
            ISecCacheController secCache = this.m_session.getSecurityInfoMgr().getSecCache();
            ISecCacheControllerAdmin secCacheAdmin = this.m_session.getSecurityInfoMgr().getSecCacheAdmin();
            secCache.batch();
            try {
                this.cacheGlobalSecInfo(secCache, secCacheAdmin);
                secCache.commit();
            }
            catch (Throwable e) {
                secCache.rollback();
                if (e instanceof SDKException) {
                    throw (SDKException)((Object)e);
                }
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
            ISecRights secRights = this.m_session.getSecurityInfoMgr().getRights();
            this.loadGlobalSecInfo(secRights);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal ensureSecInfo(int princID) throws SDKException {
        Principal princ;
        HashMap hashMap = this.m_principalsSecInfoMap;
        synchronized (hashMap) {
            princ = (Principal)this.m_principalsSecInfoMap.get(new Integer(princID));
            if (princ != null) {
                return princ;
            }
        }
        ISecCacheController secCache = this.m_session.getSecurityInfoMgr().getSecCache();
        ISecCacheControllerAdmin secCacheAdmin = this.m_session.getSecurityInfoMgr().getSecCacheAdmin();
        secCache.batch();
        try {
            this.cacheGlobalSecInfo(secCache, secCacheAdmin);
            secCache.cacheRight(73, "", princID);
            secCache.cacheRight(82, "", princID);
            secCache.commit();
        }
        catch (Throwable e) {
            secCache.rollback();
            if (e instanceof SDKException) {
                throw (SDKException)((Object)e);
            }
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        ISecRights secRights = this.m_session.getSecurityInfoMgr().getRights();
        this.loadGlobalSecInfo(secRights);
        boolean isSMRRGrantedForPrinc = false;
        boolean isCIFGrantedForPrinc = false;
        if (!this.m_isMRRGranted) {
            isSMRRGrantedForPrinc = secRights.checkRight(73, "", princID) == 2;
            isCIFGrantedForPrinc = secRights.checkRight(82, "", princID) == 2;
        }
        princ = new Principal(princID, isSMRRGrantedForPrinc, isCIFGrantedForPrinc);
        HashMap hashMap2 = this.m_principalsSecInfoMap;
        synchronized (hashMap2) {
            this.m_principalsSecInfoMap.put(new Integer(princID), princ);
        }
        return princ;
    }

    private void loadGlobalSecInfo(ISecRights secRights) throws SDKException {
        if (!this.m_isGlobalInfoLoaded) {
            boolean bl = this.m_isMRRGranted = secRights.checkRight(8, "", this.m_objectID) == 2;
            if (!this.m_isMRRGranted) {
                this.m_isSMRRGrantedForObj = secRights.checkRight(73, "", this.m_objectID) == 2;
                this.m_isCIFGrantedForObj = secRights.checkRight(82, "", this.m_objectID) == 2;
                this.m_assignedRights = new HashMap();
                this.m_assignedRoles = new HashSet();
                ISecRightsAdmin secRightsAdmin = this.m_session.getSecurityInfoMgr().getRightsAdmin();
                ISecurityResult result = secRightsAdmin.getSecurityInfo(this.m_objectID, this.m_loggedOnUserID);
                if (result.getStatus() == 0) {
                    ISecurityInfoResult secInfo = (ISecurityInfoResult)result.getResult();
                    ISecurityRightAdmin[] efRights = secInfo.getRights();
                    for (int i = 0; i < efRights.length; ++i) {
                        ISecurityRightAdmin efRight = efRights[i];
                        this.m_assignedRights.put(efRight.getRightDescriptor(), new Boolean(efRight.isGranted()));
                    }
                    ISecurityRoleAdmin[] efRoles = secInfo.getRoles();
                    for (int i = 0; i < efRoles.length; ++i) {
                        ISecurityRoleAdmin efRole = efRoles[i];
                        this.m_assignedRoles.add(new Integer(efRole.getID()));
                    }
                }
            }
            this.m_isGlobalInfoLoaded = true;
        }
    }

    private void cacheGlobalSecInfo(ISecCacheController secCache, ISecCacheControllerAdmin secCacheAdmin) throws SDKException {
        if (!this.m_isGlobalInfoLoaded) {
            secCache.cacheRight(8, "", this.m_objectID);
            secCache.cacheRight(73, "", this.m_objectID);
            secCache.cacheRight(82, "", this.m_objectID);
            secCacheAdmin.cacheSecurityInfo(this.m_objectID, this.m_loggedOnUserID);
        }
    }

    private class Principal {
        private int principalID;
        private boolean isSMRRGrantedForPrinc;
        private boolean isCIFGrantedForPrinc;

        public Principal(int principalID, boolean isSMRRGrantedForPrinc, boolean isCIFGrantedForPrinc) {
            this.principalID = principalID;
            this.isSMRRGrantedForPrinc = isSMRRGrantedForPrinc;
            this.isCIFGrantedForPrinc = isCIFGrantedForPrinc;
        }

        public int getPrincipalID() {
            return this.principalID;
        }

        public boolean isSMRRGrantedForPrincipal() {
            return this.isSMRRGrantedForPrinc;
        }

        public boolean isCIFGrantedForPrincipal() {
            return this.isCIFGrantedForPrinc;
        }
    }
}

