/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipal;
import com.crystaldecisions.sdk.occa.infostore.IEffectivePrincipals;
import com.crystaldecisions.sdk.occa.infostore.IExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfo2;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectivePrincipal;
import com.crystaldecisions.sdk.occa.infostore.internal.EffectivePrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.ExplicitPrincipals;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalSecurityInfo;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRights;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecLoadEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.ISecUpdateEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityHelper;
import com.crystaldecisions.sdk.occa.security.IBatch;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SecurityInfo2
extends AbstractSecurityInfo
implements ISecurityInfo2,
IPersistRights,
IInternalSecurityInfo,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SecurityInfo2");
    private IInfoObject m_object;
    private IRightID[] m_knownRights;
    private IRightID[] m_knownLimits;
    private IRoleID[] m_knownRoles;
    private IPluginBasedRightIDs m_knownRightsByPlugin;
    private ExplicitPrincipals m_explicitPrincipals;
    private EffectivePrincipals m_effectivePrincipals;
    private boolean m_isSecInfoLoaded;
    private AbstractSecEventListener m_loadListener;
    private ISecUpdateEvent m_updateEvent;
    private SecurityHelper m_helper;
    private static final int REQ_BASIC = 0;
    private static final int REQ_ADMIN = 1;
    private static final int REQ_SCOPED = 2;
    private static final int REQ_ADMIN_SCOPED = 3;

    public SecurityInfo2() {
    }

    public SecurityInfo2(IInfoObject obj, ISecuritySession session) throws SDKException {
        super(session);
        this.m_object = obj;
        this.m_isSecInfoLoaded = false;
        this.makeListener(this);
        this.m_helper = new SecurityHelper(obj.getID(), session.getUserInfo().getUserID(), session);
    }

    private void makeListener(final SecurityInfo2 secInfo) {
        this.m_loadListener = new AbstractSecEventListener(){

            public ISecUpdateEvent load(ISecLoadEvent event) throws SDKException {
                int eventId = event.getType();
                if (!this.isLoaded(event.getType())) {
                    SecurityInfo2.this.initializeRights();
                    if (eventId == 0) {
                        SecurityInfo2.this.getKnownRights();
                        SecurityInfo2.this.getKnownLimits();
                        SecurityInfo2.this.getKnownRoles();
                        SecurityInfo2.this.getKnownRightsByPlugin();
                        if (SecurityInfo2.this.m_updateEvent == null) {
                            SecurityInfo2.this.m_updateEvent = new ISecUpdateEvent(this, eventId){
                                private final /* synthetic */ int val$eventId;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$eventId = val$eventId;
                                }

                                public int getType() {
                                    return this.val$eventId;
                                }

                                public IRightID[] getKnownRights() throws SDKException {
                                    return 1.access$100(this.this$1).getKnownRights();
                                }

                                public IRightID[] getKnownLimits() throws SDKException {
                                    return 1.access$100(this.this$1).getKnownLimits();
                                }

                                public IRoleID[] getKnownRoles() throws SDKException {
                                    return 1.access$100(this.this$1).getKnownRoles();
                                }

                                public IPluginBasedRightIDs getKnownRightsByPlugin() throws SDKException {
                                    return 1.access$100(this.this$1).getKnownRightsByPlugin();
                                }
                            };
                        }
                    } else if (eventId == 1 && !((IInternalInfoObject)SecurityInfo2.this.m_object).isNew() && SecurityInfo2.this.m_explicitPrincipals != null && !SecurityInfo2.this.m_explicitPrincipals.isLoaded()) {
                        SecurityInfo2.this.m_explicitPrincipals.loadPrincipals(SecurityInfo2.this.m_cacheAdmin, SecurityInfo2.this.m_rightsAdmin, SecurityInfo2.this.m_object.getID(), SecurityInfo2.this.isUseCacheForAdminRequests());
                    }
                }
                return SecurityInfo2.this.m_updateEvent;
            }

            static /* synthetic */ SecurityInfo2 access$100(1 x0) {
                return x0.secInfo;
            }
        };
    }

    public synchronized boolean isUseCacheForAdminRequests() {
        return false;
    }

    public synchronized void setUseCacheForAdminRequests(boolean useCache) {
    }

    public boolean checkRight(int right, Object kind, boolean useCache) throws SDKException {
        return this.internalCheckRight(new RightDescriptor(right, kind, false), -1, useCache, 0);
    }

    public boolean checkRight(int right, Object kind, int principalID, boolean useCache) throws SDKException {
        return this.internalCheckRight(new RightDescriptor(right, kind, false), principalID, useCache, 1);
    }

    public boolean[] checkRights(int[] rights, Object[] kinds, boolean useCache) throws SDKException {
        return this.internalCheckRights(this.getRightDescriptors(rights, kinds), -1, useCache, 0);
    }

    public boolean[] checkRights(int[] rights, Object[] kinds, int principalID, boolean useCache) throws SDKException {
        return this.internalCheckRights(this.getRightDescriptors(rights, kinds), principalID, useCache, 1);
    }

    public boolean checkRight(RightDescriptor right, boolean useCache) throws SDKException {
        return this.internalCheckRight(right, -1, useCache, 2);
    }

    public boolean checkRight(RightDescriptor right, int principalID, boolean useCache) throws SDKException {
        return this.internalCheckRight(right, principalID, useCache, 3);
    }

    public boolean[] checkRights(RightDescriptor[] rights, boolean useCache) throws SDKException {
        return this.internalCheckRights(rights, -1, useCache, 2);
    }

    public boolean[] checkRights(RightDescriptor[] rights, int principalID, boolean useCache) throws SDKException {
        return this.internalCheckRights(rights, principalID, useCache, 3);
    }

    private RightDescriptor[] getRightDescriptors(int[] rights, Object[] kinds) throws SDKException.InvalidArg {
        if (rights == null || rights.length == 0 || kinds == null || rights.length != kinds.length) {
            throw new SDKException.InvalidArg();
        }
        RightDescriptor[] rightDescs = new RightDescriptor[rights.length];
        for (int i = 0; i < rights.length; ++i) {
            rightDescs[i] = new RightDescriptor(rights[i], kinds[i], false);
        }
        return rightDescs;
    }

    private boolean internalCheckRight(RightDescriptor right, int principalID, boolean useCache, int reqType) throws SDKException {
        this.initializeRights();
        boolean isAdminReq = reqType == 1 || reqType == 3;
        IBatch batch = isAdminReq ? this.m_cacheAdmin : this.m_cache;
        batch.batch(useCache);
        try {
            this.doCacheRight(reqType, right, principalID);
            batch.commit();
        }
        catch (SDKException e) {
            batch.rollback();
            throw e;
        }
        catch (Throwable e) {
            batch.rollback();
            SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
            throw sdke;
        }
        return this.doCheckRight(reqType, right, principalID) == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean[] internalCheckRights(RightDescriptor[] rights, int principalID, boolean useCache, int reqType) throws SDKException {
        if (rights == null || rights.length == 0) {
            throw new SDKException.InvalidArg();
        }
        boolean[] granted = new boolean[rights.length];
        this.initializeRights();
        boolean isAdminReq = reqType == 1 || reqType == 3;
        IBatch batch = isAdminReq ? this.m_cacheAdmin : this.m_cache;
        HashMap rightMap = new HashMap(rights.length);
        IBatch iBatch = batch;
        synchronized (iBatch) {
            batch.batch(useCache);
            try {
                for (int i = 0; i < rights.length; ++i) {
                    if (rightMap.containsKey(rights[i])) continue;
                    this.doCacheRight(reqType, rights[i], principalID);
                    rightMap.put(rights[i], null);
                }
                batch.commit();
            }
            catch (SDKException e) {
                batch.rollback();
                throw e;
            }
            catch (Throwable e) {
                batch.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
        }
        Iterator iter = rightMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            RightDescriptor right = (RightDescriptor)entry.getKey();
            boolean isGranted = this.doCheckRight(reqType, right, principalID) == 2;
            entry.setValue(isGranted);
        }
        for (int i = 0; i < rights.length; ++i) {
            Object value = rightMap.get(rights[i]);
            LOG.assertNotNull(value);
            if (value == null) continue;
            granted[i] = (Boolean)value;
        }
        return granted;
    }

    private void doCacheRight(int reqType, RightDescriptor right, int principalID) throws SDKException {
        switch (reqType) {
            case 0: {
                this.m_cache.cacheRight(right.id, right.kind, this.m_object.getID());
                break;
            }
            case 1: {
                this.m_cacheAdmin.cacheRight(right.id, right.kind, principalID, this.m_object.getID());
                break;
            }
            case 2: {
                this.m_cache.cacheRight(right, this.m_object.getID());
                break;
            }
            case 3: {
                this.m_cacheAdmin.cacheRight(right, principalID, this.m_object.getID());
            }
        }
    }

    private int doCheckRight(int reqType, RightDescriptor right, int principalID) throws SDKException {
        int result = 4;
        switch (reqType) {
            case 0: {
                result = this.m_rights.checkRight(right.id, right.kind, this.m_object.getID());
                break;
            }
            case 1: {
                result = this.m_rightsAdmin.checkRight(right.id, right.kind, principalID, this.m_object.getID());
                break;
            }
            case 2: {
                result = this.m_rights.checkRight(right, this.m_object.getID());
                break;
            }
            case 3: {
                result = this.m_rightsAdmin.checkRight(right, principalID, this.m_object.getID());
            }
        }
        return result;
    }

    public IEffectivePrincipals getEffectivePrincipals() throws SDKException {
        if (this.m_effectivePrincipals == null) {
            this.m_effectivePrincipals = new EffectivePrincipals(this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_object.getID(), this.m_loadListener);
            this.initializeRights();
            this.m_effectivePrincipals.loadPrincipals(this.m_cacheAdmin, this.m_rightsAdmin, this.m_object.getID(), this.isUseCacheForAdminRequests());
        }
        return this.m_effectivePrincipals;
    }

    public IEffectivePrincipal getAnyPrincipal(int id) throws SDKException {
        this.initializeRights();
        EffectivePrincipal op = new EffectivePrincipal(id, "", this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_object.getID(), this.m_loadListener);
        op.loadSecurityInfo(this.m_cacheAdmin, this.m_rightsAdmin, this.m_object.getID(), this.isUseCacheForAdminRequests());
        return op;
    }

    public IExplicitPrincipals getExplicitPrincipals() throws SDKException {
        if (this.m_explicitPrincipals == null) {
            this.m_explicitPrincipals = new ExplicitPrincipals(this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_object.getID(), false, this.m_loadListener);
        }
        return this.m_explicitPrincipals;
    }

    public IExplicitPrincipals newExplicitPrincipals() throws SDKException {
        if (this.m_explicitPrincipals == null) {
            this.m_explicitPrincipals = new ExplicitPrincipals(this.m_knownRights, this.m_knownLimits, this.m_knownRoles, this.m_session, this.m_object.getID(), true, this.m_loadListener);
        }
        return this.m_explicitPrincipals;
    }

    public IPluginBasedRightIDs getKnownRightsByPlugin() throws SDKException {
        this.initializeRights();
        if (this.m_knownRightsByPlugin == null) {
            if (((IInternalInfoObject)this.m_object).isNew()) {
                this.m_knownRightsByPlugin = new PluginBasedRightIDs(new IRightID[0], new IRightID[0], new HashMap(), new HashMap());
            } else {
                int objID = this.loadSecurityInfo();
                ISecurityResult result = this.m_rightsAdmin.getKnownRightsByPlugin(objID);
                this.m_knownRightsByPlugin = new PluginBasedRightIDs((IPluginBasedRightIDs)result.getResult());
            }
        }
        return this.m_knownRightsByPlugin;
    }

    public boolean isCanSetAll(int princID) throws SDKException {
        return this.m_helper.isCanSetAll(princID);
    }

    public boolean isCanSetRight(int princID, RightDescriptor right) throws SDKException {
        return this.m_helper.isCanSetRight(princID, right);
    }

    public boolean isCanSetRole(int princID, int roleID) throws SDKException {
        return this.m_helper.isCanSetRole(princID, roleID);
    }

    public boolean isCanSetInheritance(int princID) throws SDKException {
        return this.m_helper.isCanSetInheritance(princID);
    }

    public void saveRights(IRightsAdmin rightsAdmin) throws SDKException {
        throw new SDKException.NotImplemented("SecurityInfo2.saveRights()");
    }

    public void saveRights2(ISecRightsAdmin rightsAdmin) throws SDKException {
        if (this.m_explicitPrincipals != null) {
            this.m_explicitPrincipals.saveRights(rightsAdmin, this.m_object.getID());
        }
    }

    public IRightID[] getKnownRights() throws SDKException {
        this.initializeRights();
        if (this.m_knownRights == null) {
            if (((IInternalInfoObject)this.m_object).isNew()) {
                this.m_knownRights = new RightID[0];
            } else {
                int objID = this.loadSecurityInfo();
                ISecurityResult result = this.m_rightsAdmin.getKnownRights(objID);
                IRightID[] rights = (IRightID[])result.getResult();
                this.m_knownRights = new RightID[rights.length];
                System.arraycopy(rights, 0, this.m_knownRights, 0, rights.length);
            }
        }
        return this.m_knownRights;
    }

    private int loadSecurityInfo() throws SDKException {
        int objID;
        IInternalInfoObject obj = (IInternalInfoObject)this.m_object;
        int n = objID = obj.isNew() ? obj.getSecuritySurrogate() : obj.getID();
        if (!this.m_isSecInfoLoaded) {
            this.m_cacheAdmin.batch(this.isUseCacheForAdminRequests());
            try {
                this.m_cacheAdmin.cacheKnownSecurityInfo(objID);
                this.m_cacheAdmin.cacheKnownRightsByPlugin(objID);
                this.m_cacheAdmin.commit();
            }
            catch (SDKException e) {
                this.m_cacheAdmin.rollback();
                throw e;
            }
            catch (Throwable e) {
                this.m_cacheAdmin.rollback();
                SDKException.ExceptionWrapper sdke = new SDKException.ExceptionWrapper(e);
                throw sdke;
            }
            this.m_isSecInfoLoaded = true;
        }
        return objID;
    }

    public IRightID[] getKnownLimits() throws SDKException {
        this.initializeRights();
        if (this.m_knownLimits == null) {
            if (((IInternalInfoObject)this.m_object).isNew()) {
                this.m_knownLimits = new RightID[0];
            } else {
                int objID = this.loadSecurityInfo();
                ISecurityResult result = this.m_rightsAdmin.getKnownLimits(objID);
                this.m_knownLimits = (IRightID[])result.getResult();
            }
        }
        return this.m_knownLimits;
    }

    public IRoleID[] getKnownRoles() throws SDKException {
        this.initializeRights();
        if (this.m_knownRoles == null) {
            if (!((IInternalInfoObject)this.m_object).isNew()) {
                this.loadSecurityInfo();
            }
            ISecurityResult result = this.m_rightsAdmin.getKnownRoles();
            this.m_knownRoles = (IRoleID[])result.getResult();
        }
        return this.m_knownRoles;
    }

    public boolean checkPluginRight(int rightID) throws SDKException {
        boolean checkThisObjType;
        IInternalInfoObject obj = (IInternalInfoObject)this.m_object;
        boolean bl = checkThisObjType = !SecurityIDs.isPluginSpecificRight(rightID) || obj.getNonInstanceObjType() == SecurityIDs.getPluginType(rightID);
        if (checkThisObjType) {
            return this.checkRight(rightID, null, true);
        }
        return true;
    }

    IInfoObject getObject() {
        return this.m_object;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_explicitPrincipals);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_explicitPrincipals = (ExplicitPrincipals)in.readObject();
    }

    void initFromSerialization(ISecurityInfo2 deltaSecurityInfo) throws SDKException {
        if (this.m_loadListener == null) {
            this.makeListener(this);
        }
        this.m_explicitPrincipals = ((SecurityInfo2)deltaSecurityInfo).m_explicitPrincipals;
        if (this.m_explicitPrincipals != null) {
            this.m_explicitPrincipals.initFromSerialization(this.m_loadListener, this.m_object);
        }
    }
}

