/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.holder.internal.IntHolder;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimit;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimits;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractRight;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSecuritySet;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

class SecurityLimits
extends AbstractSecuritySet
implements ISecurityLimits {
    public SecurityLimits() {
    }

    public SecurityLimits(ISecuritySession session, IRightID[] knownLimits) {
        super(session, knownLimits);
    }

    public ISecurityLimit add(int id) {
        ISecurityLimit limit = this.get(id);
        if (limit == null) {
            IRightID rightID = this.findRightByID(id);
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                SecurityLimit newRight = new SecurityLimit(id, persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID());
                this.addValue(newRight);
                return newRight;
            }
            return null;
        }
        return limit;
    }

    ISecurityLimit importLimit(int id) {
        ISecurityLimit limit = this.get(id);
        if (limit == null) {
            IRightID rightID = this.findRightByID(id);
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                SecurityLimit newRight = new SecurityLimit(id, persistID.getDescriptionID(), persistID.getCategoryID(), persistID.getCollectionID());
                this.importValue(newRight);
                return newRight;
            }
            return null;
        }
        return limit;
    }

    public ISecurityLimit get(int id) {
        return (ISecurityLimit)((Object)this.getValue(new Integer(id)));
    }

    public Iterator iterator() {
        return super.iterator();
    }

    public void remove(int id) {
        super.removeValue(new Integer(id), new AbstractSecuritySet.RemovedRight(id), true);
    }

    public int size() {
        return super.size();
    }

    protected Object createRemovedEntry(Object right) {
        RightID rightId = (RightID)right;
        return new AbstractSecuritySet.RemovedRight(rightId.getID());
    }

    protected Object getKey(Object right) {
        return new Integer(((IRightID)right).getID());
    }

    protected void update(Object delta) {
        SecurityLimit deltaLimit = (SecurityLimit)delta;
        int id = deltaLimit.getID();
        SecurityLimit limit = (SecurityLimit)this.get(id);
        if (limit == null) {
            IRightID rightID = this.findRightByID(id);
            String description = "";
            String category = "";
            int collection = 0;
            if (rightID != null) {
                IPersistRightID persistID = (IPersistRightID)rightID;
                description = persistID.getDescriptionID();
                category = persistID.getCategoryID();
                collection = persistID.getCollectionID();
            }
            SecurityLimit newLimit = new SecurityLimit(id, description, category, collection);
            newLimit.update(deltaLimit);
            this.addValue(newLimit);
        } else {
            limit.update(deltaLimit);
        }
    }

    void importExplicitLimit(ISecurityLimit right) {
        AbstractRight ar;
        IPersistRightID rightID = (IPersistRightID)this.findRightByID(right.getID());
        if (!(rightID == null || (ar = (AbstractRight)this.getValue(new Integer(right.getID()))) != null && ar.isDirty())) {
            SecurityLimit rightCP = new SecurityLimit(right);
            rightCP.setCategoryID(rightID.getCategoryID());
            rightCP.setDescriptionID(rightID.getDescriptionID());
            this.importValue(rightCP);
        }
    }

    public void serializeHelper(PropertyArrayHelper arrayhelper) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            SecurityLimit limit = (SecurityLimit)itr.next();
            PropertyBag bag = arrayhelper.add(null, 0x8000000).getPropertyBag();
            limit.serializeHelper(bag);
        }
    }

    static class SecurityLimit
    extends AbstractRight
    implements ISecurityLimit {
        private int m_limit;

        public SecurityLimit() {
        }

        public SecurityLimit(int id, String description, String category, int collection) {
            super(id, description, category, collection);
            this.m_limit = 0;
        }

        public SecurityLimit(ISecurityLimit limit) {
            super(limit.getID(), null, null, 0);
            this.m_limit = limit.getValue();
        }

        public void setValue(int value) {
            if (value != this.m_limit) {
                this.m_limit = value;
                this.m_dirty = true;
            }
        }

        public int getValue() {
            return this.m_limit;
        }

        public boolean isMaximumValueUsed() {
            return false;
        }

        public void preloadRights(ICacheControllerAdmin cacheAdmin, int objectID, int principalID, String type) throws SDKException {
            if (!this.m_dirty) {
                cacheAdmin.cacheLong(this.m_id, "#" + principalID, "#" + objectID, type);
            }
        }

        public void loadRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type, int aggrMode) throws SDKException {
            if (!this.m_dirty) {
                IntHolder min = new IntHolder();
                IntHolder max = new IntHolder();
                int status = rightsAdmin.checkLong(this.m_id, "#" + principalID, "#" + objectID, type, aggrMode, min, max);
                this.m_limit = this.isMaximumValueUsed() ? max.get() : min.get();
                this.m_exists = status != 4;
                this.m_inherited = aggrMode != 1;
                this.m_dirty = false;
            }
        }

        public void saveRights(IRightsAdmin rightsAdmin, int objectID, int principalID, String type) throws SDKException {
            if (this.m_dirty) {
                rightsAdmin.setRightLong(this.m_id, "#" + principalID, "#" + objectID, type, this.m_limit);
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeInt(this.m_limit);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.m_limit = in.readInt();
        }

        protected void update(AbstractRight right) {
            super.update(right);
            this.setValue(((ISecurityLimit)((Object)right)).getValue());
        }

        protected void serializeHelper(PropertyBag bag) {
            super.serializeHelper(bag);
            bag.addItem((Object)PropertyIDs.SI_VALUE, (Object)new Integer(this.m_limit), 0);
        }
    }
}

