/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.infostore.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.category.internal.Categories;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStore;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.plugin.desktop.folder.internal.Folders;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;

final class SerializableInfoObjects
implements Serializable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.infostore.internal.SerializableInfoObjects");
    private List m_list;
    private IInternalInfoStore m_infoStore;
    private int m_resultSize;
    private String m_progID;

    SerializableInfoObjects(List list, IInternalInfoStore infoStore, int resultSize, String progID) {
        this.m_list = list;
        this.m_infoStore = infoStore;
        this.m_resultSize = resultSize;
        this.m_progID = progID;
    }

    Object readResolve() throws ObjectStreamException {
        InfoObjects coll = null;
        if (this.m_progID != null) {
            ISecuritySession session = ((InternalInfoStore)this.m_infoStore).getSecuritySession();
            try {
                IPluginMgr pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", session);
                IPluginInfo pluginInfo = pluginMgr.getPluginInfo(this.m_progID);
                if (this.m_progID.equals("CrystalEnterprise.Folder")) {
                    coll = new Folders(pluginInfo);
                } else if (this.m_progID.equals("CrystalEnterprise.Category")) {
                    coll = new Categories(pluginInfo);
                }
            }
            catch (SDKException.PluginNotFound ex) {
                LOG.warn((Object)("cannot find plugin with prog ID=" + this.m_progID), (Throwable)((Object)ex));
                coll = null;
            }
            catch (SDKException ex) {
                LOG.error((Object)("unable to get IPluginMgr for plugin with prog ID=" + this.m_progID), (Throwable)((Object)ex));
                coll = null;
            }
        }
        if (coll == null) {
            coll = new InfoObjects();
        }
        coll.initFromSerialization(this.m_list, this.m_infoStore, this.m_resultSize);
        return coll;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_list);
        out.writeObject(this.m_infoStore);
        out.writeInt(this.m_resultSize);
        out.writeObject(this.m_progID);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_list = (List)in.readObject();
        this.m_infoStore = (IInternalInfoStore)in.readObject();
        this.m_resultSize = in.readInt();
        this.m_progID = (String)in.readObject();
    }
}

