/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.pluginmgr.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRole;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistRole;
import com.crystaldecisions.sdk.occa.infostore.internal.Role;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginRole;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.IInternalPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginSecurityInfo;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.HashSet;

class PluginRole
implements IPluginRole {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginRole");
    private IRole m_role;
    private IRightID[] m_rightIDs;
    private boolean m_useOnlyOwnRights;

    PluginRole(PropertyBag properties, int obType, boolean isMetaPlugin, IPluginInfo pluginInfo) {
        int rightMask = PluginRole.getRightMask(obType, isMetaPlugin);
        this.loadRights(properties, rightMask);
        this.loadRole(properties);
        IInternalPluginInfo internal = (IInternalPluginInfo)((Object)pluginInfo);
        this.m_useOnlyOwnRights = internal.isUseOnlyOwnRights();
    }

    public static int getRightMask(int obType, boolean isMetaPlugin) {
        return isMetaPlugin ? 0 : obType << 16;
    }

    private void loadRole(PropertyBag properties) {
        int id = properties.getInt((Object)PropertyIDs.SI_ID);
        String description = properties.getString((Object)PropertyIDs.SI_DESCRIPTION);
        this.m_role = Role.makeRole(id, description);
    }

    private void loadRights(PropertyBag properties, int rightMask) {
        PropertyBag propBag = properties.getPropertyBag((Object)PropertyIDs.SI_RIGHTS);
        if (propBag != null) {
            PropertyArrayHelper helper = new PropertyArrayHelper(properties.getPropertyBag((Object)PropertyIDs.SI_RIGHTS), PropertyIDs.SI_TOTAL);
            HashSet<IRightID> result = new HashSet<IRightID>(helper.size());
            for (int i = 0; i < helper.size(); ++i) {
                PropertyBag bag = (PropertyBag)helper.get(i);
                if (bag == null) {
                    LOG.warn((Object)"Bad plugin xml, SI_TOTAL is different from the actual size.");
                    continue;
                }
                result.add(PluginSecurityInfo.makeRightID(bag, rightMask));
            }
            if (helper.size() != result.size()) {
                LOG.warn((Object)("Bad plugin xml, SI_TOTAL is different from the actual size. SI_TOTAL=" + helper.size() + " actual size=" + result.size()));
            }
            this.m_rightIDs = result.toArray(new IRightID[result.size()]);
        } else {
            this.m_rightIDs = new IRightID[0];
        }
    }

    public IRightID[] getRights() {
        return this.m_rightIDs;
    }

    public IRole getRole() {
        return this.m_role;
    }

    public void updateRole() {
        IRole role = this.getRole();
        if (role != null && role instanceof IPersistRole) {
            IPersistRole persistRole = (IPersistRole)((Object)role);
            IRightID[] rights = this.getRights();
            persistRole.addPluginRights(rights);
            IRole enumRole = Role.getRole(persistRole.getID());
            IPersistRole persistEnumRole = (IPersistRole)((Object)enumRole);
            if (this.m_useOnlyOwnRights) {
                ArrayList<IRightID> effectiveRights = new ArrayList<IRightID>(rights.length);
                for (int i = 0; i < rights.length; ++i) {
                    IRightID right = rights[i];
                    if (!SecurityIDs.isPluginSpecificRight(right.getID())) continue;
                    effectiveRights.add(right);
                }
                persistEnumRole.addPluginRights(effectiveRights.toArray(new IRightID[effectiveRights.size()]));
            } else {
                persistEnumRole.addPluginRights(rights);
            }
        }
    }
}

