/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.occa.ras21.IRASConnection;
import com.crystaldecisions.sdk.occa.ras21.IRASConnectionInitService;
import com.crystaldecisions.sdk.occa.ras21.RAS21ResourceBundle;
import com.crystaldecisions.sdk.occa.ras21.RASConnection;
import com.crystaldecisions.sdk.occa.ras21.RASConnectionException;
import com.crystaldecisions.sdk.occa.ras21.messages.GetConnection;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import com.crystaldecisions.sdk.occa.ras21.serialization.wireob.WireObServerDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.wireob.WireObServerSerializer;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class RASConnectionFactory {
    private static final ILogger LOG = LoggerManager.getLogger((Class)RASConnectionFactory.class);
    private static final String RASCONN_CLASS_ID = "RC";
    private static final String RASCONN_GET_CONNECTION = "C";
    private static final String RASCONN_SERVER_KIND = "K";
    private static final String RASCONN_INIT_SERVICE = "S";
    private static final String RASCONN_UNMANAGED_SERVERS = "US";
    private static final String CRYSTAL_ENTERPRISE_PREFIX = "CrystalEnterprise.";
    private static final Object s_mutex = new Object();
    private static RASConnectionFactory s_singleton;
    private RASConnectionServerSerializationFactory m_serializationFactory = new RASConnectionServerSerializationFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RASConnectionFactory getFactory(Locale i_locale) throws RASConnectionException {
        Object object = s_mutex;
        synchronized (object) {
            if (null == s_singleton) {
                s_singleton = new RASConnectionFactory();
            }
            return s_singleton;
        }
    }

    public IRASConnection getRASConnectionCUID(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, String i_sCUID) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionObjectCUID()");
            LOG.info((Object)("CUID is '" + (null == i_sCUID ? "" : i_sCUID) + "'"));
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("3", i_sCUID);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionCUID(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, Map i_configuration, String i_sCUID) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionObjectCUID()");
            LOG.info((Object)("CUID is '" + (null == i_sCUID ? "" : i_sCUID) + "'"));
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("3", i_sCUID);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionObjectId(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, int i_nObjectId) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionObjectId()");
            LOG.info((Object)("Object ID is " + i_nObjectId));
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("4", "" + i_nObjectId);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionObjectId(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, Map i_configuration, int i_nObjectId) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionObjectId()");
            LOG.info((Object)("Object ID is " + i_nObjectId));
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("4", "" + i_nObjectId);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionServerFile(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, String i_sFileName) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionServerFile()");
            LOG.info((Object)("Server-side file name is '" + (null == i_sFileName ? "" : i_sFileName) + "'"));
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("1", i_sFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionServerFile(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, Map i_configuration, String i_sFileName) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionServerFile()");
            LOG.info((Object)("Server-side file name is '" + (null == i_sFileName ? "" : i_sFileName) + "'"));
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("1", i_sFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getUnmanagedRASConnectionServerFile(String i_sServerKind, Locale i_locale, InetSocketAddress[] i_unmanagedServers, String i_sFileName) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getUnmanagedRASConnectionServerFile()");
            LOG.info((Object)("Server-side file name is '" + (null == i_sFileName ? "" : i_sFileName) + "'"));
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("1", i_sFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, null, i_unmanagedServers, documentId, null, null, configuration);
        return retRASConn;
    }

    public IRASConnection getUnmanagedRASConnectionServerFile(String i_sServerKind, Locale i_locale, InetSocketAddress[] i_unmanagedServers, Map i_configuration, String i_sFileName) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getUnmanagedRASConnectionServerFile()");
            LOG.info((Object)("Server-side file name is '" + (null == i_sFileName ? "" : i_sFileName) + "'"));
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("1", i_sFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, null, i_unmanagedServers, documentId, null, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionClientFile(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, String i_sClientFileName, InputStream i_documentStream) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionClientFile()");
            LOG.info((Object)("Client-side file name is '" + (null == i_sClientFileName ? "" : i_sClientFileName) + "'"));
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("2", i_sClientFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, i_documentStream, null, configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionClientFile(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, Map i_configuration, String i_sClientFileName, InputStream i_documentStream) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionClientFile()");
            LOG.info((Object)("Client-side file name is '" + (null == i_sClientFileName ? "" : i_sClientFileName) + "'"));
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("2", i_sClientFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, i_documentStream, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getUnmanagedRASConnectionClientFile(String i_sServerKind, Locale i_locale, InetSocketAddress[] i_unmanagedServers, String i_sClientFileName, InputStream i_documentStream) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getUnmanagedRASConnectionClientFile()");
            LOG.info((Object)("Client-side file name is '" + (null == i_sClientFileName ? "" : i_sClientFileName) + "'"));
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("2", i_sClientFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, null, i_unmanagedServers, documentId, i_documentStream, null, configuration);
        return retRASConn;
    }

    public IRASConnection getUnmanagedRASConnectionClientFile(String i_sServerKind, Locale i_locale, InetSocketAddress[] i_unmanagedServers, Map i_configuration, String i_sClientFileName, InputStream i_documentStream) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getUnmanagedRASConnectionClientFile()");
            LOG.info((Object)("Client-side file name is '" + (null == i_sClientFileName ? "" : i_sClientFileName) + "'"));
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("2", i_sClientFileName);
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, null, i_unmanagedServers, documentId, i_documentStream, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionNewDocument(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionNewDocument()");
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("5", "");
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionNewDocument(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, Map i_configuration) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getRASConnectionNewDocument()");
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("5", "");
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, i_secSession, null, documentId, null, null, i_configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionNewDocument(String i_sServerKind, Locale i_locale, InetSocketAddress[] i_unmanagedServers) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getUnmanagedRASConnectionNewDocument()");
        }
        HashMap configuration = new HashMap();
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("5", "");
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, null, i_unmanagedServers, documentId, null, null, configuration);
        return retRASConn;
    }

    public IRASConnection getRASConnectionNewDocument(String i_sServerKind, Locale i_locale, InetSocketAddress[] i_unmanagedServers, Map i_configuration) throws RASConnectionException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to getUnmanagedRASConnectionNewDocument()");
        }
        GetConnection.DocumentId documentId = new GetConnection.DocumentId("5", "");
        IRASConnection retRASConn = this.getRASConnection(i_sServerKind, i_locale, null, i_unmanagedServers, documentId, null, null, i_configuration);
        return retRASConn;
    }

    public String serializeRASConnection(IRASConnection i_rasConn) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to serializeRASConnection()");
        }
        if (null == i_rasConn) {
            String sMessage = "i_rasConn is null";
            LOG.error((Object)"i_rasConn is null");
            throw new IllegalArgumentException("i_rasConn is null");
        }
        if (!(i_rasConn instanceof RASConnection)) {
            String sMessage = "i_rasConn is not a RASConnection instance";
            LOG.error((Object)"i_rasConn is not a RASConnection instance");
            throw new IllegalArgumentException("i_rasConn is not a RASConnection instance");
        }
        RASConnection rasConn = (RASConnection)i_rasConn;
        IServerSerializer szer = this.m_serializationFactory.createSerializer();
        szer.setObjectName(RASCONN_CLASS_ID);
        szer.setObject(RASCONN_GET_CONNECTION, rasConn.getGetConnection());
        szer.setString(RASCONN_SERVER_KIND, rasConn.getServerKind());
        szer.setObject(RASCONN_INIT_SERVICE, rasConn.getInitService());
        StringBuffer sUnmanagedServers = new StringBuffer();
        InetSocketAddress[] arrSocks = rasConn.getUnmanagedServers();
        for (int i = 0; i < arrSocks.length; ++i) {
            sUnmanagedServers.append(arrSocks[i].toString());
            sUnmanagedServers.append("::");
        }
        szer.setString(RASCONN_UNMANAGED_SERVERS, sUnmanagedServers.toString());
        String sRetSerialized = szer.getSerializedString();
        return sRetSerialized;
    }

    public IRASConnection deserializeRASConnection(Locale i_locale, String i_sRASConn, InputStream i_documentStream) throws RASConnectionException, SerializationException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Received call to deserializeRASConnection()");
        }
        IServerDeserializer dszer = this.m_serializationFactory.createDeserializer();
        dszer.initFromSerializedString(i_sRASConn, i_locale);
        if (!dszer.getObjectName().equals(RASCONN_CLASS_ID)) {
            String sMessage = "Wrong class ID: " + dszer.getObjectName();
            LOG.error((Object)sMessage);
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, dszer.getObjectName()), "RASLIB9008", sMessage);
        }
        GetConnection getConnection = (GetConnection)dszer.getObject(RASCONN_GET_CONNECTION, new GetConnection(), i_locale);
        String sServerKind = dszer.getString(RASCONN_SERVER_KIND, i_locale);
        IRASConnectionInitService initService = (IRASConnectionInitService)dszer.getObject(RASCONN_INIT_SERVICE, RASConnection.getEmptyInitService(), i_locale);
        String sUnmanagedServers = dszer.getString(RASCONN_UNMANAGED_SERVERS, i_locale);
        LinkedList<InetSocketAddress> lAddrs = new LinkedList<InetSocketAddress>();
        String[] arrPairs = sUnmanagedServers.split("::");
        if (arrPairs != null) {
            for (int i = 0; i < arrPairs.length; ++i) {
                String[] arrHostPort = arrPairs[i].split(":");
                if (arrHostPort == null || arrHostPort.length != 2 || arrHostPort[0] == null || arrHostPort[1] == null) continue;
                Integer iPort = Integer.getInteger(arrHostPort[1]);
                InetSocketAddress sockAddr = new InetSocketAddress(arrHostPort[0], (int)iPort);
                lAddrs.add(sockAddr);
            }
        }
        RASConnection retRASConn = new RASConnection(sServerKind, getConnection, (InetSocketAddress[])lAddrs.toArray(), i_documentStream, initService, this.m_serializationFactory, this.m_serializationFactory);
        return retRASConn;
    }

    private IRASConnection getRASConnection(String i_sServerKind, Locale i_locale, ISecuritySession i_secSession, InetSocketAddress[] i_unmanagedServers, GetConnection.DocumentId i_documentId, InputStream i_documentStream, IRASConnectionInitService i_initService, Map i_configuration) throws RASConnectionException {
        GetConnection getConnection = new GetConnection(i_locale, i_secSession, i_documentId, i_configuration);
        int cePrefixStart = i_sServerKind.indexOf(CRYSTAL_ENTERPRISE_PREFIX);
        int cePrefixEnd = cePrefixStart + CRYSTAL_ENTERPRISE_PREFIX.length();
        String sShortObjectType = -1 == cePrefixStart ? i_sServerKind : i_sServerKind.substring(0, cePrefixStart) + i_sServerKind.substring(cePrefixEnd);
        String sFullServerKind = !sShortObjectType.equals("CrystalReport") ? "dpscache" + sShortObjectType : "cacheserver";
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Full server kind is " + sFullServerKind));
        }
        RASConnection retRASConn = new RASConnection(sFullServerKind, getConnection, i_unmanagedServers, i_documentStream, i_initService, this.m_serializationFactory, this.m_serializationFactory);
        return retRASConn;
    }

    private class RASConnectionServerSerializationFactory
    implements IServerDeserializerFactory,
    IServerSerializerFactory {
        private RASConnectionServerSerializationFactory() {
        }

        public IServerDeserializer createDeserializer() {
            return new WireObServerDeserializer(this);
        }

        public IServerSerializer createSerializer() {
            return new WireObServerSerializer(this);
        }
    }
}

