/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.messages;

import com.crystaldecisions.sdk.logging.internal.CETraceManager;
import com.crystaldecisions.sdk.logging.internal.ITracer;
import com.crystaldecisions.sdk.occa.ras21.RAS21ResourceBundle;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializable;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class ConnectionConfiguration
implements IServerSerializable {
    private BooleanProperties m_booleanProperties = new BooleanProperties();
    private IntegerProperties m_integerProperties = new IntegerProperties();
    private StringProperties m_stringProperties = new StringProperties();
    private static final String CONNCONF_CLASS_ID = "RCONF";
    private static final String CONNCONF_BOOLEAN_PROPERTIES = "B";
    private static final String CONNCONF_INTEGER_PROPERTIES = "I";
    private static final String CONNCONF_STRING_PROPERTIES = "S";
    private static final ITracer TRACER = CETraceManager.getLogger(ConnectionConfiguration.class);

    ConnectionConfiguration(Map i_configuration) {
        Iterator iter = i_configuration.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = i_configuration.get(name);
            if (value instanceof Boolean) {
                this.m_booleanProperties.put(name, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                this.m_integerProperties.put(name, (Integer)value);
                continue;
            }
            if (value instanceof String) {
                this.m_stringProperties.put(name, (String)value);
                continue;
            }
            String msg = "Property " + name + " has an unknown type.";
            TRACER.assertLog(false, msg);
        }
    }

    public Map getConfiguration() {
        Object value;
        String name;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = this.m_booleanProperties.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            value = this.m_booleanProperties.get(name);
            map.put(name, value);
        }
        iter = this.m_integerProperties.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            value = this.m_integerProperties.get(name);
            map.put(name, value);
        }
        iter = this.m_stringProperties.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            value = this.m_stringProperties.get(name);
            map.put(name, value);
        }
        return map;
    }

    public void serialize(IServerSerializer i_serializer) {
        i_serializer.setObjectName(CONNCONF_CLASS_ID);
        i_serializer.setObject(CONNCONF_BOOLEAN_PROPERTIES, this.m_booleanProperties);
        i_serializer.setObject(CONNCONF_INTEGER_PROPERTIES, this.m_integerProperties);
        i_serializer.setObject(CONNCONF_STRING_PROPERTIES, this.m_stringProperties);
    }

    public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
        String objectName = i_deserializer.getObjectName();
        if (!objectName.equals(CONNCONF_CLASS_ID)) {
            String rci = "RASLIB9034";
            String msg = "Wrong class ID: " + objectName + " (RCI=" + "RASLIB9034" + ")";
            TRACER.error(msg);
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, objectName), "RASLIB9034", msg);
        }
        this.m_booleanProperties = (BooleanProperties)i_deserializer.getObject(CONNCONF_BOOLEAN_PROPERTIES, new BooleanProperties(), i_locale);
        this.m_integerProperties = (IntegerProperties)i_deserializer.getObject(CONNCONF_INTEGER_PROPERTIES, new IntegerProperties(), i_locale);
        this.m_stringProperties = (StringProperties)i_deserializer.getObject(CONNCONF_STRING_PROPERTIES, new StringProperties(), i_locale);
    }

    private class StringProperties
    implements IServerSerializable {
        private final Map m_properties = new HashMap();
        private static final String CONNCONF_STRING_PROPERTIES_CLASS_ID = "RCONFS";

        public void put(String i_name, String i_value) {
            this.m_properties.put(i_name, i_value);
        }

        public String get(String i_name) {
            return (String)this.m_properties.get(i_name);
        }

        public Set keySet() {
            return this.m_properties.keySet();
        }

        public void serialize(IServerSerializer i_serializer) {
            i_serializer.setObjectName(CONNCONF_STRING_PROPERTIES_CLASS_ID);
            String[] nameArr = new String[this.m_properties.size()];
            Iterator iter = this.m_properties.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = (String)this.m_properties.get(name);
                i_serializer.setString(name, value);
            }
        }

        public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
            this.m_properties.clear();
            String objectName = i_deserializer.getObjectName();
            if (!objectName.equals(CONNCONF_STRING_PROPERTIES_CLASS_ID)) {
                String rci = "RASLIB9037";
                String msg = "Wrong class ID: " + objectName + " (RCI=" + "RASLIB9037" + ")";
                TRACER.error(msg);
                throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, objectName), "RASLIB9037", msg);
            }
            Iterator iter = i_deserializer.getNames().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = i_deserializer.getString(name, i_locale);
                this.m_properties.put(name, value);
            }
        }
    }

    private class IntegerProperties
    implements IServerSerializable {
        private final Map m_properties = new HashMap();
        private static final String CONNCONF_INTEGER_PROPERTIES_CLASS_ID = "RCONFI";

        public void put(String i_name, Integer i_value) {
            this.m_properties.put(i_name, i_value);
        }

        public Integer get(String i_name) {
            return (Integer)this.m_properties.get(i_name);
        }

        public Set keySet() {
            return this.m_properties.keySet();
        }

        public void serialize(IServerSerializer i_serializer) {
            i_serializer.setObjectName(CONNCONF_INTEGER_PROPERTIES_CLASS_ID);
            String[] nameArr = new String[this.m_properties.size()];
            Iterator iter = this.m_properties.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Integer value = (Integer)this.m_properties.get(name);
                i_serializer.setInteger(name, value);
            }
        }

        public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
            this.m_properties.clear();
            String objectName = i_deserializer.getObjectName();
            if (!objectName.equals(CONNCONF_INTEGER_PROPERTIES_CLASS_ID)) {
                String rci = "RASLIB9036";
                String msg = "Wrong class ID: " + objectName + " (RCI=" + "RASLIB9036" + ")";
                TRACER.error(msg);
                throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, objectName), "RASLIB9036", msg);
            }
            Iterator iter = i_deserializer.getNames().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Integer value = new Integer(i_deserializer.getInteger(name, i_locale));
                this.m_properties.put(name, value);
            }
        }
    }

    private class BooleanProperties
    implements IServerSerializable {
        private final Map m_properties = new HashMap();
        private static final String CONNCONF_BOOLEAN_PROPERTIES_CLASS_ID = "RCONFB";

        public void put(String i_name, Boolean i_value) {
            this.m_properties.put(i_name, i_value);
        }

        public Boolean get(String i_name) {
            return (Boolean)this.m_properties.get(i_name);
        }

        public Set keySet() {
            return this.m_properties.keySet();
        }

        public void serialize(IServerSerializer i_serializer) {
            i_serializer.setObjectName(CONNCONF_BOOLEAN_PROPERTIES_CLASS_ID);
            String[] nameArr = new String[this.m_properties.size()];
            Iterator iter = this.m_properties.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Boolean value = (Boolean)this.m_properties.get(name);
                i_serializer.setBoolean(name, value);
            }
        }

        public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
            this.m_properties.clear();
            String objectName = i_deserializer.getObjectName();
            if (!objectName.equals(CONNCONF_BOOLEAN_PROPERTIES_CLASS_ID)) {
                String rci = "RASLIB9035";
                String msg = "Wrong class ID: " + objectName + " (RCI=" + "RASLIB9035" + ")";
                TRACER.error(msg);
                throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, objectName), "RASLIB9035", msg);
            }
            Iterator iter = i_deserializer.getNames().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Boolean value = i_deserializer.getBoolean(name, i_locale);
                this.m_properties.put(name, value);
            }
        }
    }
}

