/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.messages;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.ras21.RAS21ResourceBundle;
import com.crystaldecisions.sdk.occa.ras21.messages.ConnectionConfiguration;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializable;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GetConnection
implements IServerSerializable {
    private static final ILogger LOG = LoggerManager.getLogger((Class)GetConnection.class);
    private static final String CLASS_ID = "G12";
    private static final String URI_DOCID = "UriRpt";
    private static final String URI_SESSION = "UriSec";
    private static final String URI_LOCALE = "UriLoc";
    private static final String URI_BROWSER_LOCALE = "UriBrLoc";
    private static final String URI_CONFIGURATION = "UriConf";
    private Locale m_locale;
    private Locale m_browserLocale;
    private ISecuritySession m_secSession;
    private DocumentId m_documentId;
    private Map m_configuration;

    public GetConnection(Locale i_locale, ISecuritySession i_secSession, DocumentId i_documentId, Map i_configuration) {
        this.m_locale = i_locale;
        this.m_secSession = i_secSession;
        this.m_documentId = new DocumentId(i_documentId);
        this.m_configuration = null == i_configuration ? new HashMap() : i_configuration;
        try {
            this.m_browserLocale = i_secSession.getLocale();
        }
        catch (SDKException ex) {
            this.m_browserLocale = this.m_locale;
        }
    }

    public GetConnection(Locale i_locale, Locale i_browserLocale, ISecuritySession i_secSession, DocumentId i_documentId, Map i_configuration) {
        this.m_locale = i_locale;
        this.m_browserLocale = i_browserLocale;
        this.m_secSession = i_secSession;
        this.m_documentId = new DocumentId(i_documentId);
        this.m_configuration = null == i_configuration ? new HashMap() : i_configuration;
    }

    public GetConnection(GetConnection i_getConnection) {
        this(i_getConnection.m_locale, i_getConnection.m_browserLocale, i_getConnection.m_secSession, i_getConnection.m_documentId, i_getConnection.m_configuration);
    }

    public GetConnection() {
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Locale getBrowserLocale() {
        return this.m_browserLocale;
    }

    public ISecuritySession getSecuritySession() {
        return this.m_secSession;
    }

    public DocumentId getDocumentId() {
        return new DocumentId(this.m_documentId);
    }

    public Map getConfiguration() {
        return new HashMap(this.m_configuration);
    }

    public String getSerializedLocale() {
        return this.serializeLocale(this.m_locale);
    }

    public String getSerializedBrowserLocale() {
        return this.serializeLocale(this.m_browserLocale);
    }

    public void serialize(IServerSerializer i_serializer) {
        i_serializer.setObjectName(CLASS_ID);
        i_serializer.setObject(URI_DOCID, this.m_documentId);
        if (null == this.m_secSession) {
            i_serializer.setString(URI_SESSION, "");
        } else {
            i_serializer.setString(URI_SESSION, this.m_secSession.getLogonToken());
        }
        String sLocale = this.getSerializedLocale();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Serialized Locale is '" + sLocale + "'"));
        }
        i_serializer.setString(URI_LOCALE, sLocale);
        String sBrowserLocale = this.getSerializedBrowserLocale();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Serialized Browser Locale is '" + sBrowserLocale + "'"));
        }
        i_serializer.setString(URI_BROWSER_LOCALE, sBrowserLocale);
        ConnectionConfiguration connConfig = new ConnectionConfiguration(this.m_configuration);
        i_serializer.setObject(URI_CONFIGURATION, connConfig);
    }

    public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
        ISecuritySession secSession;
        if (!i_deserializer.getObjectName().equals(CLASS_ID)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"GetConnection.deserialize(): wrong class ID");
            }
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_deserializer.getObjectName()), "RASLIB9008", "Wrong class ID");
        }
        DocumentId documentId = (DocumentId)i_deserializer.getObject(URI_DOCID, new DocumentId(), i_locale);
        String sLogonToken = i_deserializer.getString(URI_SESSION, i_locale);
        try {
            secSession = SecurityFactory.getFactory().makeSecurityMgr().logonWithToken(sLogonToken, "");
        }
        catch (SDKException except) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, URI_SESSION), "RASLIB9009", except.getMessage());
        }
        Locale locale = this.deserializeLocale(i_deserializer, URI_LOCALE, i_locale);
        Locale browserLocale = this.deserializeLocale(i_deserializer, URI_BROWSER_LOCALE, i_locale);
        HashMap dummyMap = new HashMap();
        ConnectionConfiguration connConfig = (ConnectionConfiguration)i_deserializer.getObject(URI_CONFIGURATION, new ConnectionConfiguration(dummyMap), i_locale);
        Map configuration = connConfig.getConfiguration();
        this.m_locale = locale;
        this.m_browserLocale = browserLocale;
        this.m_secSession = secSession;
        this.m_documentId = documentId;
        this.m_configuration = configuration;
    }

    public void serializeForServer(IServerSerializer i_serializer) {
        i_serializer.setObjectName(CLASS_ID);
        i_serializer.setObject(URI_DOCID, this.m_documentId);
        if (null == this.m_secSession) {
            i_serializer.setString(URI_SESSION, "");
        } else {
            i_serializer.setString(URI_SESSION, this.m_secSession.getLogonToken());
        }
        String sBrowserLocale = this.getSerializedBrowserLocale();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Serialized Browser Locale is '" + sBrowserLocale + "'"));
        }
        i_serializer.setString(URI_LOCALE, sBrowserLocale);
        ConnectionConfiguration connConfig = new ConnectionConfiguration(this.m_configuration);
        i_serializer.setObject(URI_CONFIGURATION, connConfig);
    }

    private String serializeLocale(Locale i_locale) {
        String sRetLocale;
        if (null == i_locale) {
            sRetLocale = "";
        } else {
            String sLanguage = i_locale.getLanguage();
            String sCountry = i_locale.getCountry();
            sRetLocale = null == sLanguage || sLanguage.equals("") ? "" : (null == sCountry || sCountry.equals("") ? sLanguage : sLanguage + "-" + sCountry);
        }
        return sRetLocale;
    }

    private Locale deserializeLocale(IServerDeserializer i_deserializer, String i_key, Locale i_locale) throws SerializationException {
        Locale locale;
        String sLocale = i_deserializer.getString(i_key, i_locale);
        if (null == sLocale) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_key), "RASLIB9010", "Invalid locale in message");
        }
        if (sLocale.indexOf(45) < 0) {
            locale = new Locale(sLocale);
        } else {
            int dashInd = sLocale.indexOf(45);
            locale = new Locale(sLocale.substring(0, dashInd), sLocale.substring(dashInd + 1));
        }
        return locale;
    }

    public static class DocumentId
    implements IServerSerializable {
        public static final String TYPE_SERVER = "1";
        public static final String TYPE_CLIENT = "2";
        public static final String TYPE_CUID = "3";
        public static final String TYPE_OBJID = "4";
        public static final String TYPE_NEWDOC = "5";
        private static final String URI_ID = "I";
        private static final String URI_TYPE = "T";
        private String m_sIdType;
        private String m_sId;

        public DocumentId(String i_sIdType, String i_sId) {
            this.m_sIdType = i_sIdType;
            this.m_sId = i_sId;
        }

        public DocumentId(DocumentId i_documentId) {
            this(i_documentId.m_sIdType, i_documentId.m_sId);
        }

        public DocumentId() {
        }

        public String getIdType() {
            return this.m_sIdType;
        }

        public String getId() {
            return this.m_sId;
        }

        public void serialize(IServerSerializer i_serializer) {
            i_serializer.setString(URI_ID, this.m_sId);
            i_serializer.setString(URI_TYPE, this.m_sIdType);
        }

        public void deserialize(IServerDeserializer i_deserializer, Locale i_locale) throws SerializationException {
            this.m_sIdType = i_deserializer.getString(URI_ID, i_locale);
            this.m_sId = i_deserializer.getString(URI_TYPE, i_locale);
        }

        public String toString() {
            return this.m_sIdType + ":" + this.m_sId;
        }
    }
}

