/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.messages;

import com.crystaldecisions.sdk.occa.ras21.RAS21ResourceBundle;
import com.crystaldecisions.sdk.occa.ras21.messages.GetConnection;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializable;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerSerializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import java.util.Locale;
import java.util.Stack;

public class Result
implements IServerSerializable {
    private static final String CLASSID = "RS";
    private static final String COOKIE = "C";
    private static final String ERRORDESC = "E";
    private static final String ISSAVEREQUEST = "S";
    private static final String ISSAVEASREQUEST = "A";
    private static final String SAVEASDOCUMENTID = "D";
    private String m_cookie;
    private ErrorDescription m_errorDescription;
    private boolean m_isSaveRequest = false;
    private boolean m_isSaveAsRequest = false;
    private GetConnection.DocumentId m_saveAsDocumentId = null;

    public ErrorDescription getError() {
        return this.m_errorDescription;
    }

    public String getCookie() {
        return this.m_cookie;
    }

    public boolean getIsSaveRequest() {
        return this.m_isSaveRequest;
    }

    public boolean getIsSaveAsRequest() {
        return this.m_isSaveAsRequest;
    }

    public GetConnection.DocumentId getSaveAsDocumentId() {
        return this.m_saveAsDocumentId;
    }

    public void serialize(IServerSerializer iSerializer) {
    }

    public void deserialize(IServerDeserializer iDeserializer, Locale locale) throws SerializationException {
        if (!iDeserializer.getObjectName().equals(CLASSID)) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, locale, iDeserializer.getObjectName()), "RASLIB9018", "Wrong class name");
        }
        this.m_cookie = iDeserializer.getString(COOKIE, locale);
        this.m_errorDescription = (ErrorDescription)iDeserializer.getObject(ERRORDESC, new ErrorDescription(), locale);
        this.m_isSaveRequest = iDeserializer.getBoolean(ISSAVEREQUEST, locale);
        this.m_isSaveAsRequest = iDeserializer.getBoolean(ISSAVEASREQUEST, locale);
        if (this.m_isSaveAsRequest) {
            this.m_saveAsDocumentId = (GetConnection.DocumentId)iDeserializer.getObject(SAVEASDOCUMENTID, new GetConnection.DocumentId(), locale);
        }
    }

    public static class ErrorDescription
    implements IServerSerializable {
        public static final short ErrorInternal = 0;
        public static final short ErrorTimeout = 1;
        public static final short ErrorTryAgain = 2;
        public static final short ErrorFailure = 3;
        public static final short ErrorFlushCache = 4;
        private static final String CLASSID = "C";
        private static final String ERRORCODE = "E";
        private static final String MESSAGESTACK = "M";
        private static final String DEBUGSTACK = "D";
        private static final String ROOTCAUSESTACK = "R";
        private int m_errorCode;
        private Stack m_stack = new Stack();

        public ErrorDescription() {
            this.m_errorCode = 0;
        }

        public ErrorDescription(int nErrorCode, String message, String rootCause, String debugString) {
            this.m_errorCode = nErrorCode;
            ErrorInfo info = new ErrorInfo(message, rootCause, debugString);
            this.m_stack.push(info);
        }

        public ErrorDescription(int nErrorCode, String message, String rootCause, String debugString, ErrorDescription ex) {
            this.m_errorCode = nErrorCode;
            this.m_stack = ex.m_stack;
            ErrorInfo info = new ErrorInfo(message, rootCause, debugString);
            this.m_stack.push(info);
        }

        public String getMessage() {
            if (this.m_stack == null) {
                return "";
            }
            return ((ErrorInfo)this.m_stack.peek()).message;
        }

        public String getRootCause() {
            if (this.m_stack == null) {
                return "";
            }
            return ((ErrorInfo)this.m_stack.peek()).rootCause;
        }

        public String getDebugString() {
            if (this.m_stack == null) {
                return "";
            }
            return ((ErrorInfo)this.m_stack.peek()).debugInfo;
        }

        public Stack getExceptionStack() {
            return this.m_stack;
        }

        public int getErrorCode() {
            return this.m_errorCode;
        }

        public String toString() {
            String returnString = this.errorCodeAsString() + "\n";
            for (int i = this.m_stack.size() - 1; i >= 0; --i) {
                ErrorInfo desc = (ErrorInfo)this.m_stack.elementAt(i);
                returnString = returnString + desc.message + " [" + desc.rootCause + "]" + "\n";
            }
            return returnString;
        }

        public String toDebugString() {
            String returnString = this.errorCodeAsString() + "\n";
            for (int i = this.m_stack.size() - 1; i >= 0; --i) {
                ErrorInfo desc = (ErrorInfo)this.m_stack.elementAt(i);
                returnString = returnString + desc.message + " [" + desc.rootCause + "]" + "\n" + "Debug: " + desc.debugInfo;
                if (i == 0) continue;
                returnString = returnString + "\nCaused by:\n";
            }
            return returnString;
        }

        private String errorCodeAsString() {
            switch (this.m_errorCode) {
                case 0: {
                    return "ErrorInternal";
                }
                case 1: {
                    return "ErrorTimeout";
                }
                case 2: {
                    return "ErrorTryAgain";
                }
                case 3: {
                    return "ErrorFailure";
                }
                case 4: {
                    return "ErrorFlushCache";
                }
            }
            return "Unknown ErrorCode";
        }

        public void serialize(IServerSerializer iSerializer) {
        }

        public void deserialize(IServerDeserializer iDeserializer, Locale locale) throws SerializationException {
            if (iDeserializer.getObjectName().equals("C")) {
                this.m_errorCode = iDeserializer.getInteger("E", locale);
                String[] messages = iDeserializer.getStringArray(MESSAGESTACK, locale);
                String[] rootCauses = iDeserializer.getStringArray(ROOTCAUSESTACK, locale);
                String[] debugInfo = iDeserializer.getStringArray("D", locale);
                if (messages.length != rootCauses.length || messages.length != debugInfo.length) {
                    throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, locale, MESSAGESTACK), "RASLIB9016", "String arrays of different sizes");
                }
                this.m_stack.clear();
                for (int i = messages.length - 1; i >= 0; --i) {
                    ErrorInfo info = new ErrorInfo(messages[i], rootCauses[i], debugInfo[i]);
                    this.m_stack.push(info);
                }
            } else {
                throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, locale, iDeserializer.getObjectName()), "RASLIB9017", "Wrong class name");
            }
        }

        public class ErrorInfo {
            public String message;
            public String rootCause;
            public String debugInfo;

            public ErrorInfo(String message, String rootCause, String debugInfo) {
                this.message = message;
                this.rootCause = rootCause;
                this.debugInfo = debugInfo;
            }
        }
    }
}

