/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.ras21.serialization.wireob;

import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.sdk.occa.ras21.RAS21ResourceBundle;
import com.crystaldecisions.sdk.occa.ras21.serialization.IServerDeserializerFactory;
import com.crystaldecisions.sdk.occa.ras21.serialization.ObjectDeserializer;
import com.crystaldecisions.sdk.occa.ras21.serialization.SerializationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class WireObServerDeserializer
extends ObjectDeserializer {
    private final PropertyBag m_propertyBag = new PropertyBag();

    public WireObServerDeserializer(IServerDeserializerFactory i_factory) {
        super(i_factory);
    }

    public void initFromSerializedString(String i_sSerialized, Locale i_locale) throws SerializationException {
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(i_sSerialized);
        this.m_propertyBag.unpack((IBagUnpacker)unpacker);
    }

    public String getObjectName() {
        return this.m_propertyBag.getString((Object)"CLSID");
    }

    public Set getNames() {
        HashSet<String> names = new HashSet<String>();
        Set ids = this.m_propertyBag.keySet();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            String name = IDHelper.idToName((Integer)id);
            if (name.compareTo("CLSID") == 0) continue;
            names.add(name);
        }
        return names;
    }

    public boolean getBoolean(String i_sName, Locale i_locale) throws SerializationException {
        if (!this.m_propertyBag.containsKey((Object)IDHelper.nameToID((String)i_sName))) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_sName), "RASLIB9019", "Could not retrieve boolean by that name");
        }
        Property property2 = this.m_propertyBag.getItem((Object)i_sName);
        if (property2 == null) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_sName), "RASLIB9020", "Could not retrieve boolean by that name");
        }
        Object value = property2.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value.toString().equals("1") || value.toString().equalsIgnoreCase("true")) {
            return true;
        }
        if (value.toString().equals("0") || value.toString().equalsIgnoreCase("false")) {
            return false;
        }
        throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_sName), "RASLIB9021", "Invalid boolean value");
    }

    public int getInteger(String i_sName, Locale i_locale) throws SerializationException {
        if (!this.m_propertyBag.containsKey((Object)IDHelper.nameToID((String)i_sName))) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_sName), "RASLIB9022", "Could not retrieve integer by that name");
        }
        Property property2 = this.m_propertyBag.getItem((Object)i_sName);
        if (property2 == null) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_sName), "RASLIB9023", "Could not retrieve integer by that name");
        }
        Object value = property2.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        Integer integer = IntegerConversion.parseInteger((String)value.toString());
        if (integer == null) {
            throw new SerializationException(0, RAS21ResourceBundle.getString(RAS21ResourceBundle.ERR_URL_INVL_ARG, i_locale, i_sName), "RASLIB9024", "Invalid integer value");
        }
        return integer;
    }

    public String getString(String i_sName, Locale i_locale) throws SerializationException {
        return this.m_propertyBag.getString((Object)i_sName);
    }

    public String[] getStringArray(String i_sName, Locale i_locale) throws SerializationException {
        PropertyBag arrayBag = this.m_propertyBag.getPropertyBag((Object)i_sName);
        PropertyArrayHelper arrayHelper = new PropertyArrayHelper(arrayBag, PropertyIDs.SI_TOTAL);
        int numEntries = arrayHelper.size();
        String[] sarrRetStrings = new String[numEntries];
        for (int index = 0; index < numEntries; ++index) {
            sarrRetStrings[index] = (String)arrayHelper.get(index);
        }
        return sarrRetStrings;
    }
}

