/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionBatchExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.SeqOctetHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IPluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.IRightID;
import com.crystaldecisions.sdk.occa.infostore.IRightSource;
import com.crystaldecisions.sdk.occa.infostore.IRoleID;
import com.crystaldecisions.sdk.occa.infostore.ISecurityInfoAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityLimitAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityPrincipal;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRightAdmin;
import com.crystaldecisions.sdk.occa.infostore.ISecurityRoleAdmin;
import com.crystaldecisions.sdk.occa.infostore.RightDescriptor;
import com.crystaldecisions.sdk.occa.infostore.RightIDDescriptor;
import com.crystaldecisions.sdk.occa.infostore.internal.PluginBasedRightIDs;
import com.crystaldecisions.sdk.occa.infostore.internal.RightID;
import com.crystaldecisions.sdk.occa.infostore.internal.RoleID;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRightSource;
import com.crystaldecisions.sdk.occa.infostore.internal.SecurityRoleSource;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.IBatch;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRights;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.BatchHelper;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.LimitResult;
import com.crystaldecisions.sdk.occa.security.internal.Principal;
import com.crystaldecisions.sdk.occa.security.internal.SecurityException;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;
import com.crystaldecisions.sdk.occa.security.internal.SecurityInfoResult;
import com.crystaldecisions.sdk.occa.security.internal.SecurityInfoResultForPrincipal;
import com.crystaldecisions.sdk.occa.security.internal.SecurityResult;
import com.crystaldecisions.sdk.occa.security.internal.SecurityValidator;
import com.crystaldecisions.sdk.occa.security.internal._SessionBatchExProxy;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CallFailureResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CallFailureWithMessages;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightBoolCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightBoolCommandForPrincipal;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightBoolResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightBoolScopedCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightBoolScopedForPrincipalCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightDWordCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightDWordCommandForPrincipal;
import com.crystaldecisions.sdk.occa.security.internal.serializer.CheckRightDWordResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.EffectiveBoolRight;
import com.crystaldecisions.sdk.occa.security.internal.serializer.EffectiveDWordRight;
import com.crystaldecisions.sdk.occa.security.internal.serializer.EffectiveRole;
import com.crystaldecisions.sdk.occa.security.internal.serializer.ExplicitBoolRight;
import com.crystaldecisions.sdk.occa.security.internal.serializer.ExplicitDWordRight;
import com.crystaldecisions.sdk.occa.security.internal.serializer.ExplicitRole;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetExplicitBoolRightsCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetExplicitBoolRightsResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetExplicitDWordRightsCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetExplicitDWordRightsResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetExplicitRolesCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetExplicitRolesResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetKnownRightsCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetKnownRightsResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetKnownRolesCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetKnownRolesResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetRightsByPluginCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetRightsByPluginResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetSecurityInfoCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetSecurityInfoForPrincipalCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetSecurityInfoResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetSystemRightsCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.GetSystemRightsResult;
import com.crystaldecisions.sdk.occa.security.internal.serializer.PluginRights;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RemoveRightBoolCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RemoveRightDWordCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RemoveRightsBoolCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RemoveRightsDWordCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RemoveRoleCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RemoveRolesCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RightDescription;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RightSource;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RoleInfo;
import com.crystaldecisions.sdk.occa.security.internal.serializer.RoleSource;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityCommandFactory;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityDeserializer;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecuritySerializer;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityType;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SerializableCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SetRightBoolCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SetRightDWordCommand;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SetRoleCommand;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import java.io.EOFException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class CacheControllerEx
implements IBatch,
ISecCacheControllerAdmin,
ISecCacheController,
ISecRights,
ISecRightsAdmin,
BatchHelper.BatchInputProcessor,
BatchHelper.BatchOutputListener {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.CacheController");
    private static final String MAX_CACHE_AGE_PROP = "businessobjects.enterprise.cachecontroller.maxcacheage";
    protected static final long MAX_CACHE_AGE = Long.getLong("businessobjects.enterprise.cachecontroller.maxcacheage", 60000L);
    protected static final String Any_TYPE = "Any";
    private static final int SCOPE_THIS = 1;
    private static final int SCOPE_DESCENDANTS = 2;
    private static final int SCOPE_BOTH = 3;
    private IManagedService m_handler;
    private SessionBatchExOperations m_batchStub;
    private BatchHelper m_checkHelper;
    private Map m_tl_loadBatchHelper;
    private int m_currentUserID;
    private Map m_map;
    private ReferenceQueue m_refqueue;
    private boolean m_globalSupportCache;
    private boolean m_useCache = false;
    private int m_epoch;
    private IPluginMgr m_pluginMgr;
    private static final RightDescriptor NOF_SETRIGHT = new RightDescriptor(64, "", false, "this", "");
    private static final RightDescriptor NOF_REMOVERIGHT = new RightDescriptor(64, (Object)"", false);
    private static final RightDescriptor NOG_REMOVERIGHT = new RightDescriptor(63, (Object)"", false);
    private static final RightDescriptor NOG_SETRIGHT = new RightDescriptor(63, "", false, "this", "");

    private CacheControllerEx() {
    }

    CacheControllerEx(IManagedService handler, ISecuritySession session, boolean useCache) throws SDKException {
        this.m_handler = handler;
        this.m_batchStub = new _SessionBatchExProxy(this.m_handler);
        this.m_checkHelper = new BatchHelper(this.m_batchStub, this, this);
        this.m_map = new Hashtable();
        this.m_refqueue = new ReferenceQueue();
        this.m_currentUserID = session.getUserInfo().getUserID();
        this.m_pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA(session.getAPSName(), session);
        this.m_globalSupportCache = useCache;
        this.m_tl_loadBatchHelper = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchHelper getLoadHelper() throws SDKException {
        Map helperMap;
        Map map = helperMap = this.m_tl_loadBatchHelper;
        synchronized (map) {
            BatchHelper loadHelper = (BatchHelper)helperMap.get(Thread.currentThread());
            if (loadHelper == null) {
                loadHelper = new BatchHelper(this.m_batchStub, this, this);
                helperMap.put(Thread.currentThread(), loadHelper);
            }
            return loadHelper;
        }
    }

    public synchronized int batch() throws SDKException {
        return this.batch(false);
    }

    public synchronized int batch(boolean useCache) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        if (loadHelper.isActive()) {
            throw new SecurityException.BatchState();
        }
        loadHelper.setActive(true);
        this.m_useCache = useCache;
        return 0;
    }

    public synchronized int commit() throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        if (!loadHelper.isActive()) {
            throw new SecurityException.BatchState();
        }
        loadHelper.process();
        this.m_useCache = false;
        return 0;
    }

    public synchronized int rollback() throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        if (!loadHelper.isActive()) {
            if (loadHelper.input().isEmpty() && !this.m_useCache) {
                return 0;
            }
            throw new SecurityException.BatchState();
        }
        loadHelper.clear();
        this.m_useCache = false;
        return 0;
    }

    public synchronized void cacheRight(int rightID, Object rightKind, int objectID) throws SDKException {
        CheckRightBoolCommand command = new CheckRightBoolCommand(this.getRealRightID(rightID, rightKind, false), objectID);
        this.cacheRequest(command, false);
    }

    public void cacheRight(RightDescriptor right, int objectID) throws SDKException {
        CheckRightBoolScopedCommand command = new CheckRightBoolScopedCommand(this.getRealRightID(right.id, right.kind, right.isOwner), objectID, this.getRealProgID(right.applicableObjectType), this.getRealScope(right.scope));
        this.cacheRequest(command, false);
    }

    public synchronized void cacheLimit(int rightID, Object rightKind, int objectID) throws SDKException {
        CheckRightDWordCommand command = new CheckRightDWordCommand(this.getRealRightID(rightID, rightKind, false), objectID);
        this.cacheRequest(command, false);
    }

    public synchronized void cacheRight(int rightID, Object rightKind, int principalID, int objectID) throws SDKException {
        CheckRightBoolCommandForPrincipal command = new CheckRightBoolCommandForPrincipal(this.getRealRightID(rightID, rightKind, false), objectID, principalID);
        this.cacheRequest(command, true);
    }

    public void cacheRight(RightDescriptor right, int principalID, int objectID) throws SDKException {
        CheckRightBoolScopedForPrincipalCommand command = new CheckRightBoolScopedForPrincipalCommand(this.getRealRightID(right.id, right.kind, right.isOwner), objectID, principalID, this.getRealProgID(right.applicableObjectType), this.getRealScope(right.scope));
        this.cacheRequest(command, true);
    }

    public synchronized void cacheLimit(int rightID, Object rightKind, int principalID, int objectID) throws SDKException {
        CheckRightDWordCommandForPrincipal command = new CheckRightDWordCommandForPrincipal(this.getRealRightID(rightID, rightKind, false), objectID, principalID);
        this.cacheRequest(command, true);
    }

    public synchronized void cacheExplicitRoles(int objectID) throws SDKException {
        GetExplicitRolesCommand command = new GetExplicitRolesCommand(objectID);
        this.cacheRequest(command, true);
    }

    public synchronized void cacheExplicitRights(int objectID) throws SDKException {
        GetExplicitBoolRightsCommand command = new GetExplicitBoolRightsCommand(objectID);
        this.cacheRequest(command, true);
    }

    public synchronized void cacheExplicitLimits(int objectID) throws SDKException {
        GetExplicitDWordRightsCommand command = new GetExplicitDWordRightsCommand(objectID);
        this.cacheRequest(command, true);
    }

    public synchronized void cacheSecurityInfo(int objectID) throws SDKException {
        GetSecurityInfoCommand command = new GetSecurityInfoCommand(objectID);
        this.cacheRequest(command, true);
    }

    public synchronized void cacheSecurityInfo(int objectID, int principalID) throws SDKException {
        GetSecurityInfoForPrincipalCommand command = new GetSecurityInfoForPrincipalCommand(objectID, principalID);
        this.cacheRequest(command, true);
    }

    public void cacheKnownRightsByPlugin(int objectID) throws SDKException {
        GetRightsByPluginCommand command = new GetRightsByPluginCommand(objectID);
        this.cacheRequest(command, true);
        GetSystemRightsCommand command1 = new GetSystemRightsCommand(objectID);
        this.cacheRequest(command1, true);
    }

    public synchronized void cachePrincipals(int objectID) throws SDKException {
        this.cacheSecurityInfo(objectID);
    }

    public synchronized void cacheExplicitPrincipals(int objectID) throws SDKException {
        this.cacheExplicitRights(objectID);
        this.cacheExplicitLimits(objectID);
        this.cacheExplicitRoles(objectID);
    }

    public synchronized void cacheKnownSecurityInfo(int objectID) throws SDKException {
        GetKnownRightsCommand command = new GetKnownRightsCommand(objectID);
        this.cacheRequest(command, true);
        GetKnownRolesCommand command1 = new GetKnownRolesCommand();
        this.cacheRequest(command1, true);
    }

    public synchronized int checkRight(int rightID, Object rightKind, int objectID) throws SDKException {
        CheckRightBoolCommand command = new CheckRightBoolCommand(this.getRealRightID(rightID, rightKind, false), objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return 4;
        }
        if (((BooleanEntry)entry).getValue()) {
            return 2;
        }
        return 3;
    }

    public int checkRight(RightDescriptor right, int objectID) throws SDKException {
        CheckRightBoolScopedCommand command = new CheckRightBoolScopedCommand(this.getRealRightID(right.id, right.kind, right.isOwner), objectID, this.getRealProgID(right.applicableObjectType), this.getRealScope(right.scope));
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return 4;
        }
        if (((BooleanEntry)entry).getValue()) {
            return 2;
        }
        return 3;
    }

    public synchronized ISecurityResult checkLimit(int rightID, Object rightKind, int objectID) throws SDKException {
        CheckRightDWordCommand command = new CheckRightDWordCommand(this.getRealRightID(rightID, rightKind, false), objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        DWordEntry dwe = (DWordEntry)entry;
        LimitResult result = new LimitResult(dwe.getMinValue(), dwe.getMaxValue());
        return new SecurityResult(0, result);
    }

    public synchronized int checkRight(int rightID, Object rightKind, int principalID, int objectID) throws SDKException {
        CheckRightBoolCommandForPrincipal command = new CheckRightBoolCommandForPrincipal(this.getRealRightID(rightID, rightKind, false), objectID, principalID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return 4;
        }
        if (((BooleanEntry)entry).getValue()) {
            return 2;
        }
        return 3;
    }

    public int checkRight(RightDescriptor right, int principalID, int objectID) throws SDKException {
        CheckRightBoolScopedForPrincipalCommand command = new CheckRightBoolScopedForPrincipalCommand(this.getRealRightID(right.id, right.kind, right.isOwner), objectID, principalID, this.getRealProgID(right.applicableObjectType), this.getRealScope(right.scope));
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return 4;
        }
        if (((BooleanEntry)entry).getValue()) {
            return 2;
        }
        return 3;
    }

    public synchronized ISecurityResult checkLimit(int rightID, Object rightKind, int principalID, int objectID) throws SDKException {
        CheckRightDWordCommandForPrincipal command = new CheckRightDWordCommandForPrincipal(this.getRealRightID(rightID, rightKind, false), objectID, principalID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        DWordEntry dwe = (DWordEntry)entry;
        LimitResult result = new LimitResult(dwe.getMinValue(), dwe.getMaxValue());
        return new SecurityResult(0, result);
    }

    public synchronized ISecurityResult getExplicitRoles(int objectID) throws SDKException {
        GetExplicitRolesCommand command = new GetExplicitRolesCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        return new SecurityResult(0, ((ExplicitSecurityEntry)entry).getValue());
    }

    public synchronized ISecurityResult getExplicitRights(int objectID) throws SDKException {
        GetExplicitBoolRightsCommand command = new GetExplicitBoolRightsCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        return new SecurityResult(0, ((ExplicitSecurityEntry)entry).getValue());
    }

    public synchronized ISecurityResult getExplicitLimits(int objectID) throws SDKException {
        GetExplicitDWordRightsCommand command = new GetExplicitDWordRightsCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        return new SecurityResult(0, ((ExplicitSecurityEntry)entry).getValue());
    }

    public synchronized ISecurityResult getSecurityInfo(int objectID) throws SDKException {
        GetSecurityInfoCommand command = new GetSecurityInfoCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        SecurityInfoEntry secEntry = (SecurityInfoEntry)entry;
        SecurityInfoResult result = new SecurityInfoResult(secEntry.getRights(), secEntry.getRoles(), secEntry.getLimits());
        return new SecurityResult(0, result);
    }

    public synchronized ISecurityResult getSecurityInfo(int objectID, int principalID) throws SDKException {
        GetSecurityInfoForPrincipalCommand command = new GetSecurityInfoForPrincipalCommand(objectID, principalID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        List ps = this.groupSecInfoByPrincipal(entry);
        if (ps.size() < 1) {
            SecurityInfoEntry secEntry = (SecurityInfoEntry)entry;
            SecurityInfoResultForPrincipal result = new SecurityInfoResultForPrincipal(principalID, "", secEntry.getRights(), secEntry.getRoles(), secEntry.getLimits(), true, true, true, false);
            return new SecurityResult(0, result);
        }
        LOG.assertTrue(1 == ps.size());
        Principal princ = (Principal)ps.get(0);
        SecurityInfoResultForPrincipal result = new SecurityInfoResultForPrincipal(princ.getID(), princ.getName(), princ.getRights(), princ.getRoles(), princ.getLimits(), princ.isInheritFolders(), princ.isInheritGroups(), princ.isInherited(), princ.isAdvanced());
        return new SecurityResult(0, result);
    }

    public synchronized ISecurityResult getPrincipals(int objectID) throws SDKException {
        GetSecurityInfoCommand command = new GetSecurityInfoCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        List ps = this.groupSecInfoByPrincipal(entry);
        return new SecurityResult(0, ps.toArray(new ISecurityPrincipal[ps.size()]));
    }

    private List groupSecInfoByPrincipal(CacheEntry entry) {
        HashMap<Integer, Principal> principalMap = new HashMap<Integer, Principal>();
        Map principalRightsMap = this.makePrincipalMap(((SecurityInfoEntry)entry).getRights());
        ArrayList<Principal> ps = new ArrayList<Principal>(principalRightsMap.size());
        Set entries = principalRightsMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            Integer principalID = (Integer)mapEntry.getKey();
            SecurityInfoForPrincipal rights = (SecurityInfoForPrincipal)mapEntry.getValue();
            ISecurityRightAdmin[] rightsArray = rights.toArray(new ISecurityRightAdmin[rights.size()]);
            Principal princ = (Principal)principalMap.get(principalID);
            if (princ == null) {
                princ = this.newPrincipal(rights, rights.isInherited());
                principalMap.put(principalID, princ);
                ps.add(princ);
            }
            princ.setRights2(rightsArray);
        }
        Map principalLimitsMap = this.makePrincipalMap(((SecurityInfoEntry)entry).getLimits());
        entries = principalLimitsMap.entrySet();
        Iterator iterator2 = entries.iterator();
        while (iterator2.hasNext()) {
            Map.Entry mapEntry = iterator2.next();
            Integer principalID = (Integer)mapEntry.getKey();
            SecurityInfoForPrincipal limits = (SecurityInfoForPrincipal)mapEntry.getValue();
            ISecurityLimitAdmin[] limitsArray = limits.toArray(new ISecurityLimitAdmin[limits.size()]);
            Principal princ = (Principal)principalMap.get(principalID);
            if (princ == null) {
                princ = this.newPrincipal(limits, true);
                principalMap.put(principalID, princ);
                ps.add(princ);
            }
            princ.setLimits2(limitsArray);
        }
        Map principalRolesMap = this.makePrincipalMap(((SecurityInfoEntry)entry).getRoles());
        entries = principalRolesMap.entrySet();
        Iterator iterator3 = entries.iterator();
        while (iterator3.hasNext()) {
            Map.Entry mapEntry = iterator3.next();
            Integer principalID = (Integer)mapEntry.getKey();
            SecurityInfoForPrincipal roles = (SecurityInfoForPrincipal)mapEntry.getValue();
            ISecurityRoleAdmin[] rolesArray = roles.toArray(new ISecurityRoleAdmin[roles.size()]);
            Principal princ = (Principal)principalMap.get(principalID);
            if (princ == null) {
                princ = this.newPrincipal(roles, roles.isInherited());
                principalMap.put(principalID, princ);
                ps.add(princ);
            } else if (!roles.isInherited()) {
                princ.setInherited(false);
            }
            princ.setRoles(rolesArray);
        }
        this.fillAdditionalPrincipalInfo(ps);
        return ps;
    }

    private Principal newPrincipal(SecurityInfoForPrincipal rights, boolean inherited) {
        Principal princ = new Principal(rights.getPrincipalID(), rights.getPrincipalName(), rights.isInheritFolderPrincipal(), rights.isInheritGroupPrincipal(), inherited);
        princ.setRights2(new ISecurityRightAdmin[0]);
        princ.setLimits2(new ISecurityLimitAdmin[0]);
        princ.setRoles(new ISecurityRoleAdmin[0]);
        return princ;
    }

    private void fillAdditionalPrincipalInfo(List principals) {
        Iterator iterator = principals.iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            ISecurityRightAdmin[] rights = principal.getRights();
            boolean isAdvancedPrincipal = false;
            block1: for (int i = 0; i < rights.length && !isAdvancedPrincipal; ++i) {
                ISecurityRightAdmin right = rights[i];
                List sources = right.getSources();
                Iterator iter1 = sources.iterator();
                while (iter1.hasNext()) {
                    IRightSource source = (IRightSource)iter1.next();
                    if (source.isFromRole()) continue;
                    isAdvancedPrincipal = true;
                    continue block1;
                }
            }
            if (!isAdvancedPrincipal) continue;
            principal.setAdvanced(true);
        }
    }

    public synchronized ISecurityResult getExplicitPrincipals(int objectID) throws SDKException {
        GetExplicitRolesCommand command3;
        GetExplicitDWordRightsCommand command2;
        HashMap<Integer, Principal> principalMap = new HashMap<Integer, Principal>();
        ArrayList<Principal> ps = new ArrayList<Principal>();
        GetExplicitBoolRightsCommand command1 = new GetExplicitBoolRightsCommand(objectID);
        CacheEntry entry = this.rightsRequest(command1);
        if (entry != null && !(entry instanceof NoEntry)) {
            Map principalRightsMap = this.makePrincipalMap(((ExplicitSecurityEntry)entry).getValue());
            Set entries = principalRightsMap.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                Integer principalID = (Integer)mapEntry.getKey();
                SecurityInfoForPrincipal rights = (SecurityInfoForPrincipal)mapEntry.getValue();
                ISecurityRightAdmin[] rightsArray = rights.toArray(new ISecurityRightAdmin[rights.size()]);
                Principal princ = (Principal)principalMap.get(principalID);
                if (princ == null) {
                    princ = this.newPrincipal(rights, false);
                    principalMap.put(principalID, princ);
                    ps.add(princ);
                }
                princ.setRights2(rightsArray);
            }
        }
        if ((entry = this.rightsRequest(command2 = new GetExplicitDWordRightsCommand(objectID))) != null && !(entry instanceof NoEntry)) {
            Map principalLimitsMap = this.makePrincipalMap(((ExplicitSecurityEntry)entry).getValue());
            Set entries = principalLimitsMap.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                Integer principalID = (Integer)mapEntry.getKey();
                SecurityInfoForPrincipal limits = (SecurityInfoForPrincipal)mapEntry.getValue();
                ISecurityLimitAdmin[] limitsArray = limits.toArray(new ISecurityLimitAdmin[limits.size()]);
                Principal princ = (Principal)principalMap.get(principalID);
                if (princ == null) {
                    princ = this.newPrincipal(limits, false);
                    principalMap.put(principalID, princ);
                    ps.add(princ);
                }
                princ.setLimits2(limitsArray);
            }
        }
        if ((entry = this.rightsRequest(command3 = new GetExplicitRolesCommand(objectID))) != null && !(entry instanceof NoEntry)) {
            Map principalRolesMap = this.makePrincipalMap(((ExplicitSecurityEntry)entry).getValue());
            Set entries = principalRolesMap.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                Integer principalID = (Integer)mapEntry.getKey();
                SecurityInfoForPrincipal roles = (SecurityInfoForPrincipal)mapEntry.getValue();
                ISecurityRoleAdmin[] rolesArray = roles.toArray(new ISecurityRoleAdmin[roles.size()]);
                Principal princ = (Principal)principalMap.get(principalID);
                if (princ == null) {
                    princ = this.newPrincipal(roles, false);
                    principalMap.put(principalID, princ);
                    ps.add(princ);
                }
                princ.setRoles(rolesArray);
            }
        }
        return new SecurityResult(0, ps.toArray(new ISecurityPrincipal[ps.size()]));
    }

    public synchronized int removeRight(RightDescriptor right, int principalID, int objectID) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        int realScope = this.getRealScope(right.scope);
        int realRightID = this.getRealRightID(right.id, right.kind, right.isOwner);
        String realKind = this.getRealProgID(right.applicableObjectType);
        if (realScope != 3) {
            RemoveRightBoolCommand command = new RemoveRightBoolCommand(realRightID, principalID, objectID, realKind, realScope);
            return loadHelper.submit(command);
        }
        RemoveRightBoolCommand command1 = new RemoveRightBoolCommand(realRightID, principalID, objectID, realKind, 1);
        loadHelper.submit(command1);
        RemoveRightBoolCommand command2 = new RemoveRightBoolCommand(realRightID, principalID, objectID, realKind, 2);
        return loadHelper.submit(command2);
    }

    public synchronized int removeRights(int principalID, int objectID) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        RemoveRightsBoolCommand command = new RemoveRightsBoolCommand(principalID, objectID);
        return loadHelper.submit(command);
    }

    public synchronized int removeLimits(int principalID, int objectID) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        RemoveRightsDWordCommand command = new RemoveRightsDWordCommand(principalID, objectID);
        return loadHelper.submit(command);
    }

    public synchronized int removeRoles(int principalID, int objectID) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        RemoveRolesCommand command = new RemoveRolesCommand(principalID, objectID);
        return loadHelper.submit(command);
    }

    public synchronized int removeLimit(RightDescriptor right, int principalID, int objectID) throws SDKException {
        right.isOwner = false;
        BatchHelper loadHelper = this.getLoadHelper();
        int realScope = this.getRealScope(right.scope);
        int realRightID = this.getRealRightID(right.id, right.kind, right.isOwner);
        String realKind = this.getRealProgID(right.applicableObjectType);
        if (realScope != 3) {
            RemoveRightDWordCommand command = new RemoveRightDWordCommand(realRightID, principalID, objectID, realKind, realScope);
            return loadHelper.submit(command);
        }
        RemoveRightDWordCommand command1 = new RemoveRightDWordCommand(realRightID, principalID, objectID, realKind, 1);
        loadHelper.submit(command1);
        RemoveRightDWordCommand command2 = new RemoveRightDWordCommand(realRightID, principalID, objectID, realKind, 2);
        return loadHelper.submit(command2);
    }

    public synchronized int removeRole(int roleID, int principalID, int objectID) throws SDKException {
        RemoveRoleCommand command = new RemoveRoleCommand(roleID, objectID, principalID);
        return this.getLoadHelper().submit(command);
    }

    public synchronized int setRight(RightDescriptor right, int principalID, int objectID, boolean value) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        int realScope = this.getRealScope(right.scope);
        int realRightID = this.getRealRightID(right.id, right.kind, right.isOwner);
        String realKind = this.getRealProgID(right.applicableObjectType);
        if (realScope != 3) {
            SetRightBoolCommand command = new SetRightBoolCommand(realRightID, principalID, objectID, realKind, realScope, value);
            return loadHelper.submit(command);
        }
        SetRightBoolCommand command1 = new SetRightBoolCommand(realRightID, principalID, objectID, realKind, 1, value);
        loadHelper.submit(command1);
        SetRightBoolCommand command2 = new SetRightBoolCommand(realRightID, principalID, objectID, realKind, 2, value);
        return loadHelper.submit(command2);
    }

    public synchronized int setLimit(RightDescriptor right, int principalID, int objectID, int value) throws SDKException {
        BatchHelper loadHelper = this.getLoadHelper();
        int realScope = this.getRealScope(right.scope);
        int realRightID = this.getRealRightID(right.id, right.kind, false);
        String realKind = this.getRealProgID(right.applicableObjectType);
        if (realScope != 3) {
            SetRightDWordCommand command = new SetRightDWordCommand(realRightID, principalID, objectID, realKind, realScope, value);
            return loadHelper.submit(command);
        }
        SetRightDWordCommand command1 = new SetRightDWordCommand(realRightID, principalID, objectID, realKind, 1, value);
        loadHelper.submit(command1);
        SetRightDWordCommand command2 = new SetRightDWordCommand(realRightID, principalID, objectID, realKind, 2, value);
        return loadHelper.submit(command2);
    }

    public synchronized int setRole(int roleID, int principalID, int objectID) throws SDKException {
        SetRoleCommand command = new SetRoleCommand(roleID, objectID, principalID);
        return this.getLoadHelper().submit(command);
    }

    public synchronized ISecurityResult getKnownRights(int objectID) throws SDKException {
        GetKnownRightsCommand command = new GetKnownRightsCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        return new SecurityResult(0, ((RightDescriptionEntry)entry).getRights());
    }

    public synchronized ISecurityResult getKnownLimits(int objectID) throws SDKException {
        GetKnownRightsCommand command = new GetKnownRightsCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        return new SecurityResult(0, ((RightDescriptionEntry)entry).getLimits());
    }

    public synchronized ISecurityResult getKnownRoles() throws SDKException {
        GetKnownRolesCommand command = new GetKnownRolesCommand();
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        return new SecurityResult(0, ((RoleInfoEntry)entry).getRoles());
    }

    public ISecurityResult getKnownRightsByPlugin(int objectID) throws SDKException {
        GetRightsByPluginCommand command = new GetRightsByPluginCommand(objectID);
        CacheEntry entry = this.rightsRequest(command);
        if (entry == null || entry instanceof NoEntry) {
            return new SecurityResult(4);
        }
        IPluginBasedRightIDs rights = ((PluginInfoEntry)entry).getRights();
        GetSystemRightsCommand command1 = new GetSystemRightsCommand(objectID);
        CacheEntry entry1 = this.rightsRequest(command1);
        if (entry1 == null || entry1 instanceof NoEntry) {
            return new SecurityResult(0, rights);
        }
        ((PluginBasedRightIDs)rights).setSystemRights(((RightDescriptionEntry)entry1).getRights());
        return new SecurityResult(0, rights);
    }

    public synchronized int setInheritFoldersForPrincipal(int objectID, int principalID, boolean inherit) throws SDKException {
        if (inherit) {
            return this.removeRight(NOF_REMOVERIGHT, principalID, objectID);
        }
        return this.setRight(NOF_SETRIGHT, principalID, objectID, true);
    }

    public int setInheritGroupsForPrincipal(int objectID, int principalID, boolean inherit) throws SDKException {
        if (inherit) {
            return this.removeRight(NOG_REMOVERIGHT, principalID, objectID);
        }
        return this.setRight(NOG_SETRIGHT, principalID, objectID, true);
    }

    public int setGlobalFolderInheritance(int objectID, boolean inherit) throws SDKException {
        return this.setInheritFoldersForPrincipal(objectID, 0, inherit);
    }

    public List batchProcess(BatchHelper helper) throws SDKException {
        List input = helper.input();
        SecuritySerializer serializer = new SecuritySerializer();
        try {
            Iterator iter = input.iterator();
            while (iter.hasNext()) {
                SerializableCommand command = (SerializableCommand)iter.next();
                serializer.writeByte(command.getTypeTag().getTag());
                serializer.writeObject(command);
            }
        }
        catch (NotSerializableException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to serialize the input security info requests", (Throwable)e);
            }
            throw new SDKException.InvalidArg(e);
        }
        SeqOctetHolder outHolder = new SeqOctetHolder();
        try {
            this.m_batchStub.processSerializedBatch(serializer.retrieveBuffer(), outHolder);
        }
        catch (oca_abuse oca_abuse2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to process the security info requests", (Throwable)oca_abuse2);
            }
            throw SDKException.map(oca_abuse2);
        }
        byte[] output = outHolder.value;
        SecurityDeserializer deserializer = new SecurityDeserializer(output);
        try {
            ArrayList<SerializableCommand> ret = new ArrayList<SerializableCommand>();
            while (deserializer.hasMore()) {
                SecurityType tag = SecurityType.getEnumForTag(deserializer.readByte());
                SerializableCommand val = SecurityCommandFactory.getCommandForTag(tag);
                val.read(deserializer);
                ret.add(val);
            }
            return ret;
        }
        catch (NotSerializableException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to deserialize the security info results", (Throwable)e);
            }
            throw new SDKException.Unexpected(e);
        }
        catch (EOFException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to deserialize the security info results", (Throwable)e);
            }
            throw new SDKException.Unexpected(e);
        }
        catch (StreamCorruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to deserialize the security info results", (Throwable)e);
            }
            throw new SDKException.Unexpected(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchOutput(BatchHelper helper) throws SDKException {
        int epoch;
        CacheControllerEx cacheControllerEx = this;
        synchronized (cacheControllerEx) {
            epoch = this.m_epoch++;
        }
        Iterator out = helper.output().iterator();
        Iterator in = helper.input().iterator();
        HashMap<SerializableCommand, Object> errors = null;
        while (out.hasNext()) {
            SerializableCommand outChunk;
            LOG.assertTrue(in.hasNext(), "Assertion failed");
            SerializableCommand inChunk = (SerializableCommand)in.next();
            CacheEntry entry = this.makeCacheEntry(inChunk, outChunk = (SerializableCommand)out.next(), epoch);
            if (entry == null) continue;
            if (entry instanceof ErrorEntry) {
                if (errors == null) {
                    errors = new HashMap<SerializableCommand, Object>();
                }
                errors.put(inChunk, ((ErrorEntry)entry).getError());
                continue;
            }
            CacheKey key = this.makeCacheKey(inChunk);
            if (key != null) {
                CacheEntry old = this.getCachedEntry(key, true);
                if (old == null || !old.isAggregable() || old.getEpoch() != entry.getEpoch()) {
                    this.m_map.put(key, new CacheRef(entry, key, this.m_refqueue));
                    continue;
                }
                old.aggregate(entry);
                continue;
            }
            if (!LOG.isErrorEnabled()) continue;
            LOG.error((Object)"CacheControllerEx.bachoutput() - cache key is null");
        }
        if (errors != null) {
            throw new SecurityException.BatchFailure(errors);
        }
    }

    private CacheEntry getCachedEntry(CacheKey key, boolean bValidateEntry) {
        CacheEntry entry;
        CacheRef ref = (CacheRef)this.m_refqueue.poll();
        while (ref != null) {
            this.m_map.remove(ref.getKey());
            ref = (CacheRef)this.m_refqueue.poll();
        }
        ref = (CacheRef)this.m_map.get(key);
        if (ref != null && (entry = (CacheEntry)ref.get()) != null) {
            if (!bValidateEntry || this.isDataStillValid(entry)) {
                return entry;
            }
            this.m_map.remove(key);
        }
        return null;
    }

    private CacheEntry rightsRequest(SerializableCommand request) throws SDKException {
        CacheEntry entry = null;
        CacheKey key = this.makeCacheKey(request);
        if (this.isSupportCache()) {
            entry = this.getCachedEntry(key, true);
        }
        if (entry == null) {
            this.m_checkHelper.submit(request);
            entry = this.getCachedEntry(key, false);
            LOG.assertNotNull((Object)entry, "entry is null");
        }
        if (entry != null) {
            entry.touchTimeStamp();
        }
        return entry;
    }

    private void cacheRequest(SerializableCommand request, boolean isAdminRequest) throws SDKException {
        if (this.isSupportCache()) {
            CacheKey key;
            CacheEntry entry;
            if (this.isCheckCache(isAdminRequest) && (entry = this.getCachedEntry(key = this.makeCacheKey(request), true)) != null) {
                return;
            }
            this.getLoadHelper().submit(request);
        }
    }

    private boolean isSupportCache() {
        return this.m_globalSupportCache;
    }

    private boolean isCheckCache(boolean isAdminRequest) {
        return this.isSupportCache() && this.m_useCache && !isAdminRequest;
    }

    private CacheKey makeCacheKey(SerializableCommand request) {
        SecurityType type = request.getTypeTag();
        if (type == SecurityType.CheckRightBoolCommandTag) {
            CheckRightBoolCommand command = (CheckRightBoolCommand)request;
            return new CacheKey(command.rightID, command.objectID, this.m_currentUserID, "", 3, false);
        }
        if (type == SecurityType.CheckRightDWordCommandTag) {
            CheckRightDWordCommand command = (CheckRightDWordCommand)request;
            return new CacheKey(command.rightID, command.objectID, this.m_currentUserID, "", 3, false);
        }
        if (type == SecurityType.CheckRightBoolCommandForPrincipalTag) {
            CheckRightBoolCommandForPrincipal command = (CheckRightBoolCommandForPrincipal)request;
            return new CacheKey(command.rightID, command.objectID, command.principalID, "", 3, false);
        }
        if (type == SecurityType.CheckRightDWordCommandForPrincipalTag) {
            CheckRightDWordCommandForPrincipal command = (CheckRightDWordCommandForPrincipal)request;
            return new CacheKey(command.rightID, command.objectID, command.principalID, "", 3, false);
        }
        if (type == SecurityType.GetExplicitBoolRightsCommandTag) {
            GetExplicitBoolRightsCommand command = (GetExplicitBoolRightsCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, true, 1);
        }
        if (type == SecurityType.GetExplicitDWordRightsCommandTag) {
            GetExplicitDWordRightsCommand command = (GetExplicitDWordRightsCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, true, 2);
        }
        if (type == SecurityType.GetExplicitRolesCommandTag) {
            GetExplicitRolesCommand command = (GetExplicitRolesCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, true, 3);
        }
        if (type == SecurityType.GetSecurityInfoCommandTag) {
            GetSecurityInfoCommand command = (GetSecurityInfoCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, false);
        }
        if (type == SecurityType.GetSecurityInfoForPrincipalCommandTag) {
            GetSecurityInfoForPrincipalCommand command = (GetSecurityInfoForPrincipalCommand)request;
            return new CacheKey(0, command.objectID, command.principalID, "", 3, false);
        }
        if (type == SecurityType.GetKnownRightsCommandTag) {
            GetKnownRightsCommand command = (GetKnownRightsCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, false, 4);
        }
        if (type == SecurityType.GetKnownRolesCommandTag) {
            return new CacheKey(0, 0, 0, "", 3, false, 5);
        }
        if (type == SecurityType.GetRightsByPluginCommandTag) {
            GetRightsByPluginCommand command = (GetRightsByPluginCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, false, 6);
        }
        if (type == SecurityType.GetSystemRightsCommandTag) {
            GetSystemRightsCommand command = (GetSystemRightsCommand)request;
            return new CacheKey(0, command.objectID, 0, "", 3, false, 7);
        }
        if (type == SecurityType.CheckRightBoolScopedCommandTag) {
            CheckRightBoolScopedCommand command = (CheckRightBoolScopedCommand)request;
            return new CacheKey(command.rightID, command.objectID, this.m_currentUserID, command.objectType, command.scope, false);
        }
        if (type == SecurityType.CheckRightBoolScopedForPrincipalCommandTag) {
            CheckRightBoolScopedForPrincipalCommand command = (CheckRightBoolScopedForPrincipalCommand)request;
            return new CacheKey(command.rightID, command.objectID, command.principalID, command.objectType, command.scope, false);
        }
        LOG.assertTrue(false, "Assertion failed");
        return null;
    }

    private CacheEntry makeCacheEntry(SerializableCommand request, SerializableCommand result, int epoch) throws SDKException {
        SecurityType type = result.getTypeTag();
        if (type == SecurityType.CheckRightBoolResultTag) {
            CheckRightBoolResult command = (CheckRightBoolResult)result;
            return new BooleanEntry(command.granted);
        }
        if (type == SecurityType.CheckRightDWordResultTag) {
            CheckRightDWordResult command = (CheckRightDWordResult)result;
            return new DWordEntry(command.minRight, command.maxRight, command.isDefined);
        }
        if (type == SecurityType.GetExplicitBoolRightsResultTag) {
            GetExplicitBoolRightsResult command = (GetExplicitBoolRightsResult)result;
            int size = command.rights == null ? 0 : command.rights.size();
            ISecurityInfoAdmin[] rights = new SecurityRightAdmin[size];
            int i = 0;
            int objID = ((GetExplicitBoolRightsCommand)request).objectID;
            Iterator iter = command.rights.iterator();
            while (iter.hasNext()) {
                ExplicitBoolRight element = (ExplicitBoolRight)iter.next();
                rights[i++] = new SecurityRightAdmin(element.rightID, element.granted, false, true, false, null, element.objectType, this.getStringScope(element.scope), element.principalID, element.principalName, this.m_pluginMgr, this, objID);
            }
            return new ExplicitSecurityEntry(rights);
        }
        if (type == SecurityType.GetExplicitDWordRightsResultTag) {
            GetExplicitDWordRightsResult command = (GetExplicitDWordRightsResult)result;
            int size = command.limits == null ? 0 : command.limits.size();
            ISecurityInfoAdmin[] limits = new SecurityLimitAdmin[size];
            int i = 0;
            int objID = ((GetExplicitDWordRightsCommand)request).objectID;
            Iterator iter = command.limits.iterator();
            while (iter.hasNext()) {
                ExplicitDWordRight element = (ExplicitDWordRight)iter.next();
                limits[i++] = new SecurityLimitAdmin(element.rightID, element.value, true, false, null, element.objectType, this.getStringScope(element.scope), element.principalID, element.principalName, this.m_pluginMgr, this, objID);
            }
            return new ExplicitSecurityEntry(limits);
        }
        if (type == SecurityType.GetExplicitRolesResultTag) {
            GetExplicitRolesResult command = (GetExplicitRolesResult)result;
            int size = command.roles == null ? 0 : command.roles.size();
            ISecurityInfoAdmin[] roles = new SecurityRoleAdmin[size];
            int i = 0;
            Iterator iter = command.roles.iterator();
            while (iter.hasNext()) {
                ExplicitRole element = (ExplicitRole)iter.next();
                roles[i++] = new SecurityRoleAdmin(element.roleID, true, false, null, element.principalID, element.principalName);
            }
            return new ExplicitSecurityEntry(roles);
        }
        if (type == SecurityType.GetSecurityInfoResultTag) {
            SecurityType requestType = request.getTypeTag();
            int objID = 0;
            int principalID = 0;
            if (requestType == SecurityType.GetSecurityInfoCommandTag) {
                objID = ((GetSecurityInfoCommand)request).objectID;
            } else if (requestType == SecurityType.GetSecurityInfoForPrincipalCommandTag) {
                objID = ((GetSecurityInfoForPrincipalCommand)request).objectID;
                principalID = ((GetSecurityInfoForPrincipalCommand)request).principalID;
            } else {
                LOG.assertTrue(false, "CacheControllerEx.makeCacheEntry - unsupported request type " + request.getClass().getName());
            }
            GetSecurityInfoResult command = (GetSecurityInfoResult)result;
            ArrayList<AbstractSecurityBase> secList = new ArrayList<AbstractSecurityBase>();
            Iterator iter = command.rights.iterator();
            while (iter.hasNext()) {
                EffectiveBoolRight element = (EffectiveBoolRight)iter.next();
                ArrayList sources = new ArrayList(element.sources == null ? 0 : element.sources.size());
                int thisPrincipal = principalID == 0 ? element.principalID : principalID;
                boolean isInherited = this.makeRightSources(objID, thisPrincipal, element.sources, sources);
                if (!(element.rightID != 64 && element.rightID != 63 || element.specified && element.granted)) {
                    isInherited = true;
                }
                SecurityRightAdmin rightAdmin = new SecurityRightAdmin(element.rightID, element.granted, element.inheritedValue, false, isInherited, sources, element.objectType, this.getStringScope(element.scope), thisPrincipal, element.principalName, this.m_pluginMgr, this, objID);
                rightAdmin.setImplicitSources(element.sourcesInherited);
                secList.add(rightAdmin);
            }
            ISecurityRightAdmin[] rights = secList.toArray(new ISecurityRightAdmin[secList.size()]);
            secList.clear();
            Iterator iter2 = command.limits.iterator();
            while (iter2.hasNext()) {
                EffectiveDWordRight element = (EffectiveDWordRight)iter2.next();
                ArrayList sources = new ArrayList(element.sources == null ? 0 : element.sources.size());
                int thisPrincipal = principalID == 0 ? element.principalID : principalID;
                boolean isInherited = this.makeRightSources(objID, thisPrincipal, element.sources, sources);
                secList.add(new SecurityLimitAdmin(element.right, element.minRight, false, isInherited, sources, null, null, thisPrincipal, element.principalName, this.m_pluginMgr, this, objID));
            }
            ISecurityLimitAdmin[] limits = secList.toArray(new ISecurityLimitAdmin[secList.size()]);
            secList.clear();
            Iterator iter3 = command.roles.iterator();
            while (iter3.hasNext()) {
                EffectiveRole element = (EffectiveRole)iter3.next();
                ArrayList sources = new ArrayList(element.sources == null ? 0 : element.sources.size());
                int thisPrincipal = principalID == 0 ? element.principalID : principalID;
                boolean isInherited = this.makeRoleSources(objID, thisPrincipal, element.sources, sources);
                secList.add(new SecurityRoleAdmin(element.roleID, false, isInherited, sources, thisPrincipal, element.principalName));
            }
            ISecurityRoleAdmin[] roles = secList.toArray(new ISecurityRoleAdmin[secList.size()]);
            return new SecurityInfoEntry(rights, limits, roles);
        }
        if (type == SecurityType.GetKnownRightsResultTag) {
            GetKnownRightsResult command = (GetKnownRightsResult)result;
            IRightID[] rights = this.makeRightIDs(command.rights, "");
            IRightID[] limits = this.makeRightIDs(command.limits, "");
            return new RightDescriptionEntry(rights, limits);
        }
        if (type == SecurityType.GetKnownRolesResultTag) {
            GetKnownRolesResult command = (GetKnownRolesResult)result;
            ArrayList<RoleID> secList = new ArrayList<RoleID>();
            Iterator iter = command.roles.iterator();
            while (iter.hasNext()) {
                RoleInfo element = (RoleInfo)iter.next();
                secList.add(new RoleID(element.roleId, element.name, element.description, element.cuid));
            }
            IRoleID[] roles = secList.toArray(new IRoleID[secList.size()]);
            return new RoleInfoEntry(roles);
        }
        if (type == SecurityType.GetRightsByPluginResultTag) {
            GetRightsByPluginResult command = (GetRightsByPluginResult)result;
            List pluginsNoRights = command.progIdsWithoutRights;
            HashMap<String, IRightID[]> pluginRightsMap = new HashMap<String, IRightID[]>(command.rightsByPlugin.size() + pluginsNoRights.size());
            Iterator iter = command.rightsByPlugin.iterator();
            while (iter.hasNext()) {
                PluginRights pluginRights = (PluginRights)iter.next();
                IRightID[] rights = this.makeRightIDs(pluginRights.rights, "");
                pluginRightsMap.put(pluginRights.progId, rights);
            }
            HashMap<String, IRightID[]> pluginLimitsMap = new HashMap<String, IRightID[]>(command.limitsByPlugin.size() + pluginsNoRights.size());
            Iterator iter4 = command.limitsByPlugin.iterator();
            while (iter4.hasNext()) {
                PluginRights pluginRights = (PluginRights)iter4.next();
                IRightID[] rights = this.makeRightIDs(pluginRights.rights, "");
                pluginLimitsMap.put(pluginRights.progId, rights);
            }
            iter4 = pluginsNoRights.iterator();
            while (iter4.hasNext()) {
                String progId = (String)iter4.next();
                pluginRightsMap.put(progId, new IRightID[0]);
                pluginLimitsMap.put(progId, new IRightID[0]);
            }
            IRightID[] metaRights = this.makeRightIDs(command.metapluginRights, "");
            IRightID[] metaLimits = this.makeRightIDs(command.metapluginLimits, "");
            return new PluginInfoEntry(metaRights, metaLimits, pluginRightsMap, pluginLimitsMap);
        }
        if (type == SecurityType.GetSystemRightsResultTag) {
            GetSystemRightsResult command = (GetSystemRightsResult)result;
            IRightID[] rights = this.makeRightIDs(command.rights, "");
            return new RightDescriptionEntry(rights, null);
        }
        if (type == SecurityType.CallFailureResultTag) {
            CallFailureResult error = (CallFailureResult)result;
            return new ErrorEntry(error);
        }
        if (type == SecurityType.CallFailureWithMessagesTag) {
            CallFailureWithMessages error = (CallFailureWithMessages)result;
            return new ErrorEntry(error);
        }
        if (type == SecurityType.CallSuccessResultTag) {
            // empty if block
        }
        LOG.assertTrue(false, "Assertion failed");
        return null;
    }

    private IRightID[] makeRightIDs(List rights, String categoryID) {
        ArrayList<RightID> secList = new ArrayList<RightID>();
        Iterator iter = rights.iterator();
        while (iter.hasNext()) {
            RightDescription element = (RightDescription)iter.next();
            RightID newRight = new RightID(element.rightID, Integer.toString(element.descriptionResID), categoryID, 0);
            newRight.setPluginMgr(this.m_pluginMgr);
            secList.add(newRight);
        }
        return secList.toArray(new IRightID[secList.size()]);
    }

    private boolean makeRightSources(int objectID, int principalID, List inputSources, List outputSources) throws SDKException {
        if (inputSources == null || inputSources.size() <= 0) {
            return false;
        }
        boolean isInherited = true;
        Iterator iter1 = inputSources.iterator();
        while (iter1.hasNext()) {
            RightSource source = (RightSource)iter1.next();
            boolean isInheritedSource = source.objectID != objectID || source.principalID != principalID;
            outputSources.add(new SecurityRightSource(source.objectID, source.principalID, source.objectType, this.getStringScope(source.scope), source.sourceRole > 0, source.sourceRole, isInheritedSource));
            isInherited &= isInheritedSource;
        }
        return isInherited;
    }

    private boolean makeRoleSources(int objectID, int principalID, List inputSources, List outputSources) {
        if (inputSources == null || inputSources.size() <= 0) {
            return false;
        }
        boolean isInherited = true;
        Iterator iter1 = inputSources.iterator();
        while (iter1.hasNext()) {
            RoleSource source = (RoleSource)iter1.next();
            boolean isInheritedSource = source.objectID != objectID || source.principalID != principalID;
            outputSources.add(new SecurityRoleSource(source.objectID, source.principalID, isInheritedSource));
            isInherited &= isInheritedSource;
        }
        return isInherited;
    }

    private boolean isDataStillValid(CacheEntry entry) {
        if (entry == null) {
            return false;
        }
        long timeDiff = System.currentTimeMillis() - entry.m_createTime;
        return timeDiff >= 0L && timeDiff <= MAX_CACHE_AGE;
    }

    private Map makePrincipalMap(ISecurityInfoAdmin[] secInfos) {
        HashMap<Integer, List> principalMap = new HashMap<Integer, List>();
        for (int i = 0; i < secInfos.length; ++i) {
            ISecurityInfoAdmin secInfo = secInfos[i];
            List principalSec = (List)principalMap.get(new Integer(secInfo.getPrincipalID()));
            if (principalSec == null) {
                principalSec = new SecurityInfoForPrincipal(secInfo.getPrincipalID(), secInfo.getPrincipalName());
                principalMap.put(new Integer(secInfo.getPrincipalID()), principalSec);
            }
            if (!this.checkInheritance(secInfo, (SecurityInfoForPrincipal)principalSec)) {
                principalSec.add(secInfo);
            }
            if (secInfo.isInherited()) continue;
            ((SecurityInfoForPrincipal)principalSec).setInherited(false);
        }
        return principalMap;
    }

    private boolean checkInheritance(ISecurityInfoAdmin secInfo, SecurityInfoForPrincipal principalSec) {
        if (secInfo instanceof ISecurityRightAdmin) {
            ISecurityRightAdmin rightInfo = (ISecurityRightAdmin)secInfo;
            if (rightInfo.getID() == 64) {
                if ("this".equalsIgnoreCase(rightInfo.getScope())) {
                    principalSec.setInheritFolder(!rightInfo.isGranted());
                }
                return true;
            }
            if (rightInfo.getID() == 63) {
                if ("this".equalsIgnoreCase(rightInfo.getScope())) {
                    principalSec.setInheritGroup(!rightInfo.isGranted());
                }
                return true;
            }
        }
        return false;
    }

    private int getRealRightID(int id, Object kind, boolean isOwner) throws SDKException {
        return SecurityValidator.getRealRightID(this.m_pluginMgr, id, kind, isOwner);
    }

    private String getRealProgID(Object kind) throws SDKException {
        if (SecurityValidator.isEmptyType(kind) || kind instanceof String && Any_TYPE.equalsIgnoreCase((String)kind)) {
            return Any_TYPE;
        }
        return SecurityValidator.getRealProgID(this.m_pluginMgr, kind);
    }

    private int getRealScope(String scope) throws SDKException {
        String strRealScope = SecurityValidator.validateScope(scope);
        if ("this".equalsIgnoreCase(strRealScope)) {
            return 1;
        }
        if ("descendants".equalsIgnoreCase(strRealScope)) {
            return 2;
        }
        if ("".equals(strRealScope)) {
            return 3;
        }
        throw new SDKException.InvalidArg(scope);
    }

    private String getStringScope(int scope) throws SDKException {
        switch (scope) {
            case 1: {
                return "this";
            }
            case 2: {
                return "descendants";
            }
        }
        throw new SDKException.InvalidArg(scope);
    }

    private static class CacheRef
    extends SoftReference {
        private CacheKey m_key;

        public CacheRef(Object referent, CacheKey key, ReferenceQueue q) {
            super(referent, q);
            this.m_key = key;
        }

        public CacheKey getKey() {
            return this.m_key;
        }
    }

    static class ErrorEntry
    extends CacheEntry {
        Object m_result;

        public ErrorEntry(Object result) {
            this.m_result = result;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "ErrorEntry doesn't support aggregation");
        }

        public Object getError() {
            return this.m_result;
        }
    }

    static class PluginInfoEntry
    extends CacheEntry {
        IPluginBasedRightIDs m_rights;

        public PluginInfoEntry(IRightID[] metaPluginRights, IRightID[] metaPluginLimits, HashMap pluginRights, HashMap pluginLimits) {
            this.m_rights = new PluginBasedRightIDs(metaPluginRights, metaPluginLimits, pluginRights, pluginLimits);
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "PluginInfoEntry doesn't support aggregation");
        }

        public IPluginBasedRightIDs getRights() {
            return this.m_rights;
        }
    }

    static class RoleInfoEntry
    extends CacheEntry {
        IRoleID[] m_roles;

        RoleInfoEntry(IRoleID[] roles) {
            this.m_roles = roles;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "RoleInfoEntry doesn't support aggregation");
        }

        public IRoleID[] getRoles() {
            return this.m_roles;
        }
    }

    static class RightDescriptionEntry
    extends CacheEntry {
        IRightID[] m_rights;
        IRightID[] m_limits;

        RightDescriptionEntry(IRightID[] rights, IRightID[] limits) {
            this.m_rights = rights;
            this.m_limits = limits;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "RightDescriptionEntry doesn't support aggregation");
        }

        public IRightID[] getRights() {
            return this.m_rights;
        }

        public IRightID[] getLimits() {
            return this.m_limits;
        }
    }

    static class SecurityInfoForPrincipal
    extends ArrayList
    implements ISecurityInfoAdmin,
    List {
        private int m_principalID;
        private String m_principalName;
        private boolean m_isInheritFolder;
        private boolean m_isInheritGroup;
        private boolean m_isInherited;

        public SecurityInfoForPrincipal(int principalID, String principalName) {
            this.m_principalID = principalID;
            this.m_principalName = principalName;
            this.m_isInheritFolder = true;
            this.m_isInheritGroup = true;
            this.m_isInherited = true;
        }

        public int getPrincipalID() {
            return this.m_principalID;
        }

        public String getPrincipalName() {
            return this.m_principalName;
        }

        public boolean isInheritFolderPrincipal() {
            return this.m_isInheritFolder;
        }

        public boolean isInheritGroupPrincipal() {
            return this.m_isInheritGroup;
        }

        public void setInheritFolder(boolean inheritFolder) {
            this.m_isInheritFolder = inheritFolder;
        }

        public void setInheritGroup(boolean inheritGroup) {
            this.m_isInheritGroup = inheritGroup;
        }

        public boolean isInherited() {
            return this.m_isInherited;
        }

        public void setInherited(boolean inherited) {
            this.m_isInherited = inherited;
        }
    }

    static class SecurityRoleAdmin
    extends AbstractSecurityBase
    implements ISecurityRoleAdmin {
        public SecurityRoleAdmin(int id, boolean isExplicit, boolean inherited, List sources, int principalID, String principalName) {
            super(id, isExplicit, inherited, principalID, principalName, null, null, sources, null);
        }

        public String getTitle() {
            return null;
        }
    }

    static class SecurityLimitAdmin
    extends AbstractSecurityBase
    implements ISecurityLimitAdmin {
        private int m_value;
        private CacheControllerEx m_cacheController;
        private Map m_knownRights;
        private int m_objID;

        public SecurityLimitAdmin(int id, int value, boolean isExplicit, boolean inherited, List sources, String obType, String rightScope, int principalID, String principalName, IPluginMgr pluginMgr, CacheControllerEx cacheController, int objID) {
            super(id, isExplicit, inherited, principalID, principalName, obType, rightScope, sources, pluginMgr);
            this.m_value = value;
            this.m_cacheController = cacheController;
            this.m_objID = objID;
        }

        public void setValue(int lVal) {
            this.m_value = lVal;
        }

        public int getValue() {
            return this.m_value;
        }

        public RightDescriptor getLimitDescriptor() {
            return super.getRightDescriptor();
        }

        public RightIDDescriptor getLimitID() {
            return super.getRightID();
        }

        protected Map getKnownSecInfo() {
            block5: {
                if (this.m_knownRights == null && this.m_cacheController != null) {
                    try {
                        ISecurityResult result = this.m_cacheController.getKnownLimits(this.m_objID);
                        if (0 == result.getStatus()) {
                            IRightID[] rights = (IRightID[])result.getResult();
                            this.m_knownRights = new HashMap(rights.length);
                            for (int i = 0; i < rights.length; ++i) {
                                IRightID right = rights[i];
                                this.m_knownRights.put(new Integer(right.getID()), right);
                            }
                        }
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) break block5;
                        LOG.debug((Object)"SecurityRightAdmin.getKnownSecInfo failed", (Throwable)((Object)e));
                    }
                }
            }
            return this.m_knownRights;
        }
    }

    static class SecurityRightAdmin
    extends AbstractSecurityBase
    implements ISecurityRightAdmin {
        private boolean m_value;
        private boolean m_valueWithoutExplicitRights;
        private CacheControllerEx m_cacheController;
        private Map m_knownRights;
        private int m_objID;
        protected List m_inheritedSources;

        public SecurityRightAdmin(int id, boolean value, boolean valueWithoutExplicitRights, boolean isExplicit, boolean inherited, List sources, String obType, String rightScope, int principalID, String principalName, IPluginMgr pluginMgr, CacheControllerEx cacheController, int objID) {
            super(id, isExplicit, inherited, principalID, principalName, obType, rightScope, sources, pluginMgr);
            this.m_value = value;
            this.m_cacheController = cacheController;
            this.m_objID = objID;
            this.m_valueWithoutExplicitRights = valueWithoutExplicitRights;
        }

        public boolean isGranted() {
            return this.m_value;
        }

        public void setGranted(boolean granted) {
            this.m_value = granted;
        }

        public boolean isImplicitGranted() {
            return this.m_valueWithoutExplicitRights;
        }

        public boolean isSpecified() {
            return true;
        }

        public RightDescriptor getRightDescriptor() {
            return super.getRightDescriptor();
        }

        public RightIDDescriptor getRightID() {
            return super.getRightID();
        }

        protected Map getKnownSecInfo() {
            block5: {
                if (this.m_knownRights == null && this.m_cacheController != null) {
                    try {
                        ISecurityResult result = this.m_cacheController.getKnownRights(this.m_objID);
                        if (0 == result.getStatus()) {
                            IRightID[] rights = (IRightID[])result.getResult();
                            this.m_knownRights = new HashMap(rights.length);
                            for (int i = 0; i < rights.length; ++i) {
                                IRightID right = rights[i];
                                this.m_knownRights.put(new Integer(right.getID()), right);
                            }
                        }
                    }
                    catch (SDKException e) {
                        if (!LOG.isDebugEnabled()) break block5;
                        LOG.debug((Object)"SecurityRightAdmin.getKnownSecInfo failed", (Throwable)((Object)e));
                    }
                }
            }
            return this.m_knownRights;
        }

        public List getImplicitSources() {
            return this.m_inheritedSources;
        }

        public void setImplicitSources(List inhertiedSources) {
            this.m_inheritedSources = inhertiedSources;
        }
    }

    static abstract class AbstractSecurityBase {
        protected boolean m_explicit;
        protected boolean m_inherited;
        protected int m_id;
        protected List m_sources;
        protected String m_obType;
        protected int m_principalID;
        protected String m_rightScope;
        protected String m_principalName;
        private IPluginMgr m_pluginMgr;
        private String m_desc;

        protected AbstractSecurityBase(int id, boolean explicit, boolean isInherited, int principalID, String principalName, String obType, String rightScope, List sources, IPluginMgr pluginMgr) {
            this.m_explicit = explicit;
            this.m_inherited = isInherited;
            this.m_id = id;
            this.m_sources = sources;
            this.m_obType = obType;
            this.m_principalID = principalID;
            this.m_principalName = principalName;
            this.m_rightScope = rightScope;
            this.m_pluginMgr = pluginMgr;
            this.m_desc = null;
        }

        public int getID() {
            return this.m_id;
        }

        public boolean isExplicit() {
            return this.m_explicit;
        }

        public boolean isInherited() {
            return this.m_inherited;
        }

        public String getDescription(Locale locale) {
            IRightID knownRight;
            Map knownRights;
            if (this.m_desc == null && (knownRights = this.getKnownSecInfo()) != null && (knownRight = (IRightID)knownRights.get(new Integer(this.getID()))) != null) {
                this.m_desc = knownRight.getDescription(locale);
            }
            return this.m_desc;
        }

        public List getSources() {
            return this.m_sources;
        }

        public String getObjectType() {
            return this.m_obType;
        }

        public int getPrincipalID() {
            return this.m_principalID;
        }

        public String getPrincipalName() {
            return this.m_principalName;
        }

        public String getScope() {
            return this.m_rightScope;
        }

        protected Map getKnownSecInfo() {
            return null;
        }

        protected RightDescriptor getRightDescriptor() {
            return new RightDescriptor(this.getBaseID(), this.getRightPluginKind(), this.isOwner(), this.m_rightScope, this.m_obType);
        }

        protected RightIDDescriptor getRightID() {
            return new RightIDDescriptor(this.getBaseID(), this.getRightPluginKind(), this.isOwner());
        }

        public boolean isOwner() {
            return SecurityIDs.isOwnerRight(this.m_id);
        }

        public int getBaseID() {
            return SecurityIDs.getBaseRightID(this.m_id);
        }

        public String getRightPluginKind() {
            if (this.m_pluginMgr != null) {
                try {
                    return SecurityIDs.getRightKind(this.m_id, this.m_pluginMgr);
                }
                catch (SDKException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SecurityRightAdmin::getRightPluginKind() failed", (Throwable)((Object)e));
                    }
                    return null;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SecurityRightAdmin::getRightPluginKind() failed because plugin manager is null");
            }
            throw new SDKRuntimeException.InvalidOperation();
        }

        public int getRightPluginType() {
            return SecurityIDs.getPluginType(this.m_id);
        }

        public String getApplicableKind() {
            return this.m_obType;
        }

        public int getApplicableType() {
            if (this.m_pluginMgr != null) {
                try {
                    return SecurityValidator.getRightTypeID(this.m_pluginMgr, this.m_obType);
                }
                catch (SDKException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SecurityRightAdmin::getRightPluginKind() failed", (Throwable)((Object)e));
                    }
                    return 0;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SecurityRightAdmin::getRightPluginKind() failed because plugin manager is null");
            }
            throw new SDKRuntimeException.InvalidOperation();
        }
    }

    static class SecurityInfoEntry
    extends CacheEntry {
        ISecurityRightAdmin[] m_rights;
        ISecurityLimitAdmin[] m_limits;
        ISecurityRoleAdmin[] m_roles;

        SecurityInfoEntry(ISecurityRightAdmin[] rights, ISecurityLimitAdmin[] limits, ISecurityRoleAdmin[] roles) {
            this.m_rights = rights;
            this.m_limits = limits;
            this.m_roles = roles;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "SecurityInfoEntry doesn't support aggregation");
        }

        public ISecurityRightAdmin[] getRights() {
            return this.m_rights;
        }

        public ISecurityLimitAdmin[] getLimits() {
            return this.m_limits;
        }

        public ISecurityRoleAdmin[] getRoles() {
            return this.m_roles;
        }
    }

    static class ExplicitSecurityEntry
    extends CacheEntry {
        ISecurityInfoAdmin[] m_value;

        ExplicitSecurityEntry(ISecurityInfoAdmin[] value) {
            this.m_value = value;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "ExplicitSecurityEntry doesn't support aggregation");
        }

        ISecurityInfoAdmin[] getValue() {
            return this.m_value;
        }
    }

    static class DWordEntry
    extends CacheEntry {
        int m_minValue;
        int m_maxValue;
        boolean m_isDefined;

        DWordEntry(int min, int max, boolean isDefined) {
            this.m_minValue = min;
            this.m_maxValue = max;
            this.m_isDefined = isDefined;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(entry instanceof DWordEntry, "Assertion failed");
            DWordEntry other = (DWordEntry)entry;
            this.m_maxValue = Math.max(this.m_maxValue, other.m_maxValue);
            this.m_minValue = Math.min(this.m_minValue, other.m_minValue);
            this.m_isDefined = this.m_isDefined && other.m_isDefined;
        }

        int getMinValue() {
            return this.m_minValue;
        }

        int getMaxValue() {
            return this.m_maxValue;
        }

        boolean isDefined() {
            return this.m_isDefined;
        }
    }

    static class BooleanEntry
    extends CacheEntry {
        boolean m_value;

        BooleanEntry(boolean value) {
            this.m_value = value;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(entry instanceof BooleanEntry, "Assertion failed");
            BooleanEntry other = (BooleanEntry)entry;
            this.m_value = this.m_value && other.m_value;
        }

        boolean getValue() {
            return this.m_value;
        }
    }

    static class NoEntry
    extends CacheEntry {
        int m_reason;

        NoEntry(int reason) {
            this.m_reason = reason;
        }

        void aggregate(CacheEntry entry) {
            LOG.assertTrue(false, "Assertion failed");
        }

        int getReason() {
            return this.m_reason;
        }
    }

    static abstract class CacheEntry
    implements Cloneable {
        private long m_createTime;
        private long m_time;
        private int m_epoch;

        CacheEntry() {
            this.setCreateTimeStamp();
            this.touchTimeStamp();
        }

        protected CacheEntry(int epoch) {
            this.m_epoch = epoch;
        }

        abstract void aggregate(CacheEntry var1);

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.assertTrue(false, "Assertion failed");
                return null;
            }
        }

        void touchTimeStamp() {
            this.m_time = System.currentTimeMillis();
        }

        private void setCreateTimeStamp() {
            this.m_createTime = System.currentTimeMillis();
        }

        boolean isAggregable() {
            return false;
        }

        int getEpoch() {
            return this.m_epoch;
        }
    }

    static class CacheKey {
        private static final int NO_ID = 0;
        private static final int RIGHTS_ID = 1;
        private static final int LIMITS_ID = 2;
        private static final int ROLES_ID = 3;
        private static final int KNOWN_RIGHTS_ID = 4;
        private static final int KNOWN_ROLES_ID = 5;
        private static final int RIGHTS_BY_PLUGIN_ID = 6;
        private static final int SYSTEM_RIGHTS_ID = 7;
        private int m_rightID;
        private int m_principalID;
        private int m_objectID;
        private String m_objectType;
        private int m_scope;
        private boolean m_bExplicit;
        private int m_id = 0;

        CacheKey(int rightID, int objectID, int principalID, String objectType, int scope, boolean bExplicit) {
            this(rightID, objectID, principalID, objectType, scope, bExplicit, 0);
        }

        CacheKey(int rightID, int objectID, int principalID, String objectType, int scope, boolean bExplicit, int id) {
            this.m_rightID = rightID;
            this.m_objectID = objectID;
            this.m_objectType = objectType;
            this.m_principalID = principalID;
            this.m_bExplicit = bExplicit;
            this.m_scope = scope;
            this.m_id = id;
        }

        CacheKey(CacheKey src) {
            this.m_rightID = src.m_rightID;
            this.m_objectID = src.m_objectID;
            this.m_objectType = src.m_objectType;
            this.m_principalID = src.m_principalID;
            this.m_bExplicit = src.m_bExplicit;
            this.m_scope = src.m_scope;
            this.m_id = src.m_id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                if (this.m_rightID != other.m_rightID) {
                    return false;
                }
                if (this.m_principalID != other.m_principalID) {
                    return false;
                }
                if (this.m_objectID != other.m_objectID) {
                    return false;
                }
                if (!this.m_objectType.equals(other.m_objectType)) {
                    return false;
                }
                if (this.m_id != other.m_id) {
                    return false;
                }
                if (this.m_bExplicit != other.m_bExplicit) {
                    return false;
                }
                return this.m_scope == other.m_scope;
            }
            return false;
        }

        public int hashCode() {
            return (int)(((long)this.m_principalID + (long)this.m_objectID + (long)this.m_objectType.hashCode() + (long)this.m_rightID + (long)Boolean.valueOf(this.m_bExplicit).hashCode()) % Integer.MAX_VALUE + (long)this.m_scope + (long)this.m_id);
        }
    }
}

