/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.ILogonTokenMgr;
import com.crystaldecisions.sdk.occa.security.internal._SessionExProxy;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;

class LogonTokenMgr
implements ILogonTokenMgr {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.LogonTokenMgr");
    private IManagedService m_handler;
    private SessionExOperations m_sessionStub;

    private LogonTokenMgr() {
    }

    LogonTokenMgr(IManagedService handler) throws SDKException {
        this.m_handler = handler;
        this.m_sessionStub = new _SessionExProxy(handler);
    }

    public String createLogonToken(String clientComputerName, int validMinutes, int validNumOfLogons) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createLogonToken(): machineName=" + clientComputerName + ",valid minutes=" + validMinutes + ",validNumOfTokens=" + validNumOfLogons));
        }
        try {
            StringHolder tokenHolder = new StringHolder();
            this.m_sessionStub.GetLogonTokenEx(clientComputerName, validMinutes, validNumOfLogons, tokenHolder);
            return this.m_handler.getAPS() + "@" + tokenHolder.value;
        }
        catch (oca_abuse e) {
            LOG.warn((Object)("createLogonToken(): failed to create token, machineName=" + clientComputerName + ",valid minutes=" + validMinutes + ",validNumOfTokens=" + validNumOfLogons), (Throwable)e);
            throw SDKException.map(e);
        }
    }

    public String createWCAToken(String clientComputerName, int validMinutes, int validNumOfLogons) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createSessionToken(): machineName=" + clientComputerName + ",valid minutes=" + validMinutes + ",validNumOfTokens=" + validNumOfLogons));
        }
        try {
            StringHolder tokenHolder = new StringHolder();
            this.m_sessionStub.GetLogonTokenEx(clientComputerName, validMinutes, validNumOfLogons, tokenHolder);
            return this.m_handler.getAPS() + "@" + tokenHolder.value + "ONEOFF";
        }
        catch (oca_abuse e) {
            LOG.warn((Object)("createSessionToken(): failed to create token, machineName=" + clientComputerName + ",valid minutes=" + validMinutes + ",validNumOfTokens=" + validNumOfLogons), (Throwable)e);
            throw SDKException.map(e);
        }
    }

    public String getDefaultToken() {
        return this.m_handler.getToken();
    }

    public void releaseToken(String token) throws SDKException {
        try {
            int delim = token.indexOf(64);
            String actualToken = token.substring(delim + 1);
            this.m_sessionStub.ReleaseTokenEx(actualToken);
        }
        catch (oca_abuse e) {
            LOG.warn((Object)("releaseToken(): Failed to relase token, token=" + token), (Throwable)e);
            throw SDKException.map(e);
        }
    }
}

