/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.property;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.pluginmgr.internal.PluginMgrFactory;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityPlugIn;
import com.crystaldecisions.sdk.properties.IProperties;
import java.util.HashMap;
import java.util.Map;

class PlugInLoader {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.PlugInLoader");
    private static final String MAGIC_URI = "osca:iiop://;BYPASSSEC=true";
    private Map m_pluginMap = new HashMap();
    private String m_currentAPS;

    PlugInLoader() {
    }

    public ISecurityPlugIn getClientAuthentication(String aps_name, String cluster_name, String auth_name) throws SDKException {
        this.m_currentAPS = aps_name;
        ISecurityPlugIn plugin = (ISecurityPlugIn)this.m_pluginMap.get(auth_name);
        if (plugin == null) {
            IPluginMgr plugMgr = PluginMgrFactory.getFactory().makePluginMgr("", aps_name, cluster_name, MAGIC_URI, "");
            plugin = (ISecurityPlugIn)plugMgr.getPluginInterface(auth_name, "auth");
            this.m_pluginMap.put(auth_name, plugin);
        }
        LOG.assertNotNull((Object)plugin, "plugin is null.");
        return plugin;
    }

    public String getClientError(String authen_name, int errCode, StringBuffer msgContent, property[] paraSeq, StringBuffer details) {
        return null;
    }

    public String getServerError(String authen_name, int errCode, int msgId) {
        return null;
    }

    public boolean needParams(String auth_name) {
        ISecurityPlugIn plugin = (ISecurityPlugIn)this.m_pluginMap.get(auth_name);
        LOG.assertNotNull((Object)plugin, "plugin is null.");
        return plugin.needParams();
    }

    public boolean setParams(String auth_name, IProperties inDllParams) throws SDKException {
        ISecurityPlugIn plugin = (ISecurityPlugIn)this.m_pluginMap.get(auth_name);
        LOG.assertNotNull((Object)plugin, "plugin is null.");
        plugin.setClientParasSeq(inDllParams);
        return true;
    }
}

