/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.ILogonTokenMgr;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoMgr;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.CacheControllerEx;
import com.crystaldecisions.sdk.occa.security.internal.ILogonService;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.LogonService;
import com.crystaldecisions.sdk.occa.security.internal.LogonTokenMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecurityInfoMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecurityMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.ServerLogonSession;
import com.crystaldecisions.sdk.occa.security.internal.ServerSession;
import com.crystaldecisions.sdk.occa.security.internal.UserInfo;
import com.crystaldecisions.sdk.properties.IProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class SecurityFactory {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.SecurityFactory");
    private static SecurityFactory singleton;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityFactory getFactory() {
        Object object = lock;
        synchronized (object) {
            if (singleton == null) {
                singleton = new SecurityFactory();
            }
            return singleton;
        }
    }

    public ISecurityMgr makeSecurityMgr() throws SDKException {
        return new SecurityMgr();
    }

    private String resolvedAps(String aps) {
        String aps_l = aps.toLowerCase(Locale.ENGLISH);
        String thisHostName = aps;
        try {
            if (aps_l.compareTo("localhost") == 0) {
                String localhostName;
                InetAddress localhostAddr = InetAddress.getLocalHost();
                thisHostName = localhostName = localhostAddr.getHostName();
            } else if (aps_l.startsWith("localhost:")) {
                InetAddress localhostAddr = InetAddress.getLocalHost();
                String localhostName = localhostAddr.getHostName();
                thisHostName = localhostName + thisHostName.substring(9);
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return thisHostName;
    }

    public ILogonService makeLogonService(String aps) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("makeLogonService(): aps=" + aps));
        }
        return new LogonService(this.resolvedAps(aps));
    }

    public ISecuritySession makeSecuritySession(String aps, String uri, String token, String cluster) throws SDKException {
        return new SecuritySession(this.resolvedAps(aps), uri, token, cluster);
    }

    public ISecuritySession makeSecuritySession(String aps, String uri, String token, String cluster, IProperties loginInfo) throws SDKException {
        return new SecuritySession(this.resolvedAps(aps), uri, token, cluster, loginInfo);
    }

    public ISecuritySession makeSecuritySession(String sessionID) throws SDKException {
        return SecuritySession.makeSession(sessionID);
    }

    public ISecuritySession makeServerSession(String aps, String cluster) throws SDKException {
        return new ServerSession(this.resolvedAps(aps), cluster);
    }

    public ISecuritySession makeServerLogonSession(String aps, String uri, String token, String cluster, IProperties loginInfoBag) throws SDKException {
        return new ServerLogonSession(this.resolvedAps(aps), uri, token, cluster, loginInfoBag);
    }

    ISecCacheController makeCacheController(IManagedService handler, ISecuritySession session, boolean useCache) throws SDKException {
        return new CacheControllerEx(handler, session, useCache);
    }

    ILogonTokenMgr makeLogonTokenMgr(IManagedService handler) throws SDKException {
        return new LogonTokenMgr(handler);
    }

    IUserInfo makeUserInfo(IManagedService handler, IProperties loginInfoBag) throws SDKException {
        return new UserInfo(handler, loginInfoBag);
    }

    ISecurityInfoMgr makeSecurityInfoManager(ISecuritySession session) throws SDKException {
        return new SecurityInfoMgr(session);
    }

    static {
        lock = new Object();
    }
}

