/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.internal.NameValuePairs;
import com.crystaldecisions.celib.collections.EmptyCollections;
import com.crystaldecisions.celib.collections.ISimpleCache;
import com.crystaldecisions.celib.collections.ISupportObjectLocal;
import com.crystaldecisions.celib.collections.SimpleCache;
import com.crystaldecisions.celib.conversion.LocaleConversion;
import com.crystaldecisions.celib.digest.HMACGenerator;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.uri.OcaURI;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.IServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Packer;
import com.crystaldecisions.enterprise.ocaframework.WireOb3Unpacker;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.ImplServ.OSCAFactoryPackage.connection_failure;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoObjectWireIteratorEx3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoStoreEx3Helper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.InfoWireObjects3Holder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.info_wire_ob3;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionBatchExHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionBatchExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.SessionExOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.security.ILogonTokenMgr;
import com.crystaldecisions.sdk.occa.security.ISecCacheController;
import com.crystaldecisions.sdk.occa.security.ISecCacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.ISecRights;
import com.crystaldecisions.sdk.occa.security.ISecRightsAdmin;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoMgr;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.CacheController;
import com.crystaldecisions.sdk.occa.security.internal.ICacheController;
import com.crystaldecisions.sdk.occa.security.internal.ICacheControllerAdmin;
import com.crystaldecisions.sdk.occa.security.internal.IRights;
import com.crystaldecisions.sdk.occa.security.internal.IRightsAdmin;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import com.crystaldecisions.sdk.occa.security.internal.ServerLogonSession;
import com.crystaldecisions.sdk.occa.security.internal.SessionParams;
import com.crystaldecisions.sdk.occa.security.internal.UserInfo;
import com.crystaldecisions.sdk.occa.security.internal._SessionBatchExProxy;
import com.crystaldecisions.sdk.occa.security.internal._SessionExProxy;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BooleanHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Object;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

class SecuritySession
implements ISecuritySession,
Externalizable,
ISupportObjectLocal {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.SecuritySession");
    private IManagedService m_handler;
    private SessionExOperations m_sessionStub;
    private ISecCacheController m_cache;
    private CacheController m_legacyCache;
    private IUserInfo m_userInfo;
    private int m_apsVersionInt = -1;
    private int m_apsMajorVersion = -1;
    private Map m_objectLocals = EmptyCollections.MAP;
    private boolean m_sessionLoggedOff;
    private int m_sessionFolderID;
    static final String SESSION_TOKEN_ID = "ONEOFF";
    private IProperties m_logonInfoBag;
    private int m_sessionlocale;
    private boolean m_noCache;
    private final String NOCACHE = "businessobjects.enterprise.securitysession.nocache";
    private static final String MAGIC_URI2 = "osca:iiop://;S2SDSCVRY=true";
    private static final ISimpleCache s_versionCache = new SimpleCache(new HashMap(), -1L);
    private static ISimpleCache.IRefreshHelper m_apsVersionHelper = new ISimpleCache.IRefreshHelper(){

        public boolean isCacheOutdated(java.lang.Object cached, java.lang.Object[] args) {
            return false;
        }

        public java.lang.Object refresh(java.lang.Object key, java.lang.Object[] args) throws SDKException {
            OSCAFactory ocaf;
            String apsVersion = "";
            ServerSpec spec = new ServerSpec((ServerSpec)key);
            IServiceMgr servMgr = ServiceMgrFactory.getServiceMgr();
            try {
                ocaf = servMgr.getOSCAFactory("", spec);
            }
            catch (OCAFrameworkException e) {
                throw SDKException.map(e);
            }
            try {
                apsVersion = ocaf.versionInfo();
            }
            catch (connection_failure connection_failure2) {
                try {
                    apsVersion = ocaf.getVersion();
                }
                catch (connection_failure connection_failure1) {
                    apsVersion = "8.5.0";
                }
            }
            return apsVersion;
        }
    };
    private static final int s_version = SecuritySession.findSDKVersion();
    private static final SecurityStubHelperFactory s_securityStubFactory = new SecurityStubHelperFactory();
    private static final char ENCODE_DELIMITER = '\t';
    private static final String UTF8 = "UTF8";
    private static final ISimpleCache s_noExpireClusterObjCache = new SimpleCache(new HashMap(), -1L);
    private static final ISimpleCache s_clusterObjCache = new SimpleCache(new HashMap(), 180000L);
    private static ISimpleCache.IRefreshHelper s_noExpireClusterObjHelper = new ISimpleCache.IRefreshHelper(){
        private static final String CMSOBJ_QUERY = "select si_guid from ci_systemobjects where si_id = 4";
        private final byte[] m_mask = new byte[]{65, 98, 120, 68, 107, 111, 119, 82, 66, 101, 90, 71, 111, 50, 48, 108, 105, 83, 108, 74, 113, 111, 48, 65, 98, 51, 122, 115, 112, 95, 49, 66, 105, 57, 66, 117, 108, 103, 82, 112, 49, 76, 118, 116, 51, 107};

        public boolean isCacheOutdated(java.lang.Object cached, java.lang.Object[] args) {
            return false;
        }

        public java.lang.Object refresh(java.lang.Object key, java.lang.Object[] args) throws SDKException {
            ISecuritySession logon = (ISecuritySession)args[0];
            Integer propID = (Integer)args[1];
            IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", logon);
            IInfoObjects objs = is.query(CMSOBJ_QUERY);
            if (objs.size() != 0) {
                String guid;
                IInfoObject obj = (IInfoObject)objs.get(0);
                PropertyBag props = ((PropertyBag)obj.properties()).copy();
                Property prop = (Property)props.get((java.lang.Object)propID);
                if (prop == null) {
                    throw new SDKException.PropertyNotFound(propID);
                }
                if (com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_GUID.equals(propID) && (guid = (String)prop.getValue()) != null) {
                    try {
                        byte[] desKeyData = guid.getBytes(SecuritySession.UTF8);
                        for (int i = 0; i < desKeyData.length; ++i) {
                            desKeyData[i] = (byte)(desKeyData[i] ^ this.m_mask[i % this.m_mask.length]);
                        }
                        prop.setValue((java.lang.Object)new String(desKeyData, SecuritySession.UTF8));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SDKException.Unexpected(e);
                    }
                }
                return props;
            }
            throw new SDKException.ObjectNotFound("AXNWWTizCNNBrOt2AVUPfyE");
        }
    };
    private static ISimpleCache.IRefreshHelper s_clusterObjHelper = new ISimpleCache.IRefreshHelper(){
        private static final String CMSOBJ_QUERY = "select si_system_info from ci_systemobjects where si_id = 4";

        public boolean isCacheOutdated(java.lang.Object cached, java.lang.Object[] args) {
            return false;
        }

        public java.lang.Object refresh(java.lang.Object key, java.lang.Object[] args) throws SDKException {
            ISecuritySession logon = (ISecuritySession)args[0];
            Integer propID = (Integer)args[1];
            IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", logon);
            IInfoObjects objs = is.query(CMSOBJ_QUERY);
            if (objs.size() != 0) {
                IInfoObject obj = (IInfoObject)objs.get(0);
                PropertyBag props = ((PropertyBag)obj.properties()).copy();
                Property prop = (Property)props.get((java.lang.Object)propID);
                if (prop == null) {
                    throw new SDKException.PropertyNotFound(propID);
                }
                if (com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SYSTEM_INFO.equals(propID) && !prop.isContainer()) {
                    throw new SDKException.PropertyNotFound(propID);
                }
                return props;
            }
            throw new SDKException.ObjectNotFound("AXNWWTizCNNBrOt2AVUPfyE");
        }
    };

    SecuritySession(String aps, String uri, String token, String cluster, IProperties logonInfoBag) throws SDKException {
        try {
            this.init(aps, uri, token, cluster, 0);
            this.m_logonInfoBag = logonInfoBag;
            this.m_sessionLoggedOff = false;
            this.m_sessionlocale = -1;
        }
        catch (OCAFrameworkException e) {
            throw SDKException.map(e);
        }
    }

    SecuritySession(String aps, String uri, String token, String cluster, IProperties logonInfoBag, int currSessionLocale) throws SDKException {
        try {
            this.init(aps, uri, token, cluster, 0);
            this.m_logonInfoBag = logonInfoBag;
            this.m_sessionLoggedOff = false;
            this.m_sessionlocale = currSessionLocale;
        }
        catch (OCAFrameworkException e) {
            throw SDKException.map(e);
        }
    }

    SecuritySession(String aps, String uri, String token, String cluster) throws SDKException {
        try {
            this.init(aps, uri, token, cluster, 0);
            this.m_sessionLoggedOff = false;
            this.m_sessionlocale = -1;
        }
        catch (OCAFrameworkException e) {
            throw SDKException.map(e);
        }
    }

    public SecuritySession() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getSessionID());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SessionParams sParams;
        String serializedSession = (String)in.readObject();
        try {
            sParams = SecuritySession.decodeSerializedSession(serializedSession);
        }
        catch (SDKException e) {
            throw new SDKException.Serialization(e);
        }
        this.m_sessionLoggedOff = sParams.sessionLogoff;
        if (this.m_sessionLoggedOff) {
            ServiceMgrFactory.getServiceMgr().logoffSession(sParams.uri, new ServerSpec(sParams.aps, "aps", sParams.aps, sParams.cluster));
            this.m_handler = new ExpiredSessionHandler(new ServerSpec(sParams.aps, "aps", sParams.aps, sParams.cluster), sParams.failOverToken, sParams.uri);
            this.m_sessionStub = new _SessionBatchExProxy(this.m_handler);
        } else {
            try {
                this.init(sParams.aps, sParams.uri, sParams.failOverToken, sParams.cluster, 0);
            }
            catch (OCAFrameworkException e) {
                throw new SDKException.Serialization(e);
            }
            catch (SDKException e) {
                throw new SDKException.Serialization(e);
            }
        }
        this.m_logonInfoBag = (IProperties)sParams.logonBag;
    }

    public String getAPSName() {
        return this.m_handler.getAPS();
    }

    public int getAPSVersion() throws SDKException {
        return this.getAPSVersion(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAPSVersion(boolean majorOnly) throws SDKException {
        SecuritySession securitySession = this;
        synchronized (securitySession) {
            if (majorOnly && this.m_apsMajorVersion != -1) {
                return this.m_apsMajorVersion;
            }
            if (!majorOnly && this.m_apsVersionInt != -1) {
                return this.m_apsVersionInt;
            }
        }
        String strVer = this.getAPSVersionString();
        int index = -1;
        int major = -1;
        int minor = -1;
        int build = -1;
        LOG.assertTrue(strVer.length() > 0, "getAPSVersion(): getVersionString should return something");
        index = strVer.indexOf(46);
        if (index == -1) {
            major = Integer.parseInt(strVer);
        } else {
            major = Integer.parseInt(strVer.substring(0, index));
            strVer = strVer.substring(index + 1);
        }
        if (strVer.length() > 0) {
            index = strVer.indexOf(46);
            if (index == -1) {
                minor = Integer.parseInt(strVer);
            } else {
                minor = Integer.parseInt(strVer.substring(0, index));
                strVer = strVer.substring(index + 1);
            }
        } else {
            minor = 0;
        }
        build = strVer.length() > 0 ? ((index = strVer.indexOf(46)) == -1 ? Integer.parseInt(strVer) : Integer.parseInt(strVer.substring(0, index))) : 0;
        SecuritySession securitySession2 = this;
        synchronized (securitySession2) {
            if (this.m_apsMajorVersion == -1) {
                this.m_apsMajorVersion = major * 100;
            }
            if (this.m_apsVersionInt == -1) {
                this.m_apsVersionInt = major * 100 + minor * 10 + build;
            }
        }
        if (majorOnly) {
            return this.m_apsMajorVersion;
        }
        return this.m_apsVersionInt;
    }

    public String getAPSVersionString() throws SDKException {
        ServerSpec spec = new ServerSpec("", "aps", this.m_handler.getAPS(), this.m_handler.getSvr().getCluster());
        try {
            return (String)s_versionCache.get((java.lang.Object)spec, null, m_apsVersionHelper);
        }
        catch (ISimpleCache.RefreshException e) {
            throw (SDKException)((java.lang.Object)e.getReason());
        }
    }

    public String getClusterName() {
        return this.m_handler.getSvr().getCluster();
    }

    public IRights getRights() throws SDKException {
        this.ensureLegacyCacheController();
        return this.m_legacyCache;
    }

    public IRightsAdmin getRightsAdmin() throws SDKException {
        this.ensureLegacyCacheController();
        return this.m_legacyCache;
    }

    public ILogonTokenMgr getLogonTokenMgr() throws SDKException {
        return SecurityFactory.getFactory().makeLogonTokenMgr(this.m_handler);
    }

    public ICacheController getSecCache() throws SDKException {
        this.ensureLegacyCacheController();
        return this.m_legacyCache;
    }

    public ICacheControllerAdmin getSecCacheAdmin() throws SDKException {
        this.ensureLegacyCacheController();
        return this.m_legacyCache;
    }

    public IUserInfo getUserInfo() throws SDKException {
        this.ensureUserInfo();
        return this.m_userInfo;
    }

    public String getUserURI() {
        return this.m_handler.getURI();
    }

    public String getLogonToken() {
        return this.m_handler.getToken();
    }

    public String getSessionToken() {
        return this.getLogonToken() + SESSION_TOKEN_ID;
    }

    public boolean isServerLogonSession() {
        return false;
    }

    public synchronized boolean isSessionLoggedOff() {
        return this.m_sessionLoggedOff;
    }

    public synchronized boolean isSessionExpired() {
        return ServiceMgrFactory.getServiceMgr().isSessionExpired(this.m_handler.getURI(), this.m_handler.getSvr());
    }

    public void expire() {
        ServiceMgrFactory.getServiceMgr().expireSession(this.m_handler.getURI(), this.m_handler.getSvr());
    }

    public synchronized void logoff() {
        try {
            if (!this.m_sessionLoggedOff) {
                this.m_sessionStub.UserLogoff();
                ServiceMgrFactory.getServiceMgr().logoffSession(this.m_handler.getURI(), this.m_handler.getSvr());
                this.m_sessionLoggedOff = true;
            }
        }
        catch (oca_abuse oca_abuse2) {
            // empty catch block
        }
    }

    public synchronized int getSessionFolderID() {
        return this.m_sessionFolderID;
    }

    public synchronized void setSessionFolderID(int folderID) {
        this.m_sessionFolderID = folderID;
    }

    public String toString() {
        return "(SecuritySession:userInfo=" + this.m_userInfo + ",apsName=" + this.getAPSName() + ",userURI=" + this.getUserURI();
    }

    public ISecurityInfoMgr getSecurityInfoMgr() throws SDKException {
        return SecurityFactory.getFactory().makeSecurityInfoManager(this);
    }

    public ISecRights getRightsEx() throws SDKException {
        this.ensureCacheController();
        return (ISecRights)((java.lang.Object)this.m_cache);
    }

    public ISecRightsAdmin getRightsAdminEx() throws SDKException {
        this.ensureCacheController();
        return (ISecRightsAdmin)((java.lang.Object)this.m_cache);
    }

    public ISecCacheController getSecCacheEx() throws SDKException {
        this.ensureCacheController();
        return this.m_cache;
    }

    public ISecCacheControllerAdmin getSecCacheAdminEx() throws SDKException {
        this.ensureCacheController();
        return (ISecCacheControllerAdmin)((java.lang.Object)this.m_cache);
    }

    private void init(String aps, String uri, String token, String cluster, int tempFolderID) throws OCAFrameworkException, SDKException {
        this.m_handler = ServiceMgrFactory.getServiceMgr().getManagedService("NO_ID", "Session", new ServerSpec(aps, "aps", aps, cluster), uri, token, s_securityStubFactory);
        this.m_sessionStub = new _SessionExProxy(this.m_handler);
        this.m_sessionFolderID = tempFolderID;
        Properties props = System.getProperties();
        String turnCacheOff = props.getProperty("businessobjects.enterprise.securitysession.nocache");
        this.m_noCache = turnCacheOff != null;
        LOG.info((java.lang.Object)("no cache?" + this.m_noCache));
    }

    private synchronized void ensureCacheController() throws SDKException {
        if (this.m_cache == null) {
            this.m_cache = SecurityFactory.getFactory().makeCacheController(this.m_handler, this, !this.m_noCache);
        }
    }

    private synchronized void ensureUserInfo() throws SDKException {
        if (this.m_noCache) {
            this.m_userInfo = SecurityFactory.getFactory().makeUserInfo(this.m_handler, null);
        } else if (this.m_userInfo == null) {
            this.m_userInfo = SecurityFactory.getFactory().makeUserInfo(this.m_handler, this.m_logonInfoBag);
        }
    }

    public Map getObjectLocals() {
        return this.m_objectLocals;
    }

    public void setObjectLocals(Map sessionLocals) {
        this.m_objectLocals = sessionLocals;
    }

    public int getSDKVersion() {
        return s_version;
    }

    public boolean isUserDefaultLocale() throws SDKException {
        return this.m_sessionlocale == -1 || this.m_sessionlocale == LocaleConversion.ceLocaleUserDefault;
    }

    public void setUserDefaultLocale() throws SDKException {
        this.m_sessionlocale = LocaleConversion.ceLocaleUserDefault;
    }

    public Locale getLocale() throws SDKException {
        if (this.isUserDefaultLocale()) {
            throw new SDKException.PropertyNotFound(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_LOCALE);
        }
        return LocaleConversion.convertToLocale((int)this.m_sessionlocale);
    }

    public void setLocale(Locale value) throws SDKException {
        int localeInt = LocaleConversion.convertToID((Locale)value);
        if (localeInt == -1) {
            throw new SDKException.InvalidArg(value.toString());
        }
        this.m_sessionlocale = localeInt;
    }

    public Locale getEffectivePreferredViewingLocale() throws SDKException {
        Locale effectivePVL;
        try {
            effectivePVL = this.getUserInfo().getPreferredViewingLocale();
        }
        catch (SDKException.PropertyNotFound e) {
            if (this.isUserDefaultLocale()) {
                throw new SDKException.InvalidLocale();
            }
            effectivePVL = this.getLocale();
        }
        return effectivePVL;
    }

    private static int findSDKVersion() {
        String versionStr = System.getProperty("bobj.sdk.version");
        if (versionStr == null) {
            return 1200;
        }
        return Integer.parseInt(versionStr);
    }

    protected PropertyBag createSerializationBag() {
        PropertyBag collaterals;
        if (this.m_logonInfoBag != null) {
            collaterals = ((PropertyBag)this.m_logonInfoBag).copy();
            if (this.m_userInfo != null) {
                UserInfo userInfo = (UserInfo)this.m_userInfo;
                userInfo.updateLogonInfoBag(collaterals);
            }
        } else {
            collaterals = new PropertyBag();
        }
        OcaURI ocaURI = null;
        try {
            ocaURI = new OcaURI(this.getUserURI());
        }
        catch (SILibException e) {
            LOG.warn((java.lang.Object)("(createSerializationBag:731): format error, uri=" + this.getUserURI()), (Throwable)e);
            throw new AssertionError((java.lang.Object)e);
        }
        String sessionID = ocaURI.getProperties().getString((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SESSIONID);
        collaterals.addItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SESSIONID, (java.lang.Object)sessionID, 0);
        collaterals.addItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_APS_NAME, (java.lang.Object)this.getAPSName(), 0);
        String token = this.getLogonToken().substring(this.getLogonToken().indexOf("@") + 1);
        collaterals.addItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_FAILOVER_TOKEN, (java.lang.Object)token, 0);
        collaterals.addItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_CLUSTER_NAME, (java.lang.Object)this.getClusterName(), 0);
        try {
            if (this.m_sessionlocale != -1) {
                int localeID = LocaleConversion.ceLocaleUserDefault;
                if (this.m_sessionlocale != LocaleConversion.ceLocaleUserDefault) {
                    Locale currLocale = this.getLocale();
                    localeID = LocaleConversion.convertToID((Locale)currLocale);
                }
                collaterals.addItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SDK_SESSION_LOCALE, (java.lang.Object)new Integer(localeID), 0);
            }
        }
        catch (SDKException e) {
            // empty catch block
        }
        if (this.m_sessionLoggedOff) {
            collaterals.addItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SESSION_USER, (java.lang.Object)Boolean.TRUE, 0);
        }
        return collaterals;
    }

    public String getSessionID() {
        PropertyBag serialBag = this.createSerializationBag();
        WireOb3Packer packer = new WireOb3Packer();
        return packer.pack(serialBag, 0, 0, true);
    }

    private static SessionParams decodeSerializedSession(String serializedSession) throws SDKException {
        if (serializedSession == null || serializedSession.length() == 0) {
            throw new SDKException.InvalidArg(serializedSession);
        }
        SDKPropertyBag serializeBag = new SDKPropertyBag();
        WireOb3Unpacker unpacker = new WireOb3Unpacker();
        unpacker.initialize(serializedSession);
        try {
            serializeBag.unpack(unpacker);
        }
        catch (Exception e) {
            throw new SDKException.InvalidArg(serializedSession);
        }
        SessionParams sParams = new SessionParams();
        Property sessionLocaleIDProp = serializeBag.getItem(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SDK_SESSION_LOCALE);
        sParams.sessionlocaleID = sessionLocaleIDProp == null ? -1 : sessionLocaleIDProp.getInt();
        serializeBag.removeLocal(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SDK_SESSION_LOCALE);
        sParams.logonBag = serializeBag;
        Property cmsProp = serializeBag.getItem(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_APS_NAME);
        if (cmsProp == null) {
            throw new SDKException.PropertyNotFound("SI_APS_NAME");
        }
        sParams.aps = cmsProp.getString();
        Property tokenProp = serializeBag.getItem(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_FAILOVER_TOKEN);
        if (tokenProp == null) {
            throw new SDKException.PropertyNotFound("SI_FAILOVER_TOKEN");
        }
        sParams.failOverToken = sParams.aps + "@" + tokenProp.getString();
        Property uriProp = serializeBag.getItem(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SESSIONID);
        if (uriProp == null) {
            throw new SDKException.PropertyNotFound("SESSIONID");
        }
        sParams.uri = uriProp.getString();
        OcaURI fullURI = new OcaURI(sParams.aps, com.crystaldecisions.sdk.properties.internal.PropertyIDs.SESSIONID, sParams.uri);
        sParams.uri = fullURI.toString();
        Property clusterProp = serializeBag.getItem(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_CLUSTER_NAME);
        if (clusterProp == null) {
            throw new SDKException.PropertyNotFound("SI_CLUSTER_NAME");
        }
        sParams.cluster = clusterProp.getString();
        Property loggedOffProp = serializeBag.getItem(com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SESSION_USER);
        sParams.sessionLogoff = loggedOffProp != null && loggedOffProp.getBoolean();
        return sParams;
    }

    public static ISecuritySession makeSession(String serializedSession) throws SDKException {
        SessionParams sParams = SecuritySession.decodeSerializedSession(serializedSession);
        Property serverLogonProp = sParams.logonBag.getItem((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SERVER_LOGON_SESSION);
        if (serverLogonProp == null || !serverLogonProp.getBoolean()) {
            return new SecuritySession(sParams.aps, sParams.uri, sParams.failOverToken, sParams.cluster, (IProperties)sParams.logonBag, sParams.sessionlocaleID);
        }
        sParams.uri = sParams.uri.concat(",SI_SERVER_LOGON_SESSION=1");
        return new ServerLogonSession(sParams.aps, sParams.uri, sParams.failOverToken, sParams.cluster, (IProperties)sParams.logonBag, sParams.sessionlocaleID);
    }

    private synchronized void ensureLegacyCacheController() throws SDKException {
        if (this.m_legacyCache == null || this.m_noCache) {
            this.m_legacyCache = new CacheController(this.m_handler);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Map getExecutionInfo() throws SDKException {
        block23: {
            block22: {
                block19: {
                    block20: {
                        stub = null;
                        obj = ServiceMgrFactory.getServiceMgr().getUnmanagedService("InfoStore", this.m_handler.getSvr(), "osca:iiop://;S2SDSCVRY=true");
                        if (obj != null) break block19;
                        var3_4 = new HashMap<K, V>();
                        var14_6 = null;
                        if (stub == null) break block20;
                        try {
                            stub.free();
                        }
                        catch (SystemException e) {
                            SecuritySession.LOG.warn((java.lang.Object)"find(): failed to release resource", (Throwable)e);
                        }
                    }
                    return var3_4;
                }
                stub = InfoStoreEx3Helper.narrow((Object)obj);
                SecuritySession.LOG.assertNotNull((java.lang.Object)stub, "stub is null.");
                out = new InfoWireObjects3Holder();
                itrHolder = new InfoObjectWireIteratorEx3Holder();
                props = null;
                try {
                    block21: {
                        query = "select si_cuid, si_placeholders from ci_systemobjects where si_kind = 'EnterpriseNode'";
                        stub.queryEx3(1200, 0, query.toString(), out, itrHolder);
                        objects = out.value;
                        if (objects.length == 0) break block21;
                        itr = itrHolder.value;
                        props = new ArrayList<E>();
                        unpacker = new WireOb3Unpacker();
                        this.unpackToBag(objects, unpacker, props);
                        if (itr == null) break block21;
                        moreData = new BooleanHolder();
                        do {
                            itr.getNextBatchEx3(1200, out, moreData);
                            this.unpackToBag(objects, unpacker, props);
                        } while (moreData.value);
                    }
                    var12_20 = null;
                    ** if (itrHolder.value == null) goto lbl-1000
                }
                catch (Throwable var11_22) {
                    var12_21 = null;
                    if (itrHolder.value != null) {
                        itrHolder.value.free();
                    }
                    throw var11_22;
                }
lbl-1000:
                // 1 sources

                {
                    itrHolder.value.free();
                }
lbl-1000:
                // 2 sources

                {
                    break block22;
                    catch (oca_abuse abuse) {
                        SecuritySession.LOG.warn((java.lang.Object)"SecuritySession.getExecutionInfo(): server error", (Throwable)abuse);
                        throw SDKException.map(abuse);
                    }
                }
            }
            if (props == null || props.size() == 0) {
                throw new SDKException.ObjectNotFound("EnterpriseNode");
            }
            ret = new HashMap<String, NameValuePairs>(props.size());
            iter = props.iterator();
            while (iter.hasNext()) {
                node = (PropertyBag)iter.next();
                cuid = node.getString((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_CUID);
                bag = node.getPropertyBag((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_PLACEHOLDERS);
                placeholders = null;
                if (bag != null) {
                    placeholders = new NameValuePairs(bag);
                }
                ret.put(cuid, placeholders);
            }
            var7_16 = ret;
            var14_7 = null;
            if (stub == null) break block23;
            try {
                stub.free();
            }
            catch (SystemException e) {
                SecuritySession.LOG.warn((java.lang.Object)"find(): failed to release resource", (Throwable)e);
            }
        }
        return var7_16;
        catch (OCAFrameworkException e) {
            try {
                throw SDKException.map(e);
            }
            catch (Throwable var13_24) {
                block24: {
                    var14_8 = null;
                    if (stub == null) break block24;
                    try {
                        stub.free();
                    }
                    catch (SystemException e) {
                        SecuritySession.LOG.warn((java.lang.Object)"find(): failed to release resource", (Throwable)e);
                    }
                }
                throw var13_24;
            }
        }
    }

    private void unpackToBag(info_wire_ob3[] objects, IBagUnpacker unpacker, List props) {
        for (int i = 0; i < objects.length; ++i) {
            info_wire_ob3 object = objects[i];
            if (object.uid == 0) continue;
            SDKPropertyBag newBag = new SDKPropertyBag();
            unpacker.initialize((java.lang.Object)object.propBag);
            newBag.unpack(unpacker);
            newBag.setProperty(PropertyIDs.SI_NAME, object.name);
            newBag.setProperty(PropertyIDs.SI_ID, new Integer(object.uid));
            props.add(newBag);
        }
    }

    private byte[] getSecretKey() throws SDKException {
        try {
            String guid;
            PropertyBag props = (PropertyBag)s_noExpireClusterObjCache.get((java.lang.Object)this.getClusterName(), new java.lang.Object[]{this, com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_GUID}, s_noExpireClusterObjHelper);
            if (props != null && (guid = props.getString((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_GUID)) != null) {
                return guid.getBytes(UTF8);
            }
            throw new SDKException.Unexpected();
        }
        catch (ISimpleCache.RefreshException e) {
            throw (SDKException)((java.lang.Object)e.getReason());
        }
        catch (UnsupportedEncodingException e) {
            throw new SDKException.Unexpected(e);
        }
    }

    public String getTrustedToken(String[] inputStrings, String timestamp) throws SDKException {
        if (inputStrings == null || timestamp == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((java.lang.Object)"SecuritySession.getTrustedToken: null input");
            }
            throw new SDKException.InvalidArg();
        }
        int capacity = 0;
        for (int i = 0; i < inputStrings.length; ++i) {
            capacity += inputStrings[i].length();
        }
        capacity += timestamp.length();
        String userCUID = ((UserInfo)this.getUserInfo()).getUserCUID(this);
        capacity += userCUID.length();
        capacity = capacity * 2 + inputStrings.length + 2;
        char[] buff = new char[capacity];
        int endIndex = 0;
        for (int i = 0; inputStrings != null && i < inputStrings.length; ++i) {
            endIndex = SecuritySession.encode(inputStrings[i], buff, endIndex);
            buff[endIndex++] = 9;
        }
        buff[endIndex++] = 9;
        endIndex = SecuritySession.encode(timestamp, buff, endIndex);
        buff[endIndex++] = 9;
        endIndex = SecuritySession.encode(userCUID, buff, endIndex);
        try {
            String input = new String(buff, 0, endIndex);
            return HMACGenerator.hmac((String)input, (byte[])this.getSecretKey());
        }
        catch (Exception e) {
            throw new SDKException.EncryptionError(e);
        }
    }

    static int encode(String value, char[] out, int nextIndex) {
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                char nextChar = value.charAt(i);
                if (nextChar == '\t') {
                    out[nextIndex++] = 92;
                }
                out[nextIndex++] = nextChar;
            }
        }
        return nextIndex;
    }

    public IProperties getSystemInfoProperties() throws SDKException {
        try {
            IProperties ret;
            PropertyBag props = (PropertyBag)s_clusterObjCache.get((java.lang.Object)this.getClusterName(), new java.lang.Object[]{this, com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SYSTEM_INFO}, s_clusterObjHelper);
            if (props != null && (ret = (IProperties)props.getPropertyBag((java.lang.Object)com.crystaldecisions.sdk.properties.internal.PropertyIDs.SI_SYSTEM_INFO)) != null) {
                return ret;
            }
            throw new SDKException.Unexpected();
        }
        catch (ISimpleCache.RefreshException e) {
            throw (SDKException)((java.lang.Object)e.getReason());
        }
    }

    private static class SecurityStubHelperFactory
    implements IManagedService.IHelperFactory {
        private final SecurityStubHelper m_securityStubHelper = new SecurityStubHelper();

        private SecurityStubHelperFactory() {
        }

        public IManagedService.IStubHelper makeHelper() {
            return this.m_securityStubHelper;
        }
    }

    private static class SecurityStubHelper
    extends AbstractStubHelper {
        private SecurityStubHelper() {
        }

        public java.lang.Object narrow(Object object) {
            return SessionBatchExHelper.narrow((Object)object);
        }

        public void release(java.lang.Object object) {
            ((SessionBatchExOperations)object).free();
        }
    }

    private static class ExpiredSessionHandler
    implements IManagedService {
        private ServerSpec m_spec;
        private String m_token;
        private String m_uri;

        public ExpiredSessionHandler(ServerSpec spec, String token, String uri) {
            this.m_spec = spec;
            this.m_token = token;
            this.m_uri = uri;
        }

        public String getAPS() {
            return this.m_spec.getAPS();
        }

        public IManagedService.IStubHelper getHelper() {
            return null;
        }

        public String getID() {
            return "";
        }

        public String getSvc() {
            return "Session";
        }

        public ServerSpec getSvr() {
            return this.m_spec;
        }

        public String getToken() {
            return this.m_token;
        }

        public String getURI() {
            return this.m_uri;
        }

        public boolean isDead() {
            return true;
        }

        public String getCookie() {
            return null;
        }

        public void setCookie(String cookie) {
        }

        public void setID(String id) {
        }

        public java.lang.Object invoke(Method method, java.lang.Object[] args, Map context) throws Exception {
            throw new IManagedService.ManagedLogoffException(new OCAFrameworkException.LogonFailover(this.getAPS(), null));
        }

        public void terminate(Exception e) {
        }
    }
}

