/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginInfo;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.internal.SecurityIDs;

public class SecurityValidator {
    private static final Integer SYSTEM_RIGHT_TYPE = new Integer(0);

    public static int getRealRightID(IPluginMgr pluginMgr, int id, Object kind, boolean isOwner) throws SDKException {
        if (SecurityValidator.isEmptyType(kind)) {
            if (isOwner) {
                return id | 0x20000000;
            }
            return id;
        }
        IPluginInfo pi = SecurityValidator.validatePluginThrow(pluginMgr, kind);
        int realID = SecurityIDs.getAuthenticRightID(id, pi.getType());
        if (isOwner) {
            realID |= 0x20000000;
        }
        return realID;
    }

    public static String getRealKind(IPluginMgr pluginMgr, Object kind) throws SDKException {
        if (SecurityValidator.isEmptyType(kind)) {
            return "";
        }
        IPluginInfo pi = SecurityValidator.validatePluginThrow(pluginMgr, kind);
        return pi.getKind();
    }

    public static short getRightTypeID(IPluginMgr pluginMgr, Object kind) throws SDKException {
        if (SecurityValidator.isEmptyType(kind)) {
            return 0;
        }
        IPluginInfo pi = SecurityValidator.validatePluginThrow(pluginMgr, kind);
        return pi.getType();
    }

    public static boolean isEmptyType(Object kind) {
        return kind == null || kind.equals("") || kind.equals(SYSTEM_RIGHT_TYPE);
    }

    public static String getRealProgID(IPluginMgr pluginMgr, Object progID) throws SDKException {
        if (SecurityValidator.isEmptyType(progID)) {
            return "";
        }
        IPluginInfo pi = SecurityValidator.validatePluginThrow(pluginMgr, progID);
        return pi.getProgID();
    }

    public static IPluginInfo validatePluginThrow(IPluginMgr pluginMgr, Object kind) throws SDKException {
        IPluginInfo pi = pluginMgr.getPluginInfo(kind);
        if (pi == null) {
            throw new SDKException.PluginNotFound(kind.toString());
        }
        return pi;
    }

    public static String validateScope(String scope) throws SDKException.InvalidArg {
        if (scope == null || scope.equals("")) {
            return "";
        }
        if (!"this".equalsIgnoreCase(scope) && !"descendants".equalsIgnoreCase(scope)) {
            throw new SDKException.InvalidArg(scope);
        }
        return scope;
    }
}

