/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.LocaleConversion;
import com.crystaldecisions.celib.conversion.TimeZoneConversion;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAs.Session;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal._SessionExProxy;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.thirdparty.org.omg.CORBA.IntHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

class UserInfo
implements IUserInfo {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.UserInfo");
    private IManagedService m_handler;
    private Session m_sessionStub;
    private String m_userName;
    private String m_userDesc;
    private int m_userID;
    private String m_userCUID = "";
    private String m_auth;
    static final int UNDEF = -1;
    static final String UNDEF_STR = "";
    private int m_passwordExpiry = Integer.MIN_VALUE;
    private int m_locale = -1;
    private String m_pvlocale = "";
    private int m_timezone = -1;
    private Map m_userCollateralIDs = Collections.EMPTY_MAP;
    private static final String LOCALE_ID = PropertyIDs.idToName(PropertyIDs.SI_LOCALE);
    private static final String PVLOCALE_ID = PropertyIDs.idToName(PropertyIDs.DOCUMENT_WIUserContentLocale);
    private static final String SECOND_CRED_PREFIX = "__CE2CRED_";

    public UserInfo(IManagedService handler, IProperties loginInfoBag) throws SDKException {
        this.m_handler = handler;
        this.m_sessionStub = new _SessionExProxy(this.m_handler);
        this.loadUserInfo(loginInfoBag);
    }

    public String getAuthenMethod() throws SDKException {
        return this.m_auth;
    }

    public synchronized long getPasswordExpiry() throws SDKException {
        if (this.m_passwordExpiry == Integer.MIN_VALUE) {
            try {
                IntHolder ip1 = new IntHolder();
                int status = this.m_sessionStub.GetPasswordExpiry(ip1);
                LOG.assertTrue(status == 0, "Assertion failed");
                this.m_passwordExpiry = ip1.value;
            }
            catch (oca_abuse e) {
                throw SDKException.map(e);
            }
        }
        return this.m_passwordExpiry;
    }

    public void setPassword(String oldPassword, String newPassword) throws SDKException {
        try {
            int status = this.m_sessionStub.ChangePassword(oldPassword, newPassword);
            LOG.assertTrue(status == 0, "Assertion failed");
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    public String getProfileString(String name) throws SDKException {
        try {
            StringHolder p1 = new StringHolder();
            int status = this.m_sessionStub.GetSecondaryCredential(name, p1);
            LOG.assertTrue(status == 0, "Assertion failed");
            return p1.value;
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    public void setProfileString(String name, String value) throws SDKException {
        try {
            int status = this.m_sessionStub.SetSecondaryCredential(name, value);
            LOG.assertTrue(status == 0, "Assertion failed");
        }
        catch (oca_abuse e) {
            throw SDKException.map(e);
        }
    }

    public String getSecondaryCredential(String name) throws SDKException {
        return this.getProfileString(name);
    }

    public void setSecondaryCredential(String name, String value) throws SDKException {
        this.setProfileString(name, value);
    }

    public String getSecondaryCredentialEx(String name) throws SDKException {
        String prefixName = SECOND_CRED_PREFIX + name;
        return this.getProfileString(prefixName);
    }

    public void setSecondaryCredentialEx(String name, String value) throws SDKException {
        String prefixName = SECOND_CRED_PREFIX + name;
        this.setProfileString(prefixName, value);
    }

    public String getUserDesc() throws SDKException {
        return this.m_userDesc;
    }

    public int getUserID() throws SDKException {
        return this.m_userID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUserCUID(ISecuritySession logon) throws SDKException {
        if (UNDEF_STR.equals(this.m_userCUID)) {
            String string = this.m_userCUID;
            synchronized (string) {
                if (UNDEF_STR.equals(this.m_userCUID)) {
                    String query;
                    IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA(UNDEF_STR, logon);
                    IInfoObjects objs = is.query(query = "select si_cuid from ci_systemobjects where si_id = " + this.getUserID());
                    if (objs.size() != 0) {
                        IInfoObject obj = (IInfoObject)objs.get(0);
                        this.m_userCUID = obj.getCUID();
                    } else {
                        throw new SDKException.ObjectNotFound(Integer.toString(this.getUserID()));
                    }
                }
            }
        }
        return this.m_userCUID;
    }

    public String getUserName() throws SDKException {
        return this.m_userName;
    }

    public synchronized boolean isUserDefaultLocale() throws SDKException {
        if (this.m_locale == -1) {
            String localeStr = this.getProfileString(LOCALE_ID);
            this.m_locale = null == localeStr || 0 == localeStr.length() ? LocaleConversion.ceLocaleUserDefault : Integer.parseInt(localeStr);
        }
        return this.m_locale == LocaleConversion.ceLocaleUserDefault;
    }

    public synchronized void setUserDefaultLocale() throws SDKException {
        this.m_locale = LocaleConversion.ceLocaleUserDefault;
        this.setProfileString(LOCALE_ID, LocaleConversion.ceLocaleUserDefault.toString());
    }

    public synchronized Locale getLocale() throws SDKException {
        if (this.isUserDefaultLocale()) {
            throw new SDKException.PropertyNotFound(LOCALE_ID);
        }
        return LocaleConversion.convertToLocale((int)this.m_locale);
    }

    public synchronized void setLocale(Locale value) throws SDKException {
        int localeInt = LocaleConversion.convertToID((Locale)value);
        if (localeInt == -1) {
            throw new SDKException.InvalidArg(value.toString());
        }
        this.m_locale = localeInt;
        this.setProfileString(LOCALE_ID, new Integer(localeInt).toString());
    }

    public Locale getPreferredViewingLocale() throws SDKException {
        if (this.m_pvlocale == UNDEF_STR) {
            String localeStr = this.getProfileString(PVLOCALE_ID);
            if (null == localeStr || 0 == localeStr.length()) {
                throw new SDKException.PropertyNotFound(PVLOCALE_ID);
            }
            this.m_pvlocale = localeStr;
        }
        Locale _locale = LocaleConversion.convertStringToLocale((String)this.m_pvlocale);
        return _locale;
    }

    public synchronized void setPreferredViewingLocale(Locale value) throws SDKException {
        int localeInt = LocaleConversion.convertToID((Locale)value);
        if (localeInt == -1) {
            throw new SDKException.InvalidArg(value.toString());
        }
        this.m_pvlocale = value.toString();
        this.setProfileString(PVLOCALE_ID, this.m_pvlocale);
    }

    public void removePreferredViewingLocale() throws SDKException {
        this.m_pvlocale = UNDEF_STR;
        this.setProfileString(PVLOCALE_ID, UNDEF_STR);
    }

    public synchronized TimeZone getTimeZone() throws SDKException {
        if (this.m_timezone == -1) {
            String timezoneStr = this.getProfileString(PropertyIDs.idToName(PropertyIDs.SI_TIMEZONE));
            if (null == timezoneStr || 0 == timezoneStr.length()) {
                this.m_timezone = 0;
            } else {
                try {
                    this.m_timezone = Integer.parseInt(timezoneStr);
                }
                catch (NumberFormatException e) {
                    throw new SDKException.UnexpectedValue(PropertyIDs.SI_TIMEZONE, (Object)timezoneStr);
                }
            }
        }
        return TimeZoneConversion.convertToTimeZone((int)this.m_timezone);
    }

    public synchronized void setTimeZone(TimeZone value) throws SDKException {
        int timeZoneInt;
        this.m_timezone = timeZoneInt = TimeZoneConversion.convertToID((TimeZone)value);
        this.setProfileString(PropertyIDs.idToName(PropertyIDs.SI_TIMEZONE), new Integer(timeZoneInt).toString());
    }

    public int getPersonalObjectID(String kind) throws SDKException {
        Integer id = (Integer)this.m_userCollateralIDs.get(kind);
        if (id == null) {
            throw new SDKException.InvalidArg(kind);
        }
        return id;
    }

    protected void loadUserInfo(IProperties loginInfoBag) throws SDKException {
        boolean needUserInfoQuery = false;
        if (loginInfoBag != null) {
            Object locale;
            Object passwordExpiry;
            Object authMethod;
            Object userID;
            Object userDesc;
            needUserInfoQuery = true;
            Object userName = this.getValue(loginInfoBag, PropertyIDs.SI_USERNAME);
            if (userName != null) {
                this.m_userName = (String)userName;
                needUserInfoQuery = false;
            }
            if ((userDesc = this.getValue(loginInfoBag, PropertyIDs.SI_DESCRIPTION)) != null) {
                this.m_userDesc = (String)userDesc;
                needUserInfoQuery = false;
            }
            if ((userID = this.getValue(loginInfoBag, PropertyIDs.SI_USERID)) != null) {
                this.m_userID = Integer.parseInt((String)userID);
                needUserInfoQuery = false;
            }
            if ((authMethod = this.getValue(loginInfoBag, PropertyIDs.SI_AUTHEN_METHOD)) != null) {
                this.m_auth = (String)authMethod;
                needUserInfoQuery = false;
            }
            if ((passwordExpiry = this.getValue(loginInfoBag, PropertyIDs.SI_PASSWORD_EXPIRY)) != null) {
                this.m_passwordExpiry = (Integer)passwordExpiry;
            }
            this.m_locale = (locale = this.getValue(loginInfoBag, PropertyIDs.SI_LOCALE)) != null ? ((Integer)locale).intValue() : LocaleConversion.ceLocaleUserDefault.intValue();
            Object pvlocale = this.getValue(loginInfoBag, PropertyIDs.DOCUMENT_WIUserContentLocale);
            this.m_pvlocale = pvlocale != null ? (pvlocale.equals(UNDEF_STR) ? UNDEF_STR : (String)pvlocale) : UNDEF_STR;
            Object timezone = this.getValue(loginInfoBag, PropertyIDs.SI_TIMEZONE);
            this.m_timezone = timezone != null ? (Integer)timezone : 0;
            Object collateralIDs = this.getValue(loginInfoBag, PropertyIDs.SI_COLLATERAL_IDS);
            if (collateralIDs != null) {
                PropertyArrayHelper helper = new PropertyArrayHelper((PropertyBag)collateralIDs, PropertyIDs.SI_TOTAL);
                Iterator iter = helper.iterator();
                this.m_userCollateralIDs = new HashMap(helper.size());
                while (iter.hasNext()) {
                    PropertyBag bag = (PropertyBag)iter.next();
                    this.m_userCollateralIDs.put(bag.getString((Object)PropertyIDs.SI_KIND), bag.getItem((Object)PropertyIDs.SI_ID).getValue());
                }
            }
        } else {
            needUserInfoQuery = true;
        }
        if (needUserInfoQuery) {
            try {
                StringHolder sp1 = new StringHolder();
                StringHolder sp2 = new StringHolder();
                StringHolder sp3 = new StringHolder();
                StringHolder sp4 = new StringHolder();
                int status = this.m_sessionStub.GetUserInfo(sp1, sp2, sp3, sp4);
                LOG.assertTrue(status == 0, "Assertion failed");
                this.m_userName = sp1.value;
                this.m_userDesc = sp2.value;
                this.m_userID = Integer.decode(sp3.value.substring(1));
                this.m_auth = sp4.value;
            }
            catch (oca_abuse e) {
                throw SDKException.map(e);
            }
        }
    }

    private Object getValue(IProperties bag, Integer id) {
        IProperty prop = bag.getProperty(id);
        return prop == null ? null : prop.getValue();
    }

    public String toString() {
        return "(UserInfo: username=" + this.m_userName + ",userID=" + this.m_userID + ",userDesc=" + this.m_userDesc + ",auth=" + this.m_auth + ")";
    }

    public void updateLogonInfoBag(PropertyBag logonBag) {
        if (logonBag == null) {
            return;
        }
        logonBag.addItem((Object)PropertyIDs.SI_LOCALE, (Object)new Integer(this.m_locale), 0);
        logonBag.addItem((Object)PropertyIDs.DOCUMENT_WIUserContentLocale, (Object)this.m_pvlocale, 0);
        logonBag.addItem((Object)PropertyIDs.SI_TIMEZONE, (Object)new Integer(this.m_timezone), 0);
    }
}

