/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.security.internal.serializer;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityCommandFactory;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityType;
import com.crystaldecisions.sdk.occa.security.internal.serializer.SerializableCommand;
import java.io.EOFException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class SecurityDeserializer {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.security.internal.serializer.SecurityDeserializer");
    private byte[] m_bytes;
    private int m_pos;

    public SecurityDeserializer(byte[] in) {
        this.m_bytes = in;
        this.m_pos = 0;
    }

    public int readInt() throws EOFException {
        int out = 0;
        if (this.m_pos + 4 > this.m_bytes.length) {
            throw new EOFException();
        }
        int next = this.m_bytes[this.m_pos++] & 0xFF;
        out = next << 24;
        next = this.m_bytes[this.m_pos++] & 0xFF;
        out |= next << 16;
        next = this.m_bytes[this.m_pos++] & 0xFF;
        out |= next << 8;
        next = this.m_bytes[this.m_pos++] & 0xFF;
        return out |= next;
    }

    public byte readByte() throws EOFException {
        if (this.m_pos >= this.m_bytes.length) {
            throw new EOFException();
        }
        byte out = this.m_bytes[this.m_pos];
        ++this.m_pos;
        return out;
    }

    public boolean readBool() throws EOFException, StreamCorruptedException {
        byte retval = this.readByte();
        if (retval == 1) {
            return true;
        }
        if (retval == 0) {
            return false;
        }
        throw new StreamCorruptedException();
    }

    public String readString() throws EOFException {
        int len = this.readInt();
        byte[] stringAsUTF8 = new byte[len];
        for (int i = 0; i < len; ++i) {
            stringAsUTF8[i] = this.readByte();
        }
        String out = null;
        try {
            out = new String(stringAsUTF8, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"SecuritySerializer::writeString: java.lang.String should support UTF-8");
        }
        return out;
    }

    public List readList() throws EOFException, StreamCorruptedException {
        int len = this.readInt();
        ArrayList<Object> out = new ArrayList<Object>(len);
        if (len > 0) {
            try {
                SecurityType tag = SecurityType.getEnumForTag(this.readByte());
                for (int i = 0; i < len; ++i) {
                    if (tag == SecurityType.BoolTag) {
                        out.add(new Boolean(this.readBool()));
                        continue;
                    }
                    if (tag == SecurityType.Int32Tag) {
                        out.add(new Integer(this.readInt()));
                        continue;
                    }
                    if (tag == SecurityType.Int8Tag) {
                        out.add(new Byte(this.readByte()));
                        continue;
                    }
                    if (tag == SecurityType.ListTag) {
                        out.add(this.readList());
                        continue;
                    }
                    if (tag == SecurityType.StringTag) {
                        out.add(this.readString());
                        continue;
                    }
                    SerializableCommand val = SecurityCommandFactory.getCommandForTag(tag);
                    val.read(this);
                    out.add(val);
                }
            }
            catch (NotSerializableException e) {
                throw new StreamCorruptedException();
            }
        }
        return out;
    }

    public SerializableCommand readObject(Class out) throws EOFException, StreamCorruptedException, IllegalAccessException, InstantiationException {
        SerializableCommand s = (SerializableCommand)out.newInstance();
        s.read(this);
        return s;
    }

    public boolean hasMore() {
        return this.m_pos < this.m_bytes.length;
    }
}

