/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.SeqOctetHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChunkedInputStreamPOA;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringHolder;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.ObjectNotActive;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.WrongPolicy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStreamImpl
extends ChunkedInputStreamPOA {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamImpl");
    public InputStream m_inStream;
    private long m_lastInvoked;

    public ChunkedInputStreamImpl(InputStream in) {
        this.m_inStream = in;
        this.m_lastInvoked = System.currentTimeMillis();
    }

    public synchronized int readChunk(int thisChunkMaxSize, SeqOctetHolder chunk, StringHolder trailer) throws oca_abuse {
        this.updateTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("(readChunk:69): chunkMaxSize " + thisChunkMaxSize));
        }
        try {
            int newSize;
            int size = this.m_inStream.available();
            if (thisChunkMaxSize < size) {
                size = thisChunkMaxSize;
            }
            byte[] chunkedBytes = new byte[size];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (int read = 0; read < size; read += newSize) {
                newSize = 0;
                newSize = this.m_inStream.read(chunkedBytes);
                if (newSize <= 0) continue;
                bos.write(chunkedBytes, 0, size);
            }
            chunk.value = bos.toByteArray();
            if (trailer.value == null) {
                trailer.value = "";
            }
            return this.m_inStream.available();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"(readChunk:95): IOException during skip", (Throwable)ioe);
            throw new oca_abuse();
        }
    }

    public synchronized long skip(long numberOfBytes) throws oca_abuse {
        long skipedBytes;
        this.updateTime();
        try {
            skipedBytes = this.m_inStream.skip(numberOfBytes);
        }
        catch (IOException ioe) {
            LOG.warn((Object)"(skip:109): io exception during skip", (Throwable)ioe);
            throw new oca_abuse();
        }
        return skipedBytes;
    }

    public synchronized void close() {
        this.deactivate();
        this.m_lastInvoked = -1L;
    }

    private void deactivate() {
        block4: {
            try {
                this._default_POA().deactivate_object(this._object_id());
            }
            catch (ObjectNotActive ona) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"(deactivate:130) it is OK", (Throwable)ona);
                }
            }
            catch (WrongPolicy wrongPolicy) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)"(deactivate:135) this is OK", (Throwable)wrongPolicy);
            }
        }
    }

    private void updateTime() {
        if (this.m_lastInvoked != -1L) {
            this.m_lastInvoked = System.currentTimeMillis();
        }
    }

    public long getLastInvoked() {
        return this.m_lastInvoked;
    }
}

