/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.crystaldecisions.celib.collections.CaseInsensHashMap;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.transport.internal.EncodingStyle;
import com.crystaldecisions.sdk.occa.transport.internal.IEncodingSupport;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportEntity;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class EncodeableTransportEntity
implements IEncodingSupport,
ITransportEntity {
    private Object m_body;
    private Map m_headers = Collections.EMPTY_MAP;
    private EncodingStyle m_encodingStyle = EncodingStyle.IDENTITY;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public OutputStream getBodyOutputStream() {
        if (this.m_body == null || !(this.m_body instanceof ByteArrayOutputStream)) {
            this.m_body = new ByteArrayOutputStream();
        }
        return (OutputStream)this.m_body;
    }

    public void setBody(byte[] body) {
        this.m_body = body;
    }

    public byte[] getBodyAsBytes() throws SDKException {
        if (this.m_body instanceof byte[]) {
            return (byte[])this.m_body;
        }
        if (this.m_body instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.m_body).toByteArray();
        }
        if (this.m_body instanceof InputStream) {
            BufferedInputStream bufIn = new BufferedInputStream((InputStream)this.m_body);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                int ch = bufIn.read();
                if (ch != -1) {
                    outStream.write(ch);
                    ch = bufIn.read();
                }
                outStream.flush();
                return outStream.toByteArray();
            }
            catch (IOException e) {
                throw new SDKException.Unexpected(e);
            }
        }
        return EMPTY_BYTES;
    }

    public InputStream getBodyAsInputStream() {
        if (this.m_body instanceof InputStream) {
            return (InputStream)this.m_body;
        }
        if (this.m_body instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.m_body);
        }
        if (this.m_body instanceof ByteArrayOutputStream) {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.m_body).toByteArray());
        }
        return new ByteArrayInputStream(EMPTY_BYTES);
    }

    public void setBody(InputStream body) {
        this.m_body = body;
    }

    public void addHeaders(Map headers) {
        if (headers != null && headers.size() != 0) {
            this.ensureHeaders();
            this.m_headers.putAll(headers);
        }
    }

    public void addHeader(String name, Object value) {
        if (name != null && value != null) {
            this.ensureHeaders();
            this.m_headers.put(name, value);
        }
    }

    public Object removeHeader(String name) {
        if (name != null) {
            return this.m_headers.remove(name);
        }
        return null;
    }

    public Object getHeader(String name) {
        return this.m_headers.get(name);
    }

    public Map getHeaders() {
        return Collections.unmodifiableMap(this.m_headers);
    }

    public EncodingStyle getEncodingStyle() {
        return this.m_encodingStyle;
    }

    public void setEncodingStyle(EncodingStyle encodingStyle) {
        this.m_encodingStyle = encodingStyle;
    }

    private void ensureHeaders() {
        if (this.m_headers == Collections.EMPTY_MAP) {
            this.m_headers = new CaseInsensHashMap();
        }
    }
}

