/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamImpl;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class InputStreamCleanUp
implements Runnable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.transport.internal.InputStreamCleanUp");
    private List m_inputStreams = new LinkedList();
    private static InputStreamCleanUp m_ref;
    private Thread t;
    private static final long EXPIRE_TIME = 5000000L;
    private static final long REPEAT_TIME = 30000L;

    private InputStreamCleanUp() {
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        for (ThreadGroup parentGroup = currentGroup.getParent(); null != parentGroup && null != parentGroup.getParent(); parentGroup = parentGroup.getParent()) {
            currentGroup = parentGroup;
        }
        this.t = new Thread(currentGroup, this, "Business Objects - InputStream Clean up");
        this.t.setDaemon(true);
        this.t.start();
    }

    public static synchronized InputStreamCleanUp getInputStreamCleanUpObject() {
        if (m_ref == null) {
            m_ref = new InputStreamCleanUp();
        }
        return m_ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(ChunkedInputStreamImpl stream) {
        InputStreamCleanUp inputStreamCleanUp = this;
        synchronized (inputStreamCleanUp) {
            this.m_inputStreams.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        InputStreamCleanUp inputStreamCleanUp = this;
        synchronized (inputStreamCleanUp) {
            Iterator streams = this.m_inputStreams.iterator();
            while (streams.hasNext()) {
                ChunkedInputStreamImpl stream = (ChunkedInputStreamImpl)((Object)streams.next());
                long currentTime = System.currentTimeMillis();
                if (stream.getLastInvoked() == -1L) {
                    streams.remove();
                    LOG.debug((Object)"Cleaning up input stream. removed stream");
                    continue;
                }
                if (currentTime - stream.getLastInvoked() <= 5000000L) continue;
                try {
                    stream.close();
                }
                catch (Throwable e) {
                    LOG.warn((Object)"(cleanUp:84): exception when closing stream", e);
                }
                streams.remove();
                LOG.debug((Object)"Cleaning up input stream. removed stream");
            }
        }
    }

    public void run() {
        try {
            while (true) {
                try {
                    this.cleanUp();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                Thread.sleep(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

