/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.transport.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.foundation.logging.NDC;
import com.crystaldecisions.enterprise.ocaframework.AbstractStubHelper;
import com.crystaldecisions.enterprise.ocaframework.IInvocationCallback;
import com.crystaldecisions.enterprise.ocaframework.IManagedService;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.PropertyIDs;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.enterprise.ocaframework.ServiceSpec;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.message_union;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.oca_abuse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.BIPTransportHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.BIPTransportOperations;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.Channel;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChannelHelper;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChunkedInputStream;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.ChunkedPayload;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.EncodedRequest;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.EncodedResponse;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.EncodedResponseHolder;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA2.IdentityPayload;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.transport.internal.AbstractChannel;
import com.crystaldecisions.sdk.occa.transport.internal.BIPTransportImpl;
import com.crystaldecisions.sdk.occa.transport.internal.CallbackRequestHandler;
import com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamImpl;
import com.crystaldecisions.sdk.occa.transport.internal.ChunkedInputStreamStubWrapper;
import com.crystaldecisions.sdk.occa.transport.internal.EncodingStyle;
import com.crystaldecisions.sdk.occa.transport.internal.IChannel;
import com.crystaldecisions.sdk.occa.transport.internal.IDelaySerializationCallback;
import com.crystaldecisions.sdk.occa.transport.internal.IEncodingSupport;
import com.crystaldecisions.sdk.occa.transport.internal.ILocalTransportRequestHandler;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportEntity;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportSender;
import com.crystaldecisions.sdk.occa.transport.internal.ITransportServiceHelper;
import com.crystaldecisions.sdk.occa.transport.internal.InputStreamCleanUp;
import com.crystaldecisions.sdk.occa.transport.internal.TransportUtils;
import com.crystaldecisions.sdk.occa.transport.internal._BIPTransportProxy;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORBPackage.InvalidName;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POA;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.ObjectNotActive;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAPackage.WrongPolicy;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.Servant;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.HashMap;

public class TransportSender
extends AbstractChannel
implements ITransportSender,
IChannel {
    private static final ILogger LOG;
    private BIPTransportImpl m_callback;
    private IManagedService m_stub;
    private String m_protocol;
    private String m_serviceName;
    private String m_address;
    private static InputStreamCleanUp s_streamCleanUp;
    private static final int DEFAULT_FIRST_CHUNK_SIZE = 8192;
    private ITransportServiceHelper.IFactory m_helperFactory;
    private static final String s_vmID;
    private static final Any ANY_NULL;
    private static final String s_classLoaderId;
    private static final String s_uniquePrefix;
    private static long s_requestId;
    static final /* synthetic */ boolean $assertionsDisabled;

    private synchronized void setCallback(BIPTransportOperations proxy, IChannel backChannel) throws SDKException {
        if (backChannel != null) {
            if (this.m_callback != null) {
                this.m_callback.setHandler(new CallbackRequestHandler(backChannel, this.m_stub));
            } else {
                this.m_callback = this.createServant(backChannel);
                proxy.setCallback(ChannelHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.m_callback._this_object()));
            }
        } else if (this.m_callback != null) {
            try {
                this.m_callback._default_POA().deactivate_object(this.m_callback._object_id());
                this.m_callback = null;
                proxy.setCallback(null);
            }
            catch (ObjectNotActive objectNotActive) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
        }
    }

    public TransportSender(ISecuritySession session, IChannel receiver, String serviceAddress, boolean createNew, ITransportServiceHelper.IFactory helperFactory) throws SDKException {
        ServiceSpec svcSpec = TransportUtils.parseAddress(serviceAddress);
        this.m_serviceName = svcSpec.getName();
        this.m_protocol = svcSpec.getProtocol();
        this.m_helperFactory = helperFactory;
        ServerSpec serverSpec = svcSpec.getServerSpec();
        String cookie = serverSpec.getCookie();
        String serviceID = svcSpec.getId();
        if (serviceID == null || serviceID.length() == 0) {
            serviceID = createNew ? "NEW_ID" : "NO_ID";
        }
        try {
            this.m_stub = ServiceMgrFactory.getServiceMgr().getManagedService(serviceID, this.m_serviceName, serverSpec, session.getUserURI(), session.getLogonToken(), new IManagedService.IHelperFactory(){

                public IManagedService.IStubHelper makeHelper() {
                    return new AbstractStubHelper(this){
                        private ITransportServiceHelper m_helper;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object narrow(com.crystaldecisions.thirdparty.org.omg.CORBA.Object object) {
                            return BIPTransportHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)object);
                        }

                        public void release(Object object) {
                            block4: {
                                if (TransportSender.access$100(1.access$000(this.this$1)) != null) {
                                    if (this.m_helper == null) {
                                        this.m_helper = TransportSender.access$100(1.access$000(this.this$1)).makeHelper();
                                    }
                                    try {
                                        this.m_helper.release();
                                    }
                                    catch (Throwable e) {
                                        if (!TransportSender.access$200().isInfoEnabled()) break block4;
                                        TransportSender.access$200().info((Object)"(release:124) exception during releasing", e);
                                    }
                                }
                            }
                            TransportSender.access$300(1.access$000(this.this$1));
                        }

                        public void expire(Object object) {
                            block4: {
                                if (TransportSender.access$100(1.access$000(this.this$1)) != null) {
                                    if (this.m_helper == null) {
                                        this.m_helper = TransportSender.access$100(1.access$000(this.this$1)).makeHelper();
                                    }
                                    try {
                                        this.m_helper.expire();
                                    }
                                    catch (Throwable e) {
                                        if (!TransportSender.access$200().isInfoEnabled()) break block4;
                                        TransportSender.access$200().info((Object)"(expire:148) exception during expiring", e);
                                    }
                                }
                            }
                            TransportSender.access$300(1.access$000(this.this$1));
                        }

                        public boolean isRecoverable(Throwable t) {
                            if (TransportSender.access$100(1.access$000(this.this$1)) == null || !(t instanceof oca_abuse)) {
                                return super.isRecoverable(t);
                            }
                            oca_abuse abuse = (oca_abuse)t;
                            String serializedException = abuse.details;
                            if (this.m_helper == null) {
                                this.m_helper = TransportSender.access$100(1.access$000(this.this$1)).makeHelper();
                            }
                            return this.m_helper.isRecoverable(serializedException);
                        }

                        public boolean isStateful() {
                            if (TransportSender.access$100(1.access$000(this.this$1)) == null) {
                                return super.isStateful();
                            }
                            if (this.m_helper == null) {
                                this.m_helper = TransportSender.access$100(1.access$000(this.this$1)).makeHelper();
                            }
                            return this.m_helper.isStateful();
                        }
                    };
                }

                static /* synthetic */ TransportSender access$000(1 x0) {
                    return x0.TransportSender.this;
                }
            });
            if (cookie != null && cookie.length() != 0) {
                this.m_stub.setCookie(cookie);
            }
        }
        catch (OCAFrameworkException e) {
            throw SDKException.map(e);
        }
        _BIPTransportProxy proxy = new _BIPTransportProxy(this.m_stub);
        this.setCallback(proxy, receiver);
    }

    private void cleanup() {
        if (this.m_callback != null) {
            try {
                this.m_callback._default_POA().deactivate_object(this.m_callback._object_id());
            }
            catch (ObjectNotActive objectNotActive) {
            }
            catch (WrongPolicy wrongPolicy) {
                // empty catch block
            }
        }
        this.m_callback = null;
    }

    public TransportSender(IManagedService stub, IChannel backChannel, String address) throws SDKException {
        this.m_stub = stub;
        _BIPTransportProxy proxy = new _BIPTransportProxy(this.m_stub);
        this.m_address = address;
        this.setCallback(proxy, backChannel);
    }

    public String getActualServiceAddress() throws SDKException {
        ServerSpec spec = this.m_stub.getSvr();
        if (spec != null) {
            return TransportUtils.toAddress(this.m_protocol, spec, this.m_serviceName, this.m_stub.getID());
        }
        return this.m_address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransportEntity request(ITransportEntity request, ILocalTransportRequestHandler localHandler, IDelaySerializationCallback delayCallback) throws SDKException {
        if (localHandler != null) {
            String requestId = TransportSender.generateRequestId();
            NDC.push((String)requestId);
            try {
                ITransportEntity response;
                _BIPTransportProxy proxy = new _BIPTransportProxy(this.m_stub);
                HashMap<String, LocalInvocationCallback> context = new HashMap<String, LocalInvocationCallback>(1);
                String cookie = this.m_stub.getCookie();
                LocalInvocationCallback localCallback = new LocalInvocationCallback(request, localHandler, requestId, cookie, delayCallback);
                context.put("INVOCATION_CALLBACK", localCallback);
                proxy.setContext(context);
                EncodedResponseHolder replyHolder = new EncodedResponseHolder();
                try {
                    proxy.post(null, replyHolder);
                }
                catch (oca_abuse e) {
                    throw SDKException.map(e);
                }
                if (localCallback.m_response != null) {
                    response = localCallback.m_response;
                    this.processResponse(response);
                } else {
                    response = this.createResponse(replyHolder);
                }
                ITransportEntity iTransportEntity = response;
                return iTransportEntity;
            }
            finally {
                NDC.pop();
            }
        }
        return this.request(request);
    }

    public ITransportEntity request(ITransportEntity request) throws SDKException {
        String requestId = TransportSender.generateRequestId();
        NDC.push((String)requestId);
        try {
            EncodedRequest er = TransportSender.createEncodedRequest(request, requestId, this.m_stub.getCookie());
            EncodedResponseHolder replyHolder = new EncodedResponseHolder();
            _BIPTransportProxy proxy = new _BIPTransportProxy(this.m_stub);
            proxy.post(er, replyHolder);
            ITransportEntity iTransportEntity = this.createResponse(replyHolder);
            return iTransportEntity;
        }
        catch (oca_abuse oca_abuse2) {
            throw SDKException.map(oca_abuse2);
        }
        finally {
            NDC.pop();
        }
    }

    private ITransportEntity createResponse(EncodedResponseHolder replyHolder) {
        EncodedResponse reply = replyHolder.value;
        ITransportEntity responseEntity = this.createEntity();
        String replyHeader = "";
        if (reply.discriminator().value() == 0) {
            IdentityPayload payload = reply.identityPayload();
            byte[] replyBuf = payload.body;
            replyHeader = payload.headerBag;
            responseEntity.setBody(replyBuf);
        } else {
            ChunkedPayload chunkedPayload = reply.chunkedPayload();
            replyHeader = chunkedPayload.headerBag;
            ChunkedInputStream chunkedIn = chunkedPayload.body;
            ChunkedInputStreamStubWrapper wrapper = new ChunkedInputStreamStubWrapper(chunkedIn);
            responseEntity.setBody(wrapper);
        }
        TransportUtils.extractTransportHeaders(replyHeader, responseEntity);
        this.processResponse(responseEntity);
        return responseEntity;
    }

    private void processResponse(ITransportEntity responseEntity) {
        if (this.m_stub.getHelper().isStateful()) {
            String cookie = (String)responseEntity.getHeader(PropertyIDs.idToName((Integer)PropertyIDs.SI_SERVICE_ID));
            if (Boolean.FALSE.equals(responseEntity.getHeader("SI_MAINTAIN_STATE"))) {
                this.m_stub.terminate(null);
            }
            this.m_stub.setCookie(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncRequest(ITransportEntity request, IChannel receiver) throws SDKException {
        if (receiver == null) {
            throw new SDKException.Unexpected();
        }
        String requestID = TransportSender.generateRequestId();
        NDC.push((String)requestID);
        try {
            EncodedRequest er = TransportSender.createEncodedRequest(request, requestID, this.m_stub.getCookie());
            Channel callBack = ChannelHelper.narrow((com.crystaldecisions.thirdparty.org.omg.CORBA.Object)this.createServant(receiver)._this_object());
            _BIPTransportProxy proxy = new _BIPTransportProxy(this.m_stub);
            proxy.asyncPost(er, callBack);
        }
        finally {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateRequestId() {
        long requestId;
        Class clazz = TransportSender.class;
        synchronized (clazz) {
            requestId = s_requestId++;
        }
        return s_uniquePrefix + requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ITransportEntity request) throws SDKException {
        String requestId = TransportSender.generateRequestId();
        NDC.push((String)requestId);
        try {
            EncodedRequest er = TransportSender.createEncodedRequest(request, requestId, this.m_stub.getCookie());
            _BIPTransportProxy proxy = new _BIPTransportProxy(this.m_stub);
            proxy.send(er);
        }
        finally {
            NDC.pop();
        }
    }

    private static EncodedRequest createEncodedRequest(ITransportEntity request, String requestId, String cookie) throws SDKException {
        EncodedRequest er = new EncodedRequest();
        TransportSender.processRequest(request, cookie, requestId);
        String packedHeader = TransportUtils.packTransportHeaders(request);
        EncodingStyle encodingStyle = EncodingStyle.IDENTITY;
        if (request instanceof IEncodingSupport) {
            encodingStyle = ((IEncodingSupport)((Object)request)).getEncodingStyle();
        }
        if (encodingStyle == EncodingStyle.IDENTITY) {
            byte[] out = request.getBodyAsBytes();
            IdentityPayload payLoad = new IdentityPayload(packedHeader, out);
            er.identityPayload(payLoad);
        } else if (encodingStyle == EncodingStyle.PULLSTREAM) {
            InputStream stream = request.getBodyAsInputStream();
            int chunkSize = 8192;
            try {
                chunkSize = stream.available();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("(createEncodedRequest:343): size of the chunk received " + chunkSize));
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed to retrieve chunk size", (Throwable)ioe);
            }
            ChunkedInputStreamImpl cunkedInputStream = TransportSender.createChukedInputStreamServant(stream);
            ChunkedPayload chunkedPayLoad = new ChunkedPayload(packedHeader, chunkSize, cunkedInputStream._this());
            er.chunkedPayload(chunkedPayLoad);
            s_streamCleanUp.addStream(cunkedInputStream);
        }
        return er;
    }

    private static void processRequest(ITransportEntity request, String cookie, String requestId) {
        if (cookie != null && cookie.length() != 0) {
            request.addHeader(PropertyIDs.idToName((Integer)PropertyIDs.SI_SERVICE_ID), cookie);
        }
        if (requestId != null) {
            request.addHeader(PropertyIDs.idToName((Integer)PropertyIDs.SI_REQUEST_ID), requestId);
        }
    }

    private BIPTransportImpl createServant(IChannel receiver) throws SDKException {
        POA poa;
        block5: {
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            poa = null;
            try {
                poa = (POA)orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName invalidName) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        BIPTransportImpl transportServant = new BIPTransportImpl(false, new CallbackRequestHandler(receiver, this.m_stub), poa);
        try {
            poa.activate_object((Servant)transportServant);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new SDKException.Unexpected();
        }
        catch (WrongPolicy wrongPolicy) {
            throw new SDKException.Unexpected();
        }
        return transportServant;
    }

    private static ChunkedInputStreamImpl createChukedInputStreamServant(InputStream stream) throws SDKException {
        POA poa;
        ChunkedInputStreamImpl cunkedInputStreamServant;
        block5: {
            cunkedInputStreamServant = new ChunkedInputStreamImpl(stream);
            ORB orb = ServiceMgrFactory.getServiceMgr().getORB();
            poa = null;
            try {
                poa = (POA)orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName invalidName) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        try {
            poa.activate_object((Servant)cunkedInputStreamServant);
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            LOG.warn((Object)"(createChukedInputStreamServant:406): shouldn't happen", (Throwable)servantAlreadyActive);
            throw new SDKException.Unexpected((Exception)((Object)servantAlreadyActive));
        }
        catch (WrongPolicy wrongPolicy) {
            LOG.warn((Object)"(createChukedInputStreamServant:410): shouldn't happen", (Throwable)wrongPolicy);
            throw new SDKException.Unexpected((Exception)((Object)wrongPolicy));
        }
        return cunkedInputStreamServant;
    }

    static /* synthetic */ ITransportServiceHelper.IFactory access$100(TransportSender x0) {
        return x0.m_helperFactory;
    }

    static /* synthetic */ ILogger access$200() {
        return LOG;
    }

    static /* synthetic */ void access$300(TransportSender x0) {
        x0.cleanup();
    }

    static {
        $assertionsDisabled = !TransportSender.class.desiredAssertionStatus();
        LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occa.transport.internal.TransportSender");
        s_streamCleanUp = InputStreamCleanUp.getInputStreamCleanUpObject();
        ANY_NULL = ServiceMgrFactory.getServiceMgr().getORB().create_any();
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        s_vmID = localHost == null ? new VMID().toString() : localHost.getHostName() + ":" + new UID();
        s_classLoaderId = Integer.toString(System.identityHashCode(TransportSender.class.getClassLoader()));
        s_uniquePrefix = s_vmID + ":" + s_classLoaderId + ":";
    }

    private static class LocalInvocationCallback
    implements IInvocationCallback {
        private ITransportEntity m_request;
        private ITransportEntity m_response;
        private String m_requestId;
        private ILocalTransportRequestHandler m_localHandler;
        private String m_cookie;
        private IDelaySerializationCallback m_delayCallback;

        public LocalInvocationCallback(ITransportEntity request, ILocalTransportRequestHandler localHandler, String requestId, String cookie, IDelaySerializationCallback delayCallback) {
            this.m_request = request;
            this.m_localHandler = localHandler;
            this.m_requestId = requestId;
            this.m_cookie = cookie;
            this.m_delayCallback = delayCallback;
        }

        public Object invoke(Method method, Object stub, Object[] args, ServerSpec spec) throws Throwable {
            if (this.m_localHandler.isLocal(spec)) {
                try {
                    TransportSender.processRequest(this.m_request, this.m_cookie, this.m_requestId);
                    this.m_response = this.m_localHandler.process(this.m_request);
                    return new Integer(1);
                }
                catch (SDKException e) {
                    String serializedException = BIPTransportImpl.serializeException(e);
                    throw new oca_abuse(0, new message_union[0], serializedException, ANY_NULL);
                }
            }
            this.m_delayCallback.serialize();
            args[0] = TransportSender.createEncodedRequest(this.m_request, this.m_requestId, this.m_cookie);
            return method.invoke(stub, args);
        }
    }
}

