/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occamgr.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occamgr.internal.IOCCAFactory;
import com.crystaldecisions.sdk.occamgr.internal.IOCCAMgr;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

class OCCAMgr
implements IOCCAMgr {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.occamgr.internal.OCCAMgr");
    private Map m_factoriesByClassLoader = new WeakHashMap(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOCCAFactory2(String name) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getOCCAFactory(): name=" + name));
        }
        Map map = this.m_factoriesByClassLoader;
        synchronized (map) {
            Object factory;
            HashMap factories = (HashMap)this.m_factoriesByClassLoader.get(Thread.currentThread().getContextClassLoader());
            if (factories == null) {
                factories = new HashMap();
                this.m_factoriesByClassLoader.put(Thread.currentThread().getContextClassLoader(), factories);
            }
            if ((factory = factories.get(name)) == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("getOCCAFactory(): not found, name=" + name));
                }
                Exception failure = null;
                try {
                    String propFileName = "META-INF/CrystalEnterprise.Services/" + name + ".properties";
                    InputStream propertyStream = ClassLoaderHelper.getResourceAsStream((String)propFileName);
                    if (propertyStream != null) {
                        Properties infoProperties = new Properties();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("getOCCAFactory(): reading from " + propFileName));
                        }
                        infoProperties.load(propertyStream);
                        propertyStream.close();
                        String factoryName = infoProperties.getProperty("factory");
                        LOG.assertNotNull((Object)factoryName, "factoryName is null.");
                        if (factoryName != null) {
                            Class clazz = ClassLoaderHelper.loadClass((String)factoryName);
                            Method method = null;
                            LOG.info((Object)"getOCCAFactory(): getting getFactory()");
                            method = clazz.getMethod("getFactory", null);
                            factory = method.invoke(null, null);
                            LOG.assertNotNull(factory, "factory");
                            factories.put(name, factory);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    LOG.warn((Object)("getOCCAFactory(): Failed to local factory class for " + name), (Throwable)e);
                    failure = e;
                }
                catch (IOException e) {
                    LOG.warn((Object)("getOCCAFactory(): Failed to read property file for " + name), (Throwable)e);
                    failure = e;
                }
                catch (IllegalAccessException e) {
                    LOG.warn((Object)("getOCCAFactory(): Failed to access class or constructor for " + name + ". This is most likely caused by class or constructor has not been declared public"), (Throwable)e);
                    failure = e;
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)("getOCCAFactory(): something strange happened for " + name), (Throwable)e);
                    failure = e;
                }
                catch (InvocationTargetException e) {
                    LOG.warn((Object)("getOCCAFactory(): failed to instantialize the object for " + name), (Throwable)e);
                    failure = e;
                }
                catch (NoSuchMethodException e) {
                    LOG.warn((Object)("getOCCAFactory(): getFactory() not in the OCAFactory class for " + name), (Throwable)e);
                    failure = e;
                }
                catch (SecurityException e) {
                    LOG.warn((Object)("getOCCAFactory(): Not allowed for " + name), (Throwable)e);
                    failure = e;
                }
                if (factory == null) {
                    throw new SDKException.ServiceNotFound(name, failure);
                }
            }
            LOG.debug((Object)"getOCCAFactory(): exit");
            return factory;
        }
    }

    public IOCCAFactory getOCCAFactory(String name) throws SDKException {
        return (IOCCAFactory)this.getOCCAFactory2(name);
    }
}

