/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.auditadmin.internal;

import com.businessobjects.sdk.plugin.desktop.common.IConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredServices;
import com.businessobjects.sdk.plugin.desktop.common.IIntegerProps;
import com.businessobjects.sdk.plugin.desktop.service.IService;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServiceAdmin;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;

public class AdminHelper {
    private String m_serviceCUID;
    private AbstractServiceAdmin m_admin;
    private IIntegerProps m_supportedAuditEvents;
    private IConfiguredService m_congigService = null;
    private IServer m_serverObj;

    public AdminHelper(String serviceCUID, AbstractServiceAdmin admin) {
        this.m_serviceCUID = serviceCUID;
        this.m_admin = admin;
    }

    private IIntegerProps supportedAuditEvents() throws SDKException {
        this.m_serverObj = this.m_admin.getServerObject();
        IConfiguredServices configuredServices = this.m_serverObj.getHostedServices();
        Object[] serviceIDs = configuredServices.getConfiguredServiceIDs().toArray();
        for (int i = 0; i < serviceIDs.length; ++i) {
            Integer id = (Integer)serviceIDs[i];
            IConfiguredService service = configuredServices.get(id);
            if (!service.getCUID().equals(this.m_serviceCUID)) continue;
            IService serviceObj = this.m_admin.getServiceObject(service.getCUID());
            this.m_congigService = service;
            return serviceObj.getSupportedAuditEvents();
        }
        return null;
    }

    public void setAuditEvent(Integer eventNumber, boolean value) throws SDKException {
        if (this.m_supportedAuditEvents == null) {
            this.m_supportedAuditEvents = this.supportedAuditEvents();
        }
        if (this.m_supportedAuditEvents.contains(eventNumber)) {
            IIntegerProps enabledAuditEvents = this.m_congigService.getEnabledAuditEvents();
            if (value) {
                enabledAuditEvents.add(eventNumber);
            } else {
                enabledAuditEvents.remove(eventNumber);
            }
        }
    }

    public boolean isEventEnabled(Integer eventNumber) throws SDKException {
        if (this.m_supportedAuditEvents == null) {
            this.m_supportedAuditEvents = this.supportedAuditEvents();
        }
        if (this.m_congigService != null) {
            IIntegerProps enabledAuditEvents = this.m_congigService.getEnabledAuditEvents();
            return enabledAuditEvents.contains(eventNumber);
        }
        return false;
    }
}

