/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.auditadmin.internal;

import com.businessobjects.sdk.plugin.desktop.common.IConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredServices;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServiceAdmin;
import com.crystaldecisions.sdk.plugin.admin.auditadmin.IJobServerAuditAdmin;
import com.crystaldecisions.sdk.plugin.admin.auditadmin.internal.AdminHelper;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.List;

public class JobServerAuditAdmin
extends AbstractServiceAdmin
implements IJobServerAuditAdmin {
    private static final int eJobServer = 5;
    private static final int eJS_AuditBase = 327680;
    private static final int eJS_JobSuccessful = 327681;
    private static final int eJS_JobFailed = 327682;
    private static final int eJS_FailButRetry = 327683;
    private static final Integer JOB_SUCCEEDED = PropertyIDs.define(Integer.toString(327681));
    private static final Integer JOB_FAILED = PropertyIDs.define(Integer.toString(327682));
    private static final Integer JOB_FAILED_BUT_RETRIED = PropertyIDs.define(Integer.toString(327683));
    private List m_adminHelpers;

    private void ensureHelper() throws SDKException {
        if (this.m_adminHelpers == null) {
            this.m_adminHelpers = new ArrayList();
            IServer serverObj = this.getServerObject();
            IConfiguredServices configuredServices = serverObj.getHostedServices();
            Object[] serviceIDs = configuredServices.getConfiguredServiceIDs().toArray();
            for (int i = 0; i < serviceIDs.length; ++i) {
                Integer id = (Integer)serviceIDs[i];
                IConfiguredService service = configuredServices.get(id);
                this.m_adminHelpers.add(new AdminHelper(service.getCUID(), this));
            }
        }
    }

    public boolean isJobSucceeded() throws SDKException {
        boolean isEnabled = false;
        this.ensureHelper();
        for (int i = 0; i < this.m_adminHelpers.size(); ++i) {
            isEnabled = ((AdminHelper)this.m_adminHelpers.get(i)).isEventEnabled(JOB_SUCCEEDED);
            if (!isEnabled) continue;
            this.setJobSucceeded(isEnabled);
            break;
        }
        return isEnabled;
    }

    public void setJobSucceeded(boolean value) throws SDKException {
        this.ensureHelper();
        for (int i = 0; i < this.m_adminHelpers.size(); ++i) {
            ((AdminHelper)this.m_adminHelpers.get(i)).setAuditEvent(JOB_SUCCEEDED, value);
        }
    }

    public boolean isJobFailed() throws SDKException {
        this.ensureHelper();
        boolean isEnabled = false;
        for (int i = 0; i < this.m_adminHelpers.size(); ++i) {
            isEnabled = ((AdminHelper)this.m_adminHelpers.get(i)).isEventEnabled(JOB_FAILED);
            if (!isEnabled) continue;
            this.setJobFailed(isEnabled);
            break;
        }
        return isEnabled;
    }

    public void setJobFailed(boolean value) throws SDKException {
        this.ensureHelper();
        for (int i = 0; i < this.m_adminHelpers.size(); ++i) {
            ((AdminHelper)this.m_adminHelpers.get(i)).setAuditEvent(JOB_FAILED, value);
        }
    }

    public boolean isJobFailedButRetried() throws SDKException {
        this.ensureHelper();
        boolean isEnabled = false;
        for (int i = 0; i < this.m_adminHelpers.size(); ++i) {
            isEnabled = ((AdminHelper)this.m_adminHelpers.get(i)).isEventEnabled(JOB_FAILED_BUT_RETRIED);
            if (!isEnabled) continue;
            this.setJobFailedButRetried(isEnabled);
            break;
        }
        return isEnabled;
    }

    public void setJobFailedButRetried(boolean value) throws SDKException {
        this.ensureHelper();
        for (int i = 0; i < this.m_adminHelpers.size(); ++i) {
            ((AdminHelper)this.m_adminHelpers.get(i)).setAuditEvent(JOB_FAILED_BUT_RETRIED, value);
        }
    }
}

