/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.cmsadmin.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServerAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.admin.apsadmin.IAPSAdmin;
import com.crystaldecisions.sdk.plugin.admin.cmsadmin.ICMSAdmin;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.ArrayList;
import java.util.StringTokenizer;

class CMSAdmin
extends AbstractServerAdmin
implements ICMSAdmin,
IAPSAdmin {
    private static final String s_clusterMemberSeparator = ";";

    CMSAdmin() {
    }

    public void initialize(String name, Object admin, String uri, IInfoObject serverObj, IInternalInfoStore infoStore) throws SDKException {
        super.initialize(name, admin, uri, serverObj, infoStore);
        this.initServiceAdmin("APSAdmin");
    }

    public String[] getClusterMembers() throws SDKException {
        String clustermembers = this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_CLUSTER_MEMBERS));
        if (clustermembers == null) {
            throw new SDKException.PropertyNotFound("SI_MONITOR_CLUSTER_MEMBERS");
        }
        StringTokenizer st = new StringTokenizer(clustermembers, s_clusterMemberSeparator);
        ArrayList<String> members = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            members.add(st.nextToken());
        }
        return members.toArray(new String[members.size()]);
    }

    public int getFailedJobs() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_JOB_COUNT_FAILED_JOBS));
    }

    public int getPendingJobs() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_JOB_COUNT_PENDING_JOBS));
    }

    public int getRunningJobs() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_JOB_COUNT_RUNNING_JOBS));
    }

    public int getSuccessJobs() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_JOB_COUNT_SUCCESS_JOBS));
    }

    public int getWaitingJobs() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_JOB_COUNT_WAITING_JOBS));
    }

    public int getLicensesConcurrent() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_LICENSES_CONCURRENT));
    }

    public int getLicensesNamedUsers() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_LICENSES_NAMED_USERS));
    }

    public int getLicensesProcessors() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_LICENSES_PROCESSORS));
    }

    public String getCMSBuildDate() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSBUILD_DATE));
    }

    public String getCMSDatabaseName() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSDATABASE_NAME));
    }

    public String getCMSDatabaseServerName() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSDATABASE_SERVER_NAME));
    }

    public String getCMSDatabaseUserName() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSDATABASE_USER_NAME));
    }

    public String getCMSDataSourceName() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSDATA_SOURCE_NAME));
    }

    public String getCMSPrivateBuildNumber() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSPRIVATE_BUILD_NUMBER));
    }

    public String getCMSProductVersion() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSPRODUCT_VERSION));
    }

    public String getCMSResourceVersion() throws SDKException {
        return this.getStringMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_STATIC_APSRESOURCE_VERSION));
    }

    public int getUserConnectedConcurrent() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_USER_COUNT_CONNECTED_CONCURRENT));
    }

    public int getUserConnectedNamedUsers() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_USER_COUNT_CONNECTED_NAMED_USERS));
    }

    public int getUserExistingConcurrent() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_USER_COUNT_EXISTING_CONCURRENT));
    }

    public int getUserExistingNamedUsers() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_USER_COUNT_EXISTING_NAMED_USERS));
    }

    public int getUserTokenConnections() throws SDKException {
        return this.getIntMetric(PropertyIDs.idToName(PropertyIDs.SI_MONITOR_USER_COUNT_TOKEN_CONNECTIONS));
    }

    public String getAPSBuildDate() throws SDKException {
        return this.getCMSBuildDate();
    }

    public String getAPSDatabaseName() throws SDKException {
        return this.getCMSDatabaseName();
    }

    public String getAPSDatabaseServerName() throws SDKException {
        return this.getCMSDatabaseServerName();
    }

    public String getAPSDatabaseUserName() throws SDKException {
        return this.getCMSDatabaseUserName();
    }

    public String getAPSDataSourceName() throws SDKException {
        return this.getCMSDataSourceName();
    }

    public String getAPSPrivateBuildNumber() throws SDKException {
        return this.getCMSPrivateBuildNumber();
    }

    public String getAPSProductVersion() throws SDKException {
        return this.getCMSProductVersion();
    }

    public String getAPSResourceVersion() throws SDKException {
        return this.getCMSResourceVersion();
    }
}

