/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.jobserveradmin.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredContainer;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredService;
import com.businessobjects.sdk.plugin.desktop.common.IConfiguredServices;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.uri.ObURL;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServerAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.admin.jobserveradmin.IJobServerAdmin;
import com.crystaldecisions.sdk.plugin.admin.jobserveradmin.IJobServerDestination;
import com.crystaldecisions.sdk.plugin.admin.jobserveradmin.internal.JobServerDestination;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;
import com.crystaldecisions.sdk.plugin.desktop.server.IServerDestinations;
import java.util.Set;

class JobServerAdmin
extends AbstractServerAdmin
implements IJobServerAdmin {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.admin.jobserveradmin.internal.JobServerAdmin");
    private static final String s_jobServerDestinationListClassName = "JSDL";
    private IJobServerDestination[] m_dests;
    private IConfiguredService m_configuredService = null;
    private IConfiguredContainer m_configuredContainer = null;
    private IServer m_serverObj = null;

    JobServerAdmin() {
    }

    public void initialize(String name, Object admin, String uri, IInfoObject serverObj, IInternalInfoStore infoStore) throws SDKException {
        super.initialize(name, admin, uri, serverObj, infoStore);
        this.initServiceAdmin("JobServerAdmin");
        if (serverObj instanceof IServer) {
            this.getServiceAdmin().setServerObject((IServer)serverObj);
            this.m_serverObj = (IServer)serverObj;
            this.m_configuredContainer = ((IServer)serverObj).getContainer();
            IConfiguredServices configuredServices = ((IServer)serverObj).getHostedServices();
            Object[] serviceIDs = configuredServices.getConfiguredServiceIDs().toArray();
            for (int i = 0; i < serviceIDs.length; ++i) {
                Integer id = (Integer)serviceIDs[i];
                IConfiguredService service = configuredServices.get(id);
                if (!service.getCUID().equals("Aevwbbdd8atBvhFtwxx6uFA")) continue;
                this.m_configuredService = service;
                break;
            }
        }
    }

    public int getMaxJobs() throws SDKException {
        IConfigProperties configProps = this.m_configuredContainer.getConfigProps();
        return this.getIntProp("maxJobs", configProps);
    }

    public void setMaxJobs(int n) throws SDKException {
        if (n <= 0) {
            throw new SDKException.InvalidArg(n);
        }
        IConfigProperties configProps = this.m_configuredContainer.getConfigProps();
        this.getServiceAdmin().setServerProperty("maxJobs", new Integer(n), configProps);
    }

    public String getObjectTypeName() throws SDKException {
        return this.getStringMetric("ISPROP_IPROC_OBJTYPENAME");
    }

    public String getDLLName() throws SDKException {
        return this.getStringMetric("ISPROP_IPROC_DLLNAME");
    }

    public int getCurrentJobs() throws SDKException {
        return this.getIntMetric("ISPROP_IPROC_CURJOBS");
    }

    public int getTotalJobs() throws SDKException {
        return this.getIntMetric("ISPROP_IPROC_TOTALJOBS");
    }

    public int getFailedCreated() throws SDKException {
        return this.getIntMetric("ISPROP_IPROC_FAILEDCREATED");
    }

    public String getTempDir() throws SDKException {
        IConfigProperties configProps = this.m_configuredContainer.getConfigProps();
        return this.getStringProp("dir", configProps);
    }

    public void setTempDir(String dir) throws SDKException {
        IConfigProperties configProps = this.m_configuredContainer.getConfigProps();
        this.getServiceAdmin().setServerProperty("dir", dir, configProps);
    }

    public int getProcType() throws SDKException {
        return this.getIntMetric("ProcType");
    }

    public IJobServerDestination[] getDestinations(IInfoStore infostore) throws SDKException {
        String s = this.getStringMetric("ISPROP_DEST_LIST");
        ObURL url = null;
        try {
            url = new ObURL(s);
        }
        catch (SILibException e) {
            throw new SDKException.URIFormat(s, (Exception)((Object)e));
        }
        PropertyBag topLevelBag = url.getProperties();
        if (s_jobServerDestinationListClassName.equals(url.getClassName())) {
            IServerDestinations serverDestinations = this.m_serverObj.getServerDestinations();
            Set destsSet = serverDestinations.getDestinationProgIDs();
            Object[] destsObj = destsSet.toArray();
            this.m_dests = new IJobServerDestination[destsObj.length];
            for (int i = 0; i < destsObj.length; ++i) {
                this.m_dests[i] = new JobServerDestination(serverDestinations.getServerDestination((String)destsObj[i]), this.getServiceAdmin());
            }
            return this.m_dests;
        }
        return this.m_dests;
    }

    public void commit() throws SDKException {
        if (this.m_dests != null) {
            for (int i = 0; i < this.m_dests.length; ++i) {
                LOG.assertTrue(this.m_dests[i] instanceof JobServerDestination);
                JobServerDestination dest = (JobServerDestination)this.m_dests[i];
                dest.commit();
            }
        }
        this.getServiceAdmin().commit();
    }
}

