/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.admin.ssoadmin.internal;

import com.businessobjects.sdk.plugin.desktop.common.IConfigProperties;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.enadmin.internal.AbstractServerAdmin;
import com.crystaldecisions.sdk.occa.enadmin.internal.IInternalAdminService;
import com.crystaldecisions.sdk.occa.enadmin.internal.IServiceAdmin;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.plugin.admin.ssoadmin.ISingleSignOnAdmin;
import com.crystaldecisions.sdk.plugin.desktop.server.IServer;

class SingleSignOnAdmin
extends AbstractServerAdmin
implements IInternalAdminService,
ISingleSignOnAdmin {
    private IConfigProperties m_configProps = null;
    private static final String PROP_SSPI_CTXT_CACHE_EXPIRY = "SSPI_CTXT_CACHE_EXPIRY";

    SingleSignOnAdmin() {
    }

    public void initialize(String name, Object admin, String uri, IInfoObject serverObj, IInternalInfoStore infoStore) throws SDKException {
        super.initialize(name, admin, uri, serverObj, infoStore);
        this.initServiceAdmin("SSOAdmin");
        if (serverObj instanceof IServer) {
            this.m_configProps = this.getServiceAdmin().getConfigProperties((IServer)serverObj, "AU4X8Y8d9HVOgCcoxJVTGS4");
        }
    }

    public int getProviderContextCacheExpiry() throws SDKException {
        return this.getIntSSOProp("SSPI", PROP_SSPI_CTXT_CACHE_EXPIRY, this.m_configProps);
    }

    public void setProviderContextCacheExpiry(int seconds) throws SDKException {
        IServiceAdmin sadmin = this.getServiceAdmin();
        if (sadmin != null) {
            sadmin.setSSOServerProperty("SSPI", PROP_SSPI_CTXT_CACHE_EXPIRY, new Integer(seconds), this.m_configProps);
        }
    }

    public void commit() throws SDKException {
        this.getServiceAdmin().commit();
    }
}

