/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.common;

import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.digest.Digest;
import com.crystaldecisions.celib.digest.MD5;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.stringhandler.SIStringHandler;
import com.crystaldecisions.sdk.exception.SDKException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public class AuthUtil {
    public static final String BUFF_SEPARATOR = "\n";
    private static final int LENGTH = 10;
    private static SIStringHandler sm_encryption = new SIStringHandler();
    private static final String DIGEST_SEPARATOR = new String(":");
    private static final String[] sm_ErrorStrings = new String[]{"NT Authorization required. The credentials passed do not match the credentials for this user.", "Token is complete and invalid, impersonation failed.", "Token is incomplete and requires the full context to be acquired."};

    public static String ConcatString(String[] arr, String sep) {
        StringBuffer buffer = new StringBuffer();
        boolean bFirst = true;
        for (int i = 0; i < arr.length; ++i) {
            if (bFirst) {
                bFirst = false;
            } else if (sep != null) {
                buffer.append(sep);
            }
            buffer.append(arr[i]);
        }
        return buffer.toString();
    }

    public static String[] ParseString(String inString, String sep) {
        if (inString != null && sep != null) {
            int count = 1;
            int start = 0;
            int end = 0;
            while (end != -1) {
                end = inString.indexOf(sep, start);
                if (end == -1) continue;
                ++count;
                start = end + 1;
            }
            if (count == 1) {
                String[] arr = new String[]{inString};
                return arr;
            }
            String[] arr = new String[count];
            int stringLength = inString.length();
            end = 0;
            start = 0;
            for (int index = 0; start < stringLength && index < arr.length; ++index) {
                end = inString.indexOf(sep, start);
                if (end == -1) {
                    arr[index] = new String(inString.substring(start));
                    break;
                }
                arr[index] = start == end ? null : new String(inString.substring(start, end));
                start = end + 1;
            }
            return arr;
        }
        return null;
    }

    public static void ParseString(String inString, String sep, String[] arr) {
        if (inString != null && sep != null) {
            int start = 0;
            int end = 0;
            int stringLength = inString.length();
            for (int index = 0; start < stringLength && index < arr.length; ++index) {
                end = inString.indexOf(sep, start);
                if (index == arr.length - 1 || end == -1) {
                    arr[index] = new String(inString.substring(start));
                    break;
                }
                arr[index] = start == end ? null : new String(inString.substring(start, end));
                start = end + 1;
            }
        }
    }

    public static String encryptPassword(String password) {
        if (password != null && !password.equals("")) {
            StringBuffer tempBuff = new StringBuffer(AuthUtil.GetRandomString(System.currentTimeMillis(), 10));
            tempBuff.append(BUFF_SEPARATOR);
            tempBuff.append(password);
            String tempString = tempBuff.toString();
            Integer strLength = new Integer(tempString.length());
            StringBuffer encrBuff = new StringBuffer(strLength.toString());
            encrBuff.append(BUFF_SEPARATOR);
            encrBuff.append(tempString);
            return sm_encryption.pack(encrBuff.toString());
        }
        return new String("");
    }

    private static String GetRandomString(long seed, int length) {
        Random sequence = new Random(seed);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int rand = sequence.nextInt();
            int val = 33 + (rand >= 0 ? rand : rand * -1) % 93;
            buff.append((char)val);
        }
        return buff.toString();
    }

    public static String decryptPassword(String password) throws SDKException {
        if (password != null && !password.equals("")) {
            String decryptString = sm_encryption.unpack(password);
            if (decryptString == null) {
                throw new SDKException.Unexpected();
            }
            String[] arr = new String[3];
            AuthUtil.ParseString(decryptString, BUFF_SEPARATOR, arr);
            if (arr[0] == null || arr[1] == null || arr[2] == null) {
                throw new SDKException.Unexpected();
            }
            Integer length = IntegerConversion.parseInteger((String)arr[0]);
            if (length == null) {
                throw new NumberFormatException(arr[0]);
            }
            Integer expectedLength = new Integer(arr[1].length() + arr[2].length() + 1);
            if (length.equals(expectedLength)) {
                return new String(arr[2]);
            }
            throw new SDKException.Unexpected();
        }
        return password;
    }

    public static String GetErrorString(int index) {
        if (0 <= index && index < sm_ErrorStrings.length) {
            return sm_ErrorStrings[index];
        }
        return null;
    }

    public static String GetClientIP() throws UnknownHostException {
        InetAddress thisAddress = InetAddress.getLocalHost();
        return thisAddress.getHostAddress();
    }

    public static String GenerateResponseNoIP(String errrorString, String userCredential, String responseMsg) throws SILibException, UnsupportedEncodingException {
        String[] arr = new String[]{errrorString, userCredential, errrorString};
        String clientDigest = AuthUtil.GenerateDigest(AuthUtil.ConcatString(arr, DIGEST_SEPARATOR));
        StringBuffer buffer = new StringBuffer(clientDigest);
        buffer.append(responseMsg);
        return AuthUtil.GenerateDigest(buffer.toString());
    }

    public static String GenerateResponse(String string1, String string2, String string3, String string4) throws SILibException, UnsupportedEncodingException {
        String[] arr = new String[]{string1, string2, string3, string1};
        String clientDigest = AuthUtil.GenerateDigest(AuthUtil.ConcatString(arr, DIGEST_SEPARATOR));
        StringBuffer buffer = new StringBuffer(clientDigest);
        buffer.append(string4);
        return AuthUtil.GenerateDigest(buffer.toString());
    }

    private static String GenerateDigest(String inString) throws SILibException, UnsupportedEncodingException {
        byte[] utf8ByteDigest = inString.getBytes("UTF8");
        Digest digest = MD5.digest((byte[])utf8ByteDigest, (int)utf8ByteDigest.length);
        return digest.toString();
    }
}

