/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.enterprise.internal;

import com.crystaldecisions.celib.stringhandler.StringHandler;
import com.crystaldecisions.celib.stringhandler.StringHandlerFactory;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.authentication.enterprise.IsecEnterprise;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.util.Date;

class EnterpriseDesktop
extends AbstractInfoObject
implements IsecEnterprise {
    private static final Integer AUTHPLUGINS = new Integer(26);
    private static final StringHandler s_encrypter = StringHandlerFactory.getDefaultStringHandler();

    EnterpriseDesktop() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, AUTHPLUGINS);
        ((SDKPropertyBag)this.properties()).setStringHandler(s_encrypter);
    }

    public int getMaxPasswordAge() {
        return this.getPropInt(PropertyIDs.SI_MAX_PASSWORD_AGE);
    }

    public void setMaxPasswordAge(int seconds) {
        this.setProperty(PropertyIDs.SI_MAX_PASSWORD_AGE, seconds);
    }

    public boolean isPasswordAgeEnforced() {
        return this.getPropBool(PropertyIDs.SI_ENFORCE_MAX_PASSWORD_AGE);
    }

    public void setMaxPasswordAgeEnforced(boolean enforce) {
        this.setProperty(PropertyIDs.SI_ENFORCE_MAX_PASSWORD_AGE, enforce);
    }

    public int getMinPasswordLength() {
        return this.getPropInt(PropertyIDs.SI_MIN_PASSWORD_LENGTH);
    }

    public void setMinPasswordLength(int length) {
        this.setProperty(PropertyIDs.SI_MIN_PASSWORD_LENGTH, length);
    }

    public boolean isMinPasswordLengthEnforced() {
        return this.getPropBool(PropertyIDs.SI_ENFORCE_MIN_PASSWORD_LENGTH);
    }

    public void setMinPasswordLengthEnforced(boolean enforce) {
        this.setProperty(PropertyIDs.SI_ENFORCE_MIN_PASSWORD_LENGTH, enforce);
    }

    public int getUnableToRepeatNPasswords() {
        return this.getPropInt(PropertyIDs.SI_UNABLE_TO_REPEAT_LAST_N_PASSWORDS);
    }

    public void setUnableToRepeatNPasswords(int numPasswords) {
        this.setProperty(PropertyIDs.SI_UNABLE_TO_REPEAT_LAST_N_PASSWORDS, numPasswords);
    }

    public boolean isUnableToRepeatNPasswordsEnforced() {
        return this.getPropBool(PropertyIDs.SI_ENFORCE_UNABLE_TO_REPEAT_LAST_N_PASSWORDS);
    }

    public void setUnableToRepeatNPasswordsEnforced(boolean enforce) {
        this.setProperty(PropertyIDs.SI_ENFORCE_UNABLE_TO_REPEAT_LAST_N_PASSWORDS, enforce);
    }

    public int getReenableAccountTime() {
        return this.getPropInt(PropertyIDs.SI_REENABLE_ACCOUNT_TIME);
    }

    public void setReenableAccountTime(int seconds) {
        this.setProperty(PropertyIDs.SI_REENABLE_ACCOUNT_TIME, seconds);
    }

    public boolean isReenableAccountTimeEnforced() {
        return this.getPropBool(PropertyIDs.SI_ENFORCE_REENABLE_ACCOUNT_TIME);
    }

    public void setReenableAccountTimeEnforced(boolean enforce) {
        this.setProperty(PropertyIDs.SI_ENFORCE_REENABLE_ACCOUNT_TIME, enforce);
    }

    public int getMinTimeBetweenPasswordChanges() {
        return this.getPropInt(PropertyIDs.SI_MIN_TIME_BETWEEN_PASSWORD_CHANGES);
    }

    public void setMinTimeBetweenPasswordChanges(int seconds) {
        this.setProperty(PropertyIDs.SI_MIN_TIME_BETWEEN_PASSWORD_CHANGES, seconds);
    }

    public boolean isAccountDisabledAfterNFailedLogins() {
        return this.getPropBool(PropertyIDs.SI_DISABLE_ACCOUNT_AFTER_N_FAILED_LOGINS);
    }

    public void setAccountDisabledAfterNFailedLogins(boolean disable) {
        this.setProperty(PropertyIDs.SI_DISABLE_ACCOUNT_AFTER_N_FAILED_LOGINS, disable);
    }

    public int getMaxNumberOfAttempts() {
        return this.getPropInt(PropertyIDs.SI_MAX_NUMBER_OF_ATTEMPTS);
    }

    public void setMaxNumberOfAttempts(int attempts) {
        this.setProperty(PropertyIDs.SI_MAX_NUMBER_OF_ATTEMPTS, attempts);
    }

    public int getResetLogonAttemptCount() {
        return this.getPropInt(PropertyIDs.SI_FAILED_LOGIN_COUNTER_RESET_TIME);
    }

    public void setResetLogonAttemptCount(int seconds) {
        this.setProperty(PropertyIDs.SI_FAILED_LOGIN_COUNTER_RESET_TIME, seconds);
    }

    public boolean isMixedCaseEnforced() {
        return this.getPropBool(PropertyIDs.SI_FORCE_MIXED_CASE);
    }

    public void setMixedCaseEnforced(boolean enforce) {
        this.setProperty(PropertyIDs.SI_FORCE_MIXED_CASE, enforce);
    }

    public boolean isTrustedAuthenticationEnabled() {
        IProperty prop = this.getProperty(PropertyIDs.SI_TRUSTED_AUTH_ENABLED);
        if (prop != null) {
            Object value = prop.getValue();
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new SDKRuntimeException.Unexpected();
        }
        return false;
    }

    public void setTrustedAuthenticationEnabled(boolean value) {
        this.setProperty(PropertyIDs.SI_TRUSTED_AUTH_ENABLED, value);
    }

    public void setSharedSecret(String value) throws SDKException {
        if (value == null || value.trim().length() == 0) {
            throw new SDKException.InvalidArg("value");
        }
        this.properties().add(PropertyIDs.SI_SHARED_SECRET, value, 0x1800000);
    }

    public boolean isSharedSecretNotEmpty() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_SHARED_SECRET);
        return prop != null && !"".equals(s_encrypter.unpack((String)prop.getValue()));
    }

    public int getTrustedPrincipalValidTime() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_TRUSTEDUSER_VALIDMS);
        if (prop != null) {
            Object value = prop.getValue();
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new SDKRuntimeException.Unexpected();
        }
        return 0;
    }

    public void setTrustedPrincipalValidTime(int time) {
        this.setProperty(PropertyIDs.SI_TRUSTEDUSER_VALIDMS, time);
    }

    public int getMaxSharedSecretAge() {
        return this.getPropInt(PropertyIDs.SI_MAX_SHAREDSECRET_AGE);
    }

    public void setMaxSharedSecretAge(int days) {
        this.setProperty(PropertyIDs.SI_MAX_SHAREDSECRET_AGE, days);
    }

    public Date getLastSharedSecretChangeTime() {
        return this.getPropDate(PropertyIDs.SI_LAST_SHAREDSECRET_CHANGE_TIME);
    }

    private int getPropInt(Integer id) {
        IProperty prop = this.getProperty(id);
        if (prop != null) {
            Object value = prop.getValue();
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new SDKRuntimeException.Unexpected();
        }
        throw new SDKRuntimeException.PropertyNotFound(PropertyIDs.idToName(id));
    }

    private boolean getPropBool(Integer id) {
        IProperty prop = this.getProperty(id);
        if (prop != null) {
            Object value = prop.getValue();
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new SDKRuntimeException.Unexpected();
        }
        throw new SDKRuntimeException.PropertyNotFound(PropertyIDs.idToName(id));
    }

    private Date getPropDate(Integer id) {
        IProperty prop = this.getProperty(id);
        if (prop != null) {
            Object value = prop.getValue();
            if (value instanceof Date) {
                return (Date)value;
            }
            throw new SDKRuntimeException.Unexpected();
        }
        throw new SDKRuntimeException.PropertyNotFound(PropertyIDs.idToName(id));
    }

    private void setProperty(Integer id, int value) {
        this.setProperty((Object)id, new Integer(value));
    }

    private void setProperty(Integer id, boolean value) {
        this.setProperty((Object)id, value ? Boolean.TRUE : Boolean.FALSE);
    }
}

