/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.ldap.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.internal.AbstractSecurityPlugIn;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityPlugIn;
import com.crystaldecisions.sdk.plugin.authentication.common.AuthUtil;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPError;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPHostInfoHelper;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPImpl;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPParameters;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPSSLParameters;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPSchema;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class LDAPAuthentication
extends AbstractSecurityPlugIn
implements ISecurityPlugIn {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPAuthentication");
    private static ThreadLocal sm_threadLocal = new ThreadLocal();

    public boolean needParams() {
        return true;
    }

    public long getPackageVersion() {
        return 2L;
    }

    public void initPackage() throws SDKException {
    }

    public void termPackage() {
    }

    public void setClientParasSeq(IProperties props) throws SDKException {
        try {
            LDAPParameters param = this.ExtractParameters(props);
            this.setLDAPParam(param);
        }
        catch (SDKException sdkE) {
            throw sdkE;
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
    }

    public int startLogin(String userName, String password, String serverName, OutputStream out) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"startLogin(): enter");
        }
        try {
            LDAPParameters param = this.getLDAPParam();
            LDAPImpl LDAP = new LDAPImpl(param);
            String userDN = LDAP.LogonUser(userName, password);
            return this.GenerateClientContext(userDN, null, out);
        }
        catch (SDKException sdkE) {
            throw sdkE;
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"startLogin(): exit");
            }
            return -1;
        }
    }

    public int continueLogin(byte[] inBuffer, OutputStream outBuffer) throws SDKException {
        try {
            return this.GenerateClientContext(null, inBuffer, outBuffer);
        }
        catch (SDKException sdkE) {
            throw sdkE;
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
            return -1;
        }
    }

    private int GenerateClientContext(String userDN, byte[] inBuffer, OutputStream outBuffer) throws SDKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"GenerateClientContext(): enter");
        }
        if (inBuffer == null) {
            String zeroString = new String("0");
            this.PackBuffer(zeroString, zeroString, userDN, outBuffer);
            SessionInfo session = new SessionInfo();
            session.SetCredentials(userDN);
            this.setSessionInfo(session);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"GenerateClientContext(): exit with NEEDS_CONTINUE");
            }
            return 1;
        }
        try {
            String errString = AuthUtil.GetErrorString(2);
            SessionInfo session = this.getSessionInfo();
            if (session == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"GenerateClientContext(): no session info avaiable");
                }
                LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
            }
            String[] arr = new String[3];
            this.UnPackBuffer(inBuffer, arr);
            String response = AuthUtil.GenerateResponseNoIP(errString, session.GetCredentials(), arr[2]);
            this.PackBuffer(arr[1], arr[0], response, outBuffer);
            this.setSessionInfo(null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"GenerateClientContext(): exit with GRANTED");
            }
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
        return 2;
    }

    private void UnPackBuffer(byte[] inBuffer, String[] outArr) throws SDKException {
        try {
            String inString = new String(inBuffer, 0, inBuffer.length - 1, "UTF-8");
            AuthUtil.ParseString(inString, "\n", outArr);
        }
        catch (UnsupportedEncodingException e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
    }

    private void PackBuffer(String inString1, String inString2, String inString3, OutputStream outBuffer) throws SDKException {
        String[] arr = new String[]{inString1, inString2, inString3};
        String temp = AuthUtil.ConcatString(arr, "\n");
        try {
            byte[] utf8BytesBuffer = temp.getBytes("UTF-8");
            outBuffer.write(utf8BytesBuffer);
            outBuffer.write(0);
        }
        catch (UnsupportedEncodingException e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
        catch (IOException e) {
            throw new SDKException.Unexpected(e);
        }
    }

    private LDAPParameters ExtractParameters(IProperties props) throws SDKException {
        LDAPParameters param = new LDAPParameters();
        LDAPSchema schema = param.m_Schema;
        LDAPSSLParameters sslParam = param.m_SSLParams;
        PropertyBag bag = (PropertyBag)props;
        param.m_AVAIL = bag.getInt((Object)PropertyIDs.SI_AVAIL);
        param.m_HOST_AND_PORT = bag.getString((Object)PropertyIDs.SI_HOST_AND_PORT);
        param.m_BASE_DN = bag.getString((Object)PropertyIDs.SI_BASE_DN);
        param.m_REFERRAL_DN = bag.getString((Object)PropertyIDs.SI_REFERRAL_DN);
        param.m_REFERRAL_PWD = AuthUtil.decryptPassword(bag.getString((Object)PropertyIDs.SI_REFERRAL_PWD));
        param.m_APS_ADMIN_DN = bag.getString((Object)PropertyIDs.SI_APS_ADMIN_DN);
        param.m_APS_ADMIN_PWD = AuthUtil.decryptPassword(bag.getString((Object)PropertyIDs.SI_APS_ADMIN_PWD));
        param.m_MAX_REFERRAL_HOPS = bag.getInt((Object)PropertyIDs.SI_MAX_REFERRAL_HOPS);
        param.m_AUTH_TYPE = bag.getInt((Object)PropertyIDs.SI_AUTH_TYPE);
        int enabled = bag.getInt((Object)PropertyIDs.SI_SSO_ENABLED);
        param.m_SSO_ENBALED = enabled == 1;
        param.m_SSO_VENDOR = bag.getInt((Object)PropertyIDs.SI_SSO_VENDOR);
        param.m_SSO_SERVER_AND_PORTS = bag.getString((Object)PropertyIDs.SI_SSO_SERVERS_AND_PORTS);
        param.m_SSO_SHARED_SECRETS = bag.getString((Object)PropertyIDs.SI_SSO_SHARED_SECRET);
        param.m_SSO_AGENT = bag.getString((Object)PropertyIDs.SI_SSO_AGENT);
        param.m_SSO_ACCESS_MODE = bag.getInt((Object)PropertyIDs.SI_SSO_ACCESS_MODE);
        String dir1 = LDAPHostInfoHelper.findBestMatch(bag.getString((Object)PropertyIDs.SI_CERTIFICATE_DB_PATH), false, "cacerts");
        sslParam.m_TrustStorePath = new File(dir1, "cacerts").getPath();
        String dir2 = LDAPHostInfoHelper.findBestMatch(bag.getString((Object)PropertyIDs.SI_KEY_DB_PATH), false, ".keystore");
        sslParam.m_KeyStorePath = new File(dir2, ".keystore").getPath();
        param.m_SEC_MOD_PATH = bag.getString((Object)PropertyIDs.SI_SEC_MOD_PATH);
        schema.m_User = bag.getString((Object)PropertyIDs.SI_USER_ATTR);
        schema.m_StaticGroup = bag.getString((Object)PropertyIDs.SI_STATIC_GROUP_ATTR);
        schema.m_DynamicGroup = bag.getString((Object)PropertyIDs.SI_DYNAMIC_GROUP_ATTR);
        schema.m_StaticGroupMember = bag.getString((Object)PropertyIDs.SI_STATIC_GROUP_MEMBER_ATTR);
        schema.m_DynamicGroupURL = bag.getString((Object)PropertyIDs.SI_DYNAMIC_GROUP_URL_ATTR);
        schema.m_FirstUserRDN = bag.getString((Object)PropertyIDs.SI_DEFAULT_USER_SEARCH_ATTR);
        schema.m_FirstGroupRDN = bag.getString((Object)PropertyIDs.SI_DEFAULT_GROUP_SEARCH_ATTR);
        schema.m_UserDescription = bag.getString((Object)PropertyIDs.SI_USER_DESC_ATTR);
        schema.m_GroupDescription = bag.getString((Object)PropertyIDs.SI_GROUP_DESC_ATTR);
        schema.m_ObjectClass = bag.getString((Object)PropertyIDs.SI_OBJECT_CLASS_ATTR);
        sslParam.m_NickName = LDAPHostInfoHelper.findBestMatch(bag.getString((Object)PropertyIDs.SI_CLIENT_CERT_NICKNAME), false, null);
        sslParam.m_TrustStorePwd = sslParam.m_KeyStorePwd = LDAPHostInfoHelper.findBestMatch(bag.getString((Object)PropertyIDs.SI_KEY_DB_PWD), true, null);
        sslParam.m_ServerAuthStrength = bag.getInt((Object)PropertyIDs.SI_SSL_SERVER_AUTH_STRENGTH);
        if (!param.IsInitialized()) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
        }
        return param;
    }

    private LDAPParameters getLDAPParam() throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo != null) {
                return threadInfo.m_param;
            }
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
        return null;
    }

    private SessionInfo getSessionInfo() throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo != null) {
                return threadInfo.m_session;
            }
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
        return null;
    }

    private void setLDAPParam(LDAPParameters param) throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo == null) {
                threadInfo = new ThreadInfo();
            }
            threadInfo.m_param = param;
            sm_threadLocal.set(threadInfo);
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
    }

    private void setSessionInfo(SessionInfo session) throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo == null) {
                threadInfo = new ThreadInfo();
            }
            threadInfo.m_session = session;
            sm_threadLocal.set(threadInfo);
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
    }

    private void releaseThreadInfo() {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            sm_threadLocal.set(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class ThreadInfo {
        public LDAPParameters m_param;
        public SessionInfo m_session;
    }

    public class SessionInfo {
        private String m_LdapUserCredentials;
        private String m_LdapServerChallenge;

        public void SetCredentials(String in) {
            this.m_LdapUserCredentials = in;
        }

        public String GetCredentials() {
            return this.m_LdapUserCredentials;
        }

        public void SetChallenge(String in) {
            this.m_LdapServerChallenge = in;
        }

        public String GetChallenge() {
            return this.m_LdapServerChallenge;
        }
    }
}

