/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.ldap.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.celib.properties.URLDecoder;
import com.crystaldecisions.celib.stringhandler.SIStringHandler;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.authentication.common.AuthUtil;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPError;
import com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPParameters;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPImpl {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPImpl");
    private static final String InitalContextFactory = new String("com.sun.jndi.ldap.LdapCtxFactory");
    private static final String LDAP_URL_Prefix = new String("ldap://");
    private static final String URL_BASE_SEP = new String("/");
    private static final String URL_COMP_SEP = new String("?");
    private static final String HOST_SEP = new String(" ");
    private static final String DN_SEP = new String(",");
    private static final String DN_SEP_SPACE = new String(", ");
    private static final String PORT_SEP = new String(":");
    private static final String NV_SEP = new String("=");
    private static final String LEFT_BRACKET = new String("(");
    private static final String RIGHT_BRACKET = new String(")");
    private static final String AND = new String("&");
    private static final String OR = new String("|");
    private static final String SIMPLE_AUTH = new String("simple");
    private static final String LDAP_PORT = new String("389");
    private static final String LDAP_VERSION = new String("3");
    private static final String SSO_MARKER = new String("*SSOINFO*");
    private LDAPParameters m_param;

    public LDAPImpl(LDAPParameters param) {
        this.m_param = param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String LogonUser(String userName, String password) throws SDKException {
        String userDN;
        block24: {
            DirContext ictx;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"LogonUser(): enter");
            }
            if (this.m_param == null || !this.m_param.IsInitialized()) {
                LOG.error((Object)"LogonUser(): parameters not initialized");
                LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
            }
            if (userName == null || userName.equals("")) {
                LOG.error((Object)"LogonUser(): input username initialized");
                LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_SSO_NOT_SUPPORTED, null, null);
            }
            if (this.m_param.m_AVAIL <= 0) {
                LOG.error((Object)"LogonUser(): secldap not available");
                LDAPError.ThrowException(LDAPError.IDS_ERR_S_DLL_UNAVAILABLE, new String[]{"secLDAP"}, null);
            }
            userDN = null;
            if (password == null || password.equals("")) {
                if (this.m_param.m_SSO_ENBALED) {
                    SIStringHandler encrypt = new SIStringHandler();
                    userDN = encrypt.pack(userName);
                    userDN = SSO_MARKER + userDN;
                } else {
                    LOG.error((Object)"LogonUser(): input password is empty");
                    LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_NO_PASSWORD, null, null);
                }
            } else {
                ictx = null;
                Hashtable inOutEnv = this.GetBaseEnvironment();
                ictx = this.GetDirContext(inOutEnv);
                LOG.assertNotNull((Object)ictx, "ictx is null.");
                userDN = this.GetUserDNandLogonEnvironment(ictx, inOutEnv, userName);
                LOG.assertNotNull((Object)userDN, "userDN");
                inOutEnv.put("java.naming.security.principal", userDN);
                inOutEnv.put("java.naming.security.credentials", password);
                ictx = new InitialDirContext(inOutEnv);
                Object var8_10 = null;
                try {
                    if (ictx != null) {
                        ictx.close();
                        ictx = null;
                    }
                    break block24;
                }
                catch (NamingException e2) {}
            }
            break block24;
            {
                catch (NamingException ne) {
                    String[] arr = new String[]{this.m_param.m_BASE_DN};
                    LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_AUTHENTICATION_FAILURE, arr, ne);
                    Object var8_11 = null;
                    try {
                        if (ictx != null) {
                            ictx.close();
                            ictx = null;
                        }
                        break block24;
                    }
                    catch (NamingException e2) {}
                    break block24;
                }
                catch (SDKException sdke) {
                    throw sdke;
                }
                catch (Exception e) {
                    LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
                    Object var8_12 = null;
                    try {
                        if (ictx != null) {
                            ictx.close();
                            ictx = null;
                        }
                        break block24;
                    }
                    catch (NamingException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                try {
                    if (ictx != null) {
                        ictx.close();
                        ictx = null;
                    }
                }
                catch (NamingException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"LogonUser(): exit");
        }
        return userDN;
    }

    private String AddBrackets(String inString) {
        boolean bHasRightBracket;
        boolean bHasLeftBracket = 0 == inString.indexOf(LEFT_BRACKET, 0);
        boolean bl = bHasRightBracket = inString.length() - 1 == inString.indexOf(RIGHT_BRACKET, inString.length() - 1);
        if (!bHasLeftBracket || !bHasRightBracket) {
            StringBuffer buff = new StringBuffer();
            buff.append(LEFT_BRACKET);
            buff.append(inString);
            buff.append(RIGHT_BRACKET);
            return buff.toString();
        }
        return inString;
    }

    private String ConstructBasicFilter(String[] arr, boolean bAddBrackets) {
        StringBuffer buff = new StringBuffer();
        if (bAddBrackets) {
            buff.append(LEFT_BRACKET);
        }
        buff.append(AuthUtil.ConcatString(arr, NV_SEP));
        if (bAddBrackets) {
            buff.append(RIGHT_BRACKET);
        }
        return buff.toString();
    }

    private String ConstructLogicFilter(String[] elements, String logicArg) {
        StringBuffer buff = new StringBuffer(LEFT_BRACKET);
        buff.append(logicArg);
        for (int i = 0; i < elements.length; ++i) {
            buff.append(elements[i]);
        }
        buff.append(RIGHT_BRACKET);
        return buff.toString();
    }

    private String[] ParseHosts(String hostsAndPorts) throws SDKException {
        String[] hosts = AuthUtil.ParseString(hostsAndPorts, HOST_SEP);
        if (0 == hosts.length) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
        }
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = this.AddDefaultPortIfRequired(hosts[i]);
        }
        return hosts;
    }

    private String AddDefaultPortIfRequired(String host) {
        if (-1 != host.indexOf(PORT_SEP, 0)) {
            return host;
        }
        String[] temp = new String[]{host, LDAP_PORT};
        return AuthUtil.ConcatString(temp, PORT_SEP);
    }

    private String[] FormatProviderURLs(String[] hostAndPorts) throws SDKException {
        if (0 == hostAndPorts.length) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
        }
        String[] out = new String[hostAndPorts.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.FormatProviderURL(hostAndPorts[i]);
        }
        return out;
    }

    private String FormatProviderURL(String hostAndPort) {
        String[] temp = new String[]{LDAP_URL_Prefix, hostAndPort};
        return AuthUtil.ConcatString(temp, null);
    }

    private String[] ExtractProviderURLandBaseDN(String providerURLandBase) throws SDKException {
        if (providerURLandBase == null || providerURLandBase.equals("")) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
        }
        try {
            int start = 0;
            int end = 0;
            int sepCount = 0;
            while (end != -1) {
                end = providerURLandBase.indexOf(URL_BASE_SEP, start);
                if (end != -1) {
                    ++sepCount;
                    start = end + 1;
                    continue;
                }
                --start;
            }
            if (2 == sepCount || 3 == sepCount && 0 < start) {
                String[] arr = new String[2];
                if (2 == sepCount) {
                    arr[0] = new String(providerURLandBase);
                    arr[1] = null;
                } else {
                    arr[0] = new String(providerURLandBase.substring(0, start));
                    arr[1] = ++start < (end = providerURLandBase.indexOf(URL_COMP_SEP, start)) ? new String(providerURLandBase.substring(start, end)) : new String(providerURLandBase.substring(start));
                }
                return arr;
            }
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
        }
        catch (SDKException sdke) {
            throw sdke;
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
        return null;
    }

    private String FormatURL_Where(String providerURL, String baseDN) {
        String[] temp = new String[]{providerURL, baseDN};
        return AuthUtil.ConcatString(temp, URL_BASE_SEP);
    }

    private int FindNonLiteralDNDelim(String dn, String delim) {
        int index = dn.indexOf(delim);
        while (-1 != index && 0 != index) {
            int tmpIndex = index - 1;
            int numBackslashes = 0;
            if (dn.charAt(tmpIndex) == '\\') {
                do {
                    ++numBackslashes;
                } while (0 != tmpIndex && dn.charAt(--tmpIndex) == '\\');
            }
            if (0 == (numBackslashes & 1)) break;
            if (++index >= dn.length()) {
                return -1;
            }
            index = dn.indexOf(delim, index);
        }
        return index;
    }

    private String encodeDN(String name) {
        try {
            byte[] utf8Bytes = name.getBytes("UTF-8");
            String encodedName = "";
            for (int i = 0; i < utf8Bytes.length; ++i) {
                String hexVal = Integer.toHexString(utf8Bytes[i]);
                encodedName = hexVal.length() == 2 ? encodedName + "%" + hexVal : encodedName + "%0" + hexVal;
            }
            return encodedName;
        }
        catch (UnsupportedEncodingException x) {
            x.printStackTrace();
            return name;
        }
    }

    private String[] FormatFilterAndBaseDN(String name) throws SDKException {
        String[] arr = new String[2];
        if (-1 != this.FindNonLiteralDNDelim(name, NV_SEP)) {
            int start = 0;
            int end = 0;
            end = this.FindNonLiteralDNDelim(name, DN_SEP);
            if (-1 != end) {
                String temp = name.substring(start, end);
                temp.trim();
                arr[0] = this.AddBrackets(temp);
                arr[1] = name.substring(end + 1);
                arr[1].trim();
            } else {
                name.trim();
                arr[0] = this.AddBrackets(name);
                arr[1] = name;
            }
        } else {
            String[] temp = new String[]{this.m_param.m_Schema.m_FirstUserRDN, name};
            arr[0] = this.ConstructBasicFilter(temp, true);
            arr[1] = this.m_param.m_BASE_DN;
        }
        if (arr[0] != null && arr[1] != null) {
            return arr;
        }
        LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, null);
        return null;
    }

    private Hashtable GetBaseEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", InitalContextFactory);
        env.put("java.naming.security.authentication", SIMPLE_AUTH);
        env.put("java.naming.ldap.version", LDAP_VERSION);
        env.put("java.naming.referral", "throw");
        env.put("java.naming.ldap.derefAliases", "never");
        return env;
    }

    private DirContext GetDirContext(Hashtable env) throws SDKException {
        InitialDirContext ictx = null;
        try {
            boolean bHaveRefCred = this.m_param.HaveReferralCredentials();
            boolean bHaveAdminCred = this.m_param.HaveAdminCredentials();
            String[] providerURLs = this.FormatProviderURLs(this.ParseHosts(this.m_param.m_HOST_AND_PORT));
            block7: for (int providerIndex = 0; ictx == null && providerIndex < providerURLs.length; ++providerIndex) {
                env.put("java.naming.provider.url", providerURLs[providerIndex]);
                if (bHaveAdminCred) {
                    env.put("java.naming.security.principal", this.m_param.m_APS_ADMIN_DN);
                    env.put("java.naming.security.credentials", this.m_param.m_APS_ADMIN_PWD);
                } else if (0 < providerIndex && bHaveRefCred) {
                    env.put("java.naming.security.principal", this.m_param.m_REFERRAL_DN);
                    env.put("java.naming.security.credentials", this.m_param.m_REFERRAL_PWD);
                } else {
                    env.remove("java.naming.security.principal");
                    env.remove("java.naming.security.credentials");
                }
                this.m_param.m_SSLParams.configureSSL(this.m_param.m_AUTH_TYPE, env);
                try {
                    ictx = new InitialDirContext(env);
                    return ictx;
                }
                catch (NamingException ne1) {
                    LOG.error((Object)"GetDirContext(): Failed to obtain InitialDirContext", (Throwable)ne1);
                    if (0 >= providerIndex) continue;
                    if (bHaveAdminCred) {
                        if (bHaveRefCred) {
                            env.put("java.naming.security.principal", this.m_param.m_REFERRAL_DN);
                            env.put("java.naming.security.credentials", this.m_param.m_REFERRAL_PWD);
                        } else {
                            env.remove("java.naming.security.principal");
                            env.remove("java.naming.security.credentials");
                        }
                    } else if (bHaveRefCred) {
                        env.remove("java.naming.security.principal");
                        env.remove("java.naming.security.credentials");
                    }
                    for (int count = 0; ictx == null && count < 2; ++count) {
                        try {
                            ictx = new InitialDirContext(env);
                            return ictx;
                        }
                        catch (NamingException ne2) {
                            LOG.error((Object)("GetDirContext(): Failed to obtain InitialDirContext " + count), (Throwable)ne2);
                            if (!bHaveRefCred || count != 0) continue block7;
                            env.remove("java.naming.security.principal");
                            env.remove("java.naming.security.credentials");
                            continue;
                        }
                    }
                    continue;
                }
            }
        }
        catch (SDKException sdke) {
            throw sdke;
        }
        catch (Exception e) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
        }
        if (ictx == null) {
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_FAILED_VERIFY_HOSTS, null, null);
        }
        return ictx;
    }

    private SearchControls GetSearchControls() {
        String[] attrArr = new String[]{new String(this.m_param.m_Schema.m_ObjectClass)};
        return new SearchControls(2, 0L, 0, attrArr, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String GetUserDNandLogonEnvironment(DirContext ictx, Hashtable env, String userName) throws SDKException {
        String userDN;
        block38: {
            LOG.assertNotNull((Object)ictx, "ictx is null.");
            userDN = null;
            CSimpleTreeNode curNode = new CSimpleTreeNode();
            boolean bHaveRefCred = this.m_param.HaveReferralCredentials();
            long maxReferralHops = this.m_param.m_MAX_REFERRAL_HOPS;
            long refHopsCounter = 0L;
            String providerURL = (String)env.get("java.naming.provider.url");
            String[] RDNarr = this.FormatFilterAndBaseDN(userName);
            String userFilter = RDNarr[0];
            String baseDN = RDNarr[1];
            curNode.m_URL = this.FormatURL_Where(providerURL, this.encodeDN(baseDN));
            SearchControls control = this.GetSearchControls();
            block16: while (ictx != null && refHopsCounter <= maxReferralHops) {
                try {
                    NamingEnumeration<SearchResult> nenum1 = ictx.search(curNode.m_URL, userFilter, control);
                    if (nenum1 == null) break;
                    if (nenum1.hasMore()) {
                        SearchResult someObject = nenum1.next();
                        Attributes attrs = someObject.getAttributes();
                        Attribute attr = attrs.get(this.m_param.m_Schema.m_ObjectClass);
                        boolean bIsValidObjClass = false;
                        for (int i = 0; i < attr.size(); ++i) {
                            if (0 != this.m_param.m_Schema.m_User.compareToIgnoreCase((String)attr.get(i))) continue;
                            bIsValidObjClass = true;
                            break;
                        }
                        if (bIsValidObjClass) {
                            ArrayList<String> arr = new ArrayList<String>();
                            String rDN = someObject.getName();
                            if (rDN.indexOf(92) >= 0) {
                                try {
                                    CompositeName compDN = new CompositeName(rDN);
                                    if (compDN.size() > 0) {
                                        rDN = compDN.get(0);
                                    }
                                }
                                catch (Exception x) {
                                    x.printStackTrace();
                                }
                            }
                            if (!rDN.equals("")) {
                                arr.add(rDN);
                            }
                            if (baseDN != null && !baseDN.equals("")) {
                                arr.add(baseDN);
                            }
                            userDN = AuthUtil.ConcatString(arr.toArray(new String[arr.size()]), DN_SEP_SPACE);
                        }
                    }
                    nenum1.close();
                    nenum1 = null;
                    break;
                }
                catch (ReferralException re) {
                    CSimpleTreeNode cur;
                    if (++refHopsCounter > maxReferralHops) break;
                    env.remove("java.naming.provider.url");
                    curNode.m_URL = baseDN;
                    String URL_list = "";
                    CSimpleTreeNode first = cur = new CSimpleTreeNode();
                    do {
                        cur.m_parent = curNode;
                        if (cur.m_URL != null) {
                            cur = cur.m_next = new CSimpleTreeNode();
                        }
                        String URL2 = (String)re.getReferralInfo();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("GetUserDNandLogonEnvironment(): Referral info = " + URL2));
                        }
                        URL2 = URLDecoder.decode((String)URL2);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("GetUserDNandLogonEnvironment(): Decoded referral info = " + URL2));
                        }
                        String[] providerURLAndBaseDN = this.ExtractProviderURLandBaseDN(URL2);
                        LOG.assertNotNull((Object)providerURLAndBaseDN, "providerURLAndBaseDN");
                        LOG.assertTrue(2 == providerURLAndBaseDN.length, "Assertion failed");
                        cur.m_URL = providerURLAndBaseDN[0] + '/' + baseDN;
                        URL_list = URL_list + ' ' + cur.m_URL;
                    } while (re.skipReferral());
                    URL_list = URL_list.trim();
                    curNode = first;
                    env.put("java.naming.provider.url", URL_list);
                    if (bHaveRefCred) {
                        env.put("java.naming.security.principal", this.m_param.m_REFERRAL_DN);
                        env.put("java.naming.security.credentials", this.m_param.m_REFERRAL_PWD);
                    } else {
                        env.remove("java.naming.security.principal");
                        env.remove("java.naming.security.credentials");
                    }
                    ictx.close();
                    ictx = null;
                    for (int count = 0; ictx == null && count < 2; ++count) {
                        try {
                            ictx = new InitialDirContext(env);
                            continue block16;
                        }
                        catch (NamingException ne2) {
                            if (bHaveRefCred && count == 0) {
                                env.remove("java.naming.security.principal");
                                env.remove("java.naming.security.credentials");
                                continue;
                            }
                            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_FAILED_VERIFY_HOSTS, null, ne2);
                            continue;
                        }
                    }
                }
                catch (NamingException ne) {
                    String[] arr = new String[]{this.m_param.m_BASE_DN};
                    if (curNode.m_next == null) {
                        do {
                            --refHopsCounter;
                            curNode = curNode.m_parent;
                            if (curNode != null) continue;
                            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_AUTHENTICATION_FAILURE, arr, ne);
                        } while (curNode.m_next == null);
                        curNode = curNode.m_next;
                        continue;
                    }
                    curNode = curNode.m_next;
                }
            }
            Object var25_33 = null;
            try {
                if (ictx != null) {
                    ictx.close();
                    ictx = null;
                }
                break block38;
            }
            catch (NamingException e2) {}
            break block38;
            {
                catch (SDKException sdke) {
                    throw sdke;
                }
                catch (Exception e) {
                    LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_INTERNAL_ERROR, null, e);
                    Object var25_34 = null;
                    try {
                        if (ictx != null) {
                            ictx.close();
                            ictx = null;
                        }
                        break block38;
                    }
                    catch (NamingException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var25_35 = null;
                try {
                    if (ictx != null) {
                        ictx.close();
                        ictx = null;
                    }
                }
                catch (NamingException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (userDN == null) {
            String[] arr = new String[]{this.m_param.m_BASE_DN};
            LDAPError.ThrowException(LDAPError.IDS_ERR_LDAP_AUTHENTICATION_FAILURE, arr, null);
        }
        env.remove("java.naming.security.principal");
        env.remove("java.naming.security.credentials");
        return userDN;
    }

    static {
        String provider = System.getProperty("crystal.enterprise.SSLProvider", "com.sun.net.ssl.internal.ssl.Provider");
        try {
            Class cls = ClassLoaderHelper.loadClass((String)provider);
            Security.addProvider((Provider)cls.newInstance());
        }
        catch (Throwable e) {
            LOG.warn((Object)("Can't load security provider:" + provider), e);
        }
    }

    private static class CSimpleTreeNode {
        public CSimpleTreeNode m_parent;
        public CSimpleTreeNode m_next;
        public String m_URL;

        private CSimpleTreeNode() {
        }
    }
}

