/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.ldap.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Hashtable;

public class LDAPSSLParameters {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.authentication.ldap.internal.LDAPSSLParameters");
    public static final int SI_CERTIFICATE_DB_PATH = PropertyIDs.SI_CERTIFICATE_DB_PATH;
    public static final int SI_KEY_DB_PATH = PropertyIDs.SI_KEY_DB_PATH;
    public static final int SI_CLIENT_CERT_NICKNAME = PropertyIDs.SI_CLIENT_CERT_NICKNAME;
    public static final int SI_KEY_DB_PWD = PropertyIDs.SI_KEY_DB_PWD;
    public static final int SI_SSL_STRENGTH = PropertyIDs.SI_SSL_SERVER_AUTH_STRENGTH;
    public static final String SSL_PROTOCOL = "ssl";
    public static final String SSL_TRUSTSTORE_NAME = "cacerts";
    public static final String SSL_KEYSTORE_NAME = ".keystore";
    public String m_TrustStorePath;
    public String m_KeyStorePath;
    public String m_TrustStorePwd;
    public String m_KeyStorePwd;
    public String m_NickName;
    public int m_ServerAuthStrength = 3;

    public void configureSSL(int authType, Hashtable env) {
        if (authType != 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("configureSSL(): auth type = " + authType));
            }
            env.put("java.naming.security.protocol", SSL_PROTOCOL);
            if (!"".equals(this.m_TrustStorePath)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("configureSSL(): truststore = " + this.m_TrustStorePath));
                }
                System.setProperty("javax.net.ssl.trustStore", this.m_TrustStorePath);
            }
            if (this.m_TrustStorePwd != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", this.m_TrustStorePwd);
            }
            if (authType == 2) {
                if (!"".equals(this.m_KeyStorePath)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("configureSSL(): keystore = " + this.m_KeyStorePath));
                    }
                    System.setProperty("javax.net.ssl.keyStore", this.m_KeyStorePath);
                }
                if (this.m_KeyStorePwd != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", this.m_KeyStorePwd);
                }
            }
        }
    }
}

