/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.secwinad.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.plugin.authentication.secwinad.internal.SecWinADParameters;
import java.security.PrivilegedAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SecWinADAction
implements PrivilegedAction {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.authentication.ldap.internal.SecWinADAction");
    private static final String KRB5_MECHANISM_OID = "1.2.840.113554.1.2.2";
    private static final String KRB5_PRINCIPALNAMETYPE_OID = "1.2.840.113554.1.2.2.1";
    private String m_userName;
    private SecWinADParameters m_param;
    private boolean m_initialized = false;
    private GSSContext m_context;
    private GSSCredential m_userCreds;
    private GSSManager m_manager;
    private byte[] m_token = new byte[0];

    public void setName(String name) {
        this.m_userName = name;
    }

    public String getName() {
        return this.m_userName;
    }

    public void setParam(SecWinADParameters param) {
        this.m_param = param;
    }

    public SecWinADParameters getParam() {
        return this.m_param;
    }

    public void setToken(byte[] token) {
        this.m_token = token;
    }

    public void setCredential(GSSCredential userCreds) {
        this.m_userCreds = userCreds;
    }

    public void setManager(GSSManager manager) {
        this.m_manager = manager;
    }

    public Object run() {
        try {
            if (!this.m_initialized) {
                if (this.m_manager == null) {
                    this.m_manager = GSSManager.getInstance();
                }
                Oid krb5Mechanism = new Oid(KRB5_MECHANISM_OID);
                Oid krb5PrincipalNameType = new Oid(KRB5_PRINCIPALNAMETYPE_OID);
                GSSName serverName = this.m_manager.createName(this.m_param.m_SERVER_SSPI_SPN, krb5PrincipalNameType);
                if (this.m_userCreds == null) {
                    GSSName userName = this.m_manager.createName(this.getName(), GSSName.NT_USER_NAME);
                    this.m_userCreds = this.m_manager.createCredential(userName, Integer.MAX_VALUE, krb5Mechanism, 1);
                }
                this.m_context = this.m_manager.createContext(serverName, krb5Mechanism, this.m_userCreds, Integer.MAX_VALUE);
                this.m_initialized = true;
                this.m_context.requestMutualAuth(true);
                if (this.m_param.m_CACHE_SECCONTEXT) {
                    this.m_context.requestCredDeleg(true);
                }
            }
            byte[] outToken = null;
            if (!this.m_context.isEstablished()) {
                if (this.m_token == null) {
                    this.m_token = new byte[0];
                }
                outToken = this.m_context.initSecContext(this.m_token, 0, this.m_token.length);
                if (LOG.isDebugEnabled() && this.m_context.isEstablished()) {
                    if (this.m_context.getCredDelegState()) {
                        LOG.debug((Object)"context state: CredDeleg is on");
                    } else {
                        LOG.debug((Object)"context state: CredDeleg is off");
                    }
                    if (this.m_context.getMutualAuthState()) {
                        LOG.debug((Object)"context stat: MutualAuth is on");
                    } else {
                        LOG.debug((Object)"context stat: MutalAuth is off");
                    }
                }
                return outToken;
            }
            return null;
        }
        catch (GSSException e) {
            LOG.error((Object)("LoginContext failed. " + e.getMessage()));
            return e;
        }
    }

    public void release() {
        if (this.m_context != null) {
            try {
                this.m_context.dispose();
                this.m_context = null;
                this.m_userCreds = null;
                this.m_initialized = false;
                this.m_token = null;
            }
            catch (GSSException e) {
                LOG.error((Object)("Can't dispose LoginContext. " + e.getMessage()));
            }
        }
    }

    protected void finalize() {
        this.release();
    }
}

