/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.secwinad.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.stringhandler.CryptoFactory;
import com.crystaldecisions.celib.stringhandler.SIStringHandler;
import com.crystaldecisions.celib.stringhandler.StrongStringHandler;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.security.internal.AbstractSecurityPlugIn;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityPlugIn;
import com.crystaldecisions.sdk.occa.security.internal.LogonCred;
import com.crystaldecisions.sdk.plugin.authentication.common.AuthUtil;
import com.crystaldecisions.sdk.plugin.authentication.secwinad.internal.SecWinADAction;
import com.crystaldecisions.sdk.plugin.authentication.secwinad.internal.SecWinADCallBackHandler;
import com.crystaldecisions.sdk.plugin.authentication.secwinad.internal.SecWinADError;
import com.crystaldecisions.sdk.plugin.authentication.secwinad.internal.SecWinADParameters;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class SecWinADAuthentication
extends AbstractSecurityPlugIn
implements ISecurityPlugIn {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.authentication.ldap.internal.SecWinADAuthentication");
    private static final int KIND_KERB = 1;
    private static final int KIND_EXTERN_SSO = 4;
    private static final String SSO_PROVIDER = "GSSAPI";
    private static final String NO_KEY = "NOKEY";
    private static final String DELIMITER = "\n";
    private static final String SSO_MARKER = "#SSOINFO#";
    private static final String CCR_SEPARATOR = "*";
    private static final String NULL_TERMINATOR = "\u0000";
    private static final String GEN_ERROR_MSG = "SecWinAD Error: an unknown error occurred in CCCRHandler::ParseClientResponse().\n";
    private static final String CLIENT_SESSION_ID = "0";
    private static final byte[] ZERO_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int KIND_BUF_SIZE = 1;
    private static final int LENGTH_BUF_SIZE = 4;
    private static final int ADDRESS_SIZE = 8;
    private static ThreadLocal sm_threadLocal = new ThreadLocal();

    public boolean needParams() {
        return true;
    }

    public void setClientParasSeq(IProperties props) throws SDKException {
        try {
            SecWinADParameters param = this.ExtractParameters(props);
            this.setSecWinParam(param);
        }
        catch (SDKException sdkE) {
            throw sdkE;
        }
        catch (Exception e) {
            return;
        }
    }

    public int startLogin(String userName, String password, String serverName, OutputStream out) throws SDKException {
        SecWinADParameters params;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"startLogin(): enter");
        }
        if ((params = this.getSecWinParam()) == null) {
            LOG.error((Object)"Couldn't get SecWinADParameters");
            throw new SDKException.Unexpected();
        }
        if (params.m_AVAIL <= 0) {
            LOG.error((Object)"secWinAD is not available");
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_S_DLL_UNAVAILABLE, new String[]{"secWinAD"}, null);
        }
        if (userName != null && userName.length() != 0 && (password == null || password.length() == 0) && params.areSSOParamsComplete()) {
            this.setSessionKind(4);
            return this.GenerateClientSSOContext(userName, null, out);
        }
        this.setSessionKind(1);
        return this.startKerbLogin(params, new LogonCred(userName, password), out);
    }

    public int startLogin(GSSCredential userCreds, GSSManager manager, String serverName, OutputStream out) throws SDKException {
        SecWinADParameters params;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"startLogin(): enter");
        }
        if ((params = this.getSecWinParam()) == null) {
            LOG.error((Object)"Couldn't get SecWinADParameters");
            throw new SDKException.Unexpected();
        }
        if (params.m_AVAIL <= 0) {
            LOG.error((Object)"secWinAD is not available");
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_S_DLL_UNAVAILABLE, new String[]{"secWinAD"}, null);
        }
        this.setSessionKind(1);
        return this.startKerbLogin(params, new LogonCred(userCreds, manager), out);
    }

    public int continueLogin(byte[] inBuffer, OutputStream outBuffer) throws SDKException {
        if (this.getSessionKind() == 4) {
            return this.GenerateClientSSOContext(null, inBuffer, outBuffer);
        }
        return this.continueKerbLogin(inBuffer, outBuffer);
    }

    private int GenerateClientSSOContext(String userName, byte[] inBuf, OutputStream out) throws SDKException {
        if (inBuf == null) {
            SIStringHandler encrypt = new SIStringHandler();
            String userToken = encrypt.pack(userName);
            userToken = SSO_MARKER + userToken;
            userToken = userToken + CCR_SEPARATOR;
            this.setUserCredential(userToken);
            userToken = userToken + NULL_TERMINATOR;
            try {
                String clientSessionID;
                Random random = new Random();
                int randomInt = random.nextInt(Integer.MAX_VALUE);
                String ssSeed1 = clientSessionID = this.getSessionId(randomInt);
                String ssSeed2 = GEN_ERROR_MSG;
                String ssSeed = ssSeed1;
                ssSeed = ssSeed + ssSeed2;
                ssSeed = ssSeed + ssSeed1;
                StrongStringHandler crypt = new StrongStringHandler(CryptoFactory.getCrypto((String)"3DES"));
                byte[] key = crypt.makeKey(ssSeed);
                String encrypted = crypt.pack(userToken, key);
                this.PackSSOBuffer(null, this.getSessionIdInBytes(randomInt), encrypted, out);
            }
            catch (Exception e) {
                SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, e);
            }
            return 1;
        }
        String errString = AuthUtil.GetErrorString(2);
        ByteArrayOutputStream serverAddress = new ByteArrayOutputStream();
        ByteArrayOutputStream clientAddress = new ByteArrayOutputStream();
        ByteArrayOutputStream returnedMsg = new ByteArrayOutputStream();
        this.UnPackSSOBuffer(inBuf, serverAddress, clientAddress, returnedMsg);
        byte[] byteReturnedMsg = returnedMsg.toByteArray();
        try {
            String response = AuthUtil.GenerateResponseNoIP(errString, this.getUserCredential().toUpperCase(), new String(byteReturnedMsg, 0, byteReturnedMsg.length - 1, "UTF-8"));
            this.PackSSOBuffer(serverAddress.toByteArray(), clientAddress.toByteArray(), response, out);
        }
        catch (Exception e) {
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, e);
        }
        return 2;
    }

    private int startKerbLogin(SecWinADParameters params, LogonCred logoninfo, OutputStream out) throws SDKException {
        if (!params.m_KERBEROS_ENABLED) {
            LOG.error((Object)"kerberos is disabled");
            throw new SDKException.WinADNotSupported();
        }
        String userAtDomain = this.constructUserAtDomain(logoninfo.GetUsername());
        Subject subject = null;
        SecWinADAction action = null;
        if (logoninfo.UsePassword()) {
            String password = logoninfo.GetPassword();
            SecWinADCallBackHandler handler = new SecWinADCallBackHandler();
            handler.setUserName(userAtDomain);
            handler.setPassword(password);
            LoginContext lc = null;
            try {
                lc = new LoginContext("com.businessobjects.security.jgss.initiate", handler);
            }
            catch (LoginException le) {
                LOG.error((Object)("Cannot create LoginContext. " + le.getMessage()));
                SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_LOGON_DENIED, null, le);
            }
            catch (SecurityException se) {
                LOG.error((Object)("Cannot create LoginContext. " + se.getMessage()));
                SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_LOGON_DENIED, null, se);
            }
            try {
                lc.login();
            }
            catch (LoginException le) {
                LOG.error((Object)("Authentication failed. " + le.getMessage()));
                SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_LOGON_DENIED, null, le);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Authentication succeeded!");
            }
            subject = lc.getSubject();
            action = new SecWinADAction();
            action.setName(userAtDomain);
            action.setParam(params);
        } else {
            action = new SecWinADAction();
            action.setCredential(logoninfo.GetGSSCredential());
            action.setManager(logoninfo.GetGSSManager());
            action.setParam(params);
            subject = new Subject();
        }
        Object initToken = Subject.doAs(subject, action);
        if (initToken == null) {
            action.release();
            this.getSessionInfo().setAction(null);
            this.getSessionInfo().setSubject(null);
            this.setSessionInfo(null);
            return 2;
        }
        if (initToken instanceof GSSException) {
            LOG.warn((Object)("GSSException is thrown" + ((GSSException)initToken).getMessage()));
            action.release();
            if (this.getSessionInfo() != null) {
                this.getSessionInfo().setAction(null);
                this.getSessionInfo().setSubject(null);
                this.setSessionInfo(null);
            }
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, (GSSException)initToken);
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setSubject(subject);
        sessionInfo.setAction(action);
        this.setSessionInfo(sessionInfo);
        if (!this.packKerbBuffer(userAtDomain, NO_KEY, (byte[])initToken, out)) {
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"startLogin(): exit");
        }
        return 1;
    }

    private int continueKerbLogin(byte[] inBuffer, OutputStream outBuffer) throws SDKException {
        SessionInfo sessionInfo = this.getSessionInfo();
        if (sessionInfo == null) {
            LOG.error((Object)"No session info is available");
            throw new SDKException.Unexpected();
        }
        Subject subject = sessionInfo.getSubject();
        if (subject == null) {
            LOG.error((Object)"No subject is available");
            throw new SDKException.Unexpected();
        }
        SecWinADAction action = sessionInfo.getAction();
        if (action == null) {
            LOG.error((Object)"No action is available");
            throw new SDKException.Unexpected();
        }
        String[] outArr = new String[4];
        ByteArrayOutputStream outToken = new ByteArrayOutputStream();
        if (!this.unPackKerbBuffer(inBuffer, outArr, outToken)) {
            LOG.error((Object)"Unpack data failed.");
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, null);
        }
        if (!outArr[0].equals(SSO_PROVIDER)) {
            LOG.error((Object)"Unexpected SSO Provider");
            throw new SDKException.Unexpected();
        }
        String serverSessionID = outArr[1];
        String userPlusDomain = outArr[3];
        action.setToken(outToken.toByteArray());
        Object token = Subject.doAs(subject, action);
        if (token instanceof GSSException) {
            LOG.error((Object)("GSSException " + ((GSSException)token).getMessage()));
            action.release();
            this.getSessionInfo().setAction(null);
            this.getSessionInfo().setSubject(null);
            this.setSessionInfo(null);
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, (GSSException)token);
        }
        if (!this.packKerbBuffer(userPlusDomain, serverSessionID, (byte[])token, outBuffer)) {
            LOG.error((Object)"pack buffer failed.");
            SecWinADError.ThrowException(SecWinADError.IDS_ERR_WINAD_CANNOT_GENERATE_SEC_CONTEXT, null, (GSSException)token);
        }
        if (token == null) {
            action.release();
            this.getSessionInfo().setAction(null);
            this.getSessionInfo().setSubject(null);
            this.setSessionInfo(null);
            return 2;
        }
        return 1;
    }

    private boolean PackSSOBuffer(byte[] serverAddress, byte[] clientAddress, String message, OutputStream out) {
        try {
            byte[] kind = new byte[]{4};
            out.write(kind);
            out.write(serverAddress == null ? ZERO_BYTES : serverAddress);
            out.write(clientAddress);
            int msgLen = message.length() + 1;
            this.writeMessageLength(msgLen, out);
            out.write(message.getBytes("UTF-8"));
            out.write(NULL_TERMINATOR.getBytes("UTF-8"));
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't write to OutputStream");
            return false;
        }
        return true;
    }

    private boolean UnPackSSOBuffer(byte[] inBuf, OutputStream serverAddress, OutputStream clientAddress, OutputStream msg) {
        byte kind;
        if (inBuf.length < 21) {
            LOG.error((Object)"Invalid in buffer, there is not enough content.");
            return false;
        }
        int bufferIndex = 0;
        if ((kind = inBuf[bufferIndex++]) != 4) {
            LOG.error((Object)"Invalid session kind, must be extern sso.");
            return false;
        }
        try {
            clientAddress.write(inBuf, bufferIndex, 8);
            serverAddress.write(inBuf, bufferIndex += 8, 8);
            bufferIndex += 8;
            int msgBufferLength = 0;
            for (int i = 0; i < 4; ++i) {
                msgBufferLength = msgBufferLength << 8 | inBuf[bufferIndex++] & 0xFF;
            }
            if (inBuf.length - bufferIndex < msgBufferLength) {
                LOG.error((Object)"Invalid in buffer, there is not enough content.");
                return false;
            }
            msg.write(inBuf, bufferIndex, msgBufferLength);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean packKerbBuffer(String userPlusDomain, String serverSessionID, byte[] inToken, OutputStream out) {
        try {
            StringBuffer ssId = new StringBuffer();
            ssId.append(SSO_PROVIDER);
            ssId.append(DELIMITER);
            ssId.append(CLIENT_SESSION_ID);
            ssId.append(DELIMITER);
            ssId.append(serverSessionID);
            ssId.append(DELIMITER);
            if (userPlusDomain.trim().length() == 0) {
                return false;
            }
            ssId.append(userPlusDomain);
            ssId.append(NULL_TERMINATOR);
            byte[] kind = new byte[]{1};
            out.write(kind);
            int idLength = ssId.length();
            this.writeMessageLength(idLength, out);
            byte[] ssIdBuffer = ssId.toString().getBytes("UTF-8");
            out.write(ssIdBuffer);
            if (inToken == null) {
                inToken = new byte[]{};
            }
            int tokenLength = inToken.length;
            this.writeMessageLength(tokenLength, out);
            out.write(inToken);
            return true;
        }
        catch (IOException e) {
            LOG.error((Object)("can't write to outputstream. " + e.getMessage()));
            return false;
        }
    }

    private boolean unPackKerbBuffer(byte[] inBuffer, String[] outArr, OutputStream outToken) {
        try {
            byte kind;
            int inBufferLength = inBuffer.length;
            if (inBufferLength < 9) {
                LOG.error((Object)"Invalid inBuffer, there is not enough content.");
                return false;
            }
            int bufferIndex = 0;
            if ((kind = inBuffer[bufferIndex++]) != 1) {
                LOG.error((Object)"Invalid session kind, must be kerberos.");
                return false;
            }
            int idBufferLength = 0;
            int i = 0;
            while (i < 4) {
                idBufferLength = idBufferLength << 8 | inBuffer[bufferIndex] & 0xFF;
                ++i;
                ++bufferIndex;
            }
            if (inBufferLength - bufferIndex < idBufferLength) {
                LOG.error((Object)"Invalid inBuffer, there is not enough content");
                return false;
            }
            String idBuffer = new String(inBuffer, bufferIndex, idBufferLength, "UTF-8");
            String[] idBuffers = idBuffer.split(DELIMITER);
            outArr[0] = idBuffers[0];
            outArr[1] = idBuffers[1];
            outArr[2] = idBuffers[2];
            outArr[3] = idBuffers[3].length() == 0 ? "" : idBuffers[3].substring(0, idBuffers[3].length() - 1);
            if (inBufferLength - (bufferIndex += idBufferLength) < 4) {
                LOG.error((Object)"Invalid in buffer, there is not enough content.");
                return false;
            }
            int tokenBufferLength = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                tokenBufferLength = tokenBufferLength << 8 | inBuffer[bufferIndex++] & 0xFF;
            }
            if (inBufferLength - bufferIndex < tokenBufferLength) {
                LOG.error((Object)"Invalid in buffer, there is not enough content.");
                return false;
            }
            outToken.write(inBuffer, bufferIndex, tokenBufferLength);
            return true;
        }
        catch (IOException e) {
            LOG.error((Object)("can't write to outputstream. " + e.getMessage()));
            return false;
        }
    }

    private SecWinADParameters ExtractParameters(IProperties props) throws SDKException {
        SecWinADParameters params = new SecWinADParameters();
        PropertyBag bag = (PropertyBag)props;
        params.m_AVAIL = bag.getInt((Object)PropertyIDs.SI_AVAIL);
        params.m_DEFAULT_DOMAIN = bag.getString((Object)PropertyIDs.SI_DEFAULT_DOMAIN);
        params.m_ALIAS_AUTOADD = bag.getBoolean((Object)PropertyIDs.SI_ALIAS_AUTOADD);
        params.m_APS_ADMIN_DN = bag.getString((Object)PropertyIDs.SI_APS_ADMIN_DN);
        params.m_CACHE_SECCONTEXT = bag.getBoolean((Object)PropertyIDs.SI_CACHE_SECCONTEXT);
        params.m_CREATE_NAMEDUSERS = bag.getBoolean((Object)PropertyIDs.SI_CREATE_NAMEDUSERS);
        params.m_IMPORT_USERS = bag.getBoolean((Object)PropertyIDs.SI_IMPORT_USERS);
        params.m_KERBEROS_ENABLED = bag.getBoolean((Object)PropertyIDs.SI_KERBEROS_ENABLED);
        params.m_MAPPED_GROUP = bag.getString((Object)PropertyIDs.SI_MAPPED_GROUPS);
        params.m_SSO_ENABLED = bag.getBoolean((Object)PropertyIDs.SI_SSO_ENABLED);
        params.m_SERVER_SSPI_SPN = bag.getString((Object)PropertyIDs.SI_SERVER_SSPI_SPN);
        params.m_SSO_VENDOR = bag.getInt((Object)PropertyIDs.SI_SSO_VENDOR);
        params.m_SSO_SERVERS_AND_PORTS = bag.getString((Object)PropertyIDs.SI_SSO_SERVERS_AND_PORTS);
        params.m_SSO_SHARED_SECRET = bag.getString((Object)PropertyIDs.SI_SSO_SHARED_SECRET);
        params.m_SSO_AGENT = bag.getString((Object)PropertyIDs.SI_SSO_AGENT);
        params.m_SSO_ACCESS_MODE = bag.getInt((Object)PropertyIDs.SI_SSO_ACCESS_MODE);
        if (!params.isInitialized()) {
            throw new SDKException.Unexpected();
        }
        return params;
    }

    private SecWinADParameters getSecWinParam() throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo != null) {
                return threadInfo.m_param;
            }
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
        return null;
    }

    private void setSecWinParam(SecWinADParameters param) throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo == null) {
                threadInfo = new ThreadInfo();
            }
            threadInfo.m_param = param;
            sm_threadLocal.set(threadInfo);
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
    }

    private SessionInfo getSessionInfo() throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo != null) {
                return threadInfo.m_session;
            }
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
        return null;
    }

    private void setSessionInfo(SessionInfo session) throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo == null) {
                threadInfo = new ThreadInfo();
            }
            threadInfo.m_session = session;
            sm_threadLocal.set(threadInfo);
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
    }

    private int getSessionKind() throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo != null) {
                return threadInfo.m_kind;
            }
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
        return 1;
    }

    private void setSessionKind(int kind) throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo == null) {
                threadInfo = new ThreadInfo();
            }
            threadInfo.m_kind = kind;
            sm_threadLocal.set(threadInfo);
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
    }

    private String getUserCredential() throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo != null) {
                return threadInfo.m_userCredential;
            }
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
        return null;
    }

    private void setUserCredential(String cred) throws SDKException {
        try {
            ThreadInfo threadInfo = (ThreadInfo)sm_threadLocal.get();
            if (threadInfo == null) {
                threadInfo = new ThreadInfo();
            }
            threadInfo.m_userCredential = cred;
            sm_threadLocal.set(threadInfo);
        }
        catch (Exception e) {
            throw new SDKException.Unexpected();
        }
    }

    private String constructUserAtDomain(String userName) throws SDKException {
        if (userName == null) {
            return null;
        }
        int index = userName.indexOf("@");
        if (index == -1) {
            StringBuffer userAtDomain = new StringBuffer();
            SecWinADParameters params = this.getSecWinParam();
            userAtDomain.append(userName);
            userAtDomain.append("@");
            userAtDomain.append(params.m_DEFAULT_DOMAIN);
            return userAtDomain.toString();
        }
        return userName;
    }

    private void writeMessageLength(int msgLen, OutputStream out) throws IOException {
        byte[] msgLengthBuffer = new byte[]{(byte)(msgLen >>> 24 & 0xFF), (byte)(msgLen >>> 16 & 0xFF), (byte)(msgLen >>> 8 & 0xFF), (byte)(msgLen & 0xFF)};
        out.write(msgLengthBuffer);
    }

    private byte[] getSessionIdInBytes(int id) {
        byte[] tmpBuff = new byte[8];
        for (int i = 0; i < 4; ++i) {
            tmpBuff[i] = 0;
        }
        for (int index = 5; index <= 8; ++index) {
            int shift = (8 - index) * 8;
            tmpBuff[index - 1] = (byte)(id >>> shift & 0xFF);
        }
        return tmpBuff;
    }

    private String getSessionId(int id) {
        return new Integer(id).toString();
    }

    public static class ThreadInfo {
        public SecWinADParameters m_param;
        public SessionInfo m_session;
        public int m_kind;
        public String m_userCredential;
    }

    private static class SessionInfo {
        private Subject m_subject;
        private SecWinADAction m_action;

        private SessionInfo() {
        }

        public Subject getSubject() {
            return this.m_subject;
        }

        public void setSubject(Subject subject) {
            this.m_subject = subject;
        }

        public SecWinADAction getAction() {
            return this.m_action;
        }

        public void setAction(SecWinADAction action) {
            this.m_action = action;
        }
    }
}

