/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.authentication.secwinad.internal;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.plugin.authentication.common.AuthUtil;
import com.crystaldecisions.sdk.plugin.authentication.secwinad.IsecWinAD;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

public class SecWinADDesktop
extends AbstractInfoObject
implements IsecWinAD {
    public int getAvailability() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_AVAIL);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_AVAIL);
        }
        return (Integer)prop.getValue();
    }

    public void setAvailability(int value) {
        this.setProperty((Object)PropertyIDs.SI_AVAIL, new Integer(value));
    }

    public String getDefaultDomain() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_DEFAULT_DOMAIN);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_DEFAULT_DOMAIN);
        }
        return (String)prop.getValue();
    }

    public void setDefaultDomain(String value) {
        this.setProperty((Object)PropertyIDs.SI_DEFAULT_DOMAIN, value);
    }

    public String getMappedGroups() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_MAPPED_GROUPS);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_MAPPED_GROUPS);
        }
        return (String)prop.getValue();
    }

    public void setMappingGroups(String value) {
        this.setProperty((Object)PropertyIDs.SI_MAPPED_GROUPS, value);
    }

    public String getAdminName() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_APS_ADMIN_DN);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_APS_ADMIN_DN);
        }
        return (String)prop.getValue();
    }

    public void setAdminName(String value) {
        this.setProperty((Object)PropertyIDs.SI_APS_ADMIN_DN, value);
    }

    public void setAdminPassword(String value) throws SDKException {
        this.setProperty((Object)PropertyIDs.SI_APS_ADMIN_PWD, AuthUtil.encryptPassword(value));
    }

    public boolean isAliasAutoAdd() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_ALIAS_AUTOADD);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_ALIAS_AUTOADD);
        }
        return (Boolean)prop.getValue();
    }

    public void setAliasAutoAdd(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_ALIAS_AUTOADD, new Boolean(value));
    }

    public boolean isImportUsers() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_IMPORT_USERS);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_IMPORT_USERS);
        }
        return (Boolean)prop.getValue();
    }

    public void setImportUsers(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_IMPORT_USERS, new Boolean(value));
    }

    public boolean isCreateNamedUsers() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_CREATE_NAMEDUSERS);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_CREATE_NAMEDUSERS);
        }
        return (Boolean)prop.getValue();
    }

    public void setCreateNamedUsers(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_CREATE_NAMEDUSERS, new Boolean(value));
    }

    public boolean isSSOEnabled() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_SSO_ENABLED);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_SSO_ENABLED);
        }
        return (Boolean)prop.getValue();
    }

    public void setSSOEnabled(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_ENABLED, new Boolean(value));
    }

    public int getSSOVendor() throws SDKException {
        Integer ssoVendor = (Integer)this.getProperty(PropertyIDs.SI_SSO_VENDOR).getValue();
        return ssoVendor;
    }

    public void setSSOVendor(int value) throws SDKException {
        if (value < 0 || value > 1) {
            throw new SDKException.InvalidArg(value);
        }
        this.setProperty((Object)PropertyIDs.SI_SSO_VENDOR, new Integer(value));
    }

    public String getSSOServersAndPorts() throws SDKException {
        return (String)this.getProperty(PropertyIDs.SI_SSO_SERVERS_AND_PORTS).getValue();
    }

    public void setSSOServersAndPorts(String value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_SERVERS_AND_PORTS, value);
    }

    public void setSSOSharedSecret(String value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_SHARED_SECRET, AuthUtil.encryptPassword(value));
    }

    public String getSSOAgent() throws SDKException {
        return (String)this.getProperty(PropertyIDs.SI_SSO_AGENT).getValue();
    }

    public void setSSOAgent(String value) {
        this.setProperty((Object)PropertyIDs.SI_SSO_AGENT, value);
    }

    public int getSSOAccessMode() throws SDKException {
        return (Integer)this.getProperty(PropertyIDs.SI_SSO_ACCESS_MODE).getValue();
    }

    public void setSSOAccessMode(int value) throws SDKException {
        if (value < 0 || value > 2) {
            throw new SDKException.InvalidArg(value);
        }
        this.setProperty((Object)PropertyIDs.SI_SSO_ACCESS_MODE, new Integer(value));
    }

    public boolean isKerberosEnabled() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_KERBEROS_ENABLED);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_KERBEROS_ENABLED);
        }
        return (Boolean)prop.getValue();
    }

    public void setKerberosEnabled(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_KERBEROS_ENABLED, new Boolean(value));
    }

    public boolean isCacheSecurityContext() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_CACHE_SECCONTEXT);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_CACHE_SECCONTEXT);
        }
        return (Boolean)prop.getValue();
    }

    public void setCacheSecurityContext(boolean value) {
        this.setProperty((Object)PropertyIDs.SI_CACHE_SECCONTEXT, new Boolean(value));
    }

    public String getServicePrincipalName() throws SDKException {
        IProperty prop = this.getProperty(PropertyIDs.SI_SERVER_SSPI_SPN);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_SERVER_SSPI_SPN);
        }
        return (String)prop.getValue();
    }

    public void setServicePrincipalName(String name) {
        this.setProperty((Object)PropertyIDs.SI_SERVER_SSPI_SPN, name);
    }

    public boolean isAttributeBindingEnabled() throws SDKException {
        return (Boolean)this.getProperty(PropertyIDs.SI_ENABLE_ATTR_BINDING).getValue();
    }

    public void setAttributeBindingEnabled(boolean isEnabled) {
        this.setProperty((Object)PropertyIDs.SI_ENABLE_ATTR_BINDING, isEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getAttributeBindingPriority() throws SDKException {
        return (Integer)this.getProperty(PropertyIDs.SI_ATTR_BINDING_PRIORITY).getValue();
    }

    public void setAttributeBindingPriority(int value) {
        this.setProperty((Object)PropertyIDs.SI_ATTR_BINDING_PRIORITY, new Integer(value));
    }
}

