/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.calendar.internal;

import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.plugin.desktop.calendar.IBusinessCalendarDay;
import com.crystaldecisions.sdk.plugin.desktop.calendar.IBusinessCalendarDays;
import com.crystaldecisions.sdk.plugin.desktop.calendar.internal.BusinessCalendarDay;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.AbstractSDKList;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class BusinessCalendarDays
extends AbstractSDKList
implements IBusinessCalendarDays {
    private PropertyBag m_propBag;
    private int m_nextGroupID;

    BusinessCalendarDays(PropertyBag bag) {
        super(bag, PropertyIDs.SI_TOTAL, null, false, false);
        this.m_propBag = bag;
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_MAX);
        if (prop == null) {
            this.m_propBag.addItem((Object)PropertyIDs.SI_MAX, (Object)IntegerConversion.ZERO, 0);
            this.m_nextGroupID = 0;
        } else {
            this.m_nextGroupID = prop.getInt();
        }
    }

    public IBusinessCalendarDay add(int startDay, int startMonth, int startYear, int endDay, int endMonth, int endYear, int dayOfWeek, int weekOfMonth, int group) {
        int realGroupID = group;
        if (group == -1) {
            realGroupID = this.generateUniqueID();
        }
        BusinessCalendarDay newDay = new BusinessCalendarDay();
        newDay.initialize(startDay, startMonth, startYear, endDay, endMonth, endYear, dayOfWeek, weekOfMonth, realGroupID);
        this.addNewObjectToCollection(newDay);
        return newDay;
    }

    public IBusinessCalendarDay add() {
        return this.add(-1, -1, -1, -1, -1, -1, -1, -1, -1);
    }

    protected Object createCollectionObject(int index) {
        return new BusinessCalendarDay((IProperties)this.m_bag.get(index));
    }

    public int getNextGroupID() {
        return this.generateUniqueID();
    }

    private int generateUniqueID() {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_MAX, ++this.m_nextGroupID);
        return this.m_nextGroupID;
    }

    public boolean isValid(int startDay, int startMonth, int startYear, int endDay, int endMonth, int endYear, int dayOfWeek, int weekOfMonth) {
        if (dayOfWeek != -1 && (dayOfWeek < 1 || dayOfWeek > 7)) {
            return false;
        }
        if (weekOfMonth != -1 && (weekOfMonth < 1 || weekOfMonth > 6)) {
            return false;
        }
        if (startDay == -1 && endDay != -1 || startDay != -1 && endDay == -1) {
            return false;
        }
        if (startMonth == -1 && endMonth != -1 || startMonth != -1 && endMonth == -1) {
            return false;
        }
        if (startYear == -1 && endYear != -1 || startYear != -1 && endYear == -1) {
            return false;
        }
        if (startYear != -1 && (startYear < 1 || startYear > 0x10000000) || endYear != -1 && (endYear < 1 || endYear > 0x10000000)) {
            return false;
        }
        if (startMonth != -1 && (startMonth < 0 || startMonth > 11) || endMonth != -1 && (endMonth < 0 || endMonth > 11)) {
            return false;
        }
        if (startDay != -1 && (startDay < 1 || startDay > 31) || endDay != -1 && (endDay < 1 || endDay > 31)) {
            return false;
        }
        if (startDay != -1 && startMonth != -1 && startYear != -1) {
            Calendar startDate = GregorianCalendar.getInstance();
            startDate.clear();
            startDate.set(startYear, startMonth, startDay);
            if (startDay > startDate.getActualMaximum(5)) {
                return false;
            }
            Calendar endDate = GregorianCalendar.getInstance();
            endDate.clear();
            endDate.set(endYear, endMonth, endDay);
            if (endDay > endDate.getActualMaximum(5)) {
                return false;
            }
            if (endDate.before(startDate)) {
                return false;
            }
        } else if (startYear == -1) {
            if (startMonth > endMonth) {
                return false;
            }
            if (startMonth == endMonth && startDay > endDay) {
                return false;
            }
        } else {
            if (startDay != -1 && startDay > endDay) {
                return false;
            }
            if (startMonth != -1 && startMonth > endMonth) {
                return false;
            }
            if (startYear != -1 && startYear > endYear) {
                return false;
            }
        }
        return true;
    }
}

