/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.calendar.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.calendar.IBusinessCalendarDay;
import com.crystaldecisions.sdk.plugin.desktop.calendar.IBusinessCalendarDays;
import com.crystaldecisions.sdk.plugin.desktop.calendar.ICalendar;
import com.crystaldecisions.sdk.plugin.desktop.calendar.internal.BusinessCalendarDay;
import com.crystaldecisions.sdk.plugin.desktop.calendar.internal.BusinessCalendarDays;
import com.crystaldecisions.sdk.plugin.desktop.calendar.internal.SCalendarDay;
import com.crystaldecisions.sdk.plugin.desktop.calendar.internal.SDate;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;

public class Calendar
extends AbstractInfoObject
implements ICalendar {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.calendar.internal.Calendar");
    static final Integer SEC_ID_CALENDAR_FOLDER = new Integer(22);
    private static final SCalendarDay.BegindateEnddateWeekofmonthDayofweek defaultSort = new SCalendarDay.BegindateEnddateWeekofmonthDayofweek();
    private static final SCalendarDay.BegindateEnddateDayofweekWeekofmonth sort2 = new SCalendarDay.BegindateEnddateDayofweekWeekofmonth();
    private static final SCalendarDay.DayofweekWeekofmonthStartdateEnddate sort3 = new SCalendarDay.DayofweekWeekofmonthStartdateEnddate();
    private static final SCalendarDay runEveryDay = new SCalendarDay(-1, -1, -1, -1, -1, -1, -1, -1, -1);
    private static final long sixDays = 518400000L;
    private static final long oneDay = 86400000L;
    private static final java.util.Calendar currentDate = java.util.Calendar.getInstance();
    private BusinessCalendarDays m_days;
    private static final int CASE_ONE = 1;
    private static final int CASE_TWO = 2;
    private static final int CASE_THREE = 3;
    private static final int CASE_FOUR = 4;

    Calendar() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, SEC_ID_CALENDAR_FOLDER);
    }

    protected void prepareCommit() throws SDKException {
        Property prop = (Property)this.getProperty(PropertyIDs.SI_TEMPLATE_DAYS);
        if (prop != null) {
            this.simplify();
        }
    }

    public IBusinessCalendarDays getDays() throws SDKException {
        if (this.m_days == null) {
            Property prop = (Property)this.getProperty(PropertyIDs.SI_TEMPLATE_DAYS);
            if (prop == null) {
                prop = ((PropertyBag)this.properties()).addArray((Object)PropertyIDs.SI_TEMPLATE_DAYS);
            }
            this.m_days = new BusinessCalendarDays(prop.getPropertyBag());
        }
        return this.m_days;
    }

    public boolean isRunDay(int inDay, int inMonth, int inYear) throws SDKException {
        List groupIDs = this.getGroups(inDay, inMonth, inYear, false);
        return groupIDs.size() != 0;
    }

    private java.util.Calendar toCalendarDate(int inDay, int inMonth, int inYear) {
        if (inMonth < 0 || inMonth > 11 || inYear < 0 || inYear > 0x10000000) {
            throw new IllegalArgumentException();
        }
        java.util.Calendar inDate = GregorianCalendar.getInstance();
        inDate.clear();
        inDate.set(inYear, inMonth, inDay);
        if (inDay < 1 || inDay > inDate.getActualMaximum(5)) {
            throw new IllegalArgumentException();
        }
        return inDate;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void simplify() throws SDKException {
        int ss;
        SCalendarDay cDay;
        int ii;
        TreeSet<SCalendarDay> cDays = new TreeSet<SCalendarDay>(defaultSort);
        BusinessCalendarDays runDays = (BusinessCalendarDays)this.getDays();
        int count = runDays.size();
        if (count <= 0) {
            return;
        }
        Iterator iter = runDays.iterator();
        while (iter.hasNext()) {
            IBusinessCalendarDay runDay = (IBusinessCalendarDay)iter.next();
            if (!runDays.isValid(runDay.getStartDay(), runDay.getStartMonth(), runDay.getStartYear(), runDay.getEndDay(), runDay.getEndMonth(), runDay.getEndYear(), runDay.getDayOfWeek(), runDay.getWeekNumber())) continue;
            SCalendarDay cDay2 = new SCalendarDay(runDay.getStartDay(), runDay.getStartMonth(), runDay.getStartYear(), runDay.getEndDay(), runDay.getEndMonth(), runDay.getEndYear(), runDay.getDayOfWeek(), runDay.getWeekNumber(), runDay.getGroupID());
            cDays.add(cDay2);
        }
        if (cDays.contains(runEveryDay)) {
            ArrayList<SCalendarDay> tmpList = new ArrayList<SCalendarDay>();
            tmpList.add(runEveryDay);
            this.setFinalResult(runDays, tmpList);
        }
        boolean bChanged = false;
        ArrayList cDaysList = new ArrayList(cDays);
        ArrayList cResultDaysList = (ArrayList)cDaysList.clone();
        for (ii = 0; ii < cDaysList.size(); ++ii) {
            cDay = (SCalendarDay)cDaysList.get(ii);
            int dayOfWeek = cDay.getDayOfWeek();
            int weekOfMonth = cDay.getWeekOfMonth();
            if (dayOfWeek == -1 && weekOfMonth == -1 || cDay.isPattern()) continue;
            boolean bSimplified = false;
            if (cDay.getEndDate().getDate().equals(cDay.getStartDate().getDate())) {
                if (dayOfWeek != -1) {
                    if (dayOfWeek == cDay.getStartDate().getDate().get(7)) {
                        dayOfWeek = -1;
                        bSimplified = true;
                    } else {
                        cResultDaysList.remove(cDay);
                        bChanged = true;
                        continue;
                    }
                }
                if (weekOfMonth != -1) {
                    if (weekOfMonth == SCalendarDay.calculateWeekOfMonth(cDay.getStartDay())) {
                        weekOfMonth = -1;
                        bSimplified = true;
                    } else {
                        cResultDaysList.remove(cDay);
                        bChanged = true;
                        continue;
                    }
                }
            } else if (cDay.getEndDate().getDate().getTime().getTime() <= cDay.getStartDate().getDate().getTime().getTime() + 518400000L && weekOfMonth != -1 && weekOfMonth == SCalendarDay.calculateWeekOfMonth(cDay.getStartDay()) && weekOfMonth == SCalendarDay.calculateWeekOfMonth(cDay.getEndDay())) {
                weekOfMonth = -1;
                bSimplified = true;
            }
            if (!bSimplified) continue;
            bChanged = true;
            cResultDaysList.remove(cDay);
            SCalendarDay tempDay = new SCalendarDay(cDay.getStartDay(), cDay.getStartMonth(), cDay.getStartYear(), cDay.getEndDay(), cDay.getEndMonth(), cDay.getEndYear(), dayOfWeek, weekOfMonth, cDay.getGroup());
            cResultDaysList.add(tempDay);
        }
        if (this.setResult(cResultDaysList, runDays)) {
            return;
        }
        if (bChanged) {
            cDays.clear();
            cDays.addAll(cResultDaysList);
            cDaysList = new ArrayList(cDays);
            cResultDaysList = (ArrayList)cDaysList.clone();
        }
        ii = 0;
        while (true) {
            int jj;
            boolean bWeekMatch;
            block49: {
                long dayAccumulated;
                SDate endDate;
                SDate startDate;
                block53: {
                    block51: {
                        block52: {
                            if (ii >= cDaysList.size()) break block51;
                            cDay = (SCalendarDay)cDaysList.get(ii);
                            if (cDay.getDayOfWeek() > 1) {
                                ++ii;
                                continue;
                            }
                            bWeekMatch = false;
                            startDate = cDay.getStartDate();
                            endDate = cDay.getEndDate();
                            if (cDay.getDayOfWeek() != -1) break block52;
                            for (jj = ii + 1; jj < cDaysList.size(); ++jj) {
                                SCalendarDay cDay2 = (SCalendarDay)cDaysList.get(jj);
                                if (cDay.getGroup() == cDay2.getGroup() && startDate.equals(cDay2.getStartDate()) && endDate.equals(cDay2.getEndDate()) && cDay.getWeekOfMonth() == cDay2.getWeekOfMonth()) {
                                    bWeekMatch = true;
                                    continue;
                                }
                                break block49;
                            }
                            break block49;
                        }
                        dayAccumulated = 1L;
                        break block53;
                    }
                    if (this.setResult(cResultDaysList, runDays)) {
                        return;
                    }
                    break;
                }
                while (jj < cDaysList.size()) {
                    SCalendarDay cDay2 = (SCalendarDay)cDaysList.get(jj);
                    if (cDay.getGroup() != cDay2.getGroup() || !startDate.equals(cDay2.getStartDate()) || !endDate.equals(cDay2.getEndDate()) || cDay.getWeekOfMonth() != cDay2.getWeekOfMonth()) break;
                    if ((long)cDay2.getDayOfWeek() == dayAccumulated + 1L) {
                        if (++dayAccumulated == 7L) {
                            bWeekMatch = true;
                            ++jj;
                            break;
                        } else {
                            ++jj;
                            continue;
                        }
                    }
                    ++jj;
                }
            }
            if (bWeekMatch) {
                cResultDaysList.removeAll(cDaysList.subList(ii, jj));
                SCalendarDay wholeWeek = new SCalendarDay(cDay.getStartDay(), cDay.getStartMonth(), cDay.getStartYear(), cDay.getEndDay(), cDay.getEndMonth(), cDay.getEndYear(), -1, cDay.getWeekOfMonth(), cDay.getGroup());
                cResultDaysList.add(wholeWeek);
            }
            ii = jj;
        }
        cDays = new TreeSet(sort2);
        cDays.addAll(cResultDaysList);
        cDaysList = new ArrayList(cDays);
        cResultDaysList = (ArrayList)cDaysList.clone();
        int rr = 0;
        while (true) {
            int jj;
            boolean bMonthMatch;
            SCalendarDay cDay3;
            block50: {
                long weekAccumulated;
                SDate endDate;
                SDate startDate;
                block56: {
                    block54: {
                        block55: {
                            if (rr >= cDaysList.size()) break block54;
                            cDay3 = (SCalendarDay)cDaysList.get(rr);
                            if (cDay3.getWeekOfMonth() > 1) {
                                ++rr;
                                continue;
                            }
                            bMonthMatch = false;
                            startDate = cDay3.getStartDate();
                            endDate = cDay3.getEndDate();
                            if (cDay3.getWeekOfMonth() != -1) break block55;
                            for (jj = rr + 1; jj < cDaysList.size(); ++jj) {
                                SCalendarDay cDay2 = (SCalendarDay)cDaysList.get(jj);
                                if (cDay3.getGroup() == cDay2.getGroup() && startDate.equals(cDay2.getStartDate()) && endDate.equals(cDay2.getEndDate()) && cDay3.getDayOfWeek() == cDay2.getDayOfWeek()) {
                                    bMonthMatch = true;
                                    continue;
                                }
                                break block50;
                            }
                            break block50;
                        }
                        weekAccumulated = 1L;
                        break block56;
                    }
                    if (this.setResult(cResultDaysList, runDays)) {
                        return;
                    }
                    cDays = new TreeSet(sort3);
                    cDays.addAll(cResultDaysList);
                    cDaysList = new ArrayList(cDays);
                    cResultDaysList = (ArrayList)cDaysList.clone();
                    ss = 0;
                    break;
                }
                while (jj < cDaysList.size()) {
                    SCalendarDay cDay2 = (SCalendarDay)cDaysList.get(jj);
                    if (cDay3.getGroup() != cDay2.getGroup() || !startDate.equals(cDay2.getStartDate()) || !endDate.equals(cDay2.getEndDate()) || cDay3.getDayOfWeek() != cDay2.getDayOfWeek()) break;
                    if ((long)cDay2.getWeekOfMonth() == weekAccumulated + 1L) {
                        if (++weekAccumulated == 5L) {
                            bMonthMatch = true;
                            ++jj;
                            break;
                        } else {
                            if (weekAccumulated == 4L && startDate.getDate().get(2) == 1 && !startDate.getDate().isLeapYear(startDate.getDate().get(1)) && endDate.getDate().get(2) <= 2 && endDate.getDate().get(5) <= 28) {
                                bMonthMatch = true;
                            }
                            ++jj;
                            continue;
                        }
                    }
                    ++jj;
                }
            }
            if (bMonthMatch) {
                cResultDaysList.removeAll(cDaysList.subList(rr, jj));
                SCalendarDay wholeMonth = new SCalendarDay(cDay3.getStartDay(), cDay3.getStartMonth(), cDay3.getStartYear(), cDay3.getEndDay(), cDay3.getEndMonth(), cDay3.getEndYear(), cDay3.getDayOfWeek(), -1, cDay3.getGroup());
                cResultDaysList.add(wholeMonth);
            }
            rr = jj;
        }
        while (ss < cDaysList.size()) {
            int jj;
            boolean bDateMatch = false;
            SCalendarDay cDay4 = (SCalendarDay)cDaysList.get(ss);
            SDate lastEndDate = cDay4.getEndDate();
            SCalendarDay cPrevDay = cDay4;
            for (jj = ss + 1; jj < cDaysList.size(); ++jj) {
                SCalendarDay cCurrDay = (SCalendarDay)cDaysList.get(jj);
                if (cDay4.getGroup() != cCurrDay.getGroup() || cPrevDay.getDayOfWeek() != cCurrDay.getDayOfWeek() || cPrevDay.getWeekOfMonth() != cCurrDay.getWeekOfMonth() || !cCurrDay.getStartDate().comparable(lastEndDate) || !cCurrDay.getEndDate().comparable(lastEndDate) || cCurrDay.getStartDate().moreThanOneDayAfter(lastEndDate) == 1) break;
                bDateMatch = true;
                if (cCurrDay.getEndDate().after(lastEndDate) == 1) {
                    lastEndDate = cCurrDay.getEndDate();
                }
                cPrevDay = cCurrDay;
            }
            if (bDateMatch) {
                cResultDaysList.removeAll(cDaysList.subList(ss, jj));
                SCalendarDay newYearItem = new SCalendarDay(cDay4.getStartDay(), cDay4.getStartMonth(), cDay4.getStartYear(), lastEndDate.getDay(), lastEndDate.getMonth(), lastEndDate.getYear(), cDay4.getDayOfWeek(), cDay4.getWeekOfMonth(), cDay4.getGroup());
                cResultDaysList.add(newYearItem);
            }
            ss = jj;
        }
        if (this.setResult(cResultDaysList, runDays)) {
            return;
        }
        cDays = new TreeSet(defaultSort);
        cDays.addAll(cResultDaysList);
        cDaysList = new ArrayList(cDays);
        cResultDaysList = (ArrayList)cDaysList.clone();
        bChanged = false;
        int tt = 0;
        while (true) {
            if (tt >= cDaysList.size()) {
                this.containAllDays(cResultDaysList);
                this.setFinalResult(runDays, cResultDaysList);
                return;
            }
            SCalendarDay cDay5 = (SCalendarDay)cDaysList.get(tt);
            if (cDay5.getDayOfWeek() != -1 && cDay5.getWeekOfMonth() != -1) {
                ++tt;
                continue;
            }
            if (!cResultDaysList.contains(cDay5)) {
                ++tt;
                continue;
            }
            boolean bYearPattern = cDay5.getStartMonth() == -1 && cDay5.getStartDay() == -1;
            Iterator jj = cDaysList.iterator();
            while (jj.hasNext()) {
                SCalendarDay cDay2 = (SCalendarDay)jj.next();
                if (cDay5 == cDay2 || cDay5.getGroup() != cDay2.getGroup() || !cResultDaysList.contains(cDay2) || (!bYearPattern ? !cDay2.getStartDate().comparable(cDay5.getStartDate()) || cDay2.getStartDate().before(cDay5.getStartDate()) == 1 || !cDay2.getEndDate().comparable(cDay5.getEndDate()) || cDay2.getEndDate().after(cDay5.getEndDate()) == 1 : cDay5.getStartYear() != -1 && (cDay2.getStartYear() < cDay5.getStartYear() || cDay2.getEndYear() > cDay5.getEndYear()))) continue;
                if (cDay5.getDayOfWeek() == -1 && cDay5.getWeekOfMonth() == -1) {
                    cResultDaysList.remove(cDay2);
                    continue;
                }
                if (cDay5.getDayOfWeek() == -1 && cDay5.getWeekOfMonth() == cDay2.getWeekOfMonth()) {
                    cResultDaysList.remove(cDay2);
                }
                if (cDay5.getWeekOfMonth() != -1 || cDay5.getDayOfWeek() != cDay2.getDayOfWeek()) continue;
                cResultDaysList.remove(cDay2);
            }
            ++tt;
        }
    }

    public void remove(int inStartDay, int inStartMonth, int inStartYear, int inEndDay, int inEndMonth, int inEndYear) throws SDKException {
        java.util.Calendar inEndDate;
        java.util.Calendar inStartDate = this.toCalendarDate(inStartDay, inStartMonth, inStartYear);
        if (inStartDate.after(inEndDate = this.toCalendarDate(inEndDay, inEndMonth, inEndYear))) {
            throw new IllegalArgumentException();
        }
        BusinessCalendarDays runDays = (BusinessCalendarDays)this.getDays();
        Object[] copyRunDays = runDays.toArray();
        for (int i = 0; i < copyRunDays.length; ++i) {
            java.util.Calendar pEndDate;
            java.util.Calendar pStartDate;
            java.util.Calendar pEndDate2;
            java.util.Calendar pStartDate2;
            BusinessCalendarDay runDay = (BusinessCalendarDay)copyRunDays[i];
            if (!runDays.isValid(runDay.getStartDay(), runDay.getStartMonth(), runDay.getStartYear(), runDay.getEndDay(), runDay.getEndMonth(), runDay.getEndYear(), runDay.getDayOfWeek(), runDay.getWeekNumber())) {
                runDays.remove(runDay);
                continue;
            }
            int orgStartDay = runDay.getStartDay();
            int orgStartMonth = runDay.getStartMonth();
            int orgStartYear = runDay.getStartYear();
            int orgEndDay = runDay.getEndDay();
            int orgEndMonth = runDay.getEndMonth();
            int orgEndYear = runDay.getEndYear();
            int orgDayOfWeek = runDay.getDayOfWeek();
            int orgWeekOfMonth = runDay.getWeekNumber();
            int orgGroup = runDay.getGroupID();
            if (orgStartYear != -1 && orgStartYear > inEndYear || orgEndYear != -1 && orgEndYear < inStartYear) continue;
            int startYear = orgStartYear;
            int endYear = orgEndYear;
            if (orgStartYear == -1) {
                startYear = currentDate.get(1) - 10;
            }
            if (orgEndYear == -1) {
                endYear = currentDate.get(1) + 50;
            }
            boolean bRemoveOldItem = false;
            if (inStartYear < startYear && inEndYear > endYear) {
                runDays.remove(runDay);
                continue;
            }
            if (orgStartDay == -1 && orgStartMonth == -1) {
                if (startYear >= inStartYear && startYear <= inEndYear || inStartYear >= startYear && inStartYear <= endYear) {
                    pStartDate2 = java.util.Calendar.getInstance();
                    pStartDate2.clear();
                    pStartDate2.set(startYear, orgStartMonth == -1 ? 0 : orgStartMonth, orgStartDay == -1 ? 1 : orgStartDay);
                    pEndDate2 = java.util.Calendar.getInstance();
                    pEndDate2.clear();
                    pEndDate2.set(endYear, orgEndMonth == -1 ? 11 : orgEndMonth, orgEndDay == -1 ? 31 : orgEndDay);
                    bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate2, pEndDate2, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                }
            } else if (orgStartDay != -1 && orgStartMonth == -1) {
                long maxNoRunDays = (long)(31 - (orgEndDay - orgStartDay + 1)) * 86400000L;
                if (inEndDate.getTime().getTime() - inStartDate.getTime().getTime() > maxNoRunDays || inStartDay >= orgStartDay && inStartDay <= orgEndDay || orgStartDay >= inStartDay && orgStartDay <= inEndDay) {
                    if (startYear < inStartYear) {
                        bRemoveOldItem |= this.addNewItem(runDays, orgStartDay, -1, startYear, orgEndDay, -1, inStartYear - 1, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    if (endYear > inEndYear) {
                        bRemoveOldItem |= this.addNewItem(runDays, orgStartDay, -1, inEndYear + 1, orgEndDay, -1, endYear, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    if (startYear <= inStartYear) {
                        for (int ii = 0; ii < inStartMonth; ++ii) {
                            bRemoveOldItem |= this.addNewItem(runDays, orgStartDay, ii, inStartYear, orgEndDay, ii, inStartYear, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                        }
                    }
                    if (endYear >= inEndYear) {
                        for (int jj = inEndMonth + 1; jj <= 11; ++jj) {
                            bRemoveOldItem |= this.addNewItem(runDays, orgStartDay, jj, inEndYear, orgEndDay, jj, inEndYear, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                        }
                    }
                    pStartDate = java.util.Calendar.getInstance();
                    pStartDate.clear();
                    pStartDate.set(inStartYear, inStartMonth, orgStartDay);
                    pEndDate = java.util.Calendar.getInstance();
                    pEndDate.clear();
                    pEndDate.set(inStartYear, inStartMonth, orgEndDay);
                    if (startYear <= inStartYear) {
                        bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate, pEndDate, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    if (endYear >= inEndYear && (inStartYear != inEndYear || inStartMonth != inEndMonth)) {
                        pStartDate.set(inEndYear, inEndMonth, orgStartDay);
                        pEndDate.set(inEndYear, inEndMonth, orgEndDay);
                        bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate, pEndDate, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                }
            } else if (orgStartDay == -1 && orgStartMonth != -1) {
                long maxNoRunDays = (long)(366 - (orgEndMonth - orgStartMonth + 1) * 28) * 86400000L;
                if (inEndDate.getTime().getTime() - inStartDate.getTime().getTime() > maxNoRunDays || inStartMonth >= orgStartMonth && inStartMonth <= orgEndMonth || orgStartMonth >= inStartMonth && orgStartMonth <= inEndMonth) {
                    if (startYear < inStartYear) {
                        bRemoveOldItem |= this.addNewItem(runDays, -1, orgStartMonth, startYear, -1, orgEndMonth, inStartYear - 1, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    if (endYear > inEndYear) {
                        bRemoveOldItem |= this.addNewItem(runDays, -1, orgStartMonth, inEndYear + 1, -1, orgEndMonth, endYear, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    pStartDate = java.util.Calendar.getInstance();
                    pStartDate.clear();
                    pStartDate.set(inStartYear, orgStartMonth, 1);
                    pEndDate = java.util.Calendar.getInstance();
                    pEndDate.clear();
                    pEndDate.set(1, inStartYear);
                    pEndDate.set(2, orgEndMonth);
                    pEndDate.set(5, pEndDate.getActualMaximum(5));
                    if (startYear <= inStartYear) {
                        bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate, pEndDate, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    if (endYear >= inEndYear && inStartYear != inEndYear) {
                        pStartDate.set(inEndYear, orgStartMonth, 1);
                        pEndDate.set(1, inEndYear);
                        pEndDate.set(2, orgEndMonth);
                        pEndDate.set(5, pEndDate.getActualMaximum(5));
                        bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate, pEndDate, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                }
            } else if (orgStartDay != -1 && orgStartMonth != -1 && orgStartYear == -1) {
                long maxNoRunDays = (long)(366 - (inEndMonth - inStartMonth + 1) * 28) * 86400000L;
                if (inEndDate.getTime().getTime() - inStartDate.getTime().getTime() > maxNoRunDays || (inStartMonth > orgStartMonth || inStartMonth == orgStartMonth && inStartDay >= orgStartDay) && (inStartMonth < orgEndMonth || inStartMonth == orgEndMonth && inStartDay <= orgEndDay) || (orgStartMonth > inStartMonth || orgStartMonth == inStartMonth && orgStartDay >= inStartDay) && (orgStartMonth < inStartMonth || orgStartMonth == inEndMonth && orgStartDay <= inEndDay)) {
                    for (int ii = startYear; ii < inStartYear; ++ii) {
                        bRemoveOldItem |= this.addNewItem(runDays, orgStartDay, orgStartMonth, ii, orgEndDay, orgEndMonth, ii, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    for (int jj = inEndYear + 1; jj <= endYear; ++jj) {
                        bRemoveOldItem |= this.addNewItem(runDays, orgStartDay, orgStartMonth, jj, orgEndDay, orgEndMonth, jj, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    pStartDate = java.util.Calendar.getInstance();
                    pStartDate.clear();
                    pStartDate.set(inStartYear, orgStartMonth, orgStartDay);
                    pEndDate = java.util.Calendar.getInstance();
                    pEndDate.clear();
                    pEndDate.set(inStartYear, orgEndMonth, orgEndDay);
                    if (startYear <= inStartYear) {
                        bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate, pEndDate, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                    if (endYear >= inEndYear && inStartYear != inEndYear) {
                        pStartDate.set(inEndYear, orgStartMonth, orgStartDay);
                        pEndDate.set(inEndYear, orgEndMonth, orgEndDay);
                        bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate, pEndDate, orgDayOfWeek, orgWeekOfMonth, orgGroup);
                    }
                }
            } else if (orgStartDay != -1 && orgStartMonth != -1 && orgStartYear != -1) {
                pStartDate2 = java.util.Calendar.getInstance();
                pStartDate2.clear();
                pStartDate2.set(startYear, orgStartMonth == -1 ? 0 : orgStartMonth, orgStartDay == -1 ? 1 : orgStartDay);
                pEndDate2 = java.util.Calendar.getInstance();
                pEndDate2.clear();
                pEndDate2.set(endYear, orgEndMonth == -1 ? 0 : orgEndMonth, orgEndDay == -1 ? 31 : orgEndDay);
                bRemoveOldItem |= this.rangeSplit(runDays, inStartDate, inEndDate, pStartDate2, pEndDate2, orgDayOfWeek, orgWeekOfMonth, orgGroup);
            } else {
                LOG.assertTrue(false, "remove(): Should never happen");
            }
            if (!bRemoveOldItem) continue;
            runDays.remove(runDay);
        }
    }

    public void removeGroup(int groupID) throws SDKException {
        BusinessCalendarDays runDays = (BusinessCalendarDays)this.getDays();
        Iterator iter = runDays.iterator();
        while (iter.hasNext()) {
            BusinessCalendarDay runDay = (BusinessCalendarDay)iter.next();
            if (runDay.getGroupID() != groupID) continue;
            iter.remove();
        }
    }

    public int[] getGroupIDs(int inDay, int inMonth, int inYear) throws SDKException {
        List groupIDs = this.getGroups(inDay, inMonth, inYear, true);
        int[] retArray = new int[groupIDs.size()];
        for (int i = 0; i < groupIDs.size(); ++i) {
            Integer tmp = (Integer)groupIDs.get(i);
            retArray[i] = tmp;
        }
        return retArray;
    }

    public String[] getGroupDescriptions(int inGroupID, Locale locale) throws SDKException {
        ArrayList<String> groupDescs = new ArrayList<String>();
        BusinessCalendarDays runDays = (BusinessCalendarDays)this.getDays();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] months = symbols.getMonths();
        String[] weekdays = symbols.getWeekdays();
        Iterator iter = runDays.iterator();
        while (iter.hasNext()) {
            int weekOfMonth;
            int dayOfWeek;
            int endYear;
            int endMonth;
            int endDay;
            int startYear;
            int startMonth;
            int startDay;
            BusinessCalendarDay runDay = (BusinessCalendarDay)iter.next();
            int groupID = runDay.getGroupID();
            if (inGroupID != groupID || !runDays.isValid(startDay = runDay.getStartDay(), startMonth = runDay.getStartMonth(), startYear = runDay.getStartYear(), endDay = runDay.getEndDay(), endMonth = runDay.getEndMonth(), endYear = runDay.getEndYear(), dayOfWeek = runDay.getDayOfWeek(), weekOfMonth = runDay.getWeekNumber())) continue;
            int intCase = 0;
            if (weekOfMonth != -1 && dayOfWeek != -1) {
                intCase = 1;
            } else if (weekOfMonth != -1 && dayOfWeek == -1) {
                intCase = 2;
            } else if (weekOfMonth == -1 && dayOfWeek != -1) {
                intCase = 3;
            } else if (weekOfMonth == -1 && dayOfWeek == -1) {
                intCase = 4;
            } else {
                LOG.assertTrue(false, "shouldn't reach here");
            }
            int resID = 0;
            ArrayList<String> args = new ArrayList<String>();
            if (startDay != -1 && startMonth != -1 && startYear != -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61001;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61002;
                            break;
                        }
                        resID = 61003;
                        break;
                    }
                    case 3: {
                        resID = 61004;
                        break;
                    }
                    case 4: {
                        resID = 61005;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                args.add(months[startMonth]);
                args.add(Integer.toString(startDay));
                args.add(Integer.toString(startYear));
                args.add(months[endMonth]);
                args.add(Integer.toString(endDay));
                args.add(Integer.toString(endYear));
            } else if (startDay != -1 && startMonth != -1 && startYear == -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61006;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61007;
                            break;
                        }
                        resID = 61008;
                        break;
                    }
                    case 3: {
                        resID = 61009;
                        break;
                    }
                    case 4: {
                        resID = 61010;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                args.add(months[startMonth]);
                args.add(new String(Integer.toString(startDay)));
                args.add(months[endMonth]);
                args.add(new String(Integer.toString(endDay)));
            } else if (startDay != -1 && startMonth == -1 && startYear != -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61011;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61012;
                            break;
                        }
                        resID = 61013;
                        break;
                    }
                    case 3: {
                        resID = 61014;
                        break;
                    }
                    case 4: {
                        resID = 61015;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                String startNthDay = ServerMsgResourcesBundle.getString(Integer.toString(61101 + startDay - 1), locale);
                args.add(startNthDay);
                String endNthDay = ServerMsgResourcesBundle.getString(Integer.toString(61101 + endDay - 1), locale);
                args.add(endNthDay);
                args.add(Integer.toString(startYear));
                args.add(Integer.toString(endYear));
            } else if (startDay != -1 && startMonth == -1 && startYear == -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61016;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61017;
                            break;
                        }
                        resID = 61018;
                        break;
                    }
                    case 3: {
                        resID = 61019;
                        break;
                    }
                    case 4: {
                        resID = 61020;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                args.add(ServerMsgResourcesBundle.getString(Integer.toString(61101 + startDay - 1), locale));
                args.add(ServerMsgResourcesBundle.getString(Integer.toString(61101 + endDay - 1), locale));
            } else if (startDay == -1 && startMonth != -1 && startYear != -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61021;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61022;
                            break;
                        }
                        resID = 61023;
                        break;
                    }
                    case 3: {
                        resID = 61024;
                        break;
                    }
                    case 4: {
                        resID = 61025;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                args.add(months[startMonth]);
                args.add(months[endMonth]);
                args.add(Integer.toString(startYear));
                args.add(Integer.toString(endYear));
            } else if (startDay == -1 && startMonth != -1 && startYear == -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61026;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61027;
                            break;
                        }
                        resID = 61028;
                        break;
                    }
                    case 3: {
                        resID = 61029;
                        break;
                    }
                    case 4: {
                        resID = 61030;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                args.add(months[startMonth]);
                args.add(months[endMonth]);
            } else if (startDay == -1 && startMonth == -1 && startYear != -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61031;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61032;
                            break;
                        }
                        resID = 61033;
                        break;
                    }
                    case 3: {
                        resID = 61034;
                        break;
                    }
                    case 4: {
                        resID = 61035;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
                args.add(Integer.toString(startYear));
                args.add(Integer.toString(endYear));
            } else if (startDay == -1 && startMonth == -1 && startYear == -1) {
                switch (intCase) {
                    case 1: {
                        resID = 61036;
                        break;
                    }
                    case 2: {
                        if (weekOfMonth == 6) {
                            resID = 61037;
                            break;
                        }
                        resID = 61038;
                        break;
                    }
                    case 3: {
                        resID = 61039;
                        break;
                    }
                    case 4: {
                        resID = 61040;
                        break;
                    }
                    default: {
                        LOG.assertTrue(false, "shouldn't be here");
                    }
                }
            }
            switch (intCase) {
                case 1: {
                    if (weekOfMonth != 6) {
                        args.add(ServerMsgResourcesBundle.getString(Integer.toString(61101 + weekOfMonth - 1), locale));
                    } else {
                        args.add(ServerMsgResourcesBundle.getString(Integer.toString(61132), locale));
                    }
                    args.add(weekdays[dayOfWeek]);
                    break;
                }
                case 2: {
                    if (weekOfMonth == 6) break;
                    args.add(ServerMsgResourcesBundle.getString(Integer.toString(61101 + weekOfMonth - 1), locale));
                    break;
                }
                case 3: {
                    args.add(weekdays[dayOfWeek]);
                    break;
                }
            }
            String res = ServerMsgResourcesBundle.getString(Integer.toString(resID), locale);
            String result = MessageFormat.format(res, args.toArray());
            groupDescs.add(result);
        }
        return groupDescs.toArray(new String[groupDescs.size()]);
    }

    public boolean hasMoreThanOneDay(int groupID) throws SDKException {
        BusinessCalendarDays runDays = (BusinessCalendarDays)this.getDays();
        boolean bHasOneDay = false;
        boolean bMoreThanOneDay = false;
        Iterator iter = runDays.iterator();
        while (iter.hasNext()) {
            BusinessCalendarDay runDay = (BusinessCalendarDay)iter.next();
            if (runDay.getGroupID() != groupID || !runDays.isValid(runDay.getStartDay(), runDay.getStartMonth(), runDay.getStartYear(), runDay.getEndDay(), runDay.getEndMonth(), runDay.getEndYear(), runDay.getDayOfWeek(), runDay.getWeekNumber())) continue;
            int startDay = runDay.getStartDay();
            int startMonth = runDay.getStartMonth();
            int startYear = runDay.getStartYear();
            int endDay = runDay.getEndDay();
            int endMonth = runDay.getEndMonth();
            int endYear = runDay.getEndYear();
            if (startDay != -1 && startMonth != -1 && startYear != -1) {
                java.util.Calendar startDate = java.util.Calendar.getInstance();
                startDate.clear();
                startDate.set(startYear, startMonth, startDay);
                java.util.Calendar endDate = java.util.Calendar.getInstance();
                endDate.clear();
                endDate.set(endYear, endMonth, endDay);
                if (endDate.after(startDate)) {
                    bMoreThanOneDay = true;
                    break;
                }
                if (!startDate.equals(endDate)) continue;
                if (!bHasOneDay) {
                    bHasOneDay = true;
                    continue;
                }
                bMoreThanOneDay = true;
                break;
            }
            bMoreThanOneDay = true;
            break;
        }
        return bMoreThanOneDay;
    }

    private List getGroups(int inDay, int inMonth, int inYear, boolean bGetAll) throws SDKException {
        java.util.Calendar inDate = this.toCalendarDate(inDay, inMonth, inYear);
        int inDayofWeek = inDate.get(7);
        int inWeekNumber = SCalendarDay.calculateWeekOfMonth(inDay);
        ArrayList<Integer> retIDs = new ArrayList<Integer>();
        BusinessCalendarDays runDays = (BusinessCalendarDays)this.getDays();
        for (int i = 0; i < runDays.size(); ++i) {
            BusinessCalendarDay runDay = (BusinessCalendarDay)runDays.get(i);
            if (!runDays.isValid(runDay.getStartDay(), runDay.getStartMonth(), runDay.getStartYear(), runDay.getEndDay(), runDay.getEndMonth(), runDay.getEndYear(), runDay.getDayOfWeek(), runDay.getWeekNumber())) continue;
            int startDay = runDay.getStartDay();
            int startMonth = runDay.getStartMonth();
            int startYear = runDay.getStartYear();
            int endDay = runDay.getEndDay();
            int endMonth = runDay.getEndMonth();
            int endYear = runDay.getEndYear();
            int dayOfWeek = runDay.getDayOfWeek();
            int weekNumber = runDay.getWeekNumber();
            int groupID = runDay.getGroupID();
            if (dayOfWeek != -1 && dayOfWeek != inDayofWeek || weekNumber != -1 && weekNumber != inWeekNumber && (weekNumber != 6 || !this.isLast7DayOfMonth(inDate, inDay))) continue;
            if (startDay == -1 || startMonth == -1 || startYear == -1) {
                if (startYear == -1 && startMonth != -1 && startDay != -1) {
                    GregorianCalendar tmpStartDate = new GregorianCalendar();
                    tmpStartDate.clear();
                    tmpStartDate.set(inYear, startMonth, startDay);
                    GregorianCalendar tmpEndDate = new GregorianCalendar();
                    tmpEndDate.clear();
                    tmpEndDate.set(inYear, endMonth, endDay);
                    if (inDate.before(tmpStartDate) || inDate.after(tmpEndDate)) {
                        continue;
                    }
                } else if (startYear != -1 && (inYear < startYear || inYear > endYear) || startMonth != -1 && (inMonth < startMonth || inMonth > endMonth) || startDay != -1 && (inDay < startDay || inDay > endDay)) {
                    continue;
                }
            } else {
                java.util.Calendar startDate = GregorianCalendar.getInstance();
                startDate.clear();
                startDate.set(startYear, startMonth, startDay);
                java.util.Calendar endDate = GregorianCalendar.getInstance();
                endDate.clear();
                endDate.set(endYear, endMonth, endDay);
                if (inDate.before(startDate) || inDate.after(endDate)) continue;
            }
            retIDs.add(new Integer(groupID));
            if (!bGetAll) break;
        }
        return retIDs;
    }

    private boolean rangeSplit(BusinessCalendarDays runDays, java.util.Calendar inStartDate, java.util.Calendar inEndDate, java.util.Calendar pStartDate, java.util.Calendar pEndDate, int dayOfWeek, int weekOfMonth, int group) {
        boolean b2;
        boolean bRemoveOld = false;
        if (pEndDate.before(inStartDate)) {
            bRemoveOld |= this.addNewItem(runDays, pStartDate.get(5), pStartDate.get(2), pStartDate.get(1), pEndDate.get(5), pEndDate.get(2), pEndDate.get(1), dayOfWeek, weekOfMonth, group);
        }
        boolean b1 = !inStartDate.before(pStartDate) && !inStartDate.after(pEndDate);
        boolean bl = b2 = !pStartDate.before(inStartDate) && !pStartDate.after(inEndDate);
        if (b1 || b2) {
            if (b1 && pStartDate.before(inStartDate)) {
                java.util.Calendar oneDayBeforeInSDate = java.util.Calendar.getInstance();
                oneDayBeforeInSDate.clear();
                oneDayBeforeInSDate.set(inStartDate.get(1), inStartDate.get(2), inStartDate.get(5));
                oneDayBeforeInSDate.add(5, -1);
                bRemoveOld |= this.addNewItem(runDays, pStartDate.get(5), pStartDate.get(2), pStartDate.get(1), oneDayBeforeInSDate.get(5), oneDayBeforeInSDate.get(2), oneDayBeforeInSDate.get(1), dayOfWeek, weekOfMonth, group);
            }
            if (pEndDate.after(inEndDate)) {
                java.util.Calendar oneDayAfterInEDate = java.util.Calendar.getInstance();
                oneDayAfterInEDate.clear();
                oneDayAfterInEDate.set(inEndDate.get(1), inEndDate.get(2), inEndDate.get(5));
                oneDayAfterInEDate.add(5, 1);
                bRemoveOld |= this.addNewItem(runDays, oneDayAfterInEDate.get(5), oneDayAfterInEDate.get(2), oneDayAfterInEDate.get(1), pEndDate.get(5), pEndDate.get(2), pEndDate.get(1), dayOfWeek, weekOfMonth, group);
            } else if (b2) {
                bRemoveOld = true;
            }
        }
        return bRemoveOld;
    }

    boolean addNewItem(BusinessCalendarDays runDays, int startDay, int startMonth, int startYear, int endDay, int endMonth, int endYear, int dayOfWeek, int weekOfMonth, int group) {
        int validEndDay = endDay;
        if (endDay != -1 && endMonth != -1 && endYear != -1) {
            java.util.Calendar inDate = GregorianCalendar.getInstance();
            inDate.clear();
            inDate.set(endYear, endMonth, endDay);
            int actualLastDayOfMonth = inDate.getActualMaximum(5);
            if (endDay > actualLastDayOfMonth) {
                validEndDay = actualLastDayOfMonth;
            }
        }
        if (runDays.isValid(startDay, startMonth, startYear, validEndDay, endMonth, endYear, dayOfWeek, weekOfMonth)) {
            runDays.add(startDay, startMonth, startYear, validEndDay, endMonth, endYear, dayOfWeek, weekOfMonth, group);
        }
        return true;
    }

    private boolean setResult(ArrayList cResultDaysList, BusinessCalendarDays runDays) {
        this.containAllDays(cResultDaysList);
        if (cResultDaysList.size() <= 1) {
            this.setFinalResult(runDays, cResultDaysList);
            return true;
        }
        return false;
    }

    private void containAllDays(ArrayList cResultDaysList) {
        if (cResultDaysList.contains(runEveryDay)) {
            cResultDaysList.clear();
            cResultDaysList.add(runEveryDay);
        }
    }

    private void setFinalResult(IBusinessCalendarDays target, ArrayList source) {
        target.clear();
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            SCalendarDay sDay = (SCalendarDay)iter.next();
            target.add(sDay.getStartDay(), sDay.getStartMonth(), sDay.getStartYear(), sDay.getEndDay(), sDay.getEndMonth(), sDay.getEndYear(), sDay.getDayOfWeek(), sDay.getWeekOfMonth(), sDay.getGroup());
        }
    }

    private boolean isLast7DayOfMonth(java.util.Calendar srcDate, int srcDay) {
        int lastDayOfMonth = srcDate.getActualMaximum(5);
        return srcDay <= lastDayOfMonth - 7 ? false : srcDay <= lastDayOfMonth;
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    Calendar.this.prepareCommit();
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }
}

