/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.calendar.internal;

import java.util.GregorianCalendar;

public class SDate {
    private static final int oneDay = 86400000;
    private int m_Day;
    private int m_Month;
    private int m_Year;
    GregorianCalendar m_Date;
    boolean m_IsPattern;

    SDate() {
        this.m_IsPattern = false;
        this.m_Day = 0;
        this.m_Month = 0;
        this.m_Year = 0;
    }

    SDate(int day, int month, int year, boolean bStartDate) {
        this.Set(day, month, year, bStartDate);
    }

    SDate(SDate right) {
        this.m_IsPattern = right.isPattern();
        this.m_Year = right.getYear();
        this.m_Month = right.getMonth();
        this.m_Day = right.getDay();
        this.m_Date = right.getDate();
    }

    void Set(int day, int month, int year, boolean bStartDate) {
        this.m_Day = day;
        this.m_Month = month;
        this.m_Year = year;
        this.m_IsPattern = this.m_Year == -1 || this.m_Month == -1 || this.m_Day == -1;
        this.m_Date = (GregorianCalendar)GregorianCalendar.getInstance();
        this.m_Date.clear();
        if (bStartDate) {
            this.m_Date.set(this.m_Year == -1 ? 1972 : this.m_Year, this.m_Month == -1 ? 0 : this.m_Month, this.m_Day == -1 ? 1 : this.m_Day);
        } else {
            this.m_Date.set(1, this.m_Year == -1 ? 1972 : this.m_Year);
            this.m_Date.set(2, this.m_Month == -1 ? 11 : this.m_Month);
            this.m_Date.set(5, this.m_Day == -1 ? this.m_Date.getActualMaximum(5) : this.m_Day);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SDate) {
            SDate right = (SDate)object;
            return this.m_Year == right.getYear() && this.m_Month == right.getMonth() && this.m_Day == right.getDay();
        }
        return false;
    }

    int getYear() {
        return this.m_Year;
    }

    int getMonth() {
        return this.m_Month;
    }

    int getDay() {
        return this.m_Day;
    }

    GregorianCalendar getDate() {
        return this.m_Date;
    }

    int before(SDate right) {
        if (this.m_Date.before(right.getDate())) {
            return 1;
        }
        return 0;
    }

    int moreThanOneDayAfter(SDate right) {
        if (this.m_Date.getTime().getTime() > right.getDate().getTime().getTime() + 86400000L) {
            return 1;
        }
        return 0;
    }

    int after(SDate right) {
        if (this.m_Date.after(right.getDate())) {
            return 1;
        }
        return 0;
    }

    boolean comparable(SDate right) {
        if (this.m_Year == -1 && right.getYear() != -1 || this.m_Year != -1 && right.getYear() == -1 || this.m_Month == -1 && right.getMonth() != -1 || this.m_Month != -1 && right.getMonth() == -1 || this.m_Day == -1 && right.getDay() != -1 || this.m_Day != -1 && right.getDay() == -1) {
            return false;
        }
        return !this.m_IsPattern || this.m_Year == -1 || this.m_Month == -1 && this.m_Day == -1 || this.m_Year == right.getYear();
    }

    boolean isPattern() {
        return this.m_IsPattern;
    }
}

