/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.ISchedulingInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.IDocumentObjects;
import com.crystaldecisions.sdk.plugin.desktop.common.IFormatInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.DocumentObjects;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FormatInfo
implements IFormatInfo {
    private PropertyBag m_FormatOptionsBag;
    private ISchedulingInfo m_schedulingInfo;
    private IDocumentObjects m_documentObjects;
    private static String formatOptionsClass_CR = "com.crystaldecisions.sdk.plugin.desktop.report.internal.ReportFormatOptions";
    private static String formatOptionsClass_Webi = "com.crystaldecisions.sdk.plugin.desktop.common.internal.WebiFormatOptions";
    private static String formatOptionsClass_FC = "com.businessobjects.sdk.plugin.desktop.fullclient.internal.FullClientFormatOptionsImpl";

    public FormatInfo() {
    }

    public FormatInfo(PropertyBag bag, ISchedulingInfo schedulingInfo) {
        this.m_FormatOptionsBag = bag;
        this.m_schedulingInfo = schedulingInfo;
    }

    public void initialize() {
        if (this.m_FormatOptionsBag == null) {
            this.m_FormatOptionsBag = new SDKPropertyBag();
        }
    }

    public IProperties properties() {
        return (IProperties)this.m_FormatOptionsBag;
    }

    public String getSourceDocumentKind() {
        return this.m_FormatOptionsBag.getString((Object)PropertyIDs.SI_FORMATINFO_DOCKIND);
    }

    public void setSourceDocumentKind(String srcDocKind) throws SDKException {
        if (!(srcDocKind.equals("CrystalReport") || srcDocKind.equals("Webi") || srcDocKind.equals("FullClient") || srcDocKind.equals("FullClientAddin") || srcDocKind.equals("FullClientTemplate"))) {
            throw new SDKException.InvalidArg(PropertyIDs.SI_FORMATINFO_DOCKIND);
        }
        this.m_FormatOptionsBag.addItem((Object)PropertyIDs.SI_FORMATINFO_DOCKIND, (Object)srcDocKind, 0);
    }

    public Object getFormatOptionsObject(String kind) throws SDKException {
        Object objFormatOptions = null;
        if (kind.equals("CrystalReport")) {
            objFormatOptions = this.getFormatInfoOptions(formatOptionsClass_CR);
        } else if (kind.equals("Webi")) {
            objFormatOptions = this.getFormatInfoOptions(formatOptionsClass_Webi);
        } else if (kind.equals("FullClient") || kind.equals("FullClientAddin") || kind.equals("FullClientTemplate")) {
            objFormatOptions = this.getFormatInfoOptions(formatOptionsClass_FC);
        }
        return objFormatOptions;
    }

    public int getFormat() throws SDKException {
        String kind = this.getSourceDocumentKind();
        if (kind == null || kind.equals("")) {
            kind = "CrystalReport";
        }
        return this.getFormat(kind);
    }

    public int getFormat(String kind) throws SDKException {
        String mname = "getFormat";
        Object objFormatOptions = this.getFormatOptionsObject(kind);
        try {
            Class[] types = new Class[]{};
            Method method = objFormatOptions.getClass().getMethod("getFormat", types);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Integer result = (Integer)method.invoke(objFormatOptions, new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new SDKException.InvalidArg("Invalid exception in FormatInfo.getFormat");
        }
    }

    public void setFormat(String kind, int format) throws SDKException {
        String mname = "setFormat";
        Object objFormatOptions = this.getFormatOptionsObject(kind);
        try {
            Class[] types = new Class[]{Integer.TYPE};
            Method method = objFormatOptions.getClass().getMethod("setFormat", types);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object[] paras = new Object[]{new Integer(format)};
            method.invoke(objFormatOptions, paras);
            return;
        }
        catch (Exception e) {
            throw new SDKException.InvalidArg("Invalid exception in FormatInfo.setFormat");
        }
    }

    public boolean isUseExportOptionsInReport() throws SDKException {
        String kind = this.getSourceDocumentKind();
        if (kind == null || kind.equals("") || !kind.equals("CrystalReport")) {
            throw new SDKException.InvalidArg();
        }
        return this.isUseExportOptionsInReport(kind);
    }

    public void setUseExportOptionsInReport(boolean value) throws SDKException {
        String kind = this.getSourceDocumentKind();
        if (kind == null || kind.equals("") || !kind.equals("CrystalReport")) {
            throw new SDKException.InvalidArg();
        }
        this.setUseExportOptionsInReport(kind, value);
    }

    public boolean isUseExportOptionsInReport(String kind) throws SDKException {
        String mname = "isUseExportOptionsInReport";
        Object objFormatOptions = this.getFormatOptionsObject(kind);
        try {
            Class[] types = new Class[]{};
            Method method = objFormatOptions.getClass().getMethod("isUseExportOptionsInReport", types);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Boolean result = (Boolean)method.invoke(objFormatOptions, new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new SDKException.InvalidArg("Invalid exception in FormatInfo.isUseExportOptionsInReport");
        }
    }

    public void setUseExportOptionsInReport(String kind, boolean value) throws SDKException {
        String mname = "setUseExportOptionsInReport";
        Object objFormatOptions = this.getFormatOptionsObject(kind);
        try {
            Class[] types = new Class[]{Boolean.TYPE};
            Method method = objFormatOptions.getClass().getMethod("setUseExportOptionsInReport", types);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object[] paras = new Object[]{new Boolean(value)};
            method.invoke(objFormatOptions, paras);
            return;
        }
        catch (Exception e) {
            throw new SDKException.InvalidArg("Invalid exception in FormatInfo.setUseExportOptionsInReport");
        }
    }

    public IDocumentObjects getSelectedDocumentObjects() throws SDKException {
        if (this.m_documentObjects == null) {
            PropertyBag bag = this.m_FormatOptionsBag.getPropertyBag((Object)PropertyIDs.SI_SELECTED_DOCUMENT_OBJECTS);
            if (bag == null) {
                bag = this.m_FormatOptionsBag.addPropertyBag((Object)PropertyIDs.SI_SELECTED_DOCUMENT_OBJECTS, null).getPropertyBag();
            }
            this.m_documentObjects = new DocumentObjects(bag);
        }
        return this.m_documentObjects;
    }

    public Object getFormatInfoOptions(String clsName) throws SDKException {
        Class clsPropertyBag = PropertyBag.class;
        Class clsScheduling = ISchedulingInfo.class;
        Class[] parameters = new Class[]{clsPropertyBag, clsScheduling};
        Object[] paras = new Object[]{this.m_FormatOptionsBag, this.m_schedulingInfo};
        return this.getReflectionObject(clsName, parameters, paras);
    }

    public Object getCRFormatInterface() throws SDKException {
        String clsName = this.getClassName();
        Class clsPropertyBag = PropertyBag.class;
        Class[] parameters = new Class[]{clsPropertyBag};
        Object[] paras = new Object[]{this.m_FormatOptionsBag};
        return this.getReflectionObject(clsName, parameters, paras);
    }

    private Object getReflectionObject(String className, Class[] constParameters, Object[] parameters) throws SDKException {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            Object instance = null;
            if (!cls.isArray()) {
                Constructor<?> c = cls.getDeclaredConstructor(constParameters);
                if (!c.isAccessible()) {
                    c.setAccessible(true);
                }
                instance = c.newInstance(parameters);
            }
            return instance;
        }
        catch (ClassNotFoundException exp) {
            throw new SDKException.InvalidArg(className);
        }
        catch (NoSuchMethodException exp) {
            throw new SDKException.InvalidArg(className);
        }
        catch (IllegalAccessException exp) {
            throw new SDKException.InvalidArg(className);
        }
        catch (InstantiationException exp) {
            throw new SDKException.InvalidArg(className);
        }
        catch (InvocationTargetException exp) {
            throw new SDKException.InvalidArg(className);
        }
    }

    private String getClassName() throws SDKException {
        String kind = this.getSourceDocumentKind();
        if (kind == null || kind.length() == 0) {
            kind = "CrystalReport";
        }
        int format = this.getFormat(kind);
        String clsName = "";
        switch (format) {
            case 5: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.TextFormatPlain";
                break;
            }
            case 8: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.TextFormatCharacterSeparated";
                break;
            }
            case 6: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.TextFormatPaginated";
                break;
            }
            case 10: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.TextFormatTabSeparatedText";
                break;
            }
            case 1: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.ExcelFormat";
                break;
            }
            case 9: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.ExcelDataOnlyFormat";
                break;
            }
            case 2: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.WordFormat";
                break;
            }
            case 3: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.PDFFormat";
                break;
            }
            case 4: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.RichTextFormat";
                break;
            }
            case 11: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.RichTextFormatEditable";
                break;
            }
            case 13: {
                clsName = "com.crystaldecisions.sdk.plugin.desktop.report.internal.XMLFormat";
            }
        }
        return clsName;
    }
}

