/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.ISchedulingInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.IFormatInfos;
import com.crystaldecisions.sdk.plugin.desktop.common.IProcessingPublicationInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.IScopeBatchScopes;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.FormatInfos;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.ScopeBatchScopes;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

public class ProcessingPublicationInfoHelper
implements IProcessingPublicationInfo {
    private IProperties m_properties;
    private ISchedulingInfo m_schedulingInfo;
    private IFormatInfos m_formatInfos;
    private IScopeBatchScopes m_scopes = null;

    public ProcessingPublicationInfoHelper(IProperties properties, ISchedulingInfo schedulingInfo) {
        this.m_properties = properties;
        this.m_schedulingInfo = schedulingInfo;
    }

    public String getDeliveryRuleExpression() {
        return this.m_properties.getString(PropertyIDs.SI_DELIVERY_RULE_EXPRESSION);
    }

    public void setDeliveryRuleExpression(String deliveryRuleExpression) throws SDKException {
        this.m_properties.setProperty((Object)PropertyIDs.SI_DELIVERY_RULE_EXPRESSION, deliveryRuleExpression);
    }

    public boolean isDeliverIfAlertIsTrue() {
        if (this.m_properties.get(PropertyIDs.SI_DELIVER_IF_ALERT_IS_TRUE) != null) {
            return this.m_properties.getBoolean(PropertyIDs.SI_DELIVER_IF_ALERT_IS_TRUE);
        }
        return true;
    }

    public void setDeliverIfAlertIsTrue(boolean value) throws SDKException {
        this.m_properties.setProperty((Object)PropertyIDs.SI_DELIVER_IF_ALERT_IS_TRUE, value);
    }

    public boolean isDeliverEmptyDocument() {
        if (this.m_properties.get(PropertyIDs.SI_DELIVER_EMPTY_DOCUMENT) != null) {
            return this.m_properties.getBoolean(PropertyIDs.SI_DELIVER_EMPTY_DOCUMENT);
        }
        return true;
    }

    public void setDeliverEmptyDocument(boolean bDeliveryEmptyDocument) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_DELIVER_EMPTY_DOCUMENT, bDeliveryEmptyDocument);
    }

    public boolean getDeliveryRuleResults(int scopeIDWithinScopeBatch) throws SDKException {
        boolean bDefault = true;
        Property prop = (Property)this.m_properties.getProperty(PropertyIDs.SI_DELIVERY_RULE_RESULTS);
        if (prop == null) {
            return bDefault;
        }
        Integer propertyName = new Integer(scopeIDWithinScopeBatch);
        IProperty value = ((IProperties)prop.getValue()).getProperty(propertyName);
        if (value != null) {
            return (Boolean)value.getValue();
        }
        return bDefault;
    }

    public boolean getDeliverySkipped() throws SDKException {
        Property prop = (Property)this.m_properties.getProperty(PropertyIDs.SI_DELIVERY_SKIPPED);
        if (prop == null) {
            return false;
        }
        return prop.getBoolean();
    }

    public boolean getPublicationKeepSavedData() throws SDKException {
        Property prop = (Property)this.m_properties.getProperty(PropertyIDs.SI_PUBLICATION_KEEP_SAVED_DATA);
        if (prop == null) {
            return false;
        }
        return prop.getBoolean();
    }

    public long getPublicationLastState() throws SDKException {
        Property prop = (Property)this.m_properties.getProperty(PropertyIDs.SI_PUBLICATION_LAST_STATE);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_PUBLICATION_LAST_STATE);
        }
        return prop.getLong();
    }

    public void setDeliveryRuleResults(int scopeIDWithinScopeBatch, boolean bDeliverySkipped) {
        IProperty data = this.m_properties.getProperty(PropertyIDs.SI_DELIVERY_RULE_RESULTS);
        if (data == null) {
            data = this.m_properties.add(PropertyIDs.SI_DELIVERY_RULE_RESULTS, null, 0x8000000);
        }
        ((IProperties)data.getValue()).add(new Integer(scopeIDWithinScopeBatch), new Boolean(bDeliverySkipped), 0);
    }

    public void removeDeliveryRuleResults(int scopeIDWithinScopeBatch) {
        IProperty data = this.m_properties.getProperty(PropertyIDs.SI_DELIVERY_RULE_RESULTS);
        if (data != null) {
            PropertyBag props = (PropertyBag)data.getValue();
            props.remove((Object)new Integer(scopeIDWithinScopeBatch));
        }
    }

    public void setDeliverySkipped(boolean bDeliverySkipped) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_DELIVERY_SKIPPED, bDeliverySkipped);
    }

    public void setPublicationKeepSavedData(boolean bKeepSavedData) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_PUBLICATION_KEEP_SAVED_DATA, bKeepSavedData);
    }

    public void setPublicationLastState(long lLastSavedState) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_PUBLICATION_LAST_STATE, lLastSavedState);
    }

    public IFormatInfos getFormatInfos() {
        if (this.m_formatInfos == null) {
            PropertyBag formatInfosBag = ((PropertyBag)this.m_properties).getPropertyBag((Object)PropertyIDs.SI_FORMAT_INFOS);
            if (formatInfosBag == null) {
                formatInfosBag = ((PropertyBag)this.m_properties).addArray((Object)PropertyIDs.SI_FORMAT_INFOS).getPropertyBag();
            }
            this.m_formatInfos = new FormatInfos(formatInfosBag, this.m_schedulingInfo);
        }
        return this.m_formatInfos;
    }

    public IScopeBatchScopes getScopeBatchScopes() throws SDKException {
        if (this.m_scopes == null) {
            PropertyBag scopesBag = (PropertyBag)this.m_properties.getProperties(PropertyIDs.SI_SCOPEBATCH_SCOPES, true);
            if (scopesBag == null) {
                scopesBag = (PropertyBag)this.m_properties.add(PropertyIDs.SI_SCOPEBATCH_SCOPES, null, 0x8000000).getValue();
            }
            this.m_scopes = new ScopeBatchScopes(scopesBag);
        }
        return this.m_scopes;
    }

    public boolean getIsDynamicRecipientsScopeBatch() {
        return this.m_properties.getBoolean(PropertyIDs.SI_IS_DYNAMICRECIPIENTS_SCOPES);
    }

    public void setIsDynamicRecipientsScopeBatch(boolean dynamicRecipientScopes) throws SDKException {
        this.m_properties.setProperty((Object)PropertyIDs.SI_IS_DYNAMICRECIPIENTS_SCOPES, dynamicRecipientScopes);
    }

    public int getSourceDocumentID() {
        return this.m_properties.getInt(PropertyIDs.SI_SOURCE_DOC_ID);
    }

    public void setSourceDocumentID(int value) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_SOURCE_DOC_ID, value);
    }
}

