/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.businessobjects.sdk.plugin.desktop.publication.internal.Publication;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationDocumentVariableMapping;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import com.crystaldecisions.sdk.properties.internal.SDKPropertyBag;

public class PublicationDocumentVariableMapping
implements IPublicationDocumentVariableMapping {
    private PropertyBag m_propBag;
    private final Publication.IProfileChangeListener m_changeListener;

    public PublicationDocumentVariableMapping(PropertyBag bag, Publication.IProfileChangeListener changeListener) {
        this.m_propBag = bag;
        this.m_changeListener = changeListener;
    }

    public void setVariableName(String variableName) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_VARIABLE, (Object)variableName);
    }

    public String getVariableName() {
        return this.m_propBag.getString((Object)PropertyIDs.SI_VARIABLE);
    }

    public void setSubreportName(String subreportName) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_SUBREPORTNAME, (Object)subreportName);
    }

    public String getSubreportName() {
        Property prop = this.m_propBag.getItem((Object)PropertyIDs.SI_SUBREPORTNAME);
        if (prop == null) {
            return "";
        }
        return prop.getString();
    }

    public String getMultilingualUniverseCUID() {
        return this.m_propBag.getString((Object)PropertyIDs.SI_ML_UNIVERSE_CUID);
    }

    public void setMultilingualUniverseCUID(String cuid) {
        this.m_propBag.addItem((Object)PropertyIDs.SI_ML_UNIVERSE_CUID, (Object)cuid, 0);
    }

    public String getMultilingualVariableID() {
        return this.m_propBag.getString((Object)PropertyIDs.SI_ML_VARIABLE_ID);
    }

    public void setMultilingualVariableID(String variableId) {
        this.m_propBag.addItem((Object)PropertyIDs.SI_ML_VARIABLE_ID, (Object)variableId, 0);
    }

    public void setProfileID(int profileID) throws SDKException {
        this.m_propBag.setProperty((Object)PropertyIDs.SI_ID, profileID);
        if (this.m_changeListener != null) {
            this.m_changeListener.profileChanged();
        }
    }

    public int getProfileID() {
        return this.m_propBag.getInt((Object)PropertyIDs.SI_ID);
    }

    public void initialize() {
        if (this.m_propBag == null) {
            this.m_propBag = new SDKPropertyBag();
        }
    }

    public void assumeProperties(IProperties bag) {
        this.copyProperty(PropertyIDs.SI_VARIABLE, bag);
        this.copyProperty(PropertyIDs.SI_ID, bag);
        this.copyProperty(PropertyIDs.SI_SUBREPORTNAME, bag);
        this.m_propBag = (PropertyBag)bag;
    }

    private void copyProperty(Integer id, IProperties bag) {
        Property property2 = (Property)this.m_propBag.get((Object)id);
        if (property2 != null) {
            bag.setProperty((Object)id, property2.getValue());
        }
    }

    public void copy(IProperties properties) {
        properties.putAll(this.m_propBag);
    }

    public IProperties properties() {
        return (IProperties)this.m_propBag;
    }
}

