/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.internal.ObjectRelatives;
import com.crystaldecisions.sdk.plugin.desktop.common.IDestinationProgIDs;
import com.crystaldecisions.sdk.plugin.desktop.common.IDynamicRecipientVariableMappings;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationDocumentVariableMappings;
import com.crystaldecisions.sdk.plugin.desktop.common.IPublicationInfo;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.DestinationProgIDs;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.DynamicRecipientVariableMappings;
import com.crystaldecisions.sdk.plugin.desktop.common.internal.PublicationDocumentVariableMappings;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Collection;
import java.util.HashSet;

public class PublicationInfoHelper
implements IPublicationInfo {
    private IProperties m_properties;
    private boolean m_isNew = false;
    private Collection m_sourceDocIDs;
    private IDestinationProgIDs m_destinationProgIDs;
    private Collection m_scopeBatchObjects;
    private IDynamicRecipientVariableMappings m_dynamicRecipientVariableMappings = null;
    private IPublicationDocumentVariableMappings m_pubDocVariableMappings = null;

    public PublicationInfoHelper(IProperties properties, boolean isNew) {
        this.m_properties = properties;
        this.m_isNew = isNew;
    }

    public boolean isPublicationJob() throws SDKException {
        return this.m_properties.getBoolean(PropertyIDs.SI_IS_PUBLICATION_JOB);
    }

    public void setPublicationJob(boolean value) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_IS_PUBLICATION_JOB, value);
    }

    public boolean isPublicationGlobalDeliveryRuleJob() throws SDKException {
        return this.m_properties.getBoolean(PropertyIDs.SI_IS_PUBLICATION_GLOBAL_DELIVERY_RULE_JOB);
    }

    public void setPublicationGlobalDeliveryRuleJob(boolean value) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_IS_PUBLICATION_GLOBAL_DELIVERY_RULE_JOB, value);
    }

    public boolean isShowAllDataForNullProfileValues() throws SDKException {
        return this.m_properties.getBoolean(PropertyIDs.SI_SHOW_ALL_DATA_FOR_NULL_PROFILE_VALUES);
    }

    public void setShowAllDataForNullProfileValues(boolean value) throws SDKException {
        this.m_properties.setProperty((Object)PropertyIDs.SI_SHOW_ALL_DATA_FOR_NULL_PROFILE_VALUES, value);
    }

    public int getScopeID() throws SDKException {
        IProperty scopeID = this.m_properties.getProperty(PropertyIDs.SI_SCOPE_ID);
        if (scopeID != null) {
            return (Integer)scopeID.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_SCOPE_ID);
    }

    public void setScopeID(int scopeID) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_SCOPE_ID, new Integer(scopeID));
    }

    public long getMultiPassBursting() throws SDKException {
        if (this.m_properties.get(PropertyIDs.SI_MULTIPASSBURSTING) != null) {
            return this.m_properties.getLong(PropertyIDs.SI_MULTIPASSBURSTING);
        }
        return 0L;
    }

    public void setMultiPassBursting(long multiPassBursting) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_MULTIPASSBURSTING, new Integer((int)multiPassBursting));
    }

    public boolean isPluginArtifact() throws SDKException {
        return this.m_properties.getBoolean(PropertyIDs.SI_IS_PLUGIN_ARTIFACT);
    }

    public void setPluginArtifact(boolean bIsPluginArtifact) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_IS_PLUGIN_ARTIFACT, bIsPluginArtifact);
    }

    public Collection getScopeBatchDocArtifacts() throws SDKException {
        return new HashSet();
    }

    public static Integer name2ObjectID(String name) {
        if (name == null || name.length() < 1) {
            return null;
        }
        return PropertyIDs.nameToID(name);
    }

    public IDestinationProgIDs getDestinationProgIDs() {
        if (this.m_destinationProgIDs == null) {
            PropertyBag destProgIDsBag = ((PropertyBag)this.m_properties).getPropertyBag((Object)PropertyIDs.SI_DESTINATION_PROGIDS);
            if (destProgIDsBag == null) {
                destProgIDsBag = ((PropertyBag)this.m_properties).addArray((Object)PropertyIDs.SI_DESTINATION_PROGIDS).getPropertyBag();
            }
            this.m_destinationProgIDs = new DestinationProgIDs(destProgIDsBag);
        }
        return this.m_destinationProgIDs;
    }

    public Collection getSourceDocuments() throws SDKException {
        if (this.m_sourceDocIDs == null) {
            this.m_sourceDocIDs = new ObjectRelatives();
            ((ObjectRelatives)this.m_sourceDocIDs).initialize((Object)PropertyIDs.SI_ARTIFACTS_SOURCEDOC, this.m_properties, false, this.m_isNew);
        }
        return this.m_sourceDocIDs;
    }

    private void initScopeBatch() throws SDKException {
        if (this.m_scopeBatchObjects == null) {
            this.m_scopeBatchObjects = new ObjectRelatives();
            ((ObjectRelatives)this.m_scopeBatchObjects).initialize((Object)PropertyIDs.SI_ARTIFACTS_SCOPEBATCH, this.m_properties, false, this.m_isNew);
        }
    }

    public int getScopeBatch() throws SDKException {
        this.initScopeBatch();
        if (!this.m_scopeBatchObjects.isEmpty()) {
            return (Integer)this.m_scopeBatchObjects.iterator().next();
        }
        return 0;
    }

    public void setScopeBatch(int scopeBatchID) throws SDKException {
        this.initScopeBatch();
        if (!this.m_scopeBatchObjects.isEmpty()) {
            this.m_scopeBatchObjects.clear();
        }
        this.m_scopeBatchObjects.add(new Integer(scopeBatchID));
    }

    public IDynamicRecipientVariableMappings getDynamicRecipientVariableMappings() throws SDKException {
        if (this.m_dynamicRecipientVariableMappings == null) {
            PropertyBag dynamicRecipientVariableMappingBag = this.getDynamicRecipientProfileValueMappingsBag();
            PropertyBag dynaReciVariableMappingsBag = dynamicRecipientVariableMappingBag.getPropertyBag((Object)PropertyIDs.SI_VARIABLE_MAPPINGS);
            if (dynaReciVariableMappingsBag == null) {
                dynaReciVariableMappingsBag = (PropertyBag)dynamicRecipientVariableMappingBag.addItem((Object)PropertyIDs.SI_VARIABLE_MAPPINGS, null, 0x8000000).getValue();
            }
            this.m_dynamicRecipientVariableMappings = new DynamicRecipientVariableMappings(dynaReciVariableMappingsBag);
        }
        return this.m_dynamicRecipientVariableMappings;
    }

    private PropertyBag getDynamicRecipientProfileValueMappingsBag() throws SDKException {
        PropertyBag boeDocProfileTargetsBag = (PropertyBag)this.m_properties.getProperties(PropertyIDs.SI_DYNAMIC_RECIPIENTS_PROFILE_VALUE_MAPPINGS, true);
        if (boeDocProfileTargetsBag == null) {
            boeDocProfileTargetsBag = (PropertyBag)this.m_properties.add(PropertyIDs.SI_DYNAMIC_RECIPIENTS_PROFILE_VALUE_MAPPINGS, null, 0x8000000).getValue();
        }
        return boeDocProfileTargetsBag;
    }

    public IPublicationDocumentVariableMappings getPublicationDocumentVariableMappings() throws SDKException {
        if (this.m_pubDocVariableMappings == null) {
            PropertyBag boeDocProfileTargetsBag = this.getBOEDocProfileTargetsBag();
            PropertyBag boeVariableMappingsBag = boeDocProfileTargetsBag.getPropertyBag((Object)PropertyIDs.SI_VARIABLE_MAPPINGS);
            if (boeVariableMappingsBag == null) {
                boeVariableMappingsBag = (PropertyBag)boeDocProfileTargetsBag.addItem((Object)PropertyIDs.SI_VARIABLE_MAPPINGS, null, 0x8000000).getValue();
            }
            this.m_pubDocVariableMappings = new PublicationDocumentVariableMappings(boeVariableMappingsBag, null);
        }
        return this.m_pubDocVariableMappings;
    }

    private PropertyBag getBOEDocProfileTargetsBag() throws SDKException {
        PropertyBag boeDocProfileTargetsBag = (PropertyBag)this.m_properties.getProperties(PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS, true);
        if (boeDocProfileTargetsBag == null) {
            boeDocProfileTargetsBag = (PropertyBag)this.m_properties.add(PropertyIDs.SI_PUBLICATION_DOCUMENTPROFILE_TARGETS, null, 0x8000000).getValue();
        }
        return boeDocProfileTargetsBag;
    }

    public void setPublicationDocumentVariableMappings(IPublicationDocumentVariableMappings variableMappings) throws SDKException {
        IPublicationDocumentVariableMappings myVarMappings = this.getPublicationDocumentVariableMappings();
        myVarMappings.clear();
        myVarMappings.addAll(variableMappings);
    }

    public int getArtifactParentID() throws SDKException {
        IProperty scopeID = this.m_properties.getProperty(PropertyIDs.SI_ARTIFACT_PARENT_ID);
        if (scopeID != null) {
            return (Integer)scopeID.getValue();
        }
        throw new SDKException.PropertyNotFound(PropertyIDs.SI_ARTIFACT_PARENT_ID);
    }

    public void setArtifactParentID(int artifactParentID) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_ARTIFACT_PARENT_ID, new Integer(artifactParentID));
    }

    public String getFormat() {
        IProperty prop = this.m_properties.getProperty(PropertyIDs.SI_FORMAT);
        if (prop == null) {
            return null;
        }
        return (String)prop.getValue();
    }

    public void setFormat(String value) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_FORMAT, value);
    }
}

