/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.common.internal;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.plugin.desktop.common.IViewingServerGroupInfo;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

public class ViewingServerGroupHelper
implements IViewingServerGroupInfo {
    IProperties m_properties;

    public int getViewingServerGroupChoice() throws SDKException {
        Property prop = (Property)this.m_properties.getProperty(PropertyIDs.SI_MACHINECHOICE);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_MACHINECHOICE);
        }
        return prop.getInt();
    }

    public void setViewingServerGroupChoice(int mode) {
        if (mode < 0 || mode > 2) {
            throw new SDKRuntimeException.OutOfRange(PropertyIDs.SI_MACHINECHOICE, mode, 2, 0);
        }
        this.m_properties.setProperty((Object)PropertyIDs.SI_MACHINECHOICE, mode);
    }

    public int getViewingServerGroup() throws SDKException {
        Property prop = (Property)this.m_properties.getProperty(PropertyIDs.SI_MACHINE);
        if (prop == null) {
            throw new SDKException.PropertyNotFound(PropertyIDs.SI_MACHINE);
        }
        return prop.getInt();
    }

    public void setViewingServerGroup(int groupID) {
        this.m_properties.setProperty((Object)PropertyIDs.SI_MACHINE, groupID);
    }

    public ViewingServerGroupHelper(IProperties properties) {
        this.m_properties = properties;
    }
}

