/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.event.internal;

import com.crystaldecisions.sdk.plugin.desktop.event.IFileEvent;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

class FileEvent
implements IFileEvent {
    private IProperties m_properties;

    FileEvent(IProperties properties) {
        this.m_properties = properties;
    }

    public String getFileName() {
        IProperties outerFeaturesBag = (IProperties)this.m_properties.getProperty(PropertyIDs.SI_FEATURES).getValue();
        IProperties nestedFeaturesBag = (IProperties)outerFeaturesBag.getProperty(PropertyIDs.SI_FEATURES).getValue();
        IProperty fileProp = nestedFeaturesBag.getProperty(PropertyIDs.SI_FILE);
        return (String)fileProp.getValue();
    }

    public void setFileName(String newFileName) {
        IProperties outerFeaturesBag = this.getNotNullPropertyBag(this.m_properties, PropertyIDs.SI_FEATURES);
        IProperties nestedFeaturesBag = this.getNotNullPropertyBag(outerFeaturesBag, PropertyIDs.SI_FEATURES);
        nestedFeaturesBag.setProperty((Object)PropertyIDs.SI_FILE, newFileName);
    }

    public String getServerFriendlyName() {
        IProperties featureBag = (IProperties)this.m_properties.getProperty(PropertyIDs.SI_FEATURES).getValue();
        IProperty serverProp = featureBag.getProperty(PropertyIDs.SI_SERVER);
        return (String)serverProp.getValue();
    }

    public void setServerFriendlyName(String newServerFriendlyName) {
        IProperties featuresBag = this.getNotNullPropertyBag(this.m_properties, PropertyIDs.SI_FEATURES);
        featuresBag.setProperty((Object)PropertyIDs.SI_SERVER, newServerFriendlyName);
    }

    private IProperties getNotNullPropertyBag(IProperties properties, Integer propID) {
        IProperty prop = properties.getProperty(propID);
        if (prop == null) {
            prop = properties.add(propID, null, 0x8000000);
        }
        IProperties result = (IProperties)prop.getValue();
        return result;
    }
}

