/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.event.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.plugin.desktop.event.IScheduleEvent;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;

class ScheduleEvent
implements IScheduleEvent {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.event.internal.ScheduleEvent");
    private IProperties m_properties;

    ScheduleEvent(IProperties properties) {
        this.m_properties = properties;
    }

    public int getDependencyType() {
        IProperties featuresBag = (IProperties)this.m_properties.getProperty(PropertyIDs.SI_FEATURES).getValue();
        IProperty typeProp = featuresBag.getProperty(PropertyIDs.SI_TYPE);
        Integer typeValue = (Integer)typeProp.getValue();
        return typeValue;
    }

    public void setDependencyType(int newDependencyType) {
        if (newDependencyType < 0 || newDependencyType > 2) {
            throw new SDKRuntimeException.UndefinedValue(newDependencyType, IScheduleEvent.class.getName());
        }
        IProperties featuresBag = this.getNotNullPropertyBag(this.m_properties, PropertyIDs.SI_FEATURES);
        featuresBag.setProperty((Object)PropertyIDs.SI_TYPE, new Integer(newDependencyType));
    }

    private IProperties getNotNullPropertyBag(IProperties properties, Integer propID) {
        IProperty prop = properties.getProperty(propID);
        if (prop == null) {
            prop = properties.add(propID, null, 0x8000000);
        }
        IProperties result = (IProperties)prop.getValue();
        return result;
    }
}

