/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.server;

public class ExpectedRunState {
    protected String m_expectedRunStateName;
    protected int m_expectedRunState;
    public static final ExpectedRunState RUNNING = new ExpectedRunState(1);
    public static final ExpectedRunState RESTART = new ExpectedRunState(2);
    public static final ExpectedRunState STOPPED = new ExpectedRunState(0);
    public static final ExpectedRunState UNMANAGED = new ExpectedRunState(3);
    public static final ExpectedRunState STOPNOW = new ExpectedRunState(4);
    public static final ExpectedRunState INVALID = new ExpectedRunState(-1);

    protected ExpectedRunState(int expectedRunState) {
        this.m_expectedRunState = expectedRunState;
        switch (this.m_expectedRunState) {
            case 1: {
                this.m_expectedRunStateName = "Running";
                break;
            }
            case 2: {
                this.m_expectedRunStateName = "Restart";
                break;
            }
            case 0: {
                this.m_expectedRunStateName = "Stopped";
                break;
            }
            case 3: {
                this.m_expectedRunStateName = "Unmanaged";
                break;
            }
            case 4: {
                this.m_expectedRunStateName = "StopNow";
                break;
            }
            case -2: {
                this.m_expectedRunStateName = "Deleted";
                break;
            }
            default: {
                this.m_expectedRunStateName = "Invalid";
            }
        }
    }

    public String toString() {
        return this.m_expectedRunStateName;
    }

    public static ExpectedRunState fromString(String s) {
        if ((s = s.trim()).compareToIgnoreCase(RUNNING.toString()) == 0) {
            return RUNNING;
        }
        if (s.compareToIgnoreCase(RESTART.toString()) == 0) {
            return RESTART;
        }
        if (s.compareToIgnoreCase(STOPPED.toString()) == 0) {
            return STOPPED;
        }
        if (s.compareToIgnoreCase(UNMANAGED.toString()) == 0) {
            return UNMANAGED;
        }
        if (s.compareToIgnoreCase(STOPNOW.toString()) == 0) {
            return STOPNOW;
        }
        return INVALID;
    }

    public static ExpectedRunState fromInteger(int i) {
        switch (i) {
            case 1: {
                return RUNNING;
            }
            case 2: {
                return RESTART;
            }
            case 0: {
                return STOPPED;
            }
            case 3: {
                return UNMANAGED;
            }
            case 4: {
                return STOPNOW;
            }
        }
        return INVALID;
    }

    public int toInteger() {
        return this.m_expectedRunState;
    }
}

