/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.server;

public class ServerState {
    private String m_serverState;
    private int m_state;
    public static final ServerState STOPPED = new ServerState(0);
    public static final ServerState RUNNING = new ServerState(1);
    public static final ServerState WAITING_FOR_RESOURCES = new ServerState(2);
    public static final ServerState INVALID = new ServerState(-1);

    private ServerState(int serverState) {
        this.m_state = serverState;
        switch (this.m_state) {
            case 1: {
                this.m_serverState = "Running";
                break;
            }
            case 0: {
                this.m_serverState = "Stopped";
                break;
            }
            case 2: {
                this.m_serverState = "WaitingForResources";
                break;
            }
            default: {
                this.m_serverState = "Invalid";
            }
        }
    }

    public String toString() {
        return this.m_serverState;
    }

    public static ServerState fromString(String s) {
        if ((s = s.trim()).equalsIgnoreCase("Running")) {
            return RUNNING;
        }
        if (s.equalsIgnoreCase("WaitingForResources")) {
            return WAITING_FOR_RESOURCES;
        }
        if (s.equalsIgnoreCase("Stopped")) {
            return STOPPED;
        }
        return INVALID;
    }

    public static ServerState fromInteger(int i) {
        switch (i) {
            case 1: {
                return RUNNING;
            }
            case 2: {
                return WAITING_FOR_RESOURCES;
            }
            case 0: {
                return STOPPED;
            }
        }
        return INVALID;
    }

    public int toInteger() {
        return this.m_state;
    }
}

