/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.servergroup.internal;

import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.enterprise.ocaframework.idl.OCA.OCAi.ObjectID_Ex;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEvent;
import com.crystaldecisions.sdk.occa.infostore.internal.IInfoObjectEventListener;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.plugin.desktop.internal.GroupAssociates;
import com.crystaldecisions.sdk.plugin.desktop.servergroup.IServerGroup;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.util.Set;

class ServerGroup
extends AbstractInfoObject
implements IServerGroup {
    private Set m_servers;
    private Set m_serverIDs;
    private Set m_subGroups;
    public static final Integer SEC_ID_SERVERGROUP_FOLDER = new Integer(17);

    ServerGroup() {
    }

    public void initialize(ISecuritySession session, IInfoObjects collection, ObjectID_Ex id, short type) throws SDKException {
        super.initialize(session, collection, id, type);
        this.setProperty((Object)PropertyIDs.SI_PARENTID, SEC_ID_SERVERGROUP_FOLDER);
        this.setProperty((Object)PropertyIDs.SI_SYSTEM_OBJECT, Boolean.TRUE);
        this.properties().add(PropertyIDs.SI_SERVERS, null, 0x8000000);
        this.properties().add(PropertyIDs.SI_SUBSERVERGROUPS, null, 0x8000000);
        this.properties().add(PropertyIDs.SI_GROUP_MEMBERS, null, 0x8000000);
    }

    public IInfoObjectEventListener getInfoObjectEventListener(int type) {
        final IInfoObjectEventListener superListener = super.getInfoObjectEventListener(type);
        if (type == 2) {
            return new AbstractInfoObjectEventListener(){

                protected void processEvent(IInfoObjectEvent event) throws SDKException {
                    if (ServerGroup.this.isNew()) {
                        ServerGroup.this.getServers();
                        ServerGroup.this.getServerIDs();
                        ServerGroup.this.getSubGroupsEx();
                    }
                }

                protected IInfoObjectEventListener getSuperEventListener() {
                    return superListener;
                }
            };
        }
        return superListener;
    }

    public synchronized Set getServers() {
        if (this.m_servers == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_GROUP_MEMBERS) == null) {
                    this.properties().add(PropertyIDs.SI_GROUP_MEMBERS, null, 0x8000000);
                }
                this.m_servers = new GroupAssociates(PropertyIDs.SI_GROUP_MEMBERS, PropertyIDs.SI_ADM_ADD_MEMBERS, PropertyIDs.SI_ADM_DEL_MEMBERS, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_servers;
    }

    public Set getServerIDs() {
        if (this.m_serverIDs == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_SERVERS) == null) {
                    this.properties().add(PropertyIDs.SI_SERVERS, null, 0x8000000);
                }
                this.m_serverIDs = new GroupAssociates(PropertyIDs.SI_SERVERS, PropertyIDs.SI_ADM_ADD_SERVERS_TO_SERVERGROUP, PropertyIDs.SI_ADM_DEL_SERVERS_FROM_SERVERGROUP, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_serverIDs;
    }

    public synchronized Set getSubGroups() {
        IProperty subServerGroupsProp = this.properties().getProperty(PropertyIDs.SI_SUBSERVERGROUPS);
        IProperty subGroupsProp = this.properties().getProperty(PropertyIDs.SI_SUBGROUPS);
        if (subServerGroupsProp == null && subGroupsProp != null) {
            subServerGroupsProp = this.properties().add(PropertyIDs.SI_SUBSERVERGROUPS, null, 0xA000000);
            PropertyArrayHelper subgroupsHelper = new PropertyArrayHelper((PropertyBag)subGroupsProp.getValue(), PropertyIDs.SI_TOTAL, new Integer(0));
            PropertyArrayHelper subServerGroupHelper = new PropertyArrayHelper((PropertyBag)subServerGroupsProp.getValue(), PropertyIDs.SI_TOTAL, new Integer(0));
            for (int i = 0; i < subgroupsHelper.size(); ++i) {
                subServerGroupHelper.add(subgroupsHelper.get(i));
            }
        }
        return this.getSubGroupsEx();
    }

    private Set getSubGroupsEx() {
        if (this.m_subGroups == null) {
            try {
                if (this.properties().getProperty(PropertyIDs.SI_SUBSERVERGROUPS) == null) {
                    this.properties().add(PropertyIDs.SI_SUBSERVERGROUPS, null, 0xA000000);
                }
                this.m_subGroups = new GroupAssociates(PropertyIDs.SI_SUBSERVERGROUPS, PropertyIDs.SI_ADM_ADD_SUBSERVERGROUPS_TO_SERVERGROUP, PropertyIDs.SI_ADM_DEL_SUBSERVERGROUPS_FROM_SERVERGROUP, this.properties(), this.isNew());
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        return this.m_subGroups;
    }
}

