/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.plugin.desktop.shortcut.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.exception.internal.ServerMsgResourcesBundle;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.AbstractSendableObject;
import com.crystaldecisions.sdk.occa.infostore.internal.IPersistInfoObject;
import com.crystaldecisions.sdk.occa.infostore.internal.InfoStoreFactory;
import com.crystaldecisions.sdk.plugin.desktop.shortcut.IShortcut;
import com.crystaldecisions.sdk.properties.IProperty;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.text.MessageFormat;
import java.util.Locale;

public class Shortcut
extends AbstractSendableObject
implements IPersistInfoObject,
IShortcut {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.plugin.desktop.shortcut.internal.Shortcut");

    public int getTargetID() {
        IProperty prop = this.getProperty(PropertyIDs.SI_ALIAS_TARGETID);
        if (prop == null) {
            throw new SDKRuntimeException.PropertyNotFound(PropertyIDs.SI_ALIAS_TARGETID);
        }
        return (Integer)prop.getValue();
    }

    public void setTargetID(int id) {
        String description;
        IInfoObject targetObject = this.getTargetObject(id);
        if (targetObject == null) {
            throw new SDKRuntimeException.ObjectNotFound(id);
        }
        this.setProperty((Object)PropertyIDs.SI_ALIAS_TARGETID, new Integer(targetObject.getID()));
        String title = this.getTitle();
        if (title == null || "".equals(title)) {
            String pattern = ServerMsgResourcesBundle.getString(Integer.toString(49161), this.getLocale());
            this.setTitle(MessageFormat.format(pattern, targetObject.getTitle()));
        }
        if ((description = this.getDescription()) == null || "".equals(description)) {
            this.setDescription(targetObject.getDescription());
        }
        try {
            String progid = targetObject.getProgID();
            if (!"".equals(progid)) {
                this.setProperty((Object)PropertyIDs.SI_ALIAS_TARGETPROGID, progid);
            }
        }
        catch (SDKException e) {
            LOG.error((Object)"Failed to get prog id", (Throwable)((Object)e));
        }
    }

    private Locale getLocale() {
        Locale locale;
        block3: {
            locale = null;
            try {
                locale = this.getSession().getUserInfo().getLocale();
            }
            catch (SDKException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Locale not set in user info", (Throwable)((Object)e));
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private IInfoObject getTargetObject(int id) {
        try {
            IInfoStore infostore = (IInfoStore)InfoStoreFactory.getFactory().makeOCCA(this.getSession().getAPSName(), this.getSession());
            IInfoObjects col = infostore.query("select si_progid, si_description, si_alias_targetid from ci_infoobjects where si_id = " + id);
            if (col.size() <= 0) {
                throw new SDKRuntimeException.ObjectNotFound(id);
            }
            IInfoObject targetObj = (IInfoObject)col.get(0);
            if (targetObj.getProgID().equalsIgnoreCase("CrystalEnterprise.Shortcut")) {
                return this.getTargetObject(((IShortcut)targetObj).getTargetID());
            }
            return targetObj;
        }
        catch (SDKException e) {
            throw new SDKRuntimeException.ObjectNotFound(id, (Throwable)((Object)e));
        }
    }
}

